<?php
/**
 * Copyright 2013-2014 Horde LLC (http://www.horde.org/)
 *
 * See the enclosed file COPYING for license information (GPL). If you
 * did not receive this file, see http://www.horde.org/licenses/gpl.
 *
 * @category  Horde
 * @copyright 2013-2014 Horde LLC
 * @license   http://www.fsf.org/copyleft/gpl.html GPL
 * @package   IMP
 */

/**
 * Generate avatar image for an unknown contact.
 *
 * @author    Michael Slusarz <slusarz@horde.org>
 * @category  Horde
 * @copyright 2013-2014 Horde LLC
 * @license   http://www.horde.org/licenses/gpl GPL
 * @package   IMP
 */
class IMP_Contacts_Avatar_Unknown implements IMP_Contacts_Avatar_Backend
{
    /**
     */
    public function avatarImg($email)
    {
        $img = Horde_Themes::img('unknown_contact.jpg');
        return array(
            'desc' => '',
            'url' => $img->uri
        );
    }

}
