--TEST--
maxdb fetch mixed / maxdb_query 
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
	include "connect.inc";

	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);

        maxdb_report (MAXDB_REPORT_OFF);
  	maxdb_query($link,"DROP TABLE test_bind_result");
        maxdb_report (MAXDB_REPORT_ERROR);

	maxdb_query($link,"CREATE TABLE test_bind_result(c1 smallint, c2 smallint, 
                                                        c3 int, c4 fixed(30), 
                                                        c5 fixed(4,2), c6 float,
                                                        c7 varchar(10), 
                                                        c8 varchar(10))");

  	maxdb_query($link,"INSERT INTO test_bind_result VALUES(120,2999,3999,54,
                                                              2.6,58.89,
                                                              '206','6.7')");
	$stmt = maxdb_prepare($link, "SELECT * FROM test_bind_result");

	$c = array(0,0,0,0,0,0,0,0);
	maxdb_bind_result($stmt, $c[0], $c[1], $c[2], $c[3], $c[4], $c[5], $c[6], $c[7]);
	maxdb_execute($stmt);
	maxdb_fetch($stmt); 
	maxdb_fetch($stmt);  
	maxdb_stmt_close($stmt);

	$result = maxdb_query($link, "select * from test_bind_result");
	$d = maxdb_fetch_row($result); 
	maxdb_free_result($result);

	$test = "";
	for ($i=0; $i < count($c); $i++)
		$test .= ($c[0] == $d[0]) ? "1" : "0";

	var_dump($test);

	maxdb_close($link);
?>
--EXPECT--
string(8) "11111111"
