--TEST--
maxdb long data retrieval crash
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
	include "connect.inc";

	ini_set("maxdb.long_readlen", "6");

	/*** test maxdb_connect 127.0.0.1 ***/
	$link = maxdb_connect("localhost", $user, $passwd);

	maxdb_select_db($link, $db);

        maxdb_report (MAXDB_REPORT_OFF);
  	maxdb_query($link,"DROP TABLE test_bind_fetch");
        maxdb_report (MAXDB_REPORT_ERROR);

  	maxdb_query($link,"CREATE TABLE test_bind_fetch(c1 varchar(11), c2 long ascii)");

	$stmt = maxdb_prepare ($link, "INSERT INTO test_bind_fetch VALUES (?,?)");
	maxdb_bind_param($stmt, "sb", $c1, $c2);

	$c1 = "Hello World";

	maxdb_execute($stmt);

        $a = str_repeat("A1", 32000);
	maxdb_send_long_data($stmt, 1, $a);
        maxdb_stmt_close_long_data ($stmt, 1);
	maxdb_stmt_close($stmt);
        maxdb_commit($link);

        $result = maxdb_query($link, "SELECT * FROM test_bind_fetch");
	$row = maxdb_fetch_row($result);
        printf ("%s\n", $row[1]);
	maxdb_stmt_close($stmt);
        maxdb_free_result($result);

	maxdb_close($link);
	ini_restore("maxdb.long_readlen");
?>
--EXPECTF--
%s
A1A1A%s

