--TEST--
maxdb insert error
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
include "connect.inc";

$link = maxdb_connect("localhost", $user, $passwd);
   
/* check connection */
if (maxdb_connect_errno()) {
   printf("Connect failed: %s\n", maxdb_connect_error());
   exit();
}

/* Performing SQL query */
maxdb_report (MAXDB_REPORT_OFF);
$result = maxdb_query($link, "drop table abc");
maxdb_report (MAXDB_REPORT_ERROR);
$result = maxdb_query($link, "create table abc ( i fixed(5))") or die("Query failed : " . maxdb_error());
$result = maxdb_query($link, "insert into abc values (-19999)") or die("Query failed : " . maxdb_error());
$query = "SELECT i FROM abc";
$result = maxdb_query($link, $query) or die("Query failed : " . maxdb_error());

/* Printing results in HTML */
echo "<table>\n";
while ($line = maxdb_fetch_array($result, MAXDB_ASSOC)) {
    echo "  <tr>\n";
    foreach ($line as $col_value) {
        echo "    <td>$col_value</td>\n";
    }
    echo "  </tr>\n";
}
echo "</table>\n";

/* Free resultset */
maxdb_free_result($result);

/* Closing connection */
maxdb_close($link);
?>
--EXPECT--
<table>
  <tr>
    <td>-19999</td>
  </tr>
</table>
