--TEST--
maxdb test assoc fetch
--SKIPIF--
<?php require 'skipif.inc'; ?>
--FILE--
<?php
include "connect.inc";  

$link = maxdb_connect("localhost", $user, $passwd);

/* check connection */
if (maxdb_connect_errno()) {
   printf("Connect failed: %s\n", maxdb_connect_error());
   exit();
}

$query = "SELECT name, state FROM hotel.city ORDER by zip";
$result = maxdb_query($link, $query);

/* associative array */
$row = maxdb_fetch_array($result, MAXDB_ASSOC);
printf ("%s (%s)\n", $row["NAME"], $row["STATE"]);

$row = maxdb_fetch_array($result, MAXDB_ASSOC_UPPER);
printf ("%s (%s)\n", $row["NAME"], $row["STATE"]);

$row = maxdb_fetch_array($result, MAXDB_ASSOC_LOWER);
printf ("%s (%s)\n", $row["name"], $row["state"]);  

/* free result set */
maxdb_free_result($result);

/* close connection */
maxdb_close($link);
?>
--EXPECT--
New York (NY)
New York (NY)
Long Island (NY)
