#line 1 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
/* -*- c -*-
 * $Id: builtin.cmod,v 1.25 2001/09/21 17:57:55 grubba Exp $
 */

#include "global.h"
#include "interpret.h"
#include "svalue.h"
#include "opcodes.h"
#include "pike_macros.h"
#include "object.h"
#include "program.h"
#include "array.h"
#include "pike_error.h"
#include "constants.h"
#include "mapping.h"
#include "stralloc.h"
#include "multiset.h"
#include "pike_types.h"
#include "pike_memory.h"
#include "threads.h"
#include <math.h>
#include <ctype.h>
#include "module_support.h"
#include "cyclic.h"
#include "bignum.h"
#include "main.h"
#include "operators.h"
#include "builtin_functions.h"













#define f_column_defined
void f_column(INT32 args) {
#line 42 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct array * data;
#line 42 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct svalue * index;
#line 42 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("column",args,2);
#line 42 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_ARRAY) SIMPLE_BAD_ARG_ERROR("column",1,"array");
#line 42 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
debug_malloc_pass(data=sp[0-2].u.array);
#line 42 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
index=sp+1-2; dmalloc_touch_svalue(sp+1-2);
#line 45 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
  INT32 e;
  struct array *a;

  DECLARE_CYCLIC();

  /* Optimization */
  if(data->refs == 1)
  {
    /* An array with one ref cannot possibly be cyclic */
    struct svalue sval;
    data->type_field = BIT_MIXED | BIT_UNFINISHED;
    for(e=0;e<data->size;e++)
    {
      index_no_free(&sval, ITEM(data)+e, index);
      free_svalue(ITEM(data)+e);
      ITEM(data)[e]=sval;
    }
    pop_stack();
    return;
  }

  if((a=(struct array *)BEGIN_CYCLIC(data,0)))
  {
    add_ref(a);
  }else{
    push_array(a=allocate_array(data->size));
    SET_CYCLIC_RET(a);

    for(e=0;e<a->size;e++)
      index_no_free(ITEM(a)+e, ITEM(data)+e, index);

    sp--;
  }
  END_CYCLIC();
  do { struct array * ret_=(a); pop_n_elems(2); push_array(ret_); return; }while(0);
#line 81 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
}






}
#define f_mkmultiset_defined
void f_mkmultiset(INT32 args) {
#line 88 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct array * a;
#line 88 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("mkmultiset",args,1);
#line 88 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_ARRAY) SIMPLE_BAD_ARG_ERROR("mkmultiset",1,"array");
#line 88 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
debug_malloc_pass(a=sp[0-1].u.array);
#line 91 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
  do { struct multiset * ret_=(mkmultiset(a)); pop_stack(); push_multiset(ret_); return; }while(0);
#line 93 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
}












}
#define f_trace_defined
void f_trace(INT32 args) {
#line 106 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
INT_TYPE t;
#line 106 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("trace",args,1);
#line 106 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("trace",1,"int");
t=Pike_sp[0-1].u.integer;
#line 109 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
  pop_n_elems(args);
  push_int(t_flag);
  t_flag=t;
}







}
#define f_ctime_defined
void f_ctime(INT32 args) {
#line 121 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
INT_TYPE timestamp;
#line 121 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("ctime",args,1);
#line 121 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("ctime",1,"int");
timestamp=Pike_sp[0-1].u.integer;
#line 124 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
  time_t i=(time_t)timestamp;
  do { struct pike_string * ret_=(make_shared_string(ctime(&i))); pop_stack(); push_string(ret_); return; }while(0);
#line 127 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
}












}
#define f_mkmapping_defined
void f_mkmapping(INT32 args) {
#line 140 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct array * ind;
#line 140 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct array * val;
#line 140 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("mkmapping",args,2);
#line 140 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_ARRAY) SIMPLE_BAD_ARG_ERROR("mkmapping",1,"array");
#line 140 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
debug_malloc_pass(ind=sp[0-2].u.array);
#line 140 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(Pike_sp[1-2].type != PIKE_T_ARRAY) SIMPLE_BAD_ARG_ERROR("mkmapping",2,"array");
#line 140 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
debug_malloc_pass(val=sp[1-2].u.array);
#line 143 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
  if(ind->size != val->size)
    bad_arg_error("mkmapping", sp-args, args, 2, "array", sp+1-args,
		  "mkmapping called on arrays of different sizes (%d != %d)\n",
		  ind->size, val->size);

  do { struct mapping * ret_=(mkmapping(ind, val)); pop_n_elems(2); push_mapping(ret_); return; }while(0);
#line 150 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
}







}
#define f_string_count_defined
void f_string_count(INT32 args) {
#line 158 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct pike_string * haystack;
#line 158 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct pike_string * needle;
#line 158 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("String.count",args,2);
#line 158 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("String.count",1,"string");
#line 158 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
debug_malloc_pass(haystack=sp[0-2].u.string);
#line 158 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(Pike_sp[1-2].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("String.count",2,"string");
#line 158 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
debug_malloc_pass(needle=sp[1-2].u.string);
#line 161 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
   ptrdiff_t c = 0;
   ptrdiff_t i, j;

   switch (needle->len)
   {
     case 0:
       switch (haystack->len)
       {
	 case 0: c=1; break; /* "" appears one time in "" */
	 case 1: c=0; break; /* "" doesn't appear in "x" */
	 default: c=haystack->len-1; /* one time between each character */
       }
       break;
     case 1:
       /* maybe optimize? */
     default:
       for (i=0; i<haystack->len; i++)
       {
	 j=string_search(haystack,needle,i);
	 if (j==-1) break;
	 i=j+needle->len-1;
	 c++;
       }
       break;
   }
   do { INT_TYPE ret_=(DO_NOT_WARN((INT_TYPE)c)); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 188 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
}



}
#define f_program_implements_defined
void f_program_implements(INT32 args) {
#line 192 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct program * prog;
#line 192 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct program * api;
#line 192 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("Program.implements",args,2);
#line 192 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(!( prog=program_from_svalue(sp+0-2))) SIMPLE_BAD_ARG_ERROR("Program.implements",1,"program");
#line 192 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(!( api=program_from_svalue(sp+1-2))) SIMPLE_BAD_ARG_ERROR("Program.implements",2,"program");
#line 195 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
  do { INT_TYPE ret_=(implements(prog, api)); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 197 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
}



}
#define f_program_inherits_defined
void f_program_inherits(INT32 args) {
#line 201 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct program * child;
#line 201 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct program * parent;
#line 201 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("Program.inherits",args,2);
#line 201 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(!( child=program_from_svalue(sp+0-2))) SIMPLE_BAD_ARG_ERROR("Program.inherits",1,"program");
#line 201 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(!( parent=program_from_svalue(sp+1-2))) SIMPLE_BAD_ARG_ERROR("Program.inherits",2,"program");
#line 204 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
  do { INT_TYPE ret_=(!!low_get_storage(parent, child)); pop_n_elems(2); push_int(ret_); return; }while(0);
#line 206 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
}









}
#define f_program_defined_defined
void f_program_defined(INT32 args) {
#line 216 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct program * p;
#line 216 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("Program.defined",args,1);
#line 216 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(!( p=program_from_svalue(sp+0-1))) SIMPLE_BAD_ARG_ERROR("Program.defined",1,"program");
#line 219 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
  if(p && p->num_linenumbers)
  {
    char *tmp;
    INT32 line;
    if((tmp=get_line(p->program, p, &line)))
    {
      struct pike_string *tmp2;
      tmp2=make_shared_string(tmp);
      pop_n_elems(args);

      push_string(tmp2);
      if(line > 1)
      {
	push_constant_text(":");
	push_int(line);
	f_add(3);
      }
      return;
    }
  }

  pop_n_elems(args);
  push_int(0);
}













}
#define f_string_width_defined
void f_string_width(INT32 args) {
#line 257 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct pike_string * s;
#line 257 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("String.width",args,1);
#line 257 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("String.width",1,"string");
#line 257 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
debug_malloc_pass(s=sp[0-1].u.string);
#line 260 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
  do { INT_TYPE ret_=(8 * (1 << s->size_shift)); pop_stack(); push_int(ret_); return; }while(0);
#line 262 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
}














}
#define f_m_delete_defined
void f_m_delete(INT32 args) {
#line 277 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct svalue * map;
#line 277 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct svalue * index;
#line 277 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("m_delete",args,2);
#line 277 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
map=sp+0-2; dmalloc_touch_svalue(sp+0-2);
#line 277 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
index=sp+1-2; dmalloc_touch_svalue(sp+1-2);
#line 280 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
  /*FIXME: Should be
   *     type function(mapping(1=mixed:2=mixed),1:2)|
   *     function(object,mixed:mixed);
   *
   *     or similar
   */
  if( map->type == T_MAPPING )
  {
    struct svalue s;
    map_delete_no_free(map->u.mapping, index, &s);
    pop_n_elems(args);
    *sp=s;
    sp++;
  }
  else if (map->type == T_OBJECT)
  {
    int id = FIND_LFUN(map->u.object->prog, LFUN__M_DELETE);

    if( id == -1 )
      SIMPLE_BAD_ARG_ERROR("m_delete", 1, "object with _m_delete");

    apply_low( map->u.object, id, 1 );
    stack_swap();
    pop_stack();
  } else {
    SIMPLE_BAD_ARG_ERROR("m_delete", 1, "object|mapping");
  }
}




}
#define f_get_weak_flag_defined
void f_get_weak_flag(INT32 args) {
#line 313 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct svalue * m;
#line 313 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("get_weak_flag",args,1);
#line 313 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
m=sp+0-1; dmalloc_touch_svalue(sp+0-1);
#line 316 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
  int flag = 0;
  switch (m->type) {
    case T_ARRAY:
      flag = (m->u.array->flags & ARRAY_WEAK_FLAG) ? PIKE_WEAK_VALUES : 0;
      break;
    case T_MAPPING:
      flag = mapping_get_flags(m->u.mapping) & MAPPING_WEAK;
      break;
    case T_MULTISET:
      flag = (m->u.multiset->ind->flags & (ARRAY_WEAK_FLAG|ARRAY_WEAK_SHRINK)) ?
	PIKE_WEAK_INDICES : 0;
      break;
    default:
      SIMPLE_BAD_ARG_ERROR("get_weak_flag",1,"array|mapping|multiset");
  }
  pop_n_elems(args);
  push_int(flag);
}

}
#line 336 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
#define INITIAL_BUF_LEN 4096




#undef class_Buffer_defined
#define class_Buffer_defined
struct program *Buffer_program=0;

#undef var_str_Buffer_defined
#define var_str_Buffer_defined

#undef var_initial_Buffer_defined
#define var_initial_Buffer_defined

#undef THIS
#define THIS ((struct Buffer_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef THIS_BUFFER
#define THIS_BUFFER ((struct Buffer_struct *)(Pike_interpreter.frame_pointer->current_storage))

#undef OBJ2_BUFFER
#define OBJ2_BUFFER(o) ((struct Buffer_struct *)(o->storage+Buffer_storage_offset))

#undef GET_BUFFER_STORAGE
#define GET_BUFFER_STORAGE ((struct Buffer_struct *)(o->storage+Buffer_storage_offset)
static ptrdiff_t Buffer_storage_offset;
struct Buffer_struct {

#ifdef var_str_Buffer_defined
#line 368 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct string_builder str;
#endif /* var_str_Buffer_defined */

#ifdef var_initial_Buffer_defined
#line 369 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
int initial;
#endif /* var_initial_Buffer_defined */
};
#line 371 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
void f_Buffer_get_copy( INT32 args );
  void f_Buffer_get( INT32 args );
  void f_Buffer_add( INT32 args );


  #define f_Buffer_create_defined
void f_Buffer_create(INT32 args) {
#line 376 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct svalue * size;
#line 376 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args > 1) wrong_number_of_args_error("create",args,1);
if(args > 0) { 
#line 376 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
size=sp+0-args; dmalloc_touch_svalue(sp+0-args);
}else{
size=0;
}
#line 386 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
    struct Buffer_struct *str = THIS;
    if( args )
      str->initial = MAXIMUM( size->u.integer, 512 );
    else
    {
      str->initial = 256;
      push_int(0);
    }
  }

  }
#define f_Buffer_cq__sprintf_defined
void f_Buffer_cq__sprintf(INT32 args) {
#line 397 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
INT_TYPE flag;
#line 397 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct mapping * flags;
#line 397 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 2) wrong_number_of_args_error("_sprintf",args,2);
#line 397 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(Pike_sp[0-2].type != PIKE_T_INT) SIMPLE_BAD_ARG_ERROR("_sprintf",1,"int");
flag=Pike_sp[0-2].u.integer;
#line 397 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(Pike_sp[1-2].type != PIKE_T_MAPPING) SIMPLE_BAD_ARG_ERROR("_sprintf",2,"mapping(mixed:mixed)");
#line 397 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
debug_malloc_pass(flags=sp[1-2].u.mapping);
{
    switch( flag )
    {
      case 'O':
	{
	  struct pike_string *res;
	  struct Buffer_struct *str = THIS;
	  push_text( "Buffer(%d /* %d */)" );
	  if( str->str.s )
	  {
	    push_int(str->str.s->len);
	    push_int(str->str.malloced);
	  }
	  else
	  {
	    push_int( 0 );
	    push_int( 0 );
	  }
	  f_sprintf( 3 );
	  res = Pike_sp[-1].u.string;
	  Pike_sp--;
	  do { struct pike_string * ret_=(res); pop_n_elems(2); push_string(ret_); return; }while(0);
#line 420 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
}

      case 's':
	{
	  pop_n_elems( args );
	  if( Pike_fp->current_object->refs != 1 )
	    f_Buffer_get_copy( 0 );
	  else
	    f_Buffer_get( 0 );
	}
	return;
	
      case 't':
	do { struct pike_string * ret_=(make_shared_binary_string("Buffer",6)); pop_n_elems(2); push_string(ret_); return; }while(0);
#line 434 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
}
    pop_n_elems( args );
    push_int( 0 );
    Pike_sp[-1].subtype = 1;
  }

  }
#define f_Buffer_cast_defined
void f_Buffer_cast(INT32 args) {
#line 440 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct pike_string * type;
#line 440 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("cast",args,1);
#line 440 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("cast",1,"string");
#line 440 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
debug_malloc_pass(type=sp[0-1].u.string);
{
    struct pike_string *string_t;
    MAKE_CONSTANT_SHARED_STRING( string_t, "string" ); 

    if( type == string_t )
    {
      pop_n_elems( args );
      if( Pike_fp->current_object->refs != 1 )
	f_Buffer_get_copy( 0 );
      else
	f_Buffer_get( 0 );
      return;
    }
    Pike_error("Cannot cast to %s\n", type->str );
  }
  
  }
#define f_Buffer_cq__backtick_add_defined
void f_Buffer_cq__backtick_add(INT32 args) {
#line 457 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct pike_string * what;
#line 457 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("`+",args,1);
#line 457 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`+",1,"string");
#line 457 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
debug_malloc_pass(what=sp[0-1].u.string);
{
    struct Buffer_struct *str = THIS, *str2;
    struct object *res = clone_object( Buffer_program, 0 );

    if( str->str.s )
    {
      str2 = OBJ2_BUFFER( res );

      if( str2->str.s ) free_string_builder( &str2->str );
      *str2 = *str;
      init_string_builder_alloc( &str2->str,
				 str->str.malloced,
				 str->str.s->size_shift );
      MEMCPY( (void *)str2->str.s, (void *)str->str.s,
	      str->str.malloced+sizeof(struct pike_string));
    }
    apply( res, "add", 1 );
    do { struct object * ret_=(res); pop_stack(); push_object(ret_); return; }while(0);
#line 476 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
}

  }
#define f_Buffer_cq__backtick_add_eq_defined
void f_Buffer_cq__backtick_add_eq(INT32 args) {
#line 478 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct pike_string * what;
#line 478 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 1) wrong_number_of_args_error("`+=",args,1);
#line 478 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(Pike_sp[0-1].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("`+=",1,"string");
#line 478 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
debug_malloc_pass(what=sp[0-1].u.string);
{
    f_Buffer_add( 1 );
    do { struct object * ret_=(fp->current_object); add_ref(ret_); pop_stack(); push_object(ret_); return; }while(0);
#line 482 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
}

  }
#define f_Buffer_add_defined
void f_Buffer_add(INT32 args) {
#line 484 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
struct pike_string * arg1;
#line 484 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args > 2147483647) wrong_number_of_args_error("add",args,2147483647);
#line 484 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(Pike_sp[0-args].type != PIKE_T_STRING) SIMPLE_BAD_ARG_ERROR("add",1,"string");
#line 484 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
debug_malloc_pass(arg1=sp[0-args].u.string);
#line 490 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
    struct Buffer_struct *str = THIS;
    int j;

    if (!str->str.s && args) {
      int sum = 0;
      int shift = 0;
      for (j=0; j < args; j++) {
	struct pike_string *a = Pike_sp[j-args].u.string;
	sum += a->len;
	shift |= a->size_shift;
      }
      if (sum < str->initial) {
	sum = str->initial;
      }
      init_string_builder_alloc(&str->str, sum, shift & ~(shift>>1));
    }

    for( j = 0; j<args; j++ )
    {
      struct pike_string *a = Pike_sp[j-args].u.string;
      string_builder_shared_strcat( &str->str, a );
    }

    if (str->str.s) {
      do { INT_TYPE ret_=(str->str.s->len); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 516 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
} else {
      do { INT_TYPE ret_=(0); pop_n_elems(args); push_int(ret_); return; }while(0);
#line 518 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
}
  }

  }
#define f_Buffer_get_copy_defined
void f_Buffer_get_copy(INT32 args) {
#line 521 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("get_copy",args,0);
#line 527 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
    struct pike_string *str = THIS->str.s;
    if( str )
    {
      ptrdiff_t len = str->len;
      if( len > 0 )
      {
	char *d = (char *)str->str;
	switch( str->size_shift )
	{
	  case 0:
	    do { struct pike_string * ret_=(make_shared_binary_string(d,len));  push_string(ret_); return; }while(0);
#line 539 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
break;
	  case 1:
	    do { struct pike_string * ret_=(make_shared_binary_string1((short*)d,len>>1));  push_string(ret_); return; }while(0);
#line 542 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
break;
	  case 2:
	    do { struct pike_string * ret_=(make_shared_binary_string2((int*)d,len>>2));  push_string(ret_); return; }while(0);
#line 545 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
break;
	}
      }
    }
    push_text("");
    return;
  }

  }
#define f_Buffer_get_defined
void f_Buffer_get(INT32 args) {
#line 553 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("get",args,0);
#line 561 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
    struct Buffer_struct *str = THIS;
    if( str->str.s )
    {
      struct pike_string *s = finish_string_builder( &str->str );
      str->str.malloced = 0;
      str->str.s = 0;
      do { struct pike_string * ret_=(s);  push_string(ret_); return; }while(0);
#line 569 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
}
    pop_n_elems(args);
    push_text("");
    return;
  }

  }
#define f_Buffer_cq__sizeof_defined
void f_Buffer_cq__sizeof(INT32 args) {
#line 575 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
if(args != 0) wrong_number_of_args_error("_sizeof",args,0);
#line 580 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
    struct Buffer_struct *str = THIS;
    do { INT_TYPE ret_=(str->str.s ? str->str.s->len : 0);  push_int(ret_); return; }while(0);
#line 583 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
}

  }

#undef internal_init_Buffer_defined
#define internal_init_Buffer_defined
static void init_Buffer_struct(struct object *o)
#line 586 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
      struct Buffer_struct *str = THIS;
      MEMSET( str, 0, sizeof( *str ) );
    }

  
#undef internal_exit_Buffer_defined
#define internal_exit_Buffer_defined
static void exit_Buffer_struct(struct object *o)
#line 592 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
{
      struct Buffer_struct *str = THIS;
      if( str->str.s )
	free_string_builder( &str->str );
    }
#line 599 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
/* @endmodule */

void init_builtin(void)
{

#ifdef class_Buffer_defined
  start_new_program();

#ifdef THIS_BUFFER

  Buffer_storage_offset=ADD_STORAGE(struct Buffer_struct);

#endif /* THIS_BUFFER */

#ifdef internal_init_Buffer_defined
  set_init_callback(init_Buffer_struct);

#endif /* internal_init_Buffer_defined */

#ifdef internal_exit_Buffer_defined
  set_exit_callback(exit_Buffer_struct);

#endif /* internal_exit_Buffer_defined */

#ifdef f_Buffer_create_defined
#line 376 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_FUNCTION2("create", f_Buffer_create, tFunc(tOr("\10\200\0\0\0\177\377\377\377",tVoid),tVoid), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_create_defined */

#ifdef f_Buffer_cq__sprintf_defined
#line 397 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_FUNCTION2("_sprintf", f_Buffer_cq__sprintf, tFunc("\10\200\0\0\0\177\377\377\377" tMapping,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__sprintf_defined */

#ifdef f_Buffer_cast_defined
#line 440 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_FUNCTION2("cast", f_Buffer_cast, tFunc(tString,tMix), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cast_defined */

#ifdef f_Buffer_cq__backtick_add_defined
#line 457 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_FUNCTION2("`+", f_Buffer_cq__backtick_add, tFunc(tString,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__backtick_add_defined */

#ifdef f_Buffer_cq__backtick_add_eq_defined
#line 478 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_FUNCTION2("`+=", f_Buffer_cq__backtick_add_eq, tFunc(tString,tObj), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__backtick_add_eq_defined */

#ifdef f_Buffer_add_defined
#line 484 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_FUNCTION2("add", f_Buffer_add, tFuncV(tNone,tString,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_add_defined */

#ifdef f_Buffer_get_copy_defined
#line 521 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_FUNCTION2("get_copy", f_Buffer_get_copy, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_get_copy_defined */

#ifdef f_Buffer_get_defined
#line 553 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_FUNCTION2("get", f_Buffer_get, tFunc(tNone,tString), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_get_defined */

#ifdef f_Buffer_cq__sizeof_defined
#line 575 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_FUNCTION2("_sizeof", f_Buffer_cq__sizeof, tFunc(tNone,"\10\200\0\0\0\177\377\377\377"), 0, OPT_EXTERNAL_DEPEND|OPT_SIDE_EFFECT);

#endif /* f_Buffer_cq__sizeof_defined */
  Buffer_program=end_program();
  add_program_constant("Buffer",Buffer_program,0);

#endif /* class_Buffer_defined */

#ifdef f_column_defined
#line 42 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_EFUN("column", f_column, tFunc(tArray tMix,tArray), OPT_TRY_OPTIMIZE);

#endif /* f_column_defined */

#ifdef f_mkmultiset_defined
#line 88 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_EFUN("mkmultiset", f_mkmultiset, tFunc(tArr(tSetvar(1,tMix)),tSet(tVar(1))), OPT_TRY_OPTIMIZE|OPT_EXTERNAL_DEPEND);

#endif /* f_mkmultiset_defined */

#ifdef f_trace_defined
#line 106 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_EFUN("trace", f_trace, tFunc("\10\200\0\0\0\177\377\377\377","\10\200\0\0\0\177\377\377\377"), OPT_SIDE_EFFECT);

#endif /* f_trace_defined */

#ifdef f_ctime_defined
#line 121 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_EFUN("ctime", f_ctime, tFunc("\10\200\0\0\0\177\377\377\377",tString), OPT_TRY_OPTIMIZE);

#endif /* f_ctime_defined */

#ifdef f_mkmapping_defined
#line 140 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_EFUN("mkmapping", f_mkmapping, tFunc(tArr(tSetvar(1,tMix)) tArr(tSetvar(2,tMix)),tMap(tVar(1),tVar(2))), OPT_TRY_OPTIMIZE|OPT_EXTERNAL_DEPEND);

#endif /* f_mkmapping_defined */

#ifdef f_string_count_defined
#line 158 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_FUNCTION2("string_count", f_string_count, tFunc(tString tString,"\10\200\0\0\0\177\377\377\377"), 0, OPT_TRY_OPTIMIZE);

#endif /* f_string_count_defined */

#ifdef f_program_implements_defined
#line 192 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_FUNCTION2("program_implements", f_program_implements, tFunc(tPrg tPrg,"\10\200\0\0\0\177\377\377\377"), 0, OPT_TRY_OPTIMIZE);

#endif /* f_program_implements_defined */

#ifdef f_program_inherits_defined
#line 201 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_FUNCTION2("program_inherits", f_program_inherits, tFunc(tPrg tPrg,"\10\200\0\0\0\177\377\377\377"), 0, OPT_TRY_OPTIMIZE);

#endif /* f_program_inherits_defined */

#ifdef f_program_defined_defined
#line 216 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_FUNCTION2("program_defined", f_program_defined, tFunc(tPrg,tString), 0, OPT_TRY_OPTIMIZE);

#endif /* f_program_defined_defined */

#ifdef f_string_width_defined
#line 257 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_FUNCTION2("string_width", f_string_width, tFunc(tString,"\10\200\0\0\0\177\377\377\377"), 0, OPT_TRY_OPTIMIZE);

#endif /* f_string_width_defined */

#ifdef f_m_delete_defined
#line 277 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_EFUN("m_delete", f_m_delete, tFunc(tOr(tObj,tMapping) tMix,tMix), OPT_SIDE_EFFECT);

#endif /* f_m_delete_defined */

#ifdef f_get_weak_flag_defined
#line 313 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
  ADD_EFUN("get_weak_flag", f_get_weak_flag, tFunc(tOr3(tArray,tMapping,tMultiset),"\10\200\0\0\0\177\377\377\377"), OPT_EXTERNAL_DEPEND);

#endif /* f_get_weak_flag_defined */
#line 604 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
}

void exit_builtin(void)
{

#ifdef class_Buffer_defined
  if(Buffer_program) {
    free_program(Buffer_program);
    Buffer_program=0;
  }

#endif /* class_Buffer_defined */
#line 609 "/home/grendel/tmp/pike-export/7.2.340/src/builtin.cmod"
}

