/***************************************************************************
 *            qof-datebook.h
 *
 *  Thu Oct 21 15:38:58 2004
 *  Copyright  2004-2005  Neil Williams
 *  linux@codehelp.co.uk
 ****************************************************************************/
/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
/** @addtogroup QOF
	@{ */
/** @addtogroup DB Datebooks and Appointments

A note on TIME:
	- QOF uses UTC time throughout
	- QSF uses UTC time in the XML, using the Z timezone-neutral designation.
	- pilot-link and the Palm use localtime.

The pilot-link QOF objects therefore expect UTC time from QOF and pass
\b localtime to the pilot-link code.

	@{ */
/** @file  qof-datebook.h
	@brief QOF datebook definitions for pilot-link
	@author Copyright (c) 2004 Neil Williams <linux@codehelp.co.uk>
*/

#ifndef _QOF_DATEBOOK_H
#define _QOF_DATEBOOK_H

/** \name QOF object declaration
@{
*/
#define PILOT_LINK_QOF_DATEBOOK "pilot_datebook"
#define QOF_DATEBOOK_DESC       "Pilot-link QOF datebook"
#define DATEBOOK_DESCRIPTION    "description"
#define DATEBOOK_DURATION       "duration_hours"

/** @} */

/** \brief Is this a transient repeat object?

To make it easier to query repeat appointments, transient
events are created for each incidence of a repeat. This
parameter allows such transient events to be ignored in
certain queries. */
#define DATEBOOK_REPEATER          "transient_repeat"

/** Register the datebook with QOF */
gboolean DateBookRegister (void);

#endif /* _QOF_DATEBOOK_H */
/** @} */
/** @} */
