/*
 * PIMPPA - File integrity checker
 *
 */

#include <limits.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/stat.h>

#include "pimppa.h"

int Verbose=0;
int BeNazi=0;					// Autodelete broken files

/*
 * Returns file extension (.ext) location as int
 *
 */
int return_ext(char *filename)
{
	int i;

	if(!filename)
		return(0);
		
	i=strlen(filename);
	
	while(i>0)
	{
		if(filename[i]=='.')
		{
			i++;
			break;
		}
		i--;
	}

	return(i);
}

int check()
{
	MYSQL *src_db, *dst_db;
	MYSQL_RES *sql_res, *sql_res2;
	MYSQL_ROW sql_row, sql_row2;
	char tmpfile[PATH_MAX];
	int passed_files=0, failed_files=0;
	int check_status;
	FILE *fp;

/********* Connect databases *******************************/

	src_db=p_connect();
	if(!src_db)
		return(0);

	dst_db=p_connect();
	if(!dst_db)
	{
		mysql_close(src_db);
		return(0);
	}

/******** fetch files with suitable filenames & test status *******/
	
	sprintf(tmpfile, "/tmp/pcheck.%d", getpid());
	fprintf(stderr, "Checking untested files...\n");

	p_query(src_db, "SELECT file_name, file_area, file_id, area_path "
			"FROM p_files, p_areas "
			"WHERE file_integ=%d AND NOT (file_flags & %ld) "
			"  AND file_area=area_id "
			"ORDER BY file_name",
		INTEG_NEW, FILE_OFFLINE); 
	if(mysql_error(src_db)[0])
		return(-1);
	
	sql_res=mysql_store_result(src_db);

	while((sql_row=mysql_fetch_row(sql_res)))
	{
		int i;
		char path[PATH_MAX];
		
		check_status=INTEG_NEW;

		sprintf(path, "%s%s%s", 
				sql_row[3], 
				(p_checkp(sql_row[3]) ? "" : "/"),
				sql_row[0]);

		if(Verbose)
			fprintf(stderr, "%s", sql_row[0]);

		i=return_ext(sql_row[0]);
		p_query(dst_db, "SELECT type_testcmd, type_testokstr "
				"FROM p_types "
				"WHERE type_ext='%s'",
			&sql_row[0][i]);
		if(mysql_error(dst_db)[0])
		{
			fprintf(stderr, "Err: %s\n", mysql_error(dst_db));
			continue;
		}
		sql_res2=mysql_store_result(dst_db);
		if(!sql_res2)
		{
			fprintf(stderr, "Err: %s\n", mysql_error(dst_db));
			continue;
		}
		if((sql_row2=mysql_fetch_row(sql_res2)))
		{
			char tmpbuf[QUERY_MAX];
			int error,testres;
			struct stat st;
			
			error=1;					// Optimistic, eh?
			
			if(stat(path, &st)!=0)
			{
				if(Verbose)
					fprintf(stderr, " - Offline!\n");
			
				mysql_free_result(sql_res2);
			
				p_query(dst_db, "UPDATE p_files "
						"SET file_flags=(file_flags | %ld) "
						"WHERE file_id=%s",
					FILE_OFFLINE, sql_row[2]);
				if(mysql_error(dst_db)[0])
					fprintf(stderr, "Err: %s\n", mysql_error(dst_db));

				continue;
			}

			sprintf(tmpbuf, "%s \"%s\" >%s 2>/dev/null", 
					sql_row2[0], path, tmpfile);
			testres=system(tmpbuf); 	// Test file

			if(sql_row2[1][0])			// We have "test_ok" string
			{
				if((fp=fopen(tmpfile, "r")))
				{		
					while((fgets(tmpbuf, QUERY_MAX, fp)))
					{
						if(strstr(tmpbuf, sql_row2[1])!=NULL)
						{
							error=0;
							break;
						}
					}
					fclose(fp);
				}
			}							
			else						// No "test_ok" string
				error=testres;

			if(!error)
			{
				if(Verbose)
					fprintf(stderr, " - Passed\n");
				check_status=INTEG_PASSED;
				passed_files++;
			}
			else
			{
				if(Verbose)
					fprintf(stderr, " - FAILED!\n");
				check_status=INTEG_FAILED;
				failed_files++;
			}
		}
		else 
		{
			if(Verbose)
				fprintf(stderr, " - Unknown filetype\n");

			check_status=INTEG_UNKNOWN;
		}

		mysql_free_result(sql_res2);

		if(check_status==INTEG_FAILED && BeNazi) 	// Delete it
		{
			remove(path);
			
			p_query(dst_db, "DELETE FROM p_files "
					"WHERE file_id=%s",
				sql_row[2]);
		}
		else
		{	p_query(dst_db, "UPDATE p_files "
					"SET file_integ=%d "
					"WHERE file_id=%s",
				check_status, sql_row[2]);
		}
		if(mysql_error(dst_db)[0])
			fprintf(stderr, "%s\n", mysql_error(dst_db));
	}

	mysql_free_result(sql_res);

	remove(tmpfile);

	fprintf(stderr, "%d checked, %d passed and %d failed.\n",
					passed_files+failed_files, passed_files,
					failed_files);

	mysql_close(dst_db);
	mysql_close(src_db);
	
	return(1);
}
	

int main(int argc, char *argv[])
{
	int go=1;

	while(go)
	{
		switch(getopt(argc, argv, "hnvV"))
		{
			case 'v':
				Verbose=1;
				break;
			case 'h':
				fprintf(stderr, "Usage: %s [-hvn]\n\n%s", argv[0],
								"-n   Nazi, autodelete broken files\n"
								"-v   Verbose\n");
				return(0);
				break;
			case 'n':
				BeNazi=1;
				break;
			case 'V':
				printf("%s %s %s\n", PACKAGE, argv[0], VERSION);
				return(0);
				break;
			default:
				go=0;
				break;
		}
	}

	check();
	
	return(0);
}

