;;; planner-xtla.el --- Xtla integration for the Emacs Planner

;; Copyright (C) 2005 Stefan Reichr

;; Author: Stefan Reichr <stefan@xsteve.at>
;; Keywords: planner, xtla

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;;_ + Commentary:

;; This file allows you to refer to your tla changesets easily from within
;; a planner page.
;;
;; Example:
;; [[xtla://miles@gnu.org--gnu-2005/emacs--cvs-trunk--0--patch-19][patch-19]]
;;   can be browsed easily via xtla

;;; Code:

(require 'planner)
(require 'xtla)

(defun planner-annotation-from-xtla ()
  "If called from a xtla buffer, return an annotation.
Suitable for use in `planner-annotation-functions'."
  (cond ((eq major-mode 'tla-revision-list-mode)
         (concat "[[xtla://"
                 (cadr (tla--get-revision-info-at-point))
                 "][" (cadr (tla--get-revision-info-at-point))
                 "]]"))))

(defun planner-xtla-browse-url (url)
  "If this is a xtla url, handle it."
  (when (string-match "^xtla:/?/?\\(.+\\)" url)
    (tla-get-changeset (match-string 1 url) t)
    t))

(planner-add-protocol "xtla" 'planner-xtla-browse-url nil)
(add-hook 'planner-annotation-functions 'planner-annotation-from-xtla)
(custom-add-option 'planner-annotation-functions 'planner-annotation-from-xtla)

(provide 'planner-xtla)

;;; planner-xtla.el ends here
