/* ========================================================================
 * PlantUML : a free UML diagram generator
 * ========================================================================
 *
 * (C) Copyright 2009-2017, Arnaud Roques
 *
 * Project Info:  http://plantuml.com
 * 
 * This file is part of PlantUML.
 *
 * Licensed under The MIT License (Massachusetts Institute of Technology License)
 * 
 * See http://opensource.org/licenses/MIT
 * 
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
 * IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 * 
 *
 * Original Author:  Arnaud Roques
 */
package net.sourceforge.plantuml.eggs;

import java.awt.Font;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

import javax.imageio.ImageIO;

import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UFont;

public class PSystemAppleTwo extends AbstractPSystem {

	private final List<String> strings = new ArrayList<String>();
	private final BufferedImage image;

	public PSystemAppleTwo() throws IOException {
		strings.add("   <b><size:16>Apple //e for ever!");
		strings.add(" ");

		final InputStream is = new ByteArrayInputStream(imm);
		image = ImageIO.read(is);
		is.close();
	}

	public ImageData exportDiagram(OutputStream os, int num, FileFormatOption fileFormat) throws IOException {
		final GraphicStrings result = getGraphicStrings();
		final ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, result.getBackcolor(),
				getMetadata(), null, 0, 0, null, false);
		imageBuilder.setUDrawable(result);
		return imageBuilder.writeImageTOBEMOVED(fileFormat, os);
	}

	private GraphicStrings getGraphicStrings() throws IOException {
		final UFont font = new UFont("SansSerif", Font.PLAIN, 12);
		final GraphicStrings result = new GraphicStrings(strings, font, HtmlColorUtils.BLACK, HtmlColorUtils.WHITE,
				UAntiAliasing.ANTI_ALIASING_ON, image, GraphicPosition.BOTTOM);
		result.setMinWidth(200);
		return result;
	}

	public DiagramDescription getDescription() {
		return new DiagramDescriptionImpl("(Apple //e)", getClass());
	}

	private static final byte imm[] = new byte[] { (byte) 255, (byte) 216, (byte) 255, (byte) 224, (byte) 0, (byte) 16,
			(byte) 74, (byte) 70, (byte) 73, (byte) 70, (byte) 0, (byte) 1, (byte) 1, (byte) 1, (byte) 0, (byte) 96,
			(byte) 0, (byte) 96, (byte) 0, (byte) 0, (byte) 255, (byte) 219, (byte) 0, (byte) 67, (byte) 0, (byte) 10,
			(byte) 7, (byte) 7, (byte) 8, (byte) 7, (byte) 6, (byte) 10, (byte) 8, (byte) 8, (byte) 8, (byte) 11,
			(byte) 10, (byte) 10, (byte) 11, (byte) 14, (byte) 24, (byte) 16, (byte) 14, (byte) 13, (byte) 13,
			(byte) 14, (byte) 29, (byte) 21, (byte) 22, (byte) 17, (byte) 24, (byte) 35, (byte) 31, (byte) 37,
			(byte) 36, (byte) 34, (byte) 31, (byte) 34, (byte) 33, (byte) 38, (byte) 43, (byte) 55, (byte) 47,
			(byte) 38, (byte) 41, (byte) 52, (byte) 41, (byte) 33, (byte) 34, (byte) 48, (byte) 65, (byte) 49,
			(byte) 52, (byte) 57, (byte) 59, (byte) 62, (byte) 62, (byte) 62, (byte) 37, (byte) 46, (byte) 68,
			(byte) 73, (byte) 67, (byte) 60, (byte) 72, (byte) 55, (byte) 61, (byte) 62, (byte) 59, (byte) 255,
			(byte) 219, (byte) 0, (byte) 67, (byte) 1, (byte) 10, (byte) 11, (byte) 11, (byte) 14, (byte) 13,
			(byte) 14, (byte) 28, (byte) 16, (byte) 16, (byte) 28, (byte) 59, (byte) 40, (byte) 34, (byte) 40,
			(byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59,
			(byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59,
			(byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59,
			(byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59,
			(byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59,
			(byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 59, (byte) 255, (byte) 192, (byte) 0, (byte) 17,
			(byte) 8, (byte) 0, (byte) 136, (byte) 0, (byte) 200, (byte) 3, (byte) 1, (byte) 34, (byte) 0, (byte) 2,
			(byte) 17, (byte) 1, (byte) 3, (byte) 17, (byte) 1, (byte) 255, (byte) 196, (byte) 0, (byte) 31, (byte) 0,
			(byte) 0, (byte) 1, (byte) 5, (byte) 1, (byte) 1, (byte) 1, (byte) 1, (byte) 1, (byte) 1, (byte) 0,
			(byte) 0, (byte) 0, (byte) 0, (byte) 0, (byte) 0, (byte) 0, (byte) 0, (byte) 1, (byte) 2, (byte) 3,
			(byte) 4, (byte) 5, (byte) 6, (byte) 7, (byte) 8, (byte) 9, (byte) 10, (byte) 11, (byte) 255, (byte) 196,
			(byte) 0, (byte) 181, (byte) 16, (byte) 0, (byte) 2, (byte) 1, (byte) 3, (byte) 3, (byte) 2, (byte) 4,
			(byte) 3, (byte) 5, (byte) 5, (byte) 4, (byte) 4, (byte) 0, (byte) 0, (byte) 1, (byte) 125, (byte) 1,
			(byte) 2, (byte) 3, (byte) 0, (byte) 4, (byte) 17, (byte) 5, (byte) 18, (byte) 33, (byte) 49, (byte) 65,
			(byte) 6, (byte) 19, (byte) 81, (byte) 97, (byte) 7, (byte) 34, (byte) 113, (byte) 20, (byte) 50,
			(byte) 129, (byte) 145, (byte) 161, (byte) 8, (byte) 35, (byte) 66, (byte) 177, (byte) 193, (byte) 21,
			(byte) 82, (byte) 209, (byte) 240, (byte) 36, (byte) 51, (byte) 98, (byte) 114, (byte) 130, (byte) 9,
			(byte) 10, (byte) 22, (byte) 23, (byte) 24, (byte) 25, (byte) 26, (byte) 37, (byte) 38, (byte) 39,
			(byte) 40, (byte) 41, (byte) 42, (byte) 52, (byte) 53, (byte) 54, (byte) 55, (byte) 56, (byte) 57,
			(byte) 58, (byte) 67, (byte) 68, (byte) 69, (byte) 70, (byte) 71, (byte) 72, (byte) 73, (byte) 74,
			(byte) 83, (byte) 84, (byte) 85, (byte) 86, (byte) 87, (byte) 88, (byte) 89, (byte) 90, (byte) 99,
			(byte) 100, (byte) 101, (byte) 102, (byte) 103, (byte) 104, (byte) 105, (byte) 106, (byte) 115, (byte) 116,
			(byte) 117, (byte) 118, (byte) 119, (byte) 120, (byte) 121, (byte) 122, (byte) 131, (byte) 132, (byte) 133,
			(byte) 134, (byte) 135, (byte) 136, (byte) 137, (byte) 138, (byte) 146, (byte) 147, (byte) 148, (byte) 149,
			(byte) 150, (byte) 151, (byte) 152, (byte) 153, (byte) 154, (byte) 162, (byte) 163, (byte) 164, (byte) 165,
			(byte) 166, (byte) 167, (byte) 168, (byte) 169, (byte) 170, (byte) 178, (byte) 179, (byte) 180, (byte) 181,
			(byte) 182, (byte) 183, (byte) 184, (byte) 185, (byte) 186, (byte) 194, (byte) 195, (byte) 196, (byte) 197,
			(byte) 198, (byte) 199, (byte) 200, (byte) 201, (byte) 202, (byte) 210, (byte) 211, (byte) 212, (byte) 213,
			(byte) 214, (byte) 215, (byte) 216, (byte) 217, (byte) 218, (byte) 225, (byte) 226, (byte) 227, (byte) 228,
			(byte) 229, (byte) 230, (byte) 231, (byte) 232, (byte) 233, (byte) 234, (byte) 241, (byte) 242, (byte) 243,
			(byte) 244, (byte) 245, (byte) 246, (byte) 247, (byte) 248, (byte) 249, (byte) 250, (byte) 255, (byte) 196,
			(byte) 0, (byte) 31, (byte) 1, (byte) 0, (byte) 3, (byte) 1, (byte) 1, (byte) 1, (byte) 1, (byte) 1,
			(byte) 1, (byte) 1, (byte) 1, (byte) 1, (byte) 0, (byte) 0, (byte) 0, (byte) 0, (byte) 0, (byte) 0,
			(byte) 1, (byte) 2, (byte) 3, (byte) 4, (byte) 5, (byte) 6, (byte) 7, (byte) 8, (byte) 9, (byte) 10,
			(byte) 11, (byte) 255, (byte) 196, (byte) 0, (byte) 181, (byte) 17, (byte) 0, (byte) 2, (byte) 1, (byte) 2,
			(byte) 4, (byte) 4, (byte) 3, (byte) 4, (byte) 7, (byte) 5, (byte) 4, (byte) 4, (byte) 0, (byte) 1,
			(byte) 2, (byte) 119, (byte) 0, (byte) 1, (byte) 2, (byte) 3, (byte) 17, (byte) 4, (byte) 5, (byte) 33,
			(byte) 49, (byte) 6, (byte) 18, (byte) 65, (byte) 81, (byte) 7, (byte) 97, (byte) 113, (byte) 19,
			(byte) 34, (byte) 50, (byte) 129, (byte) 8, (byte) 20, (byte) 66, (byte) 145, (byte) 161, (byte) 177,
			(byte) 193, (byte) 9, (byte) 35, (byte) 51, (byte) 82, (byte) 240, (byte) 21, (byte) 98, (byte) 114,
			(byte) 209, (byte) 10, (byte) 22, (byte) 36, (byte) 52, (byte) 225, (byte) 37, (byte) 241, (byte) 23,
			(byte) 24, (byte) 25, (byte) 26, (byte) 38, (byte) 39, (byte) 40, (byte) 41, (byte) 42, (byte) 53,
			(byte) 54, (byte) 55, (byte) 56, (byte) 57, (byte) 58, (byte) 67, (byte) 68, (byte) 69, (byte) 70,
			(byte) 71, (byte) 72, (byte) 73, (byte) 74, (byte) 83, (byte) 84, (byte) 85, (byte) 86, (byte) 87,
			(byte) 88, (byte) 89, (byte) 90, (byte) 99, (byte) 100, (byte) 101, (byte) 102, (byte) 103, (byte) 104,
			(byte) 105, (byte) 106, (byte) 115, (byte) 116, (byte) 117, (byte) 118, (byte) 119, (byte) 120, (byte) 121,
			(byte) 122, (byte) 130, (byte) 131, (byte) 132, (byte) 133, (byte) 134, (byte) 135, (byte) 136, (byte) 137,
			(byte) 138, (byte) 146, (byte) 147, (byte) 148, (byte) 149, (byte) 150, (byte) 151, (byte) 152, (byte) 153,
			(byte) 154, (byte) 162, (byte) 163, (byte) 164, (byte) 165, (byte) 166, (byte) 167, (byte) 168, (byte) 169,
			(byte) 170, (byte) 178, (byte) 179, (byte) 180, (byte) 181, (byte) 182, (byte) 183, (byte) 184, (byte) 185,
			(byte) 186, (byte) 194, (byte) 195, (byte) 196, (byte) 197, (byte) 198, (byte) 199, (byte) 200, (byte) 201,
			(byte) 202, (byte) 210, (byte) 211, (byte) 212, (byte) 213, (byte) 214, (byte) 215, (byte) 216, (byte) 217,
			(byte) 218, (byte) 226, (byte) 227, (byte) 228, (byte) 229, (byte) 230, (byte) 231, (byte) 232, (byte) 233,
			(byte) 234, (byte) 242, (byte) 243, (byte) 244, (byte) 245, (byte) 246, (byte) 247, (byte) 248, (byte) 249,
			(byte) 250, (byte) 255, (byte) 218, (byte) 0, (byte) 12, (byte) 3, (byte) 1, (byte) 0, (byte) 2, (byte) 17,
			(byte) 3, (byte) 17, (byte) 0, (byte) 63, (byte) 0, (byte) 246, (byte) 106, (byte) 40, (byte) 162,
			(byte) 128, (byte) 10, (byte) 40, (byte) 162, (byte) 128, (byte) 43, (byte) 221, (byte) 92, (byte) 253,
			(byte) 153, (byte) 3, (byte) 121, (byte) 79, (byte) 41, (byte) 39, (byte) 133, (byte) 66, (byte) 185,
			(byte) 253, (byte) 72, (byte) 21, (byte) 145, (byte) 115, (byte) 173, (byte) 106, (byte) 157, (byte) 45,
			(byte) 180, (byte) 146, (byte) 191, (byte) 237, (byte) 73, (byte) 42, (byte) 31, (byte) 208, (byte) 55,
			(byte) 245, (byte) 173, (byte) 59, (byte) 225, (byte) 157, (byte) 159, (byte) 83, (byte) 92, (byte) 61,
			(byte) 182, (byte) 181, (byte) 169, (byte) 181, (byte) 149, (byte) 188, (byte) 243, (byte) 223, (byte) 91,
			(byte) 71, (byte) 44, (byte) 209, (byte) 171, (byte) 149, (byte) 54, (byte) 228, (byte) 129, (byte) 144,
			(byte) 9, (byte) 254, (byte) 44, (byte) 247, (byte) 245, (byte) 172, (byte) 165, (byte) 39, (byte) 114,
			(byte) 210, (byte) 69, (byte) 251, (byte) 155, (byte) 239, (byte) 19, (byte) 78, (byte) 113, (byte) 135,
			(byte) 133, (byte) 79, (byte) 240, (byte) 196, (byte) 168, (byte) 63, (byte) 92, (byte) 147, (byte) 250,
			(byte) 213, (byte) 80, (byte) 254, (byte) 34, (byte) 67, (byte) 129, (byte) 53, (byte) 222, (byte) 115,
			(byte) 221, (byte) 203, (byte) 127, (byte) 141, (byte) 52, (byte) 107, (byte) 183, (byte) 185, (byte) 192,
			(byte) 213, (byte) 180, (byte) 188, (byte) 142, (byte) 205, (byte) 106, (byte) 223, (byte) 252, (byte) 120,
			(byte) 84, (byte) 131, (byte) 90, (byte) 212, (byte) 63, (byte) 232, (byte) 41, (byte) 164, (byte) 127,
			(byte) 224, (byte) 51, (byte) 127, (byte) 241, (byte) 250, (byte) 139, (byte) 190, (byte) 229, (byte) 104,
			(byte) 39, (byte) 159, (byte) 226, (byte) 64, (byte) 120, (byte) 158, (byte) 232, (byte) 255, (byte) 0,
			(byte) 192, (byte) 88, (byte) 255, (byte) 0, (byte) 74, (byte) 67, (byte) 121, (byte) 226, (byte) 96,
			(byte) 121, (byte) 158, (byte) 243, (byte) 131, (byte) 198, (byte) 32, (byte) 110, (byte) 127, (byte) 241,
			(byte) 202, (byte) 144, (byte) 107, (byte) 119, (byte) 223, (byte) 244, (byte) 16, (byte) 210, (byte) 88,
			(byte) 250, (byte) 8, (byte) 136, (byte) 255, (byte) 0, (byte) 218, (byte) 198, (byte) 158, (byte) 53,
			(byte) 203, (byte) 220, (byte) 224, (byte) 73, (byte) 167, (byte) 183, (byte) 209, (byte) 138, (byte) 255,
			(byte) 0, (byte) 83, (byte) 74, (byte) 236, (byte) 44, (byte) 66, (byte) 53, (byte) 63, (byte) 18,
			(byte) 131, (byte) 180, (byte) 205, (byte) 121, (byte) 248, (byte) 218, (byte) 31, (byte) 254, (byte) 34,
			(byte) 156, (byte) 53, (byte) 143, (byte) 16, (byte) 142, (byte) 179, (byte) 207, (byte) 199, (byte) 247,
			(byte) 173, (byte) 64, (byte) 254, (byte) 105, (byte) 86, (byte) 6, (byte) 181, (byte) 169, (byte) 127,
			(byte) 207, (byte) 173, (byte) 131, (byte) 255, (byte) 0, (byte) 219, (byte) 211, (byte) 47, (byte) 254,
			(byte) 211, (byte) 52, (byte) 241, (byte) 172, (byte) 234, (byte) 196, (byte) 241, (byte) 166, (byte) 88,
			(byte) 48, (byte) 246, (byte) 191, (byte) 147, (byte) 255, (byte) 0, (byte) 140, (byte) 83, (byte) 187,
			(byte) 2, (byte) 161, (byte) 215, (byte) 181, (byte) 213, (byte) 25, (byte) 55, (byte) 79, (byte) 248,
			(byte) 194, (byte) 131, (byte) 255, (byte) 0, (byte) 101, (byte) 163, (byte) 254, (byte) 18, (byte) 61,
			(byte) 100, (byte) 114, (byte) 110, (byte) 112, (byte) 61, (byte) 227, (byte) 65, (byte) 253, (byte) 42,
			(byte) 231, (byte) 246, (byte) 206, (byte) 168, (byte) 57, (byte) 109, (byte) 46, (byte) 215, (byte) 254,
			(byte) 3, (byte) 122, (byte) 231, (byte) 255, (byte) 0, (byte) 104, (byte) 138, (byte) 81, (byte) 175,
			(byte) 95, (byte) 15, (byte) 189, (byte) 166, (byte) 1, (byte) 254, (byte) 237, (byte) 206, (byte) 127,
			(byte) 154, (byte) 138, (byte) 46, (byte) 251, (byte) 133, (byte) 151, (byte) 98, (byte) 160, (byte) 241,
			(byte) 54, (byte) 172, (byte) 188, (byte) 153, (byte) 227, (byte) 56, (byte) 245, (byte) 9, (byte) 82,
			(byte) 47, (byte) 136, (byte) 181, (byte) 210, (byte) 55, (byte) 36, (byte) 45, (byte) 34, (byte) 255,
			(byte) 0, (byte) 121, (byte) 45, (byte) 139, (byte) 143, (byte) 204, (byte) 86, (byte) 134, (byte) 153,
			(byte) 172, (byte) 46, (byte) 177, (byte) 101, (byte) 117, (byte) 34, (byte) 197, (byte) 36, (byte) 45,
			(byte) 4, (byte) 175, (byte) 4, (byte) 138, (byte) 236, (byte) 15, (byte) 204, (byte) 160, (byte) 19,
			(byte) 211, (byte) 168, (byte) 230, (byte) 132, (byte) 211, (byte) 165, (byte) 142, (byte) 118, (byte) 104,
			(byte) 239, (byte) 25, (byte) 119, (byte) 73, (byte) 189, (byte) 129, (byte) 81, (byte) 202, (byte) 231,
			(byte) 59, (byte) 126, (byte) 152, (byte) 226, (byte) 142, (byte) 103, (byte) 220, (byte) 44, (byte) 140,
			(byte) 209, (byte) 226, (byte) 173, (byte) 88, (byte) 16, (byte) 79, (byte) 144, (byte) 65, (byte) 231,
			(byte) 5, (byte) 63, (byte) 250, (byte) 249, (byte) 167, (byte) 127, (byte) 194, (byte) 95, (byte) 169,
			(byte) 47, (byte) 38, (byte) 43, (byte) 102, (byte) 3, (byte) 146, (byte) 54, (byte) 48, (byte) 255,
			(byte) 0, (byte) 217, (byte) 171, (byte) 50, (byte) 225, (byte) 118, (byte) 201, (byte) 34, (byte) 246,
			(byte) 87, (byte) 35, (byte) 167, (byte) 185, (byte) 170, (byte) 237, (byte) 83, (byte) 205, (byte) 46,
			(byte) 227, (byte) 178, (byte) 61, (byte) 58, (byte) 55, (byte) 89, (byte) 35, (byte) 87, (byte) 83,
			(byte) 149, (byte) 97, (byte) 144, (byte) 125, (byte) 69, (byte) 62, (byte) 178, (byte) 252, (byte) 61,
			(byte) 113, (byte) 246, (byte) 141, (byte) 14, (byte) 217, (byte) 179, (byte) 146, (byte) 139, (byte) 229,
			(byte) 159, (byte) 248, (byte) 9, (byte) 199, (byte) 242, (byte) 197, (byte) 106, (byte) 87, (byte) 74,
			(byte) 119, (byte) 70, (byte) 33, (byte) 69, (byte) 20, (byte) 83, (byte) 0, (byte) 162, (byte) 138,
			(byte) 40, (byte) 0, (byte) 162, (byte) 138, (byte) 40, (byte) 0, (byte) 162, (byte) 138, (byte) 40,
			(byte) 0, (byte) 162, (byte) 138, (byte) 40, (byte) 2, (byte) 181, (byte) 224, (byte) 253, (byte) 218,
			(byte) 253, (byte) 107, (byte) 202, (byte) 245, (byte) 112, (byte) 97, (byte) 142, (byte) 201, (byte) 84,
			(byte) 227, (byte) 98, (byte) 178, (byte) 140, (byte) 123, (byte) 96, (byte) 127, (byte) 74, (byte) 245,
			(byte) 91, (byte) 177, (byte) 152, (byte) 135, (byte) 177, (byte) 175, (byte) 46, (byte) 241, (byte) 26,
			(byte) 20, (byte) 158, (byte) 37, (byte) 56, (byte) 225, (byte) 229, (byte) 0, (byte) 99, (byte) 253,
			(byte) 161, (byte) 88, (byte) 207, (byte) 114, (byte) 227, (byte) 177, (byte) 199, (byte) 94, (byte) 11,
			(byte) 155, (byte) 251, (byte) 249, (byte) 101, (byte) 121, (byte) 164, (byte) 42, (byte) 174, (byte) 81,
			(byte) 20, (byte) 49, (byte) 194, (byte) 237, (byte) 249, (byte) 78, (byte) 7, (byte) 185, (byte) 6,
			(byte) 180, (byte) 52, (byte) 125, (byte) 58, (byte) 53, (byte) 156, (byte) 25, (byte) 162, (byte) 71,
			(byte) 207, (byte) 247, (byte) 192, (byte) 111, (byte) 231, (byte) 78, (byte) 181, (byte) 69, (byte) 49,
			(byte) 22, (byte) 199, (byte) 223, (byte) 146, (byte) 70, (byte) 252, (byte) 221, (byte) 143, (byte) 245,
			(byte) 171, (byte) 208, (byte) 29, (byte) 146, (byte) 2, (byte) 43, (byte) 101, (byte) 162, (byte) 49,
			(byte) 111, (byte) 83, (byte) 164, (byte) 131, (byte) 72, (byte) 181, (byte) 104, (byte) 195, (byte) 44,
			(byte) 17, (byte) 129, (byte) 140, (byte) 240, (byte) 130, (byte) 164, (byte) 146, (byte) 194, (byte) 203,
			(byte) 162, (byte) 194, (byte) 83, (byte) 28, (byte) 96, (byte) 128, (byte) 217, (byte) 231, (byte) 175,
			(byte) 229, (byte) 69, (byte) 133, (byte) 223, (byte) 238, (byte) 128, (byte) 207, (byte) 106, (byte) 145,
			(byte) 229, (byte) 6, (byte) 168, (byte) 30, (byte) 166, (byte) 117, (byte) 214, (byte) 159, (byte) 0,
			(byte) 145, (byte) 188, (byte) 164, (byte) 194, (byte) 103, (byte) 140, (byte) 129, (byte) 156, (byte) 126,
			(byte) 21, (byte) 151, (byte) 113, (byte) 96, (byte) 64, (byte) 37, (byte) 93, (byte) 212, (byte) 255,
			(byte) 0, (byte) 178, (byte) 228, (byte) 127, (byte) 90, (byte) 218, (byte) 185, (byte) 151, (byte) 142,
			(byte) 43, (byte) 53, (byte) 230, (byte) 39, (byte) 140, (byte) 210, (byte) 29, (byte) 236, (byte) 97,
			(byte) 77, (byte) 29, (byte) 228, (byte) 71, (byte) 228, (byte) 185, (byte) 153, (byte) 123, (byte) 242,
			(byte) 217, (byte) 254, (byte) 117, (byte) 99, (byte) 64, (byte) 188, (byte) 212, (byte) 134, (byte) 187,
			(byte) 107, (byte) 12, (byte) 215, (byte) 38, (byte) 104, (byte) 100, (byte) 44, (byte) 25, (byte) 89,
			(byte) 20, (byte) 17, (byte) 242, (byte) 147, (byte) 144, (byte) 64, (byte) 29, (byte) 197, (byte) 93,
			(byte) 145, (byte) 65, (byte) 228, (byte) 210, (byte) 105, (byte) 113, (byte) 168, (byte) 214, (byte) 109,
			(byte) 155, (byte) 28, (byte) 135, (byte) 63, (byte) 250, (byte) 9, (byte) 169, (byte) 146, (byte) 86,
			(byte) 8, (byte) 201, (byte) 220, (byte) 234, (byte) 124, (byte) 34, (byte) 127, (byte) 119, (byte) 173,
			(byte) 199, (byte) 233, (byte) 168, (byte) 74, (byte) 223, (byte) 154, (byte) 175, (byte) 248, (byte) 87,
			(byte) 79, (byte) 92, (byte) 199, (byte) 132, (byte) 191, (byte) 227, (byte) 243, (byte) 93, (byte) 143,
			(byte) 176, (byte) 187, (byte) 45, (byte) 215, (byte) 212, (byte) 176, (byte) 254, (byte) 149, (byte) 211,
			(byte) 175, (byte) 32, (byte) 31, (byte) 106, (byte) 230, (byte) 55, (byte) 56, (byte) 219, (byte) 209,
			(byte) 139, (byte) 139, (byte) 128, (byte) 58, (byte) 9, (byte) 152, (byte) 126, (byte) 166, (byte) 170,
			(byte) 53, (byte) 93, (byte) 212, (byte) 70, (byte) 46, (byte) 238, (byte) 127, (byte) 235, (byte) 187,
			(byte) 255, (byte) 0, (byte) 232, (byte) 77, (byte) 84, (byte) 24, (byte) 212, (byte) 148, (byte) 117,
			(byte) 126, (byte) 12, (byte) 184, (byte) 6, (byte) 11, (byte) 155, (byte) 98, (byte) 126, (byte) 235,
			(byte) 135, (byte) 25, (byte) 247, (byte) 24, (byte) 254, (byte) 131, (byte) 243, (byte) 174, (byte) 162,
			(byte) 184, (byte) 63, (byte) 10, (byte) 220, (byte) 121, (byte) 26, (byte) 226, (byte) 33, (byte) 56,
			(byte) 19, (byte) 163, (byte) 39, (byte) 63, (byte) 159, (byte) 244, (byte) 174, (byte) 238, (byte) 186,
			(byte) 105, (byte) 187, (byte) 196, (byte) 202, (byte) 75, (byte) 81, (byte) 104, (byte) 162, (byte) 138,
			(byte) 178, (byte) 66, (byte) 138, (byte) 40, (byte) 160, (byte) 2, (byte) 138, (byte) 40, (byte) 160,
			(byte) 2, (byte) 138, (byte) 40, (byte) 160, (byte) 2, (byte) 138, (byte) 40, (byte) 160, (byte) 10,
			(byte) 247, (byte) 127, (byte) 234, (byte) 9, (byte) 244, (byte) 34, (byte) 188, (byte) 215, (byte) 197,
			(byte) 75, (byte) 139, (byte) 248, (byte) 135, (byte) 253, (byte) 52, (byte) 148, (byte) 127, (byte) 227,
			(byte) 194, (byte) 189, (byte) 50, (byte) 228, (byte) 102, (byte) 221, (byte) 171, (byte) 205, (byte) 124,
			(byte) 87, (byte) 197, (byte) 236, (byte) 39, (byte) 254, (byte) 154, (byte) 74, (byte) 127, (byte) 85,
			(byte) 172, (byte) 103, (byte) 185, (byte) 113, (byte) 216, (byte) 229, (byte) 108, (byte) 159, (byte) 253,
			(byte) 10, (byte) 220, (byte) 250, (byte) 198, (byte) 191, (byte) 202, (byte) 174, (byte) 198, (byte) 220,
			(byte) 138, (byte) 205, (byte) 180, (byte) 56, (byte) 180, (byte) 128, (byte) 122, (byte) 32, (byte) 31,
			(byte) 149, (byte) 91, (byte) 141, (byte) 186, (byte) 86, (byte) 199, (byte) 59, (byte) 220, (byte) 232,
			(byte) 109, (byte) 37, (byte) 2, (byte) 33, (byte) 207, (byte) 52, (byte) 247, (byte) 185, (byte) 219,
			(byte) 222, (byte) 179, (byte) 160, (byte) 124, (byte) 39, (byte) 90, (byte) 116, (byte) 143, (byte) 129,
			(byte) 78, (byte) 227, (byte) 38, (byte) 146, (byte) 125, (byte) 245, (byte) 3, (byte) 250, (byte) 211,
			(byte) 21, (byte) 179, (byte) 77, (byte) 145, (byte) 248, (byte) 160, (byte) 67, (byte) 36, (byte) 147,
			(byte) 60, (byte) 84, (byte) 186, (byte) 79, (byte) 58, (byte) 189, (byte) 184, (byte) 245, (byte) 111,
			(byte) 232, (byte) 106, (byte) 163, (byte) 18, (byte) 77, (byte) 90, (byte) 210, (byte) 71, (byte) 252,
			(byte) 77, (byte) 109, (byte) 191, (byte) 223, (byte) 254, (byte) 148, (byte) 158, (byte) 195, (byte) 91,
			(byte) 157, (byte) 79, (byte) 132, (byte) 255, (byte) 0, (byte) 228, (byte) 51, (byte) 174, (byte) 175,
			(byte) 253, (byte) 54, (byte) 67, (byte) 249, (byte) 188, (byte) 191, (byte) 225, (byte) 93, (byte) 60,
			(byte) 99, (byte) 247, (byte) 106, (byte) 79, (byte) 112, (byte) 43, (byte) 150, (byte) 240, (byte) 153,
			(byte) 198, (byte) 187, (byte) 173, (byte) 251, (byte) 200, (byte) 191, (byte) 250, (byte) 28, (byte) 191,
			(byte) 227, (byte) 93, (byte) 76, (byte) 103, (byte) 247, (byte) 72, (byte) 48, (byte) 79, (byte) 202,
			(byte) 58, (byte) 125, (byte) 43, (byte) 152, (byte) 232, (byte) 103, (byte) 35, (byte) 170, (byte) 140,
			(byte) 94, (byte) 220, (byte) 15, (byte) 250, (byte) 106, (byte) 199, (byte) 245, (byte) 53, (byte) 154,
			(byte) 213, (byte) 161, (byte) 172, (byte) 200, (byte) 201, (byte) 172, (byte) 79, (byte) 27, (byte) 40,
			(byte) 40, (byte) 228, (byte) 237, (byte) 97, (byte) 215, (byte) 119, (byte) 4, (byte) 254, (byte) 24,
			(byte) 34, (byte) 179, (byte) 92, (byte) 212, (byte) 50, (byte) 209, (byte) 53, (byte) 140, (byte) 205,
			(byte) 14, (byte) 161, (byte) 109, (byte) 34, (byte) 156, (byte) 21, (byte) 153, (byte) 79, (byte) 235,
			(byte) 94, (byte) 159, (byte) 94, (byte) 79, (byte) 19, (byte) 133, (byte) 184, (byte) 141, (byte) 137,
			(byte) 198, (byte) 28, (byte) 28, (byte) 231, (byte) 222, (byte) 189, (byte) 96, (byte) 86, (byte) 244,
			(byte) 182, (byte) 51, (byte) 152, (byte) 180, (byte) 81, (byte) 69, (byte) 106, (byte) 64, (byte) 81,
			(byte) 69, (byte) 20, (byte) 0, (byte) 81, (byte) 69, (byte) 20, (byte) 0, (byte) 81, (byte) 69, (byte) 20,
			(byte) 0, (byte) 81, (byte) 69, (byte) 20, (byte) 1, (byte) 28, (byte) 195, (byte) 48, (byte) 191,
			(byte) 210, (byte) 188, (byte) 215, (byte) 198, (byte) 3, (byte) 253, (byte) 34, (byte) 31, (byte) 247,
			(byte) 165, (byte) 255, (byte) 0, (byte) 217, (byte) 107, (byte) 210, (byte) 228, (byte) 25, (byte) 141,
			(byte) 135, (byte) 168, (byte) 175, (byte) 55, (byte) 241, (byte) 136, (byte) 255, (byte) 0, (byte) 72,
			(byte) 132, (byte) 255, (byte) 0, (byte) 181, (byte) 39, (byte) 254, (byte) 201, (byte) 89, (byte) 79,
			(byte) 114, (byte) 226, (byte) 112, (byte) 240, (byte) 182, (byte) 17, (byte) 151, (byte) 251, (byte) 146,
			(byte) 200, (byte) 191, (byte) 147, (byte) 176, (byte) 171, (byte) 49, (byte) 190, (byte) 42, (byte) 175,
			(byte) 221, (byte) 185, (byte) 158, (byte) 62, (byte) 226, (byte) 82, (byte) 199, (byte) 254, (byte) 5,
			(byte) 134, (byte) 255, (byte) 0, (byte) 217, (byte) 170, (byte) 236, (byte) 54, (byte) 238, (byte) 216,
			(byte) 35, (byte) 161, (byte) 173, (byte) 86, (byte) 198, (byte) 13, (byte) 106, (byte) 93, (byte) 134,
			(byte) 76, (byte) 12, (byte) 158, (byte) 148, (byte) 231, (byte) 155, (byte) 119, (byte) 21, (byte) 25,
			(byte) 2, (byte) 40, (byte) 241, (byte) 222, (byte) 171, (byte) 249, (byte) 148, (byte) 192, (byte) 176,
			(byte) 37, (byte) 197, (byte) 33, (byte) 147, (byte) 53, (byte) 84, (byte) 189, (byte) 39, (byte) 155,
			(byte) 72, (byte) 46, (byte) 88, (byte) 105, (byte) 0, (byte) 171, (byte) 122, (byte) 83, (byte) 143,
			(byte) 237, (byte) 75, (byte) 111, (byte) 250, (byte) 232, (byte) 5, (byte) 101, (byte) 51, (byte) 213,
			(byte) 253, (byte) 24, (byte) 238, (byte) 213, (byte) 109, (byte) 6, (byte) 122, (byte) 201, (byte) 252,
			(byte) 129, (byte) 63, (byte) 210, (byte) 147, (byte) 216, (byte) 22, (byte) 231, (byte) 85, (byte) 225,
			(byte) 118, (byte) 199, (byte) 136, (byte) 245, (byte) 81, (byte) 234, (byte) 73, (byte) 252, (byte) 164,
			(byte) 111, (byte) 241, (byte) 174, (byte) 186, (byte) 48, (byte) 60, (byte) 181, (byte) 200, (byte) 228,
			(byte) 10, (byte) 227, (byte) 60, (byte) 52, (byte) 216, (byte) 241, (byte) 93, (byte) 242, (byte) 250,
			(byte) 199, (byte) 43, (byte) 126, (byte) 82, (byte) 175, (byte) 248, (byte) 215, (byte) 103, (byte) 23,
			(byte) 220, (byte) 252, (byte) 127, (byte) 173, (byte) 115, (byte) 35, (byte) 162, (byte) 71, (byte) 39,
			(byte) 173, (byte) 32, (byte) 26, (byte) 165, (byte) 219, (byte) 115, (byte) 146, (byte) 16, (byte) 117,
			(byte) 246, (byte) 83, (byte) 254, (byte) 126, (byte) 130, (byte) 177, (byte) 166, (byte) 32, (byte) 119,
			(byte) 226, (byte) 182, (byte) 124, (byte) 69, (byte) 32, (byte) 139, (byte) 81, (byte) 186, (byte) 245,
			(byte) 33, (byte) 14, (byte) 63, (byte) 5, (byte) 172, (byte) 24, (byte) 109, (byte) 47, (byte) 53,
			(byte) 55, (byte) 253, (byte) 218, (byte) 236, (byte) 132, (byte) 28, (byte) 25, (byte) 24, (byte) 113,
			(byte) 248, (byte) 122, (byte) 159, (byte) 242, (byte) 113, (byte) 72, (byte) 181, (byte) 177, (byte) 93,
			(byte) 167, (byte) 253, (byte) 224, (byte) 84, (byte) 203, (byte) 49, (byte) 56, (byte) 0, (byte) 117,
			(byte) 39, (byte) 210, (byte) 189, (byte) 58, (byte) 231, (byte) 196, (byte) 54, (byte) 176, (byte) 79,
			(byte) 229, (byte) 162, (byte) 60, (byte) 216, (byte) 234, (byte) 202, (byte) 64, (byte) 31, (byte) 175,
			(byte) 90, (byte) 229, (byte) 116, (byte) 253, (byte) 34, (byte) 11, (byte) 33, (byte) 242, (byte) 21,
			(byte) 18, (byte) 145, (byte) 204, (byte) 178, (byte) 2, (byte) 73, (byte) 250, (byte) 96, (byte) 112,
			(byte) 61, (byte) 191, (byte) 60, (byte) 213, (byte) 209, (byte) 106, (byte) 63, (byte) 231, (byte) 162,
			(byte) 49, (byte) 250, (byte) 31, (byte) 234, (byte) 42, (byte) 226, (byte) 218, (byte) 37, (byte) 171,
			(byte) 238, (byte) 110, (byte) 175, (byte) 136, (byte) 45, (byte) 207, (byte) 222, (byte) 133, (byte) 199,
			(byte) 210, (byte) 88, (byte) 207, (byte) 254, (byte) 205, (byte) 82, (byte) 13, (byte) 114, (byte) 212,
			(byte) 255, (byte) 0, (byte) 4, (byte) 191, (byte) 130, (byte) 134, (byte) 254, (byte) 68, (byte) 215,
			(byte) 62, (byte) 45, (byte) 155, (byte) 213, (byte) 63, (byte) 25, (byte) 20, (byte) 127, (byte) 51,
			(byte) 71, (byte) 217, (byte) 155, (byte) 217, (byte) 190, (byte) 142, (byte) 15, (byte) 245, (byte) 167,
			(byte) 207, (byte) 33, (byte) 114, (byte) 163, (byte) 164, (byte) 26, (byte) 189, (byte) 169, (byte) 237,
			(byte) 48, (byte) 250, (byte) 192, (byte) 255, (byte) 0, (byte) 225, (byte) 75, (byte) 253, (byte) 175,
			(byte) 99, (byte) 156, (byte) 25, (byte) 246, (byte) 159, (byte) 246, (byte) 145, (byte) 135, (byte) 243,
			(byte) 21, (byte) 203, (byte) 152, (byte) 121, (byte) 195, (byte) 46, (byte) 8, (byte) 235, (byte) 145,
			(byte) 72, (byte) 242, (byte) 164, (byte) 67, (byte) 229, (byte) 33, (byte) 219, (byte) 182, (byte) 41,
			(byte) 169, (byte) 177, (byte) 114, (byte) 163, (byte) 174, (byte) 183, (byte) 189, (byte) 182, (byte) 186,
			(byte) 37, (byte) 96, (byte) 157, (byte) 36, (byte) 101, (byte) 25, (byte) 32, (byte) 30, (byte) 69,
			(byte) 21, (byte) 129, (byte) 225, (byte) 167, (byte) 102, (byte) 212, (byte) 102, (byte) 220, (byte) 73,
			(byte) 38, (byte) 46, (byte) 191, (byte) 66, (byte) 63, (byte) 198, (byte) 138, (byte) 210, (byte) 46,
			(byte) 234, (byte) 228, (byte) 181, (byte) 99, (byte) 168, (byte) 162, (byte) 138, (byte) 42, (byte) 132,
			(byte) 20, (byte) 81, (byte) 69, (byte) 0, (byte) 53, (byte) 134, (byte) 65, (byte) 30, (byte) 162,
			(byte) 184, (byte) 63, (byte) 17, (byte) 216, (byte) 75, (byte) 125, (byte) 118, (byte) 60, (byte) 160,
			(byte) 27, (byte) 203, (byte) 39, (byte) 43, (byte) 144, (byte) 51, (byte) 144, (byte) 190, (byte) 191,
			(byte) 74, (byte) 239, (byte) 24, (byte) 133, (byte) 4, (byte) 146, (byte) 0, (byte) 3, (byte) 36,
			(byte) 154, (byte) 228, (byte) 117, (byte) 41, (byte) 188, (byte) 61, (byte) 125, (byte) 40, (byte) 55,
			(byte) 83, (byte) 72, (byte) 207, (byte) 16, (byte) 40, (byte) 36, (byte) 141, (byte) 102, (byte) 78,
			(byte) 255, (byte) 0, (byte) 222, (byte) 80, (byte) 1, (byte) 233, (byte) 235, (byte) 89, (byte) 84,
			(byte) 42, (byte) 39, (byte) 23, (byte) 123, (byte) 225, (byte) 171, (byte) 201, (byte) 231, (byte) 19,
			(byte) 165, (byte) 179, (byte) 68, (byte) 224, (byte) 96, (byte) 149, (byte) 145, (byte) 8, (byte) 108,
			(byte) 116, (byte) 200, (byte) 207, (byte) 63, (byte) 134, (byte) 63, (byte) 149, (byte) 39, (byte) 246,
			(byte) 118, (byte) 167, (byte) 18, (byte) 5, (byte) 22, (byte) 146, (byte) 57, (byte) 232, (byte) 74,
			(byte) 198, (byte) 216, (byte) 253, (byte) 51, (byte) 93, (byte) 71, (byte) 217, (byte) 124, (byte) 49,
			(byte) 252, (byte) 26, (byte) 244, (byte) 144, (byte) 158, (byte) 152, (byte) 125, (byte) 102, (byte) 81,
			(byte) 250, (byte) 59, (byte) 212, (byte) 145, (byte) 233, (byte) 118, (byte) 115, (byte) 241, (byte) 103,
			(byte) 226, (byte) 121, (byte) 219, (byte) 61, (byte) 60, (byte) 185, (byte) 160, (byte) 155, (byte) 255,
			(byte) 0, (byte) 66, (byte) 86, (byte) 169, (byte) 83, (byte) 104, (byte) 171, (byte) 38, (byte) 113,
			(byte) 83, (byte) 218, (byte) 223, (byte) 15, (byte) 191, (byte) 105, (byte) 34, (byte) 253, (byte) 84,
			(byte) 143, (byte) 253, (byte) 8, (byte) 10, (byte) 164, (byte) 203, (byte) 42, (byte) 253, (byte) 232,
			(byte) 219, (byte) 240, (byte) 32, (byte) 255, (byte) 0, (byte) 42, (byte) 244, (byte) 143, (byte) 248,
			(byte) 71, (byte) 245, (byte) 56, (byte) 190, (byte) 104, (byte) 245, (byte) 105, (byte) 95, (byte) 143,
			(byte) 249, (byte) 109, (byte) 111, (byte) 30, (byte) 63, (byte) 241, (byte) 213, (byte) 90, (byte) 67,
			(byte) 166, (byte) 107, (byte) 153, (byte) 255, (byte) 0, (byte) 143, (byte) 251, (byte) 22, (byte) 29,
			(byte) 54, (byte) 155, (byte) 103, (byte) 255, (byte) 0, (byte) 227, (byte) 148, (byte) 253, (byte) 161,
			(byte) 62, (byte) 205, (byte) 30, (byte) 108, (byte) 86, (byte) 99, (byte) 210, (byte) 9, (byte) 143,
			(byte) 210, (byte) 38, (byte) 255, (byte) 0, (byte) 10, (byte) 102, (byte) 38, (byte) 255, (byte) 0,
			(byte) 158, (byte) 19, (byte) 127, (byte) 223, (byte) 166, (byte) 255, (byte) 0, (byte) 10, (byte) 244,
			(byte) 71, (byte) 211, (byte) 117, (byte) 126, (byte) 127, (byte) 208, (byte) 52, (byte) 185, (byte) 207,
			(byte) 171, (byte) 59, (byte) 39, (byte) 254, (byte) 200, (byte) 213, (byte) 3, (byte) 216, (byte) 234,
			(byte) 73, (byte) 247, (byte) 252, (byte) 57, (byte) 167, (byte) 185, (byte) 207, (byte) 252, (byte) 177,
			(byte) 185, (byte) 25, (byte) 253, (byte) 98, (byte) 20, (byte) 253, (byte) 160, (byte) 189, (byte) 154,
			(byte) 56, (byte) 34, (byte) 179, (byte) 127, (byte) 207, (byte) 9, (byte) 191, (byte) 239, (byte) 211,
			(byte) 127, (byte) 133, (byte) 106, (byte) 248, (byte) 126, (byte) 25, (byte) 155, (byte) 92, (byte) 180,
			(byte) 38, (byte) 25, (byte) 2, (byte) 161, (byte) 102, (byte) 102, (byte) 101, (byte) 35, (byte) 31,
			(byte) 35, (byte) 122, (byte) 245, (byte) 231, (byte) 21, (byte) 209, (byte) 73, (byte) 107, (byte) 56,
			(byte) 255, (byte) 0, (byte) 91, (byte) 225, (byte) 75, (byte) 156, (byte) 122, (byte) 197, (byte) 60,
			(byte) 68, (byte) 127, (byte) 232, (byte) 98, (byte) 155, (byte) 11, (byte) 219, (byte) 90, (byte) 74,
			(byte) 37, (byte) 254, (byte) 195, (byte) 213, (byte) 33, (byte) 96, (byte) 15, (byte) 34, (byte) 35,
			(byte) 39, (byte) 111, (byte) 246, (byte) 93, (byte) 168, (byte) 117, (byte) 52, (byte) 26, (byte) 133,
			(byte) 152, (byte) 190, (byte) 26, (byte) 111, (byte) 248, (byte) 172, (byte) 46, (byte) 125, (byte) 224,
			(byte) 159, (byte) 255, (byte) 0, (byte) 70, (byte) 199, (byte) 93, (byte) 188, (byte) 127, (byte) 112,
			(byte) 253, (byte) 79, (byte) 243, (byte) 174, (byte) 19, (byte) 195, (byte) 2, (byte) 87, (byte) 241,
			(byte) 91, (byte) 74, (byte) 109, (byte) 174, (byte) 163, (byte) 83, (byte) 4, (byte) 191, (byte) 52,
			(byte) 182, (byte) 242, (byte) 70, (byte) 57, (byte) 116, (byte) 56, (byte) 249, (byte) 128, (byte) 231,
			(byte) 143, (byte) 210, (byte) 187, (byte) 57, (byte) 110, (byte) 227, (byte) 180, (byte) 143, (byte) 116,
			(byte) 188, (byte) 41, (byte) 220, (byte) 217, (byte) 200, (byte) 236, (byte) 195, (byte) 143, (byte) 215,
			(byte) 244, (byte) 172, (byte) 139, (byte) 145, (byte) 201, (byte) 248, (byte) 171, (byte) 82, (byte) 139,
			(byte) 79, (byte) 213, (byte) 247, (byte) 203, (byte) 100, (byte) 46, (byte) 132, (byte) 135, (byte) 104,
			(byte) 87, (byte) 144, (byte) 168, (byte) 27, (byte) 85, (byte) 14, (byte) 72, (byte) 193, (byte) 207,
			(byte) 222, (byte) 233, (byte) 237, (byte) 223, (byte) 60, (byte) 81, (byte) 79, (byte) 25, (byte) 67,
			(byte) 128, (byte) 26, (byte) 192, (byte) 160, (byte) 3, (byte) 133, (byte) 73, (byte) 65, (byte) 254,
			(byte) 130, (byte) 163, (byte) 248, (byte) 147, (byte) 58, (byte) 90, (byte) 223, (byte) 219, (byte) 187,
			(byte) 134, (byte) 101, (byte) 33, (byte) 219, (byte) 228, (byte) 93, (byte) 199, (byte) 145, (byte) 24,
			(byte) 254, (byte) 149, (byte) 196, (byte) 255, (byte) 0, (byte) 107, (byte) 91, (byte) 19, (byte) 203,
			(byte) 72, (byte) 163, (byte) 253, (byte) 168, (byte) 95, (byte) 252, (byte) 43, (byte) 120, (byte) 194,
			(byte) 45, (byte) 106, (byte) 67, (byte) 108, (byte) 239, (byte) 215, (byte) 198, (byte) 186, (byte) 104,
			(byte) 225, (byte) 237, (byte) 238, (byte) 198, (byte) 61, (byte) 21, (byte) 63, (byte) 248, (byte) 161,
			(byte) 82, (byte) 199, (byte) 227, (byte) 13, (byte) 33, (byte) 241, (byte) 151, (byte) 120, (byte) 243,
			(byte) 211, (byte) 112, (byte) 207, (byte) 254, (byte) 131, (byte) 154, (byte) 224, (byte) 132, (byte) 158,
			(byte) 110, (byte) 217, (byte) 85, (byte) 91, (byte) 100, (byte) 136, (byte) 25, (byte) 24, (byte) 169,
			(byte) 27, (byte) 128, (byte) 102, (byte) 25, (byte) 25, (byte) 247, (byte) 4, (byte) 126, (byte) 6,
			(byte) 131, (byte) 46, (byte) 196, (byte) 203, (byte) 182, (byte) 213, (byte) 4, (byte) 100, (byte) 147,
			(byte) 199, (byte) 90, (byte) 175, (byte) 103, (byte) 17, (byte) 115, (byte) 51, (byte) 209, (byte) 87,
			(byte) 196, (byte) 250, (byte) 43, (byte) 112, (byte) 47, (byte) 9, (byte) 63, (byte) 245, (byte) 198,
			(byte) 79, (byte) 234, (byte) 181, (byte) 98, (byte) 29, (byte) 91, (byte) 79, (byte) 185, (byte) 144,
			(byte) 71, (byte) 21, (byte) 204, (byte) 108, (byte) 228, (byte) 18, (byte) 23, (byte) 112, (byte) 207,
			(byte) 3, (byte) 39, (byte) 3, (byte) 169, (byte) 224, (byte) 19, (byte) 248, (byte) 87, (byte) 155,
			(byte) 69, (byte) 34, (byte) 56, (byte) 249, (byte) 27, (byte) 119, (byte) 161, (byte) 21, (byte) 167,
			(byte) 161, (byte) 182, (byte) 221, (byte) 102, (byte) 220, (byte) 247, (byte) 219, (byte) 40, (byte) 252,
			(byte) 227, (byte) 97, (byte) 253, (byte) 105, (byte) 58, (byte) 106, (byte) 195, (byte) 82, (byte) 103,
			(byte) 111, (byte) 52, (byte) 172, (byte) 252, (byte) 46, (byte) 85, (byte) 125, (byte) 61, (byte) 106,
			(byte) 12, (byte) 96, (byte) 99, (byte) 240, (byte) 169, (byte) 202, (byte) 212, (byte) 101, (byte) 107,
			(byte) 3, (byte) 67, (byte) 83, (byte) 195, (byte) 7, (byte) 254, (byte) 38, (byte) 50, (byte) 231,
			(byte) 254, (byte) 120, (byte) 159, (byte) 253, (byte) 8, (byte) 81, (byte) 75, (byte) 225, (byte) 180,
			(byte) 35, (byte) 82, (byte) 118, (byte) 231, (byte) 2, (byte) 18, (byte) 9, (byte) 199, (byte) 251,
			(byte) 75, (byte) 69, (byte) 111, (byte) 13, (byte) 140, (byte) 158, (byte) 231, (byte) 83, (byte) 69,
			(byte) 20, (byte) 85, (byte) 8, (byte) 41, (byte) 172, (byte) 202, (byte) 168, (byte) 89, (byte) 136,
			(byte) 10, (byte) 7, (byte) 36, (byte) 210, (byte) 59, (byte) 172, (byte) 104, (byte) 89, (byte) 206,
			(byte) 0, (byte) 234, (byte) 107, (byte) 50, (byte) 123, (byte) 212, (byte) 153, (byte) 202, (byte) 188,
			(byte) 37, (byte) 226, (byte) 237, (byte) 243, (byte) 17, (byte) 248, (byte) 241, (byte) 82, (byte) 221,
			(byte) 134, (byte) 149, (byte) 200, (byte) 239, (byte) 47, (byte) 26, (byte) 228, (byte) 152, (byte) 227,
			(byte) 202, (byte) 197, (byte) 233, (byte) 221, (byte) 170, (byte) 151, (byte) 151, (byte) 20, (byte) 201,
			(byte) 204, (byte) 104, (byte) 87, (byte) 28, (byte) 54, (byte) 7, (byte) 205, (byte) 255, (byte) 0,
			(byte) 214, (byte) 255, (byte) 0, (byte) 61, (byte) 58, (byte) 217, (byte) 117, (byte) 180, (byte) 158,
			(byte) 65, (byte) 31, (byte) 149, (byte) 60, (byte) 104, (byte) 6, (byte) 231, (byte) 97, (byte) 200,
			(byte) 62, (byte) 220, (byte) 245, (byte) 255, (byte) 0, (byte) 235, (byte) 115, (byte) 193, (byte) 230,
			(byte) 95, (byte) 46, (byte) 208, (byte) 253, (byte) 219, (byte) 163, (byte) 207, (byte) 170, (byte) 19,
			(byte) 89, (byte) 61, (byte) 77, (byte) 17, (byte) 158, (byte) 108, (byte) 237, (byte) 143, (byte) 88,
			(byte) 23, (byte) 240, (byte) 36, (byte) 127, (byte) 42, (byte) 175, (byte) 54, (byte) 143, (byte) 167,
			(byte) 78, (byte) 49, (byte) 37, (byte) 170, (byte) 48, (byte) 247, (byte) 231, (byte) 249, (byte) 230,
			(byte) 181, (byte) 205, (byte) 164, (byte) 103, (byte) 238, (byte) 221, (byte) 196, (byte) 126, (byte) 191,
			(byte) 45, (byte) 31, (byte) 96, (byte) 145, (byte) 190, (byte) 228, (byte) 145, (byte) 55, (byte) 209,
			(byte) 243, (byte) 253, (byte) 41, (byte) 89, (byte) 133, (byte) 209, (byte) 203, (byte) 220, (byte) 105,
			(byte) 30, (byte) 28, (byte) 177, (byte) 144, (byte) 44, (byte) 162, (byte) 218, (byte) 217, (byte) 200,
			(byte) 200, (byte) 201, (byte) 69, (byte) 63, (byte) 94, (byte) 153, (byte) 20, (byte) 244, (byte) 181,
			(byte) 211, (byte) 179, (byte) 182, (byte) 13, (byte) 126, (byte) 72, (byte) 200, (byte) 63, (byte) 118,
			(byte) 27, (byte) 246, (byte) 31, (byte) 160, (byte) 113, (byte) 90, (byte) 18, (byte) 120, (byte) 78,
			(byte) 79, (byte) 53, (byte) 230, (byte) 89, (byte) 239, (byte) 11, (byte) 200, (byte) 114, (byte) 205,
			(byte) 231, (byte) 1, (byte) 159, (byte) 110, (byte) 48, (byte) 106, (byte) 164, (byte) 158, (byte) 18,
			(byte) 186, (byte) 199, (byte) 55, (byte) 37, (byte) 143, (byte) 253, (byte) 52, (byte) 181, (byte) 14,
			(byte) 127, (byte) 70, (byte) 231, (byte) 252, (byte) 105, (byte) 217, (byte) 245, (byte) 27, (byte) 113,
			(byte) 182, (byte) 132, (byte) 137, (byte) 166, (byte) 94, (byte) 227, (byte) 117, (byte) 174, (byte) 175,
			(byte) 118, (byte) 71, (byte) 247, (byte) 153, (byte) 203, (byte) 255, (byte) 0, (byte) 232, (byte) 91,
			(byte) 169, (byte) 77, (byte) 182, (byte) 186, (byte) 135, (byte) 141, (byte) 105, (byte) 155, (byte) 31,
			(byte) 194, (byte) 97, (byte) 139, (byte) 255, (byte) 0, (byte) 141, (byte) 131, (byte) 250, (byte) 214,
			(byte) 115, (byte) 248, (byte) 70, (byte) 97, (byte) 255, (byte) 0, (byte) 44, (byte) 108, (byte) 206,
			(byte) 14, (byte) 114, (byte) 208, (byte) 24, (byte) 255, (byte) 0, (byte) 161, (byte) 173, (byte) 29,
			(byte) 39, (byte) 74, (byte) 26, (byte) 126, (byte) 247, (byte) 149, (byte) 209, (byte) 166, (byte) 147,
			(byte) 130, (byte) 35, (byte) 56, (byte) 69, (byte) 95, (byte) 65, (byte) 211, (byte) 63, (byte) 92,
			(byte) 127, (byte) 92, (byte) 161, (byte) 33, (byte) 124, (byte) 207, (byte) 17, (byte) 39, (byte) 11,
			(byte) 45, (byte) 148, (byte) 131, (byte) 214, (byte) 72, (byte) 73, (byte) 63, (byte) 163, (byte) 143,
			(byte) 229, (byte) 74, (byte) 47, (byte) 245, (byte) 216, (byte) 190, (byte) 245, (byte) 157, (byte) 180,
			(byte) 196, (byte) 127, (byte) 207, (byte) 48, (byte) 201, (byte) 253, (byte) 90, (byte) 180, (byte) 48,
			(byte) 126, (byte) 180, (byte) 224, (byte) 15, (byte) 231, (byte) 72, (byte) 101, (byte) 1, (byte) 173,
			(byte) 106, (byte) 163, (byte) 253, (byte) 102, (byte) 134, (byte) 20, (byte) 122, (byte) 173, (byte) 211,
			(byte) 31, (byte) 231, (byte) 24, (byte) 254, (byte) 116, (byte) 198, (byte) 215, (byte) 81, (byte) 198,
			(byte) 219, (byte) 173, (byte) 26, (byte) 241, (byte) 186, (byte) 224, (byte) 175, (byte) 150, (byte) 71,
			(byte) 39, (byte) 61, (byte) 75, (byte) 131, (byte) 255, (byte) 0, (byte) 234, (byte) 173, (byte) 46,
			(byte) 248, (byte) 252, (byte) 205, (byte) 57, (byte) 229, (byte) 16, (byte) 199, (byte) 187, (byte) 156,
			(byte) 14, (byte) 128, (byte) 127, (byte) 42, (byte) 5, (byte) 99, (byte) 138, (byte) 241, (byte) 77,
			(byte) 192, (byte) 212, (byte) 110, (byte) 32, (byte) 157, (byte) 109, (byte) 228, (byte) 137, (byte) 22,
			(byte) 63, (byte) 44, (byte) 9, (byte) 217, (byte) 50, (byte) 79, (byte) 83, (byte) 209, (byte) 142,
			(byte) 56, (byte) 199, (byte) 83, (byte) 216, (byte) 215, (byte) 57, (byte) 60, (byte) 16, (byte) 164,
			(byte) 139, (byte) 27, (byte) 199, (byte) 9, (byte) 103, (byte) 206, (byte) 54, (byte) 149, (byte) 113,
			(byte) 198, (byte) 123, (byte) 174, (byte) 64, (byte) 233, (byte) 252, (byte) 143, (byte) 66, (byte) 43,
			(byte) 168, (byte) 215, (byte) 230, (byte) 55, (byte) 183, (byte) 10, (byte) 3, (byte) 65, (byte) 186,
			(byte) 55, (byte) 70, (byte) 223, (byte) 59, (byte) 98, (byte) 54, (byte) 251, (byte) 223, (byte) 41,
			(byte) 245, (byte) 206, (byte) 56, (byte) 3, (byte) 168, (byte) 13, (byte) 233, (byte) 85, (byte) 103,
			(byte) 179, (byte) 188, (byte) 189, (byte) 71, (byte) 242, (byte) 116, (byte) 171, (byte) 50, (byte) 204,
			(byte) 191, (byte) 122, (byte) 198, (byte) 9, (byte) 64, (byte) 31, (byte) 48, (byte) 111, (byte) 226,
			(byte) 24, (byte) 29, (byte) 8, (byte) 227, (byte) 28, (byte) 55, (byte) 126, (byte) 49, (byte) 211,
			(byte) 77, (byte) 251, (byte) 166, (byte) 82, (byte) 90, (byte) 156, (byte) 133, (byte) 236, (byte) 12,
			(byte) 183, (byte) 150, (byte) 235, (byte) 109, (byte) 251, (byte) 165, (byte) 116, (byte) 145, (byte) 164,
			(byte) 218, (byte) 163, (byte) 230, (byte) 198, (byte) 192, (byte) 58, (byte) 143, (byte) 246, (byte) 169,
			(byte) 5, (byte) 169, (byte) 152, (byte) 136, (byte) 166, (byte) 145, (byte) 165, (byte) 141, (byte) 136,
			(byte) 12, (byte) 164, (byte) 46, (byte) 15, (byte) 62, (byte) 192, (byte) 86, (byte) 244, (byte) 186,
			(byte) 93, (byte) 228, (byte) 92, (byte) 203, (byte) 28, (byte) 113, (byte) 251, (byte) 60, (byte) 241,
			(byte) 131, (byte) 249, (byte) 110, (byte) 205, (byte) 71, (byte) 30, (byte) 159, (byte) 117, (byte) 47,
			(byte) 250, (byte) 171, (byte) 57, (byte) 165, (byte) 199, (byte) 59, (byte) 162, (byte) 132, (byte) 183,
			(byte) 234, (byte) 5, (byte) 105, (byte) 161, (byte) 55, (byte) 118, (byte) 51, (byte) 101, (byte) 209,
			(byte) 45, (byte) 47, (byte) 103, (byte) 6, (byte) 68, (byte) 105, (byte) 102, (byte) 147, (byte) 10,
			(byte) 25, (byte) 216, (byte) 51, (byte) 30, (byte) 138, (byte) 6, (byte) 79, (byte) 62, (byte) 128,
			(byte) 126, (byte) 21, (byte) 111, (byte) 64, (byte) 210, (byte) 109, (byte) 173, (byte) 53, (byte) 120,
			(byte) 37, (byte) 129, (byte) 202, (byte) 228, (byte) 227, (byte) 29, (byte) 71, (byte) 63, (byte) 141,
			(byte) 109, (byte) 233, (byte) 26, (byte) 129, (byte) 209, (byte) 94, (byte) 113, (byte) 117, (byte) 246,
			(byte) 155, (byte) 101, (byte) 152, (byte) 47, (byte) 42, (byte) 160, (byte) 19, (byte) 130, (byte) 120,
			(byte) 33, (byte) 177, (byte) 235, (byte) 80, (byte) 45, (byte) 228, (byte) 55, (byte) 94, (byte) 35,
			(byte) 89, (byte) 161, (byte) 152, (byte) 202, (byte) 178, (byte) 93, (byte) 33, (byte) 220, (byte) 196,
			(byte) 100, (byte) 229, (byte) 134, (byte) 123, (byte) 250, (byte) 231, (byte) 30, (byte) 216, (byte) 168,
			(byte) 247, (byte) 155, (byte) 105, (byte) 173, (byte) 7, (byte) 100, (byte) 146, (byte) 119, (byte) 215,
			(byte) 177, (byte) 214, (byte) 176, (byte) 228, (byte) 213, (byte) 121, (byte) 164, (byte) 218, (byte) 226,
			(byte) 56, (byte) 212, (byte) 201, (byte) 41, (byte) 25, (byte) 10, (byte) 14, (byte) 49, (byte) 238,
			(byte) 79, (byte) 97, (byte) 254, (byte) 7, (byte) 0, (byte) 224, (byte) 225, (byte) 210, (byte) 76,
			(byte) 242, (byte) 187, (byte) 69, (byte) 109, (byte) 141, (byte) 192, (byte) 225, (byte) 229, (byte) 35,
			(byte) 33, (byte) 61, (byte) 135, (byte) 171, (byte) 126, (byte) 131, (byte) 190, (byte) 113, (byte) 180,
			(byte) 190, (byte) 24, (byte) 86, (byte) 8, (byte) 202, (byte) 140, (byte) 156, (byte) 156, (byte) 150,
			(byte) 39, (byte) 37, (byte) 142, (byte) 7, (byte) 39, (byte) 215, (byte) 255, (byte) 0, (byte) 172,
			(byte) 43, (byte) 152, (byte) 216, (byte) 185, (byte) 225, (byte) 200, (byte) 60, (byte) 173, (byte) 87,
			(byte) 204, (byte) 119, (byte) 50, (byte) 74, (byte) 209, (byte) 48, (byte) 45, (byte) 140, (byte) 0,
			(byte) 50, (byte) 188, (byte) 1, (byte) 216, (byte) 127, (byte) 128, (byte) 201, (byte) 39, (byte) 154,
			(byte) 42, (byte) 93, (byte) 12, (byte) 255, (byte) 0, (byte) 196, (byte) 208, (byte) 127, (byte) 184,
			(byte) 194, (byte) 138, (byte) 214, (byte) 27, (byte) 25, (byte) 189, (byte) 206, (byte) 158, (byte) 152,
			(byte) 238, (byte) 168, (byte) 165, (byte) 152, (byte) 224, (byte) 10, (byte) 29, (byte) 213, (byte) 20,
			(byte) 179, (byte) 28, (byte) 1, (byte) 89, (byte) 151, (byte) 51, (byte) 180, (byte) 242, (byte) 99,
			(byte) 149, (byte) 3, (byte) 166, (byte) 123, (byte) 127, (byte) 245, (byte) 255, (byte) 0, (byte) 207,
			(byte) 213, (byte) 202, (byte) 86, (byte) 4, (byte) 174, (byte) 54, (byte) 230, (byte) 225, (byte) 238,
			(byte) 31, (byte) 28, (byte) 170, (byte) 131, (byte) 211, (byte) 211, (byte) 255, (byte) 0, (byte) 175,
			(byte) 254, (byte) 126, (byte) 180, (byte) 53, (byte) 43, (byte) 248, (byte) 244, (byte) 219, (byte) 38,
			(byte) 153, (byte) 204, (byte) 69, (byte) 254, (byte) 236, (byte) 105, (byte) 38, (byte) 62, (byte) 118,
			(byte) 244, (byte) 232, (byte) 79, (byte) 191, (byte) 3, (byte) 160, (byte) 53, (byte) 120, (byte) 0,
			(byte) 56, (byte) 3, (byte) 35, (byte) 182, (byte) 43, (byte) 151, (byte) 214, (byte) 32, (byte) 186,
			(byte) 184, (byte) 251, (byte) 68, (byte) 177, (byte) 45, (byte) 203, (byte) 179, (byte) 137, (byte) 4,
			(byte) 34, (byte) 9, (byte) 140, (byte) 160, (byte) 28, (byte) 124, (byte) 167, (byte) 98, (byte) 18,
			(byte) 6, (byte) 62, (byte) 92, (byte) 241, (byte) 233, (byte) 156, (byte) 214, (byte) 90, (byte) 189,
			(byte) 77, (byte) 52, (byte) 71, (byte) 63, (byte) 172, (byte) 107, (byte) 115, (byte) 107, (byte) 22,
			(byte) 242, (byte) 51, (byte) 181, (byte) 178, (byte) 136, (byte) 207, (byte) 151, (byte) 19, (byte) 67,
			(byte) 41, (byte) 92, (byte) 177, (byte) 56, (byte) 222, (byte) 20, (byte) 156, (byte) 119, (byte) 199,
			(byte) 174, (byte) 51, (byte) 239, (byte) 78, (byte) 142, (byte) 246, (byte) 255, (byte) 0, (byte) 251,
			(byte) 68, (byte) 132, (byte) 184, (byte) 188, (byte) 40, (byte) 97, (byte) 12, (byte) 203, (byte) 21,
			(byte) 217, (byte) 113, (byte) 184, (byte) 177, (byte) 231, (byte) 61, (byte) 73, (byte) 249, (byte) 72,
			(byte) 252, (byte) 61, (byte) 14, (byte) 40, (byte) 184, (byte) 211, (byte) 210, (byte) 214, (byte) 91,
			(byte) 85, (byte) 197, (byte) 223, (byte) 151, (byte) 2, (byte) 54, (byte) 67, (byte) 68, (byte) 9,
			(byte) 83, (byte) 133, (byte) 11, (byte) 213, (byte) 112, (byte) 6, (byte) 55, (byte) 113, (byte) 236,
			(byte) 181, (byte) 71, (byte) 201, (byte) 141, (byte) 173, (byte) 164, (byte) 6, (byte) 72, (byte) 196,
			(byte) 211, (byte) 92, (byte) 130, (byte) 223, (byte) 185, (byte) 31, (byte) 42, (byte) 121, (byte) 157,
			(byte) 114, (byte) 15, (byte) 63, (byte) 39, (byte) 59, (byte) 70, (byte) 59, (byte) 129, (byte) 72,
			(byte) 11, (byte) 208, (byte) 107, (byte) 186, (byte) 180, (byte) 80, (byte) 89, (byte) 187, (byte) 92,
			(byte) 207, (byte) 153, (byte) 78, (byte) 11, (byte) 60, (byte) 10, (byte) 251, (byte) 151, (byte) 4,
			(byte) 228, (byte) 119, (byte) 35, (byte) 145, (byte) 201, (byte) 237, (byte) 223, (byte) 140, (byte) 84,
			(byte) 237, (byte) 226, (byte) 205, (byte) 66, (byte) 56, (byte) 238, (byte) 143, (byte) 155, (byte) 4,
			(byte) 173, (byte) 9, (byte) 253, (byte) 216, (byte) 146, (byte) 50, (byte) 9, (byte) 24, (byte) 29,
			(byte) 74, (byte) 225, (byte) 122, (byte) 231, (byte) 211, (byte) 159, (byte) 65, (byte) 129, (byte) 84,
			(byte) 163, (byte) 130, (byte) 36, (byte) 189, (byte) 105, (byte) 35, (byte) 104, (byte) 22, (byte) 59,
			(byte) 120, (byte) 151, (byte) 203, (byte) 0, (byte) 186, (byte) 6, (byte) 56, (byte) 108, (byte) 237,
			(byte) 4, (byte) 17, (byte) 156, (byte) 96, (byte) 115, (byte) 237, (byte) 239, (byte) 76, (byte) 91,
			(byte) 105, (byte) 222, (byte) 210, (byte) 218, (byte) 220, (byte) 202, (byte) 210, (byte) 53, (byte) 227,
			(byte) 111, (byte) 153, (byte) 86, (byte) 225, (byte) 91, (byte) 113, (byte) 10, (byte) 9, (byte) 220,
			(byte) 27, (byte) 1, (byte) 79, (byte) 11, (byte) 199, (byte) 177, (byte) 29, (byte) 133, (byte) 49,
			(byte) 155, (byte) 145, (byte) 120, (byte) 190, (byte) 228, (byte) 92, (byte) 172, (byte) 97, (byte) 108,
			(byte) 217, (byte) 36, (byte) 66, (byte) 200, (byte) 233, (byte) 33, (byte) 64, (byte) 57, (byte) 28,
			(byte) 100, (byte) 245, (byte) 56, (byte) 201, (byte) 237, (byte) 248, (byte) 98, (byte) 172, (byte) 65,
			(byte) 227, (byte) 137, (byte) 140, (byte) 16, (byte) 74, (byte) 246, (byte) 115, (byte) 42, (byte) 203,
			(byte) 32, (byte) 143, (byte) 11, (byte) 114, (byte) 25, (byte) 129, (byte) 44, (byte) 71, (byte) 76,
			(byte) 122, (byte) 14, (byte) 228, (byte) 117, (byte) 252, (byte) 107, (byte) 157, (byte) 144, (byte) 92,
			(byte) 43, (byte) 222, (byte) 223, (byte) 58, (byte) 22, (byte) 22, (byte) 160, (byte) 196, (byte) 26,
			(byte) 72, (byte) 17, (byte) 151, (byte) 43, (byte) 134, (byte) 195, (byte) 31, (byte) 169, (byte) 198,
			(byte) 125, (byte) 198, (byte) 15, (byte) 81, (byte) 81, (byte) 53, (byte) 160, (byte) 133, (byte) 45,
			(byte) 237, (byte) 36, (byte) 72, (byte) 198, (byte) 73, (byte) 146, (byte) 67, (byte) 36, (byte) 82,
			(byte) 70, (byte) 207, (byte) 131, (byte) 247, (byte) 88, (byte) 117, (byte) 193, (byte) 207, (byte) 233,
			(byte) 138, (byte) 44, (byte) 35, (byte) 179, (byte) 143, (byte) 199, (byte) 10, (byte) 30, (byte) 84,
			(byte) 146, (byte) 43, (byte) 196, (byte) 120, (byte) 66, (byte) 153, (byte) 23, (byte) 201, (byte) 86,
			(byte) 218, (byte) 8, (byte) 39, (byte) 57, (byte) 207, (byte) 160, (byte) 255, (byte) 0, (byte) 12,
			(byte) 243, (byte) 86, (byte) 35, (byte) 241, (byte) 197, (byte) 131, (byte) 136, (byte) 183, (byte) 220,
			(byte) 5, (byte) 89, (byte) 64, (byte) 43, (byte) 230, (byte) 196, (byte) 70, (byte) 114, (byte) 51,
			(byte) 142, (byte) 7, (byte) 167, (byte) 225, (byte) 232, (byte) 77, (byte) 112, (byte) 161, (byte) 227,
			(byte) 243, (byte) 47, (byte) 38, (byte) 85, (byte) 82, (byte) 71, (byte) 238, (byte) 149, (byte) 97,
			(byte) 148, (byte) 118, (byte) 249, (byte) 115, (byte) 176, (byte) 142, (byte) 65, (byte) 36, (byte) 30,
			(byte) 123, (byte) 103, (byte) 165, (byte) 77, (byte) 30, (byte) 200, (byte) 18, (byte) 218, (byte) 216,
			(byte) 153, (byte) 62, (byte) 210, (byte) 177, (byte) 147, (byte) 27, (byte) 9, (byte) 183, (byte) 34,
			(byte) 54, (byte) 210, (byte) 48, (byte) 48, (byte) 64, (byte) 3, (byte) 57, (byte) 29, (byte) 248,
			(byte) 35, (byte) 182, (byte) 40, (byte) 11, (byte) 30, (byte) 133, (byte) 105, (byte) 173, (byte) 217,
			(byte) 95, (byte) 150, (byte) 16, (byte) 165, (byte) 188, (byte) 204, (byte) 167, (byte) 5, (byte) 76,
			(byte) 101, (byte) 24, (byte) 113, (byte) 232, (byte) 220, (byte) 254, (byte) 149, (byte) 108, (byte) 205,
			(byte) 22, (byte) 15, (byte) 250, (byte) 24, (byte) 83, (byte) 219, (byte) 14, (byte) 71, (byte) 242,
			(byte) 172, (byte) 15, (byte) 11, (byte) 104, (byte) 247, (byte) 54, (byte) 22, (byte) 242, (byte) 94,
			(byte) 94, (byte) 51, (byte) 139, (byte) 155, (byte) 189, (byte) 164, (byte) 198, (byte) 78, (byte) 54,
			(byte) 168, (byte) 233, (byte) 145, (byte) 221, (byte) 185, (byte) 231, (byte) 250, (byte) 115, (byte) 157,
			(byte) 226, (byte) 63, (byte) 217, (byte) 95, (byte) 251, (byte) 228, (byte) 127, (byte) 133, (byte) 23,
			(byte) 21, (byte) 134, (byte) 198, (byte) 246, (byte) 113, (byte) 68, (byte) 136, (byte) 240, (byte) 200,
			(byte) 48, (byte) 48, (byte) 88, (byte) 177, (byte) 228, (byte) 250, (byte) 253, (byte) 127, (byte) 198,
			(byte) 178, (byte) 53, (byte) 235, (byte) 216, (byte) 6, (byte) 32, (byte) 183, (byte) 82, (byte) 175,
			(byte) 143, (byte) 152, (byte) 150, (byte) 206, (byte) 1, (byte) 254, (byte) 167, (byte) 249, (byte) 84,
			(byte) 154, (byte) 165, (byte) 202, (byte) 136, (byte) 252, (byte) 161, (byte) 134, (byte) 207, (byte) 64,
			(byte) 123, (byte) 251, (byte) 214, (byte) 20, (byte) 185, (byte) 98, (byte) 89, (byte) 137, (byte) 44,
			(byte) 78, (byte) 73, (byte) 39, (byte) 169, (byte) 160, (byte) 102, (byte) 7, (byte) 138, (byte) 142,
			(byte) 52, (byte) 66, (byte) 115, (byte) 130, (byte) 110, (byte) 98, (byte) 239, (byte) 232, (byte) 178,
			(byte) 255, (byte) 0, (byte) 241, (byte) 85, (byte) 201, (byte) 196, (byte) 98, (byte) 126, (byte) 89,
			(byte) 85, (byte) 143, (byte) 184, (byte) 174, (byte) 195, (byte) 196, (byte) 177, (byte) 121, (byte) 186,
			(byte) 28, (byte) 153, (byte) 255, (byte) 0, (byte) 150, (byte) 114, (byte) 43, (byte) 244, (byte) 247,
			(byte) 11, (byte) 255, (byte) 0, (byte) 179, (byte) 87, (byte) 22, (byte) 150, (byte) 11, (byte) 213,
			(byte) 102, (byte) 157, (byte) 125, (byte) 196, (byte) 135, (byte) 250, (byte) 154, (byte) 222, (byte) 27,
			(byte) 25, (byte) 200, (byte) 212, (byte) 183, (byte) 185, (byte) 184, (byte) 135, (byte) 30, (byte) 69,
			(byte) 204, (byte) 208, (byte) 143, (byte) 250, (byte) 98, (byte) 251, (byte) 127, (byte) 149, (byte) 91,
			(byte) 254, (byte) 209, (byte) 191, (byte) 63, (byte) 52, (byte) 151, (byte) 215, (byte) 19, (byte) 96,
			(byte) 103, (byte) 247, (byte) 242, (byte) 180, (byte) 159, (byte) 204, (byte) 226, (byte) 178, (byte) 213,
			(byte) 150, (byte) 217, (byte) 34, (byte) 71, (byte) 18, (byte) 76, (byte) 207, (byte) 38, (byte) 208,
			(byte) 217, (byte) 203, (byte) 156, (byte) 140, (byte) 128, (byte) 121, (byte) 0, (byte) 1, (byte) 180,
			(byte) 246, (byte) 207, (byte) 60, (byte) 231, (byte) 140, (byte) 77, (byte) 43, (byte) 19, (byte) 19,
			(byte) 132, (byte) 141, (byte) 214, (byte) 77, (byte) 135, (byte) 104, (byte) 32, (byte) 156, (byte) 156,
			(byte) 113, (byte) 156, (byte) 86, (byte) 150, (byte) 68, (byte) 154, (byte) 209, (byte) 107, (byte) 26,
			(byte) 132, (byte) 35, (byte) 17, (byte) 204, (byte) 136, (byte) 63, (byte) 217, (byte) 130, (byte) 32,
			(byte) 127, (byte) 61, (byte) 185, (byte) 253, (byte) 106, (byte) 253, (byte) 134, (byte) 181, (byte) 117,
			(byte) 115, (byte) 168, (byte) 90, (byte) 219, (byte) 204, (byte) 161, (byte) 214, (byte) 73, (byte) 146,
			(byte) 51, (byte) 151, (byte) 144, (byte) 99, (byte) 115, (byte) 1, (byte) 192, (byte) 12, (byte) 6,
			(byte) 121, (byte) 244, (byte) 197, (byte) 114, (byte) 210, (byte) 182, (byte) 162, (byte) 187, (byte) 124,
			(byte) 152, (byte) 226, (byte) 101, (byte) 11, (byte) 243, (byte) 229, (byte) 246, (byte) 252, (byte) 222,
			(byte) 221, (byte) 120, (byte) 171, (byte) 218, (byte) 20, (byte) 215, (byte) 103, (byte) 95, (byte) 211,
			(byte) 146, (byte) 107, (byte) 95, (byte) 45, (byte) 126, (byte) 215, (byte) 15, (byte) 204, (byte) 31,
			(byte) 112, (byte) 255, (byte) 0, (byte) 88, (byte) 190, (byte) 194, (byte) 165, (byte) 164, (byte) 23,
			(byte) 61, (byte) 49, (byte) 34, (byte) 72, (byte) 163, (byte) 84, (byte) 69, (byte) 10, (byte) 160,
			(byte) 96, (byte) 40, (byte) 24, (byte) 0, (byte) 82, (byte) 17, (byte) 252, (byte) 234, (byte) 96,
			(byte) 50, (byte) 128, (byte) 251, (byte) 85, (byte) 123, (byte) 169, (byte) 225, (byte) 182, (byte) 129,
			(byte) 230, (byte) 158, (byte) 69, (byte) 138, (byte) 40, (byte) 198, (byte) 89, (byte) 152, (byte) 224,
			(byte) 10, (byte) 230, (byte) 53, (byte) 47, (byte) 104, (byte) 132, (byte) 13, (byte) 81, (byte) 51,
			(byte) 221, (byte) 88, (byte) 15, (byte) 202, (byte) 138, (byte) 161, (byte) 225, (byte) 221, (byte) 62,
			(byte) 255, (byte) 0, (byte) 87, (byte) 212, (byte) 33, (byte) 213, (byte) 231, (byte) 243, (byte) 44,
			(byte) 244, (byte) 248, (byte) 78, (byte) 235, (byte) 104, (byte) 72, (byte) 195, (byte) 206, (byte) 113,
			(byte) 141, (byte) 205, (byte) 232, (byte) 190, (byte) 131, (byte) 243, (byte) 246, (byte) 43, (byte) 88,
			(byte) 232, (byte) 181, (byte) 33, (byte) 157, (byte) 85, (byte) 237, (byte) 220, (byte) 22, (byte) 216,
			(byte) 251, (byte) 66, (byte) 72, (byte) 83, (byte) 25, (byte) 222, (byte) 177, (byte) 150, (byte) 11,
			(byte) 245, (byte) 199, (byte) 74, (byte) 170, (byte) 154, (byte) 158, (byte) 143, (byte) 41, (byte) 194,
			(byte) 222, (byte) 70, (byte) 173, (byte) 220, (byte) 59, (byte) 21, (byte) 35, (byte) 240, (byte) 61,
			(byte) 43, (byte) 86, (byte) 177, (byte) 117, (byte) 63, (byte) 13, (byte) 165, (byte) 235, (byte) 249,
			(byte) 182, (byte) 183, (byte) 114, (byte) 88, (byte) 200, (byte) 78, (byte) 91, (byte) 98, (byte) 171,
			(byte) 163, (byte) 127, (byte) 192, (byte) 72, (byte) 224, (byte) 253, (byte) 49, (byte) 78, (byte) 200,
			(byte) 69, (byte) 216, (byte) 141, (byte) 165, (byte) 193, (byte) 255, (byte) 0, (byte) 71, (byte) 186,
			(byte) 142, (byte) 67, (byte) 219, (byte) 99, (byte) 131, (byte) 252, (byte) 169, (byte) 205, (byte) 103,
			(byte) 201, (byte) 109, (byte) 192, (byte) 177, (byte) 234, (byte) 72, (byte) 228, (byte) 215, (byte) 51,
			(byte) 55, (byte) 133, (byte) 181, (byte) 193, (byte) 247, (byte) 47, (byte) 244, (byte) 251, (byte) 128,
			(byte) 58, (byte) 9, (byte) 173, (byte) 221, (byte) 79, (byte) 232, (byte) 216, (byte) 253, (byte) 42,
			(byte) 31, (byte) 236, (byte) 175, (byte) 18, (byte) 218, (byte) 255, (byte) 0, (byte) 171, (byte) 211,
			(byte) 173, (byte) 155, (byte) 31, (byte) 197, (byte) 109, (byte) 122, (byte) 99, (byte) 63, (byte) 150,
			(byte) 223, (byte) 235, (byte) 71, (byte) 42, (byte) 29, (byte) 217, (byte) 208, (byte) 79, (byte) 161,
			(byte) 199, (byte) 60, (byte) 134, (byte) 82, (byte) 89, (byte) 93, (byte) 186, (byte) 178, (byte) 185,
			(byte) 244, (byte) 199, (byte) 126, (byte) 59, (byte) 85, (byte) 89, (byte) 60, (byte) 58, (byte) 88,
			(byte) 96, (byte) 79, (byte) 43, (byte) 15, (byte) 250, (byte) 106, (byte) 21, (byte) 135, (byte) 233,
			(byte) 138, (byte) 199, (byte) 55, (byte) 190, (byte) 35, (byte) 182, (byte) 63, (byte) 61, (byte) 142,
			(byte) 176, (byte) 152, (byte) 234, (byte) 35, (byte) 242, (byte) 231, (byte) 95, (byte) 204, (byte) 146,
			(byte) 105, (byte) 195, (byte) 197, (byte) 247, (byte) 86, (byte) 223, (byte) 241, (byte) 242, (byte) 215,
			(byte) 49, (byte) 30, (byte) 255, (byte) 0, (byte) 104, (byte) 177, (byte) 112, (byte) 63, (byte) 48,
			(byte) 160, (byte) 126, (byte) 180, (byte) 185, (byte) 16, (byte) 249, (byte) 153, (byte) 106, (byte) 79,
			(byte) 11, (byte) 47, (byte) 95, (byte) 46, (byte) 217, (byte) 207, (byte) 253, (byte) 123, (byte) 108,
			(byte) 253, (byte) 121, (byte) 170, (byte) 146, (byte) 120, (byte) 85, (byte) 59, (byte) 219, (byte) 64,
			(byte) 73, (byte) 254, (byte) 228, (byte) 207, (byte) 159, (byte) 200, (byte) 224, (byte) 85, (byte) 136,
			(byte) 188, (byte) 117, (byte) 1, (byte) 225, (byte) 174, (byte) 244, (byte) 246, (byte) 99, (byte) 252,
			(byte) 38, (byte) 79, (byte) 44, (byte) 254, (byte) 68, (byte) 154, (byte) 209, (byte) 139, (byte) 196,
			(byte) 194, (byte) 84, (byte) 207, (byte) 216, (byte) 252, (byte) 193, (byte) 216, (byte) 67, (byte) 40,
			(byte) 124, (byte) 254, (byte) 96, (byte) 15, (byte) 214, (byte) 151, (byte) 32, (byte) 115, (byte) 28,
			(byte) 228, (byte) 190, (byte) 18, (byte) 5, (byte) 24, (byte) 27, (byte) 107, (byte) 133, (byte) 82,
			(byte) 48, (byte) 64, (byte) 146, (byte) 50, (byte) 63, (byte) 46, (byte) 77, (byte) 55, (byte) 73,
			(byte) 240, (byte) 230, (byte) 172, (byte) 111, (byte) 110, (byte) 110, (byte) 103, (byte) 185, (byte) 48,
			(byte) 172, (byte) 108, (byte) 241, (byte) 192, (byte) 38, (byte) 82, (byte) 204, (byte) 232, (byte) 72,
			(byte) 231, (byte) 253, (byte) 145, (byte) 242, (byte) 143, (byte) 199, (byte) 61, (byte) 59, (byte) 245,
			(byte) 81, (byte) 248, (byte) 130, (byte) 193, (byte) 254, (byte) 253, (byte) 172, (byte) 209, (byte) 99,
			(byte) 174, (byte) 228, (byte) 94, (byte) 63, (byte) 34, (byte) 106, (byte) 117, (byte) 213, (byte) 180,
			(byte) 167, (byte) 255, (byte) 0, (byte) 150, (byte) 165, (byte) 127, (byte) 222, (byte) 71, (byte) 31,
			(byte) 210, (byte) 151, (byte) 35, (byte) 31, (byte) 49, (byte) 206, (byte) 71, (byte) 225, (byte) 235,
			(byte) 232, (byte) 99, (byte) 49, (byte) 175, (byte) 216, (byte) 221, (byte) 76, (byte) 143, (byte) 38,
			(byte) 30, (byte) 70, (byte) 234, (byte) 204, (byte) 91, (byte) 166, (byte) 223, (byte) 124, (byte) 126,
			(byte) 21, (byte) 47, (byte) 135, (byte) 188, (byte) 48, (byte) 154, (byte) 76, (byte) 179, (byte) 93,
			(byte) 207, (byte) 181, (byte) 238, (byte) 100, (byte) 118, (byte) 217, (byte) 180, (byte) 252, (byte) 177,
			(byte) 169, (byte) 61, (byte) 184, (byte) 228, (byte) 145, (byte) 140, (byte) 159, (byte) 192, (byte) 119,
			(byte) 39, (byte) 163, (byte) 91, (byte) 189, (byte) 57, (byte) 248, (byte) 75, (byte) 216, (byte) 24,
			(byte) 158, (byte) 194, (byte) 85, (byte) 205, (byte) 76, (byte) 45, (byte) 209, (byte) 134, (byte) 84,
			(byte) 130, (byte) 15, (byte) 124, (byte) 102, (byte) 151, (byte) 43, (byte) 14, (byte) 100, (byte) 84,
			(byte) 219, (byte) 207, (byte) 184, (byte) 170, (byte) 151, (byte) 247, (byte) 43, (byte) 12, (byte) 100,
			(byte) 117, (byte) 61, (byte) 14, (byte) 63, (byte) 149, (byte) 106, (byte) 61, (byte) 190, (byte) 216,
			(byte) 216, (byte) 134, (byte) 3, (byte) 3, (byte) 60, (byte) 10, (byte) 229, (byte) 238, (byte) 93,
			(byte) 166, (byte) 148, (byte) 147, (byte) 156, (byte) 3, (byte) 128, (byte) 42, (byte) 90, (byte) 177,
			(byte) 73, (byte) 220, (byte) 169, (byte) 41, (byte) 105, (byte) 92, (byte) 187, (byte) 117, (byte) 53,
			(byte) 3, (byte) 165, (byte) 91, (byte) 43, (byte) 219, (byte) 244, (byte) 172, (byte) 248, (byte) 228,
			(byte) 187, (byte) 214, (byte) 47, (byte) 26, (byte) 195, (byte) 68, (byte) 69, (byte) 145, (byte) 208,
			(byte) 226, (byte) 107, (byte) 182, (byte) 25, (byte) 138, (byte) 15, (byte) 254, (byte) 41, (byte) 189,
			(byte) 191, (byte) 62, (byte) 132, (byte) 80, (byte) 149, (byte) 193, (byte) 153, (byte) 186, (byte) 246,
			(byte) 211, (byte) 164, (byte) 94, (byte) 219, (byte) 161, (byte) 221, (byte) 57, (byte) 133, (byte) 29,
			(byte) 34, (byte) 31, (byte) 120, (byte) 129, (byte) 52, (byte) 121, (byte) 56, (byte) 244, (byte) 255,
			(byte) 0, (byte) 3, (byte) 88, (byte) 87, (byte) 54, (byte) 90, (byte) 91, (byte) 70, (byte) 162,
			(byte) 29, (byte) 118, (byte) 25, (byte) 153, (byte) 3, (byte) 62, (byte) 193, (byte) 98, (byte) 97,
			(byte) 125, (byte) 193, (byte) 51, (byte) 140, (byte) 224, (byte) 100, (byte) 18, (byte) 161, (byte) 112,
			(byte) 79, (byte) 4, (byte) 231, (byte) 28, (byte) 147, (byte) 94, (byte) 181, (byte) 166, (byte) 120,
			(byte) 67, (byte) 75, (byte) 177, (byte) 179, (byte) 120, (byte) 102, (byte) 139, (byte) 237, (byte) 147,
			(byte) 79, (byte) 131, (byte) 61, (byte) 196, (byte) 220, (byte) 188, (byte) 135, (byte) 235, (byte) 216,
			(byte) 123, (byte) 10, (byte) 124, (byte) 222, (byte) 19, (byte) 211, (byte) 93, (byte) 54, (byte) 196,
			(byte) 247, (byte) 80, (byte) 127, (byte) 185, (byte) 59, (byte) 17, (byte) 244, (byte) 195, (byte) 100,
			(byte) 126, (byte) 149, (byte) 180, (byte) 116, (byte) 86, (byte) 51, (byte) 111, (byte) 83, (byte) 197,
			(byte) 26, (byte) 12, (byte) 188, (byte) 108, (byte) 73, (byte) 83, (byte) 27, (byte) 110, (byte) 7,
			(byte) 29, (byte) 240, (byte) 71, (byte) 245, (byte) 171, (byte) 34, (byte) 95, (byte) 246, (byte) 114,
			(byte) 58, (byte) 115, (byte) 197, (byte) 122, (byte) 140, (byte) 190, (byte) 2, (byte) 183, (byte) 111,
			(byte) 185, (byte) 120, (byte) 157, (byte) 115, (byte) 137, (byte) 44, (byte) 45, (byte) 219, (byte) 245,
			(byte) 8, (byte) 15, (byte) 235, (byte) 84, (byte) 102, (byte) 248, (byte) 124, (byte) 255, (byte) 0,
			(byte) 193, (byte) 253, (byte) 157, (byte) 39, (byte) 185, (byte) 142, (byte) 116, (byte) 63, (byte) 248,
			(byte) 236, (byte) 184, (byte) 253, (byte) 42, (byte) 249, (byte) 137, (byte) 177, (byte) 196, (byte) 232,
			(byte) 250, (byte) 116, (byte) 26, (byte) 133, (byte) 196, (byte) 177, (byte) 207, (byte) 36, (byte) 232,
			(byte) 171, (byte) 30, (byte) 71, (byte) 145, (byte) 24, (byte) 115, (byte) 156, (byte) 129, (byte) 158,
			(byte) 189, (byte) 6, (byte) 106, (byte) 118, (byte) 183, (byte) 142, (byte) 203, (byte) 197, (byte) 22,
			(byte) 241, (byte) 195, (byte) 191, (byte) 202, (byte) 23, (byte) 49, (byte) 58, (byte) 110, (byte) 77,
			(byte) 188, (byte) 22, (byte) 7, (byte) 212, (byte) 156, (byte) 3, (byte) 145, (byte) 215, (byte) 181,
			(byte) 116, (byte) 167, (byte) 193, (byte) 23, (byte) 246, (byte) 239, (byte) 190, (byte) 11, (byte) 82,
			(byte) 174, (byte) 58, (byte) 61, (byte) 174, (byte) 163, (byte) 229, (byte) 159, (byte) 195, (byte) 116,
			(byte) 68, (byte) 255, (byte) 0, (byte) 227, (byte) 213, (byte) 93, (byte) 188, (byte) 35, (byte) 173,
			(byte) 155, (byte) 184, (byte) 238, (byte) 166, (byte) 183, (byte) 184, (byte) 118, (byte) 71, (byte) 83,
			(byte) 243, (byte) 92, (byte) 164, (byte) 206, (byte) 66, (byte) 158, (byte) 57, (byte) 37, (byte) 106,
			(byte) 44, (byte) 249, (byte) 249, (byte) 175, (byte) 167, (byte) 99, (byte) 75, (byte) 195, (byte) 146,
			(byte) 214, (byte) 215, (byte) 189, (byte) 255, (byte) 0, (byte) 67, (byte) 110, (byte) 238, (byte) 242,
			(byte) 223, (byte) 79, (byte) 178, (byte) 251, (byte) 69, (byte) 204, (byte) 155, (byte) 16, (byte) 0,
			(byte) 56, (byte) 25, (byte) 44, (byte) 79, (byte) 64, (byte) 7, (byte) 114, (byte) 125, (byte) 41,
			(byte) 52, (byte) 127, (byte) 14, (byte) 220, (byte) 106, (byte) 247, (byte) 17, (byte) 234, (byte) 154,
			(byte) 236, (byte) 94, (byte) 92, (byte) 40, (byte) 119, (byte) 91, (byte) 88, (byte) 30, (byte) 139,
			(byte) 232, (byte) 242, (byte) 122, (byte) 183, (byte) 183, (byte) 111, (byte) 207, (byte) 55, (byte) 52,
			(byte) 95, (byte) 13, (byte) 204, (byte) 247, (byte) 73, (byte) 171, (byte) 107, (byte) 155, (byte) 94,
			(byte) 237, (byte) 127, (byte) 212, (byte) 91, (byte) 41, (byte) 204, (byte) 118, (byte) 163, (byte) 219,
			(byte) 213, (byte) 189, (byte) 91, (byte) 250, (byte) 99, (byte) 29, (byte) 53, (byte) 76, (byte) 99,
			(byte) 97, (byte) 54, (byte) 0, (byte) 1, (byte) 192, (byte) 224, (byte) 81, (byte) 75, (byte) 69,
			(byte) 89, (byte) 33, (byte) 69, (byte) 20, (byte) 80, (byte) 1, (byte) 73, (byte) 69, (byte) 20, (byte) 0,
			(byte) 180, (byte) 152, (byte) 207, (byte) 90, (byte) 40, (byte) 160, (byte) 10, (byte) 243, (byte) 88,
			(byte) 89, (byte) 220, (byte) 12, (byte) 77, (byte) 105, (byte) 4, (byte) 128, (byte) 255, (byte) 0,
			(byte) 122, (byte) 48, (byte) 107, (byte) 54, (byte) 111, (byte) 7, (byte) 120, (byte) 114, (byte) 115,
			(byte) 185, (byte) 244, (byte) 123, (byte) 96, (byte) 222, (byte) 168, (byte) 155, (byte) 79, (byte) 233,
			(byte) 69, (byte) 20, (byte) 1, (byte) 89, (byte) 188, (byte) 17, (byte) 165, (byte) 143, (byte) 248,
			(byte) 247, (byte) 184, (byte) 212, (byte) 45, (byte) 135, (byte) 101, (byte) 138, (byte) 241, (byte) 246,
			(byte) 143, (byte) 192, (byte) 146, (byte) 42, (byte) 7, (byte) 240, (byte) 93, (byte) 194, (byte) 255,
			(byte) 0, (byte) 199, (byte) 182, (byte) 191, (byte) 118, (byte) 163, (byte) 178, (byte) 205, (byte) 20,
			(byte) 114, (byte) 126, (byte) 187, (byte) 115, (byte) 69, (byte) 20, (byte) 92, (byte) 8, (byte) 31,
			(byte) 194, (byte) 254, (byte) 32, (byte) 143, (byte) 136, (byte) 181, (byte) 27, (byte) 9, (byte) 215,
			(byte) 210, (byte) 88, (byte) 29, (byte) 79, (byte) 232, (byte) 216, (byte) 253, (byte) 42, (byte) 164,
			(byte) 154, (byte) 39, (byte) 136, (byte) 225, (byte) 231, (byte) 251, (byte) 54, (byte) 218, (byte) 95,
			(byte) 246, (byte) 173, (byte) 175, (byte) 154, (byte) 35, (byte) 255, (byte) 0, (byte) 160, (byte) 231,
			(byte) 245, (byte) 162, (byte) 138, (byte) 119, (byte) 1, (byte) 26, (byte) 125, (byte) 122, (byte) 216,
			(byte) 98, (byte) 77, (byte) 47, (byte) 88, (byte) 140, (byte) 142, (byte) 134, (byte) 23, (byte) 89,
			(byte) 64, (byte) 252, (byte) 11, (byte) 16, (byte) 127, (byte) 21, (byte) 52, (byte) 209, (byte) 173,
			(byte) 100, (byte) 236, (byte) 187, (byte) 211, (byte) 111, (byte) 195, (byte) 147, (byte) 247, (byte) 163,
			(byte) 178, (byte) 144, (byte) 17, (byte) 245, (byte) 24, (byte) 193, (byte) 247, (byte) 32, (byte) 253,
			(byte) 5, (byte) 20, (byte) 82, (byte) 105, (byte) 49, (byte) 167, (byte) 97, (byte) 214, (byte) 218,
			(byte) 62, (byte) 163, (byte) 226, (byte) 89, (byte) 74, (byte) 186, (byte) 207, (byte) 167, (byte) 105,
			(byte) 32, (byte) 225, (byte) 153, (byte) 148, (byte) 164, (byte) 247, (byte) 62, (byte) 192, (byte) 117,
			(byte) 69, (byte) 253, (byte) 79, (byte) 183, (byte) 34, (byte) 187, (byte) 75, (byte) 13, (byte) 62,
			(byte) 211, (byte) 75, (byte) 179, (byte) 142, (byte) 210, (byte) 202, (byte) 4, (byte) 130, (byte) 24,
			(byte) 198, (byte) 21, (byte) 84, (byte) 81, (byte) 69, (byte) 36, (byte) 172, (byte) 13, (byte) 220,
			(byte) 181, (byte) 69, (byte) 20, (byte) 83, (byte) 16, (byte) 81, (byte) 69, (byte) 20, (byte) 0,
			(byte) 148, (byte) 81, (byte) 69, (byte) 0, (byte) 45, (byte) 20, (byte) 81, (byte) 64, (byte) 5,
			(byte) 20, (byte) 81, (byte) 64, (byte) 31, (byte) 255, (byte) 217

	};

}
