/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file frame_password.hpp
 * \brief This frame is shown to enter the passwords.
 * \author Julien Jorge.
 */
#ifndef __PTB_FRAME_PASSWORD_HPP__
#define __PTB_FRAME_PASSWORD_HPP__

#include "ptb/frame/frame.hpp"
#include "ptb/frame/button.hpp"
#include "gui/text_input.hpp"

namespace ptb
{
  /**
   * \brief This frame is shown to choose enter the passwords.
   * \author Julien Jorge.
   */
  class frame_password:
    public frame
  {
    typedef button< bear::gui::static_text,
                    std::mem_fun_t<bool, frame_password> > button_with_text;

  public:
    frame_password( windows_layer* in_layer );

  private:
    bool on_key_press( const bear::input::key_info& key );
    bool on_button_press( bear::input::joystick::joy_code button,
                          unsigned int joy_index );
    void validate();

    void create_controls();
    void create_input( bear::gui::static_text::font_type f );
    void create_back( bear::gui::static_text::font_type f );

    bool on_back();
    void on_up();
    void on_down();

    void execute_command( const std::vector<std::string>& command ) const;

    void command_load_level( const std::vector<std::string>& command ) const;
    void command_give
    ( const std::vector<std::string>& command, unsigned int index ) const;
    void command_game_variable( const std::vector<std::string>& command ) const;

    template<typename T>
    void command_game_variable( const std::string& var_value ) const;

  private:
    /** \brief The text control receiving the passwords. */
    bear::gui::text_input* m_password;

    /** \brief The "Back" button. */
    button_with_text* m_back;

    /** \brief The history of commands. */
    std::vector<std::string> m_history;

    /** \brief The index of the current command in the history. */
    unsigned int m_history_index;

    /** \brief The size of the margins between controls. */
    static const unsigned int s_margin;

  }; // class frame_password
} // namespace ptb

#include "ptb/frame/impl/frame_password.tpp"

#endif // __PTB_FRAME_PASSWORD_HPP__
