/*
  Plee the Bear

  Copyright (C) 2005-2009 Julien Jorge, Sebastien Angibaud

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

  contact: plee-the-bear@gamned.org

  Please add the tag [PTB] in the subject of your mails.
*/
/**
 * \file air_stone.hpp
 * \brief The class describing a stone with the air power.
 * \author Sbastien Angibaud
 */
#ifndef __PTB_AIR_STONE_HPP__
#define __PTB_AIR_STONE_HPP__

#include "ptb/item/stone/stone.hpp"
#include "universe/derived_item_handle.hpp"
#include "generic_items/reference_item.hpp"

namespace ptb
{
  class plee;

  /**
   * \brief The class describing a stone with the air power.
   * \author Sbastien Angibaud
   */
  class air_stone:
    public stone
  {
  public:
    /** \brief The type of the parent class. */
    typedef stone super;

  public:
    air_stone( bear::engine::base_item::id_type id_creator );
    ~air_stone();

    void build();
    virtual void progress( bear::universe::time_type elapsed_time);
    virtual void inform_new_stone();
    virtual void inform_no_energy(const monster& attacker);
    virtual void kill();
    virtual bool has_air_power() const;

  protected:
    void air_progress( bear::universe::time_type elapsed_time);
    virtual void create_decorations(); 
    virtual void initialize_intensity();
    void blast();
    void create_movement();
    virtual void execute_function( const std::string& name );

  private:
    void create_decorative_blast
    (const std::string& anim_name, const bear::universe::speed_type& speed);

  private:
    /** \brief Pointer to the player. */
    bear::universe::derived_item_handle_maker<plee>::handle_type m_player;
    
    /** \brief Indicates if the stone blast. */
    bool m_blast;
    
    /** \brief The reference item for the movement. */
    bear::reference_item* m_reference_item; 

    /** \brief Indicates the time since the stone deflates. */
    bear::universe::time_type m_deflate_time;

    /** \brief The time over which the stone falls. */
    static const bear::universe::time_type s_fall_time;
  }; // class air_stone
} // namespace ptb

#endif // __PTB_AIR_STONE_HPP__
