/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001  Kevin P. Lawton
 *
 *  cgutil-mon.c: utility functions for tcode generation.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#include "plex86.h"
#define IN_MONITOR_SPACE
#include "monitor.h"







  unsigned
dtEmitPushImm32(Bit8u *p, unsigned remain, Bit32u imm32)
{
  if (remain < 5)
    return( 0 ); /* Out of space. */
  *p++ = 0x68;
  *(Bit32u *) p = imm32;

  return( 5 );
}


  unsigned
dtEmitUseR3hStack(Bit8u *p, unsigned remain)
{
  Bit8u *pOrig = p;

  /* Store guest stack info in r3h data area. */

  /* gs; movl %esp, __guestESP */
  if (remain < 7)
    return( 0 ); /* Out of space. */
  *p++ = 0x65;
  *p++ = 0x89;
  *p++ = 0x25;
  *(Bit32u *) p = (Bit32u) & __guestESP;
  p += 4;
  remain -= 7;

  /* Switch to r3h stack. */

  /* gs; lss __r3hESP, %esp */
  if (remain < 8)
    return( 0 ); /* Out of space. */
  *p++ = 0x65;
  *p++ = 0x0f;
  *p++ = 0xb2;
  *p++ = 0x25;
  *(Bit32u *) p = (Bit32u) & __r3hESP;
  p += 4;
  remain -= 8;

  return( p - pOrig );
}


  unsigned
dtEmitUseGuestStack(Bit8u *p, unsigned remain)
{
  Bit8u *pOrig = p;

  /* Switch to guest stack. */

  /* gs; lss __guestESP, %esp */
  if (remain < 8)
    return( 0 ); /* Out of space. */
  *p++ = 0x65;
  *p++ = 0x0f;
  *p++ = 0xb2;
  *p++ = 0x25;
  *(Bit32u *) p = (Bit32u) & __guestESP;
  p += 4;
  remain -= 8;

  return( p - pOrig );
}


  unsigned
dtEmitPushf(Bit8u *p, unsigned remain)
{
  if (remain < 1)
    return( 0 ); /* Out of space. */
  *p++ = 0x9c;   /* pushfl */
  remain -= 1;
  return( 1 );
}


  unsigned
dtEmitPopf(Bit8u *p, unsigned remain)
{
  if (remain < 1)
    return( 0 ); /* Out of space. */
  *p++ = 0x9d;   /* popfl */
  remain -= 1;
  return( 1 );
}


  unsigned
dtEmitIDCheck(Bit8u *p, unsigned remain, Bit8u **offsetPtr, Bit8u **idPtr)
{
  Bit8u *pOrig = p;

  if (remain < 11)
    return( 0 ); /* Out of space. */
  /* gs; cmpl $inline-ID, globalID */
  *p++ = 0x65;
  *p++ = 0x81;
  *p++ = 0x3d;
  *(Bit32u *) p = (Bit32u) & __hashID;
  p += 4;
  /* Start ID at zero so the first compare creates a miss.  This is
   * dynamically patched by handler routine.
   */
  *idPtr = p;
  *(Bit32u *) p = 0; // xxx Should use 0 here?
  p += 4;
  remain -= 11;

  /* jnz */
  if (remain < 2)
    return( 0 ); /* Out of space. */
  *p++ = 0x75;
  *offsetPtr = p;
  *p++ = 0x00;   /* 8bit offset patched by DT engine */
  remain -= 2;

  return( p - pOrig );
}


  unsigned
dtEmitJmp(Bit8u *p, unsigned remain, Bit32u **offsetPtr)
{
  if (remain < 5)
    return( 0 ); /* Out of space. */
  *p++ = 0xe9;   /* jmp Jv */
  *offsetPtr = (Bit32u *) p;
  *(Bit32u *) p = 0; /* Patched in by DT engine */
  p += 4;
  remain -= 5;

  return( 5 );
}


  unsigned
dtEmitCall(Bit8u *p, unsigned remain, Bit32u **offsetPtr)
{
  if (remain < 5)
    return( 0 ); /* Out of space. */
  *p++ = 0xe8;   /* call Av */
  *offsetPtr = (Bit32u *) p;
  *(Bit32u *) p = 0; /* Patched in by DT engine */
  p += 4;
  remain -= 5;

  return( 5 );
}
