/*
 *  plex86: run multiple x86 operating systems concurrently
 *  Copyright (C) 1999-2001 Kevin P. Lawton
 *
 *  mon-mode.c:  Handling of mode to run guest code in.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

/* TODO:
 *   - kick out of RMMonPM when descriptor caches are compat w/ RM
 *     (and switch to differnet virtualization matrix)
 */

#include "plex86.h"
#define IN_MONITOR_SPACE
#include "monitor.h"





#warning "need to deal with LGDT for siv==0"




  void
monModeChange(vm_t *vm)
{
  if (vm->modeChange & ModeChangeRequestMapVSegs) {
    copyGuestDescToMon(vm, SRegES);
    copyGuestDescToMon(vm, SRegCS);
    copyGuestDescToMon(vm, SRegSS);
    copyGuestDescToMon(vm, SRegDS);
    copyGuestDescToMon(vm, SRegFS);
    copyGuestDescToMon(vm, SRegGS);
    vm->modeChange &= ~ModeChangeRequestMapVSegs;
    }

#if 0
  if (vm->modeChange & ModeChangeEventCS) {
    unsigned newGuestMode;

    /* If the monitor saw an event which may change the mode of
     * the guest, such as a CS register reload, than have a look.
     */
    if (V8086Mode(vm))
      newGuestMode = GuestModeVM;
    else if (RealMode(vm))
      newGuestMode = GuestModeRM;
    else {
      newGuestMode = GuestModePMR0 | G_GetCPL(vm);
      }
    if (GetGuestMode(vm) != newGuestMode) {
      /* Yep, the guest's mode changed.  Flag this as a transition. */
      vm->modeChange |=  ModeChangeEventTransition;
      }
    }
#endif

  /* If we don't need remap due to a guest mode change, then
   * skip the following code, and check for the need for a
   * paging remap.
   */
  if ( !(vm->modeChange & ModeChangeEventTransition) )
    goto pageRemapCheck;

  sysRemapMonitor(vm);

pageRemapCheck:

  /* First set EFLAGS.VM bit according to the mode that the guest
   * will be executed in.
   */
  //if (GetMonMode(vm) == MonModeVM)
  //  vm->guest.addr.guest_context->eflags.fields.vm = 1;
  //else
    vm->guest.addr.guest_context->eflags.fields.vm = 0;

  /* If there was a request for a paging remap, handle that now */
  if (vm->modeChange & ModeChangeRequestPaging) {
    monPagingRemap(vm);
    }

  /* We will get there due to the following conditions:
   *   - CS change
   *   - Guest paging (and thus linear address space) changes
   *   - Mode switch
   * These conditions require a flush of the hash tables used by
   * the DT architecture because they are based on EIP offsets
   * from CS.base, and the current linear address space.
   *
   * xxx However, we will also get here due to:
   * xxx   - Monitor paging remap (monPagingRemap)
   * xxx I'm not sure that we need to flush tables for that alone.
   * xxx   Maybe we do because of A20 changes etc.
   */
  //dtInitHashTables(vm);

  /* All mode changes have been handled, reset flag */
  vm->modeChange = 0;
}
