/*
 * $Id: control.h,v 1.23 2001/09/16 15:07:38 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#ifndef __PLUCKER_CONTROL_H
#define __PLUCKER_CONTROL_H

#include "viewer.h"
#include "prefsdata.h"



typedef enum {
    AUTOSCROLL_OFF,
    AUTOSCROLL_ON,
    AUTOSCROLL_TOGGLE
} AutoscrollType;



void ClearControlBounds( void );
void DoControlAction( const Int16 control );
void DoSelectTypeAction( SelectType selection );
void GetControlBounds( const FormType* form, const UInt16 objectId,
        const Int16 control );
void GotoLocation( const Int16 percent );
void HandlePenDown( const EventType* event );
void HandlePenMove( const EventType* event );
void HandlePenUp( const EventType* event );
void InitializeTbmpData( Int16 width, Int16 height );
void DoAutoscrollToggle( AutoscrollType toggle );
void DoAutoscrollIncr( void );
void DoAutoscrollDecr( void );
Boolean MainFormWinActive ( void );
void JumpToRecord( const Int16 record, const Int16 offset );

#endif
