/*
 * $Id: gestureform.c,v 1.4 2001/09/16 15:07:38 nordstrom Exp $
 *
 * Viewer - a part of Plucker, the free off-line HTML viewer for PalmOS
 * Copyright (c) 1998-2001, Mark Ian Lillywhite and Michael Nordstrm
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "debug.h"
#include "prefsdata.h"
#include "gestureform.h"
#include "resourceids.h"
#include "util.h"


static void GestureFormInit( void ) PLKRDB_SECTION;


/***********************************************************************
 *
 *      Private variables
 *
 ***********************************************************************/
static SelectType gestMode[ NUM_OF_GESTURES ];



/* Initialize the preference form */
static void GestureFormInit( void )
{
    FormType*       prefsForm;
    ListType*       list;
    ControlType*    ctl;
    Int16           selection;

    MemMove( gestMode, Prefs()->gestMode, sizeof( gestMode ) );

    prefsForm = FrmGetFormPtr( frmGesture );
    FrmDrawForm( prefsForm );

    CtlSetValue( (ControlType*) GetObjectPtr( frmGestureGestures ), Prefs()->gestures );

    list        = (ListType*) GetObjectPtr( frmGestureActionList );
    ctl         = (ControlType*) GetObjectPtr( frmGestureSelectAction );
    selection   = gestMode[ GESTURES_UP ];

    LstSetSelection( list, selection );
    CtlSetLabel( ctl, LstGetSelectionText( list, selection ) );

    CtlSetValue( (ControlType*) GetObjectPtr( frmGestureUp ), true );
}



/* Event handler for the preference form */
Boolean GestureFormHandleEvent
    (
    const EventType* event  /* pointer to an EventType structure */
    )
{
    ListType*       list;
    ControlType*    ctl;
    Int16           selection;
    Boolean         handled;

    SET_A4_FROM_A5 

    handled = false;

    switch ( event->eType ) {
        case ctlSelectEvent:
            switch ( event->data.ctlEnter.controlID ) {
                case frmGestureUp:
                case frmGestureRight:
                case frmGestureDown:
                case frmGestureLeft:
                case frmGestureTap:
                    list        = (ListType*) GetObjectPtr( frmGestureActionList );
                    ctl         = (ControlType*) GetObjectPtr( frmGestureSelectAction );
                    selection   = gestMode[ event->data.ctlEnter.controlID - frmGestureUp ];
                    LstSetSelection( list, selection );
                    CtlSetLabel( ctl, LstGetSelectionText( list, selection ) );

                    break;

                case frmGestureSelectAction:
                    list        = (ListType*) GetObjectPtr( frmGestureActionList );
                    selection   = LstPopupList( list );
                    if ( selection != noListSelection ) {
                        ControlType*    ctl;
                        Char*           label;

                        ctl     = (ControlType*) GetObjectPtr( event->data.ctlEnter.controlID );
                        label   = LstGetSelectionText( list, selection );

                        CtlSetLabel( ctl, label );
                        LstSetSelection( list, selection );

                        if ( CtlGetValue( (ControlType*) GetObjectPtr( frmGestureUp ) ) )
                            gestMode[ GESTURES_UP ] = (SelectType) LstGetSelection( list );
                        else if ( CtlGetValue( (ControlType*) GetObjectPtr( frmGestureRight ) ) )
                            gestMode[ GESTURES_RIGHT ] = (SelectType) LstGetSelection( list );
                        else if ( CtlGetValue( (ControlType*) GetObjectPtr( frmGestureDown ) ) )
                            gestMode[ GESTURES_DOWN ] = (SelectType) LstGetSelection( list );
                        else if ( CtlGetValue( (ControlType*) GetObjectPtr( frmGestureLeft ) ) )
                            gestMode[ GESTURES_LEFT ] = (SelectType) LstGetSelection( list );
                        else
                            gestMode[ GESTURES_TAP ] = (SelectType) LstGetSelection( list );

                        if ( CtlGetValue( (ControlType*) GetObjectPtr( frmGestureGestures ) ) == false &&
                             selection != SELECT_NONE ) {
                            Prefs()->gestures = true;
                            CtlSetValue( (ControlType*) GetObjectPtr( frmGestureGestures ), true );
                        }
                        if ( ( gestMode[ GESTURES_UP ] | gestMode[ GESTURES_RIGHT ] |
                               gestMode[ GESTURES_DOWN ] | gestMode[ GESTURES_LEFT ] |
                               gestMode[ GESTURES_TAP ] ) == SELECT_NONE ) {
                            Prefs()->gestures = false;
                            CtlSetValue( (ControlType*) GetObjectPtr( frmGestureGestures ), false );
                        }
                    }
                    break;

                case frmGestureOK:
                    Prefs()->gestures = CtlGetValue( (ControlType*) GetObjectPtr( frmGestureGestures ) );
                    MemMove( Prefs()->gestMode, gestMode, sizeof( gestMode ) );

                    FrmReturnToForm( Prefs()->lastForm );
                    handled = true;
                    break;

                case frmGestureCancel:
                    FrmReturnToForm( Prefs()->lastForm );
                    handled = true;
                    break;

                default:
                    break;
            }
            break;

        case frmOpenEvent:
            GestureFormInit();
            handled = true;
            break;

        default:
            handled = false;
    }

    RESTORE_A4 

    return handled;
}
