(* Copyright (C) 1993 Digital Equipment Corporation.                   *)
(* All rights reserved. See the file COPYRIGHT for a full description. *)

(* Last modified on Tue Sep  6 16:25:43 PDT 1994 by bharat *)
(*      modified on Thu Mar 10 10:01:04 PST 1994 by mhb  *)
(*      modified on Fri Sep 10 15:01:41 1993 by luca *)

MODULE ObliqRuntime;

IMPORT ObliqOnline;
IMPORT ObLibM3; (* rd,wr,lex,fmt,pickle,process,thread *)
IMPORT ObLibUI; (* color,form *)
IMPORT Dialog, Rsrc, NodeVBT, TextRd, Thread;

CONST Greetings = "Internal Obliq interpreter installed...";

TYPE
  Closure = Thread.SizedClosure OBJECT
              t: TEXT;
            OVERRIDES
              apply := ForkedDo;
            END;

VAR (* probably should not be global *)
  interp: ObliqOnline.T;

PROCEDURE Do (t: TEXT) =
  BEGIN
    EVAL
      Thread.Join(
        Thread.Fork(
          NEW(Closure, t := t,
              stackSize := 2 * Thread.GetDefaultStackSize())));
  END Do;

PROCEDURE ForkedDo (cl: Closure): REFANY =
  BEGIN
    ObliqOnline.Interact(interp,
      rd := TextRd.New(cl.t),
      rdName := "file generated by Visual Obliq",
      closeRd := TRUE, 
      generateEOF := TRUE);
    RETURN NIL
  END ForkedDo;


PROCEDURE loadObliqRsrc(name: TEXT) =
  BEGIN
     TRY
      WITH  loadedFile = Rsrc.Get(name, Dialog.rsrcPath) DO
        Do(loadedFile);
      END;
    EXCEPT
      Rsrc.NotFound =>NodeVBT.print("Error: Cannot find '" & name & "' in resource bundle\n");
    ELSE
     NodeVBT.print("Error: while executing '" & name & "'\n");
    END (* TRY *);
  END loadObliqRsrc;

PROCEDURE Setup() =
 BEGIN
  ObliqOnline.Setup();
  ObLibM3.PackageSetup();
  ObLibUI.PackageSetup();

  (* Don't load default .obliq - who knows what it contains *)
  interp := ObliqOnline.New(Greetings, NIL,  FALSE);

  (* Feed it the bundled obliq start-up files *) 

  (* temporarily mask this:-
     loadObliqRsrc("netobjexec.obl"); 
  *)
  loadObliqRsrc("templates.obl"); 
  loadObliqRsrc("vowidgets.obl"); 
  loadObliqRsrc("vocheckpt.obl"); 
  loadObliqRsrc("volib.obl"); 
  loadObliqRsrc("vos-internal.obl");
 
  Do(";"); 

END Setup;

BEGIN
END ObliqRuntime.


