(* Copyright (C) 1990, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)
(* See the file COPYRIGHT for a full description.              *)

INTERFACE M3PathTool;

IMPORT M3Extension, M3FindFile;

(* This tool provides control over the search path used by an "M3TK"
application. The "Define_Arg" and "TFile_Arg" arguments are "prefix"
keywords, that is, any keyword that begins with a "D" or a "T" will
match and the value returned by "M3Args.GetPrefixArg" will be the text
of the keyword with the prefix removed. 


The "TFile_Arg" may also occur zero or more time, and each occurrence
names a file that contains an explicit mapping of Modula-3 files to
directories, in the syntax specified in the "M3DirFindFile" interface.
For each occurrence, a file finder is generated
by a call to "NEW(M3DirFindFile.TFinder).init".

The "Define_Arg" may occur zero or more times, and each occurrence specifies
a list of directories, in an OS-dependent syntax, in which to look for
Modula-3 files.  Each instance generates an "M3PathElemList.T", by a
call of "M3PathElemOS.DecomposePath"; the separate lists are then
concatenated in the order of occurrence of the associated arguments.

If neither of these arguments is given, a file named <I>m3path</I>,
that is assumed to contain a search path, is searched for in the
current directory. If such a file is found an "M3PathElemList.T"
is generated by a call of "M3PathFile.Read", otherwise a value
of "NIL" is returned.

In the latter two cases, the current working directory is prepended to
the search list by a call of "M3PathDefaults.EnsureCurrentFirst" and,
unless the "NOSTD_Arg" is set, the default library directories, as
given by "M3Config.Pub()", are appended to the search list.  A file
finder is then generated by a call to "NEW(M3DirFindFile.Finder).init".

Finally, the finders are merged into a single instance with the "merge"
method. The merge process begins with the finder generated from the
"Define_Arg" arguments, if any, and then proceeds with the "TFile_Arg"
finders, in reverse order of occurrence.

The "Check" procedure checks for the above arguments and returns
the generated finder. *)

CONST
  Define_Arg = "D";
  TFile_Arg = "T";
  NOSTD_Arg = "NOSTD";

PROCEDURE Check(exts := M3Extension.All): M3FindFile.T;
(* Check for the tool arguments, set up the search path accordingly,
and return a finder for the given set of extensions. *)

END M3PathTool.
