# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import Servers, AbstractFolder, Log

class Folder(AbstractFolder.AbstractFolder):

	def __init__(self, server, name):
		Log.log("creating folder from", server, name)
		AbstractFolder.AbstractFolder.__init__(self)
		Log.log("initialized as abstract folder")
		self._server = server
		self.name = name

	def _get_messages(self):
		Log.log("getting messages from server")
		return self.server().get_list(self.name)

	def _get_folders(self):
		Log.log("getting folders from server")
		return self.server().get_subfolders(self.name)

	def server(self):
		Log.log("getting server")
		return Servers.Servers().server(self._server)

	def get_header(self, index=None):
		Log.log("getting header of", index)
		return self.server().get_header(self.name, self.get_uid(index))

	def get_message(self, index=None):
		Log.log("getting message of", index)
		return self.server().get_message(self.name, 
		                                 self.get_uid(index))

	def _remove_message(self, message):
		Log.log("removing", message) 
		self.server().remove_message(self.name, message)

	def save_message(self, message, index=None):
		Log.log("saving message to", index)
		uid = self.server().save_message(message, self.name, index)
		Log.log("resyncing, uid is", uid)
		self.resync()
		return uid

	def folder(self, folder):
		Log.log("getting subfolder", folder)
		return self.server().subfolder(self.name, folder)

	def create(self):
		Log.log("creating self")
		self.server().create(self.name)
