# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
class And:

	def __init__(self, f1, f2):
		self.f1, self.f2 = f1, f2

	def __call__(self, folder, message):
		return self.f1(folder, message) and self.f2(folder, message)

class Or:

	def __init__(self, f1, f2):
		self.f1, self.f2 = f1, f2

	def __call__(self, folder, message):
		return self.f1(folder, message) or self.f2(folder, message)

class Not:

	def __init__(self, f):
		self.f1 = f

	def __call__(self, folder, message):
		return not self.f(folder, message)


class HeaderMatches:

	def __init__(self, header, matches):
		self.header = header
		self.matches = matches

	def __call__(self, folder, message):
		headers = folder.get_header(message)
		return self.matches(headers.get(self.header, ''))

class MessageIndex:

	def __init__(self, min, max):
		self.min = min
		self.max = max

	def __call__(self, folder, message):
		if self.min is not None and message<self.min:
			return 0
		if self.max is not None and message>self.max:
			return 0
		return 1
