# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import Server, Folder, Actions, MailMessage, Log
import os, string, time, socket

def make_sure_dir_exists(d):
	if not os.path.isdir(d):
		del_dir = os.path.normpath(d)
		Log.log("making directory", d)
		os.makedirs(d)

class MaildirServer(Server.Server):

	seq = [0]

	def __init__(self, name, root):
		Log.log("initializing Maildirserver with", name, root)
		self.name = name
		self.root = root

        def get_message(self, folder, uid):
		Log.log("getting message", uid, "from", folder)
		fp = open(os.path.join(self.root, folder, uid))
		Log.log("got message")
		return MailMessage.parse(fp)
		
        def remove_message(self, folder, uid):
		Log.log("removing", uid, "from", folder)
		name = os.path.basename(uid)
		new_uid = os.path.join('del', name)
		del_dir = os.path.join(self.root, folder, 'del')
		Log.log("moving to", new_uid)
		make_sure_dir_exists(del_dir)
		os.rename(os.path.join(self.root, folder, uid), 
		          os.path.join(self.root, folder, new_uid))

        def save_message(self, message, folder, uid):
		Log.log("saving message to", folder, uid)
		if uid is None:
			Log.log("uid is empty, generating")
			t = int(time.time())
			h = socket.gethostname()
			p = os.getpid()
			s = self.seq[0]
			self.seq[0] = self.seq[0]+1
			uid = "%(t)s.%(p)s_%(s)s.%(h)s" % vars()
			uid = os.path.join('new', uid)
			Log.log("uid is", uid)
			d = os.path.join(self.root, folder, 'new')
			make_sure_dir_exists(d)
		fp = open(os.path.join(self.root, folder, uid), 'w')
		Log.log("saving message to", fp.name)
		try:
			Actions.serialize_message(message, fp)
		finally:
			fp.close()
		return uid

        def get_list(self, folder):
		Log.log("getting list of messages from", folder)
		d = os.path.join(self.root, folder)
		if not os.path.isdir(os.path.join(d, 'new')):
			Log.log("no new/ subfolder,treating as list of folders")
			return []
		ret = []
		Log.log("looking for messages")
		for name in ['cur', 'new']:
			Log.log("looking for messages in", name)
			try:
				list = os.listdir(os.path.join(d, name))
				Log.log("found", len(list), "messages")
			except OSError:
				Log.log("directory doesn't exist")
				pass
			else:
				for file in list:
					ret.append(os.path.join(name, file))
		return ret

        def get_subfolders(self, folder):
		Log.log("looking for subfolders")
		d = os.path.join(self.root, folder)
		if not os.path.isdir(os.path.join(d, 'new')):
			Log.log("guessed only folders are here")
			return os.listdir(d)
		Log.log("guessed only messages are here")
		return []

	def subfolder(self, folder, subfolder):
		Log.log("getting subfolder", subfolder, "of", folder)
		return Folder.Folder(self.name, os.path.join(folder, subfolder))

	def create(self, folder):
		Log.log("creating folder", folder)
		d = os.path.join(self.root, folder)
		os.mkdir(d)
