# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import AbstractFolder, Log

class RecursiveFolder(AbstractFolder.AbstractFolder):

	def __init__(self, folder):
		Log.log("initializing RecursiveFolder from", folder)
		AbstractFolder.AbstractFolder.__init__(self)
		self.name = 'closure('+folder.name+')'
		self._folder = folder
		self.folders = folder.folders
		self.children = {None: folder}
		Log.log("adding children")
		for name in folder.folders:
			Log.log("adding", name)
			child = RecursiveFolder(folder.folder(name))
			self.children[name] = child
			Log.log("added", name)
			
	def _get_messages(self):
		Log.log("getting messages")
		messages = []
		for (name, child) in self.children.items():
			Log.log("getting from", name)
			for message in child.messages:
				Log.log("getting", message)
				messages.append((name, message))
		Log.log("got", len(messages))
		return messages

	def _get_folders(self):
		Log.log("getting subfolders")
		return self._folder.folders
			
	def get_header(self, index=None):
		Log.log("getting header of", index)
		child, uid = self.get_uid(index)
		Log.log("from", child, uid)
		return self.children[child].get_header(uid)

	def get_message(self, index=None):
		Log.log("getting message", index)
		child, uid = self.get_uid(index)
		Log.log("from", child, uid)
		return self.children[child].get_message(uid)

	def _remove_message(self, index=None):
		Log.log("removing message", index)
		child, uid = self.get_uid(index)
		Log.log("from", child, uid)
		self.children[child].remove_message(uid)

	def save_message(self, message, index=None):
		raise NotImplementedError("save not supported")

	def folder(self, folder):
		Log.log("returning child", folder)
		return self.children[folder]

	def create(self):
		raise NotImplementedError("cannot create recursive folder")
