# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import Configuration
import sys

_old_sys_exitfunc = getattr(sys, 'exitfunc', lambda : None)

def onexit():
	for server in Servers().servers.values():
		server.close()
	_old_sys_exitfunc()

sys.exitfunc = onexit

class ServerNotFound(KeyError):
	pass

servers = None
def Servers():
	global servers
	if servers is not None:
		return servers
	servers = _Servers()
	return servers
	
class _Servers: 

	def __init__(self):
		self.servers = {}

	def server(self, name):
		try:
			return self.servers[name]
		except KeyError:
			try:
				config = Configuration.Configuration()
				func = config.servers[name]
			except KeyError:
				raise ServerNotFound(name)
			server = self.servers[name] = func(name)
			return server
