# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import Log
import string, rfc822, time

def from_(folder, mes):
	return folder.get_header(mes).get('from', '')

def subject(folder, mes):
	subject = folder.get_header(mes).get('subject', '')
	while string.lower(subject[:3]) == 're:':
		subject = string.lstrip(subject[3:])
	return subject

def date(folder, mes):
	date = folder.get_header(mes).get('date', '')
	if not date:
		return 0
	date = rfc822.parsedate(date)
	if not date:
		return 0
	return time.mktime(date)
