# This file is released to the Public Domain by Moshe Zadka
# Author: Moshe Zadka <pms@zadka.site.co.il>
import SortFunctions, SortedFolder
import Configuration, Log

def sort_by(func):
	Log.log("sorting by", func)
	status = Configuration.Configuration().status
	folder = status.get_folder()
	folder = SortedFolder.SortedFolder(folder, func)
	Log.log("got folder")
	status.set_folder(folder)
	Log.log("set folder")

def sort_from():
	'''\
	sort_from()

	Sort the current folder by sender
	'''
	Log.log("sorting by sender")
	sort_by(SortFunctions.from_)

def sort_subject():
	'''\
	sort_subject()

	Sort the current folder by subject.
	'''
	Log.log("sorting by subject")
	sort_by(SortFunctions.subject)

def sort_date():
	'''\
	sort_date()

	Sort the current folder by date
	'''
	Log.log("sorting by date")
	sort_by(SortFunctions.date)
