
#include "image.h"
#include "moon.h"
#include "pngwrite.h"
#include "stars.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define VERSION "1.0"

static inline void usage( char *name )
{
   char *base = name;
   char *c;
   
   for( c = name+1; *c; c++)
   {
      if( *(c-1) == '/' ) base = c; 
   }
   
   printf( "this is pngphoon version " VERSION "\n\n"
	   "usage: %s options (* = mandatory)\n"
	   "\t-w # width*\n"
	   "\t-h # height*\n"
	   "\t-f $ filename*\n"
	   "\t-x # number of moons in x axis (for multihead configurations)\n"
	   "\t-y # number of moons in y axis (for multihead configurations)\n"
	   "\t-s # star density\n"
	   "\t-b   black (no earthlight)\n", base );
   exit(0);
}

int main( int argc, char *argv[] )
{
   int     width     = 0;
   int     height    = 0;
   int     xmoons    = 1;
   int     ymoons    = 1;
   int     stars     = 50;
   char    *filename = NULL;
   int	   black     = 0;
   image_t *image    = NULL;
   moon_t  *moon     = NULL;
   int     c;
   int     x;
   int     y;
   
   opterr = 0;
   
   if( argc == 1 )
   {
      usage( argv[0] );
   }
   
   while ((c = getopt (argc, argv, "w:h:x:y:s:f:b")) != EOF)
   {
      switch (c)
      {
	 case 'w':
	    width    = strtol( optarg, NULL, 0 );
	    break;
	 case 'h':
	    height   = strtol( optarg, NULL, 0 );
	    break;
	 case 'x':
	    xmoons   = strtol( optarg, NULL, 0 );
	    break;
	 case 'y':
	    ymoons   = strtol( optarg, NULL, 0 );
	    break;
	 case 's':
	    stars    = strtol( optarg, NULL, 0 );
	    break;
	 case 'f':
	    filename = optarg;
	    break;
	 case 'b':
	    black    = 1;
	    break;
	 default:
	    printf("unknown option: '%c'\n", c);
      }
   }
   
   if( !width || !height || !filename )
   {
      printf( "you need to specify at least width, height and filename\n" );
   }
   
   moon = mooncreate();
   
   image = imagecreate( width, height );
   if( (width  < (moon->width)  * xmoons) ||
       (height < (moon->height) * ymoons) )
   {
      printf("image too small to fit moon%s, creating stars only\n",
	     (xmoons * ymoons > 1) ? "s" : "");
      scarymonster( image, stars * 2 );
   }
   else
   {
      scarymonster( image, stars );
      for( y = (height/ymoons)/2; y < height; y += (height/ymoons) )
      {
	 for( x = (width/xmoons)/2; x < width; x += (width/xmoons) )
	 {
	    mooncopy( image, moon, x, y, black );
	 }
      }
   }
   pngwrite( image, filename );
   imagedestroy( image );
   moondestroy( moon );
   
   return 0;
}
