//
// FIFOEvent.h
//
// $Id: //poco/1.3/Foundation/include/Poco/FIFOEvent.h#2 $
//
// Library: Foundation
// Package: Events
// Module:  FIFOEvent
//
// Implementation of the FIFOEvent template.
//
// Copyright (c) 2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#ifndef  Foundation_FIFOEvent_INCLUDED
#define  Foundation_FIFOEvent_INCLUDED


#include "Poco/AbstractEvent.h"
#include "Poco/FIFOStrategy.h"
#include "Poco/AbstractDelegate.h"
#include "Poco/CompareFunctions.h"


namespace Poco {


template <class TArgs> 
class FIFOEvent: public AbstractEvent < 
	TArgs, 
	FIFOStrategy<TArgs, AbstractDelegate<TArgs>, p_less<AbstractDelegate< TArgs> > >,
	AbstractDelegate<TArgs>
>
	/// A FIFOEvent uses internally a FIFOStrategy which guarantees
	/// that delegates are invoked in the order they were added to
	/// the event.
	///
	/// Note that one object can only register one method to a FIFOEvent.
	/// Subsequent registrations will overwrite the existing delegate.
	/// For example:
	///     FIFOEvent<int> tmp;
	///     MyClass myObject;
	///     tmp += delegate(&myObject, &MyClass::myMethod1);
	///     tmp += delegate(&myObject, &MyClass::myMethod2);
	///
	/// The second registration will overwrite the first one.
{
public:
	FIFOEvent()
	{
	}

	~FIFOEvent()
	{
	}

private:
	FIFOEvent(const FIFOEvent& e);
	FIFOEvent& operator = (const FIFOEvent& e);
};


} // namespace Poco


#endif
