/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef POLYXEDIT_UI_SEQED_WND_H
#define POLYXEDIT_UI_SEQED_WND_H

#include "polyxedit-globals.h"
#include "polyxedit-editctxt.h"
#include "polyxmass-window-mngmt.h"


PxmRect monicon_rect;

gboolean scroll_size_changed;


GtkWidget *
polyxedit_seqed_wnd_setup (PxmEditCtxt *editctxt);

void
polyxedit_seqed_wnd_update_polseq_prop (PxmEditCtxt *editctxt);


void
polyxedit_seqed_wnd_set_polymer_modified (PxmEditCtxt *editctxt, 
					  gboolean modified);




/*
****************************************************************
************* DRAWING FUNCTIONS THROUGHOUT THE FILE ************
****************************************************************
*/
void 
polyxedit_seqed_wnd_setup_monomer_flag (PxmEditCtxt *editctxt);

void 
polyxedit_seqed_wnd_update_monomer_flag (PxmEditCtxt *editctxt);






/*
****************************************************************
**************** VARIOUS  UTILITY   FUNCTIONS ******************
****************************************************************
*/
gint
polyxedit_seqed_wnd_self_read_configuration (PxmEditCtxt *editctxt);


gboolean
polyxedit_seqed_wnd_get_selection_indices (PxmEditCtxt *editctxt,
					   gint *start, gint * end);


PxmMonomer *
polyxedit_seqed_wnd_get_selected_monomer (PxmEditCtxt *editctxt,
					  gint *idx);







/*
****************************************************************
**************** E V E N T  HANDLING FUNCTIONS *****************
****************************************************************
*/

/* SEQEDITOR WINDOW ******************************
 */
gboolean
polyxedit_seqed_wnd_canvas_event (GtkWidget *widget,
				     GdkEvent *event,
				     gpointer data);

gboolean
polyxedit_seqed_wnd_kbd_key_press_event (GtkWidget *widget,
				     GdkEventKey *event,
				     gpointer data);

gboolean
polyxedit_seqed_wnd_kbd_key_release_event (GtkWidget *widget,
					   GdkEventKey *event,
					   gpointer data);

void
polyxedit_seqed_wnd_seq_modified (GtkWidget *widget,
				  gpointer data);

void
polyxedit_seqed_wnd_seq_not_modified (GtkWidget *widget,
				      gpointer data) ;

void
polyxedit_seqed_wnd_whole_seq_mass_update_required (GtkWidget *widget,
					  gpointer data);

void
polyxedit_seqed_wnd_selec_seq_mass_update_required (GtkWidget *widget,
						    gpointer data);

gboolean
polyxedit_seqed_wnd_update_left_end_modif_state (GtkWidget *seqed_widget,
						    gpointer data);

gboolean
polyxedit_seqed_wnd_update_right_end_modif_state (GtkWidget *seqed_widget,
						    gpointer data);




void
polyxedit_seqed_wnd_monicon_size_value_changed (GtkWidget *range,
						gpointer data);

gboolean
polyxedit_seqed_sw_size_allocate (GtkWidget *widget, 
			GtkAllocation *allocation,
				  gpointer data);


gboolean
polyxedit_seqed_wnd_focus_in_event (GtkWidget *widget, 
				    GdkEventFocus *event,
				    gpointer data);


gboolean
polyxedit_seqed_wnd_canvas_event (GtkWidget *widget,
				  GdkEvent *event,
				  gpointer data);

gboolean
polyxedit_seqed_wnd_sel_polygon_event (GtkWidget *widget,
				       GdkEvent *event,
				       gpointer data);


gboolean
polyxedit_seqed_wnd_canvas_item_event (GnomeCanvasItem *canvas_item,
				       GdkEvent *event, gpointer data);

gboolean
polyxedit_seqed_monomer_flag_expose_event (GtkWidget *widget,
					   GdkEventExpose *event, 
					   gpointer data);





/*
****************************************************************
******************** REPORTING FUNCTIONS ***********************
****************************************************************
*/
extern gchar *
polyxedit_seqed_wnd_make_report (PxmReportOpt* reportopt,
				 PxmWinMngmt* winmngmt);

gchar *
polyxedit_seqed_wnd_make_report_text_format (PxmReportOpt* reportopt,
					     PxmWinMngmt* winmngmt);

gchar *
polyxedit_seqed_wnd_make_report_latex_format (PxmReportOpt* reportopt,
					      PxmWinMngmt* winmngmt);



/* WINDOW LIFE-CYCLE FUNCTIONS.
 */
gint 
polyxedit_seqed_wnd_delete_event (GtkWidget *window, GdkEventAny *event, 
			gpointer data);

void 
polyxedit_seqed_wnd_save_question (GtkWidget *widget,
				   gint arg,
				   gpointer data);


gboolean
polyxedit_seqed_wnd_save_and_close (PxmEditCtxt *editctxt);


void 
polyxedit_seqed_wnd_close (PxmEditCtxt *editctxt);



#endif /* ifndef POLYXEDIT_UI_SEQED_WND_H */
