#ifndef __server_h
#define __server_h

#define _GNU_SOURCE
#include "../pslave_cfg.h"
#include <netinet/in.h>
#include "rwconf.h"
#include "auth.h"

#include <syslog.h>

#ifndef HAVE_IPV6
#define in_port_t uint16_t
#endif

void nsyslog(int pri, const char *fmt, ...);
void nopenlog(const char *ident, int logstat, int logfac);
char *check_device(const char *file);

#define P_IDLE  0
#define P_INCOM 5
#define P_LOGIN 10

/* Range of normal, non escape ascii chars */
#define Fascii	32	/* Space */
#define Lascii	126	/* Tilde */

/* Some syntatic sugar */
#define true	1
#define false	0

/* defined in ppp headers
typedef unsigned char bool;
*/

/*
 * Global functions for the portslave.
 */
int do_socket(struct auth *ai);
void tstr(char *out, int sending, const char *input);
int dolock(const char *lock_name);
void dolock_and_wait(int sleep_time);
int islocked(const char *lock_name);
int tty_copy(int crnl, int in, int out);
void xsleep(unsigned int seconds);
void xusleep(unsigned long usec);
void *xmalloc(int size);
void *xrealloc(void *ptr, int size);
char *xstrdup(const char *str);
void block(int sig);
void unblock(int sig);
char *static_num(int i);

typedef enum
{
  eNoErr = 0,
  eInterrupt,
  eTimeOut,
  eAbort,
  eStupidAdmin
} CHAT_ERR;
CHAT_ERR chat(int fd, const char *str, struct auth *ai);
void unescape(char *);
const char *dotted(unsigned int ipno);
const char *dotted_sa(const struct sockaddr *sa, bool port);
int sa_len(const struct sockaddr *sa);
in_port_t *get_port_ptr(struct sockaddr *sa);

typedef enum
{
  eLocModem = 0,
  eLocBuf = 1,
  eLocSocket = 2,
  eLocSocSrv = 3
} LOCATION;
int serial_open(LOCATION location);
void serial_close();
int lockfile(char **lock_name, const char *lockdir, const char *tty
	, LOCATION location);
int getty(struct auth *ai, LOCATION location);
int emumodem(struct auth *ai, LOCATION location);
void maketermsane(void);
int do_login(struct auth *ai);
int spawnit(struct auth *ai);
void expand_format(char *buffer, size_t size, const char *format, const struct auth *ai);
int do_slip(struct auth *ai);
int update_utmp(const char *login_fmt, const char *from_fmt, const struct auth *ai, bool wtmp);

/* GetPortNo should be used by the rest of the code to get the
 * "current" port number.  ONLY main.c should call SetPortNo().
 */
int GetPortNo();
void SetPortNo(int num);

int GetChatTimeout();
void SetChatTimeout(int num);
int GetChatSendDelay();
void SetChatSendDelay(int num);

/* Global variables. */
extern void (*chat_debug_printf)(const char *, ...);

/* used to compact sets of strings with '#' separators and store them in
 * environment variables, and to unpack them on retrieval.
 */
int setenv_from_rad(const char *name, const char **val, unsigned int num);
int getenv_from_rad(const char *name, char **val, unsigned int max, unsigned int *num);

#ifdef PORTSLAVE_CALLBACK
#ifndef CB_CONF_USER
#define CB_CONF_USER   2
#endif
#ifndef CB_CONF_ADMIN
#define CB_CONF_ADMIN  3
#endif
#endif

#endif	/* __server_h */
