#! /bin/sh

# make-postfix-cert.sh
# by Craig Sanders <cas@taz.net.au>    2000-09-02
# this script is hereby placed in the public domain.

# this script assumes that you already have a CA set up, as the openssl
# default "demoCA" under the current directory.  if you haven't done it
# already, run "/usr/lib/ssl/misc/CA.pl -newca" (or where the path to
# openssl's CA.pl script is on your system).
#
# then run this script like so: 
#
#    ./make-postfix-cert.sh hostname.your.domain.com
#
# it will create the certificate and key files for that host and put
# them into a subdirectory.

site="$1"

# edit these values to suit your site.

COUNTRY="??"                  # ISO country code
PROVINCE="YOUR STATE OR PROVINCE"
LOCALITY="YOUR CITY"
ORGANISATION="YOUR ORG NAME"
ORG_UNIT=""
COMMON_NAME=$site
EMAIL="someone@your.domain.com"

OPTIONAL_COMPANY_NAME=""

# leave challenge password blank
CHALLENGE_PASSWORD=""

# generate a certificate valid for 10 years
# (probably not a good idea if you care about authentication, but should
# be fine if you only care about encryption of the smtp session)
DAYS="-days 1825"

# alternatively, make one valid for one year
#DAYS="-days 365"

# create the certificate request
cat <<__EOF__ | openssl req -new -nodes -keyout newreq.pem -out newreq.pem $DAYS
$COUNTRY
$PROVINCE
$LOCALITY
$ORGANISATION
$ORG_UNIT
$COMMON_NAME
$EMAIL
$CHALLENGE_PASSWORD
$OPTIONAL_COMPANY_NAME
__EOF__

# sign it
openssl ca -policy policy_anything -out newcert.pem -infiles newreq.pem

# move it
mkdir -p $site
mv newreq.pem $site/key.pem
chmod 400 $site/key.pem
mv newcert.pem $site/cert.pem
cd $site

# create server.pem for smtpd
cat cert.pem ../demoCA/cacert.pem key.pem >server.pem
chmod 400 server.pem

# create fingerprint file
openssl x509 -fingerprint -in cert.pem -noout > fingerprint

# create pkcs12 certificate for netscape (probably not needed)
#openssl pkcs12 -export -in cert.pem -inkey key.pem \
#  -certfile ../demoCA/cacert.pem -name "$site" -out cert.p12

cd ..
