#ifndef _TLS_MAIL_PARAMS_H_INCLUDED_
#define _TLS_MAIL_PARAMS_H_INCLUDED_

/*++
/* NAME
/*	tls_mail_params 3h
/* SUMMARY
/*	globally configurable parameters
/* SYNOPSIS
/*	#include <tls_mail_params.h>
/* DESCRIPTION
/* .nf
 */

#include "mail_params.h"

#define VAR_TLS_RAND_EXCH_NAME	"tls_random_exchange_name"
#define DEF_TLS_RAND_EXCH_NAME	"${config_directory}/prng_exch"
extern char *var_tls_rand_exch_name;

#define VAR_TLS_RAND_SOURCE	"tls_random_source"
#define DEF_TLS_RAND_SOURCE	""
extern char *var_tls_rand_source;

#define VAR_TLS_RAND_BYTES	"tls_random_bytes"
#define DEF_TLS_RAND_BYTES	32
extern int var_tls_rand_bytes;

#define VAR_TLS_DAEMON_RAND_SOURCE	"tls_daemon_random_source"
#define DEF_TLS_DAEMON_RAND_SOURCE	""
extern char *var_tls_daemon_rand_source;

#define VAR_TLS_DAEMON_RAND_BYTES	"tls_daemon_random_bytes"
#define DEF_TLS_DAEMON_RAND_BYTES	32
extern int var_tls_daemon_rand_bytes;

#define VAR_TLS_RESEED_PERIOD	"tls_random_reseed_period"
#define DEF_TLS_RESEED_PERIOD	"3600s"
extern int var_tls_reseed_period;

#define VAR_TLS_PRNG_UPD_PERIOD	"tls_random_prng_update_period"
#define DEF_TLS_PRNG_UPD_PERIOD "60s"
extern int var_tls_prng_upd_period;

#define VAR_SMTP_STARTTLS_TMOUT	"smtp_starttls_timeout"
#define DEF_SMTP_STARTTLS_TMOUT	"300s"
extern int var_smtp_starttls_tmout;

#define VAR_SMTPD_STARTTLS_TMOUT "smtpd_starttls_timeout"
#define DEF_SMTPD_STARTTLS_TMOUT "300s"
extern int var_smtpd_starttls_tmout;

#define VAR_SMTPD_TLS_WRAPPER	"smtpd_tls_wrappermode"
#define DEF_SMTPD_TLS_WRAPPER	0
extern bool var_smtpd_tls_wrappermode;

#define VAR_SMTPD_USE_TLS	"smtpd_use_tls"
#define DEF_SMTPD_USE_TLS	0
extern bool var_smtpd_use_tls;

#define VAR_SMTPD_ENFORCE_TLS	"smtpd_enforce_tls"
#define DEF_SMTPD_ENFORCE_TLS	0
extern bool var_smtpd_enforce_tls;

#define VAR_SMTPD_TLS_AUTH_ONLY	"smtpd_tls_auth_only"
#define DEF_SMTPD_TLS_AUTH_ONLY 0
extern bool var_smtpd_tls_auth_only;

#define VAR_SMTPD_TLS_ACERT	"smtpd_tls_ask_ccert"
#define DEF_SMTPD_TLS_ACERT	0
extern bool var_smtpd_tls_ask_ccert;

#define VAR_SMTPD_TLS_RCERT	"smtpd_tls_req_ccert"
#define DEF_SMTPD_TLS_RCERT	0
extern bool var_smtpd_tls_req_ccert;

#define VAR_SMTPD_TLS_CCERT_VD	"smtpd_tls_ccert_verifydepth"
#define DEF_SMTPD_TLS_CCERT_VD	5
extern int var_smtpd_tls_ccert_vd;

#define VAR_SMTPD_TLS_CERT_FILE	"smtpd_tls_cert_file"
#define DEF_SMTPD_TLS_CERT_FILE	""
extern char *var_smtpd_tls_cert_file;

#define VAR_SMTPD_TLS_KEY_FILE	"smtpd_tls_key_file"
#define DEF_SMTPD_TLS_KEY_FILE	"$smtpd_tls_cert_file"
extern char *var_smtpd_tls_key_file;

#define VAR_SMTPD_TLS_DCERT_FILE "smtpd_tls_dcert_file"
#define DEF_SMTPD_TLS_DCERT_FILE ""
extern char *var_smtpd_tls_dcert_file;

#define VAR_SMTPD_TLS_DKEY_FILE	"smtpd_tls_dkey_file"
#define DEF_SMTPD_TLS_DKEY_FILE	"$smtpd_tls_dcert_file"
extern char *var_smtpd_tls_dkey_file;

#define VAR_SMTPD_TLS_CA_FILE	"smtpd_tls_CAfile"
#define DEF_SMTPD_TLS_CA_FILE	""
extern char *var_smtpd_tls_CAfile;

#define VAR_SMTPD_TLS_CA_PATH	"smtpd_tls_CApath"
#define DEF_SMTPD_TLS_CA_PATH	""
extern char *var_smtpd_tls_CApath;

#define VAR_SMTPD_TLS_CLIST	"smtpd_tls_cipherlist"
#define DEF_SMTPD_TLS_CLIST	""
extern char *var_smtpd_tls_cipherlist;

#define VAR_SMTPD_TLS_512_FILE	"smtpd_tls_dh512_param_file"
#define DEF_SMTPD_TLS_512_FILE	""
extern char *var_smtpd_tls_dh512_param_file;

#define VAR_SMTPD_TLS_1024_FILE	"smtpd_tls_dh1024_param_file"
#define DEF_SMTPD_TLS_1024_FILE	""
extern char *var_smtpd_tls_dh1024_param_file;

#define VAR_SMTPD_TLS_LOGLEVEL	"smtpd_tls_loglevel"
#define DEF_SMTPD_TLS_LOGLEVEL	0
extern int var_smtpd_tls_loglevel;

#define VAR_SMTPD_TLS_RECHEAD	"smtpd_tls_received_header"
#define DEF_SMTPD_TLS_RECHEAD	0
extern bool var_smtpd_tls_received_header;

#define VAR_SMTPD_TLS_SCACHE_DB	"smtpd_tls_session_cache_database"
#define DEF_SMTPD_TLS_SCACHE_DB	""
extern char *var_smtpd_tls_scache_db;

#define VAR_SMTPD_TLS_SCACHTIME	"smtpd_tls_session_cache_timeout"
#define DEF_SMTPD_TLS_SCACHTIME	"3600s"
extern int var_smtpd_tls_scache_timeout;

#define VAR_SMTP_TLS_PER_SITE	"smtp_tls_per_site"
#define DEF_SMTP_TLS_PER_SITE	""
extern char *var_smtp_tls_per_site;

#define VAR_SMTP_USE_TLS	"smtp_use_tls"
#define DEF_SMTP_USE_TLS	0
extern bool var_smtp_use_tls;

#define VAR_SMTP_ENFORCE_TLS	"smtp_enforce_tls"
#define DEF_SMTP_ENFORCE_TLS	0
extern bool var_smtp_enforce_tls;

#define VAR_SMTP_TLS_ENFORCE_PN	"smtp_tls_enforce_peername"
#define DEF_SMTP_TLS_ENFORCE_PN	1
extern bool var_smtp_tls_enforce_peername;

#define VAR_SMTP_TLS_SCERT_VD	"smtp_tls_scert_verifydepth"
#define DEF_SMTP_TLS_SCERT_VD	5
extern int var_smtp_tls_scert_vd;

#define VAR_SMTP_TLS_CERT_FILE	"smtp_tls_cert_file"
#define DEF_SMTP_TLS_CERT_FILE	""
extern char *var_smtp_tls_cert_file;

#define VAR_SMTP_TLS_KEY_FILE	"smtp_tls_key_file"
#define DEF_SMTP_TLS_KEY_FILE	"$smtp_tls_cert_file"
extern char *var_smtp_tls_key_file;

#define VAR_SMTP_TLS_DCERT_FILE "smtp_tls_dcert_file"
#define DEF_SMTP_TLS_DCERT_FILE ""
extern char *var_smtp_tls_dcert_file;

#define VAR_SMTP_TLS_DKEY_FILE	"smtp_tls_dkey_file"
#define DEF_SMTP_TLS_DKEY_FILE	"$smtp_tls_dcert_file"
extern char *var_smtp_tls_dkey_file;

#define VAR_SMTP_TLS_CA_FILE	"smtp_tls_CAfile"
#define DEF_SMTP_TLS_CA_FILE	""
extern char *var_smtp_tls_CAfile;

#define VAR_SMTP_TLS_CA_PATH	"smtp_tls_CApath"
#define DEF_SMTP_TLS_CA_PATH	""
extern char *var_smtp_tls_CApath;

#define VAR_SMTP_TLS_CLIST	"smtp_tls_cipherlist"
#define DEF_SMTP_TLS_CLIST	""
extern char *var_smtp_tls_cipherlist;

#define VAR_SMTP_TLS_LOGLEVEL	"smtp_tls_loglevel"
#define DEF_SMTP_TLS_LOGLEVEL	0
extern int var_smtp_tls_loglevel;

#define VAR_SMTP_TLS_NOTEOFFER	"smtp_tls_note_starttls_offer"
#define DEF_SMTP_TLS_NOTEOFFER	0
extern bool var_smtp_tls_note_starttls_offer;

#define VAR_SMTP_TLS_SCACHE_DB	"smtp_tls_session_cache_database"
#define DEF_SMTP_TLS_SCACHE_DB	""
extern char *var_smtp_tls_scache_db;

#define VAR_SMTP_TLS_SCACHTIME	"smtp_tls_session_cache_timeout"
#define DEF_SMTP_TLS_SCACHTIME	"3600s"
extern int var_smtp_tls_scache_timeout;

#define VAR_RELAY_CCERTS	"relay_clientcerts"
#define DEF_RELAY_CCERTS	""
extern char *var_relay_ccerts;

#define PERMIT_TLS_CLIENTCERTS	"permit_tls_clientcerts"
#define PERMIT_TLS_ALL_CLIENTCERTS	"permit_tls_all_clientcerts"
/* extern int var_relay_code; */

#endif /* _TLS_MAIL_PARAMS_H_INCLUDED_ */
