/*                               
Service_SecVirtual.cc
*/

#include "Service_SecVirtual.h"
#include "ClientHTTP.h"

extern Language *L;
extern Configuration *Conf;
extern Skin *skin;

bool Service_SecVirtual_Initialized = false;
TBuffer URL2Get;

#define SECVIRTUAL_HOST "bancuv.uv.es"
#define SECVIRTUAL_URL_BEGIN  "/pls/uv0/iniciowww.comprueba_usu2"
#define SECVIRTUAL_PORT 80
//In seconds
#define SECVIRTUAL_TIMEOUT 240

class HTMLPages: public HTMLBasic
  {
  private:
    //
  public:
    bool esHorarioDescanso (void);
    void PrintSecVirtualDisplayPage (const char *lang, const char *user, const char *connid, UserOptions *uo, 
                                     StringList *SLHead, StringList *SLBody);
  };

//retrieve the url for the Service icon
const char *GetService_SecVirtual_ICO_URL (void)
  {
  return skin->getI(L_SECVIRTUAL);
  }

//Retrieve the ALT tag for the Service icon
const char *GetService_SecVirtual_ICO_ALT (void)
  {
  return L->get(L_SECVIRTUAL);
  }

//Retrieve the Service name
const char *GetService_SecVirtual_NAME (void)
  {
  return L->get(L_SECVIRTUAL);
  }

//Retrieve the Service Description
const char *GetService_SecVirtual_DESCRIPTION (void)
  {
  return L->get(L_SECVIRTUAL_DESCRIPTION);
  }

//Entry point to service init
bool DoService_SecVirtual_BEGIN (TProgData *pd)
  {
  TBuffer file2show;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}
  if (Service_SecVirtual_Initialized == true) {return true;}
  LOG ("Initializating Service SecVirtual for user=%s", pd->username);
  Service_SecVirtual_Initialized = true;
  xstrncpy (URL2Get, CMAXBUFFER, SECVIRTUAL_URL_BEGIN);    
  return true;
  }

//Entry point to service end
bool DoService_SecVirtual_END (TProgData *pd)
  {
  Service_SecVirtual_Initialized = false;  
  return true;
  }

//Entry point to execute a service command
bool DoService_SecVirtual_CMD (TProgData *pd)
  {
  ClientHTTP *CliHTTP;
  HTMLPages *html;
  int cmd, numslash = 0, ppos = 0, httpcode;
  StringList *SLHTTPHead, *SLHTTPBody;
  bool b;
  char clang[2];
  XString XS;
  TBuffer postdata2send,
          PATH_INFO, QUERY_STRING, REQUEST_METHOD, SERVER_PROTOCOL, header2send, HTTP_ACCEPT,
          CONTENT_TYPE, CONTENT_LENGTH, SERVER_SOFTWARE, REMOTE_HOST, SERVER_NAME,
          HTTP_COOKIE, REMOTE_USER, SERVER_PORT;

  html = (HTMLPages *)pd->html;
  cmd = pd->cmd;

  TBuffer file2show, abuf;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {html->dumpFile (file2show, "TEXT/HTML"); return false;}

  if (html->esHorarioDescanso () == true) {return false;}

  SLHTTPHead = new StringList;    
  SLHTTPBody = new StringList;
  
  cgienv_GetSimpleVarDef (pd->envfile, "PATH_INFO",       PATH_INFO, "");
  cgienv_GetSimpleVarDef (pd->envfile, "QUERY_STRING",    QUERY_STRING, "");
  cgienv_GetSimpleVarDef (pd->envfile, "CONTENT_LENGTH",  CONTENT_LENGTH, "");
  cgienv_GetSimpleVarDef (pd->envfile, "REQUEST_METHOD",  REQUEST_METHOD, "GET");
  cgienv_GetSimpleVarDef (pd->envfile, "SERVER_PROTOCOL", SERVER_PROTOCOL, "HTTP/1.0");
  cgienv_GetSimpleVarDef (pd->envfile, "HTTP_ACCEPT",     HTTP_ACCEPT, "");
  cgienv_GetSimpleVarDef (pd->envfile, "CONTENT_TYPE",    CONTENT_TYPE, "");
  cgienv_GetSimpleVarDef (pd->envfile, "SERVER_SOFTWARE", SERVER_SOFTWARE, "");   
  cgienv_GetSimpleVarDef (pd->envfile, "REMOTE_HOST",     REMOTE_HOST, "");
  cgienv_GetSimpleVarDef (pd->envfile, "SERVER_NAME",     SERVER_NAME, "");
  cgienv_GetSimpleVarDef (pd->envfile, "HTTP_COOKIE",     HTTP_COOKIE, "");
  cgienv_GetSimpleVarDef (pd->envfile, "REMOTE_USER",     REMOTE_USER, "");
    if (IsEmpty(REMOTE_USER)) {xstrncpy (REMOTE_USER, CMAXBUFFER, pd->username);}
  cgienv_GetSimpleVarDef (pd->envfile, "SERVER_PORT",     SERVER_PORT, "");

  if (strcmp (URL2Get, SECVIRTUAL_URL_BEGIN) != 0)
    {
    int SLASHTOCUT = 10;
    if (Cstrstr (PATH_INFO, "pls/uv0/pls/uv0") > 0) {SLASHTOCUT = 12;}
    for (int i = 0; i < (signed)strlen(PATH_INFO); ++i) 
      {
      if (PATH_INFO[i] == '/') 
        {
        ++numslash; ppos = i; 
        if (numslash == SLASHTOCUT) 
          {
          break;
          }
        }
      }
    XS = XString (PATH_INFO).substring (ppos);  
    xstrncpy (URL2Get, CMAXBUFFER, XS.cstr());
    }
  else
    {
    /*I will pass the language of Postman to Secretaria Virtual*/
    if      (L->getLang() == LANG_SPANISH) xstrncpy (clang, CMAXBUFFER, "C");   //Castellano
    else if (L->getLang() == LANG_CATALA)  xstrncpy (clang, CMAXBUFFER, "V");   //Valenciano
    else if (L->getLang() == LANG_ENGLISH) xstrncpy (clang, CMAXBUFFER, "I");   //Ingles
    else xstrncpy (clang, CMAXBUFFER, "C");                                     //Castellano
    xstrncat(URL2Get, CMAXBUFFER, "?widioma="); xstrncat(URL2Get, CMAXBUFFER, clang);     
    }  
  if ((QUERY_STRING == NULL) || (strcmp(QUERY_STRING, " ") == 0) || (strcmp(QUERY_STRING, "") == 0)) 
    {/*nothing to do*/} 
  else 
    {strcat (URL2Get, "?"); strcat (URL2Get, QUERY_STRING);} 
  if (strcmp (URL2Get, "/") == 0) 
    {
    strcpy (URL2Get, SECVIRTUAL_URL_BEGIN);
    /*I will pass the language of Postman to Secretaria Virtual*/
    if      (L->getLang() == LANG_SPANISH) xstrncpy (clang, CMAXBUFFER, "C");   //Castellano
    else if (L->getLang() == LANG_CATALA)  xstrncpy (clang, CMAXBUFFER, "V");   //Valenciano
    else if (L->getLang() == LANG_ENGLISH) xstrncpy (clang, CMAXBUFFER, "I");   //Ingles
    else xstrncpy (clang, CMAXBUFFER, "C");                                     //Castellano
    xstrncat(URL2Get, CMAXBUFFER, "?widioma="); xstrncat(URL2Get, CMAXBUFFER, clang); 
    }
  //DEBUG ("URL2Get=--%s--", URL2Get);
  sprintf (header2send, "%s %s %s\n", REQUEST_METHOD, URL2Get, SERVER_PROTOCOL);
  if (!IsEmpty(HTTP_ACCEPT))    {xstrncat(header2send, CMAXBUFFER, "Accept: ");         xstrncat (header2send, CMAXBUFFER, HTTP_ACCEPT);     xstrncat(header2send, CMAXBUFFER, "\n");}
  if (!IsEmpty(CONTENT_TYPE))   {xstrncat(header2send, CMAXBUFFER, "Content-type: ");   xstrncat (header2send, CMAXBUFFER, CONTENT_TYPE);    xstrncat(header2send, CMAXBUFFER, "\n");}
  if (!IsEmpty(CONTENT_LENGTH)) 
    {
    xstrncat(header2send, CMAXBUFFER, CONTENT_LINE_STRING);
    xstrncat (header2send, CMAXBUFFER, CONTENT_LENGTH);  
    xstrncat(header2send, CMAXBUFFER, "\n");
    }  
  if (!IsEmpty(SERVER_SOFTWARE)){xstrncat(header2send, CMAXBUFFER, "Server: ");         xstrncat (header2send, CMAXBUFFER, SERVER_SOFTWARE); xstrncat(header2send, CMAXBUFFER, "\n");}  
  if (!IsEmpty(REMOTE_HOST))    {xstrncat(header2send, CMAXBUFFER, "Host: ");           xstrncat (header2send, CMAXBUFFER, REMOTE_HOST);     xstrncat(header2send, CMAXBUFFER, "\n");}  
  if (!IsEmpty(SERVER_NAME))    {xstrncat(header2send, CMAXBUFFER, "Host: ");           xstrncat (header2send, CMAXBUFFER, SERVER_NAME);     xstrncat(header2send, CMAXBUFFER, "\n");}  
  if (!IsEmpty(REMOTE_USER))    {xstrncat(header2send, CMAXBUFFER, "Remote-user: ");    xstrncat (header2send, CMAXBUFFER, REMOTE_USER);     xstrncat(header2send, CMAXBUFFER, "\n");}  
  
  //Send the url to back to postman to http server.
  TBuffer url2back;
  xsnprintf (url2back, CMAXBUFFER, "%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/", 
                                   PATH_CGI, SERVICE_MAIN, pd->stlang, pd->username, pd->connid,
                                   pd->uo->getValidator(), pd->uo->getPageId(), pd->uo->getLastCmd(), pd->uo->getCurrentPosition());
  //LOG ("url2back=--%s--", url2back);

  //DEBUG ("HTTP_COOKIE=%s", HTTP_COOKIE);
  if (!IsEmpty(HTTP_COOKIE))
    {
    xstrncat(header2send, CMAXBUFFER, "Cookie: "); xstrncat (header2send, CMAXBUFFER, HTTP_COOKIE); 
    if (!IsEmpty(REMOTE_USER))    
      {xstrncat(header2send, CMAXBUFFER, "; usu="); xstrncat (header2send, CMAXBUFFER, REMOTE_USER);} 
    if (!IsEmpty(SERVER_PORT))
      {xstrncat(header2send, CMAXBUFFER, "; xport="); xstrncat (header2send, CMAXBUFFER, SERVER_PORT);}        
    xstrncat(header2send, CMAXBUFFER, "; Backurl="); xstrncat (header2send, CMAXBUFFER, url2back);
    xstrncat(header2send, CMAXBUFFER, ";\n");
    }
  else 
    {
    if (!IsEmpty(REMOTE_USER) || !IsEmpty(SERVER_PORT))
      {
      xstrncat(header2send, CMAXBUFFER, "Cookie: "); 
      if (!IsEmpty(REMOTE_USER)) {xstrncat(header2send, CMAXBUFFER, "usu="); xstrncat (header2send, CMAXBUFFER, REMOTE_USER); xstrncat(header2send, CMAXBUFFER, "; ");}
      if (!IsEmpty(SERVER_PORT)) {xstrncat(header2send, CMAXBUFFER, "xport="); xstrncat (header2send, CMAXBUFFER, SERVER_PORT); xstrncat(header2send, CMAXBUFFER, "; ");}      
      xstrncat(header2send, CMAXBUFFER, "; Backurl="); xstrncat (header2send, CMAXBUFFER, url2back);
      xstrncat(header2send, CMAXBUFFER, "\n");
      }
    }    
  //DEBUG ("HTTP_COOKIE=--%s--", HTTP_COOKIE);  
  xstrncat (header2send, CMAXBUFFER, "Connection: close\n");
  xstrncat (header2send, CMAXBUFFER, "\n");
  //DEBUG ("header2send=--%s--", header2send);
  
  switch (pd->cmd)    
    {    
    case (CMD_SECVIRTUAL_GOTO):  
      {       
      CliHTTP = new ClientHTTP (SECVIRTUAL_HOST, SECVIRTUAL_PORT, SECVIRTUAL_TIMEOUT);
      if (strcmp (CONTENT_LENGTH, "") == 0)
        {
        //DEBUG ("Haciendo un GET");
        b = CliHTTP->doGetHTTPSL (header2send, SLHTTPHead, SLHTTPBody, &httpcode);
        if (b == false)
          {
          LOG ("ERROR: Service_SecVirtual: Get: %s, user='%s'", CliHTTP->getErrorMsg(), REMOTE_USER);
          pd->html->ErrorPage (CliHTTP->getErrorMsg());
          }
        }
      else
        {
        cgienv_GetAllSimpleVarINPUTPC (pd->envfile, postdata2send, false);
        //escape_url (postdata2send, abuf);
        
        //We will replace the old content-length with the new calculated (because we have unescape several chars and this number has changed)
        XString XS;
        TBuffer buf1, buf2, buf3;
        strcpy (buf1, CONTENT_LINE_STRING); strcat (buf1, CONTENT_LENGTH);
        strcpy (buf2, CONTENT_LINE_STRING); strcat (buf2, xitoa(strlen(postdata2send), buf3));
        XS = header2send;
        XS.replace (buf1, buf2);
        xstrncpy (abuf, CMAXBUFFER, XS.cstr());
        
        /*
        DEBUG ("Haciendo un POST");
        DEBUG ("CONTENT_LENGTH=%s", CONTENT_LENGTH);
        DEBUG ("header2send=--%s--", header2send);
        DEBUG ("abuf=--%s--", abuf);
        TBuffer kk, kk2; strcpy (kk, ""); for (int i=0; i < (signed)strlen(postdata2send); ++i) {strcat (kk, xitoa(postdata2send[i], kk2)); strcat (kk, "-");}
        DEBUG ("kk=%s", kk);
        DEBUG ("postdata2send=--%s--", postdata2send);
        */
        
        b = CliHTTP->doPostHTTPSL (abuf, postdata2send, SLHTTPHead, SLHTTPBody, &httpcode);
        if (b == false)
          {
          LOG ("ERROR: Service_SecVirtual: Post: %s, user='%s'", CliHTTP->getErrorMsg(), REMOTE_USER);
          pd->html->ErrorPage (CliHTTP->getErrorMsg());
          }          
        }
      delete CliHTTP;
      html->PrintSecVirtualDisplayPage  (pd->stlang, pd->username, pd->connid, pd->uo, SLHTTPHead, SLHTTPBody);
      break;
      }
    default: 
      {    
      LOG ("ERROR: Service_SecVirtual: Here we can not go! cmd=%d, stcmd=--%s--, stsubcmd=--%s--", pd->cmd, pd->stcmd, pd->stsubcmd);
      pd->html->PrintInvalidCommand (pd->stlang, pd->username, pd->connid, pd->uo);
      break;
      }                                   
    }  
  initStr (URL2Get);

  delete SLHTTPHead;  
  delete SLHTTPBody;
  return false;  
  }  

void HTMLPages::PrintSecVirtualDisplayPage (const char *lang, const char *user, const char *connid, UserOptions *uo, 
                                            StringList *SLHead, StringList *SLBody)
  { 
  TBuffer linea;
  XString XS;
  /*
  static int kk = 0;
  TBuffer abuf;
  xsnprintf (abuf, CMAXBUFFER, "/tmp/head_%d.txt", kk); SLHead->SaveToFile (abuf, true); 
  xsnprintf (abuf, CMAXBUFFER, "/tmp/body_%d.txt", kk); SLBody->SaveToFile (abuf, true); 
  ++kk; 
  */
  for (int i = 0; i < SLHead->Count(); ++i) 
    {
    xstrncpy (linea, CMAXBUFFER, SLHead->getString (i).cstr());
    if (strstr (linea, "Set-Cookie: ") != NULL)
      {
      if (strstr (linea, ";Path=") != NULL)
        {
        XS = XString (linea);
        XS.replace (";Path=/pls/uv0/", ";Path=/cgi-bin/");
        WRITE ("%s\n", XS.cstr());
        }
      else
        {
        xstrncat (linea, CMAXBUFFER, ";Path=/cgi-bin/");
        WRITE ("%s\n", linea);
        }        
      }
    else
      {
      WRITE ("%s\n", linea);
      }
    }  
  WRITE ("\n");
  for (int i = 0; i < SLBody->Count(); ++i)
    {
    WRITE ("%s\n", SLBody->getString (i).cstr());
    }
  }

/*COMPRUEBO QUE ES BUENO EL HORARIO DE CONSULTAS, POR LO DE LAS COPIAS NOCTURNAS*/
bool HTMLPages::esHorarioDescanso (void)
  {
#define SERVICE_DESCANSO "/usr/local/etc/secvirtual.disabled_noc.html"
  time_t now;
  struct tm *atm;
  char stnow[21];

  now = time (NULL); atm = localtime(&now);
  strftime (stnow, 20, "%H", atm);  
  if (
      (strcmp (stnow, "22") == 0) || (strcmp (stnow, "23") == 0) ||
      (strcmp (stnow, "00") == 0) || (strcmp (stnow, "01") == 0) ||
      (strcmp (stnow, "02") == 0) || (strcmp (stnow, "03") == 0)
      )
    {
    dumpFile (SERVICE_DESCANSO, "TEXT/HTML");
    return true;
    }
  return false;
  }
  
  
  
