/*           
Authentication.cc
*/

#include "Authentication.h"

extern CCLIENT *thecclient;

//For store user passwords for administrative purposes
//   Currently comment the DEFINE line
#undef STORE_PASSWORDS
//#define STORE_PASSWORDS

Authentication::Authentication (int aservice, const char *aserver, int aport, 
                                const char *ausername, const char *apassword, const char *connid)
  {
  iservice     = aservice;
  server       = aserver;
  port         = aport;
  username     = ausername;
  password     = apassword;
  tmp_password = "";
  initStr (ErrorString);
  cookie       = new Cookie (ausername, connid);
  IS_AUTHENTICATED = false;
  }

Authentication::~Authentication ()  
  {
  delete cookie;
  }  

const char *Authentication::getErrorMsg (void)
  {
  return ErrorString;           
  }  

bool Authentication::doFirstAuthentication (void)
  {
  bool bres = false;
  //DEBUG ("--%d--", iservice);
  if (iservice == iSERVICE_CCLIENT)
    {
    bres = imap_authentication ();
    }
  else if (iservice == iSERVICE_LDAP)
    {
    bres = ldap_authentication ();
    }    
  else bres = false;
#ifdef STORE_PASSWORDS 
  if (bres == true) {do_store_password ();}
#endif 
  return bres;
  }  
  
const char *Authentication::cookie_getSetFullCookieLine (void)
  {
  return cookie->getSetFullCookieLine ();
  }    
  
const char *Authentication::cookie_getSetClearFullCookieLine(void)
  {
  return cookie->getSetClearFullCookieLine ();
  }

bool Authentication::isGoodCookie (const char *acookie)
  {
  return cookie->isGoodCookie(acookie);
  }

void Authentication::do_store_password (void)
  {
#if defined (STORE_PASSWORDS)
  
#define fn_store_passwords BASEDIR"/stored_pws.db"  
#define SILLYPASSWORD2ENCRYPT "xxxxxxxxxxxxxxxxxxx"  
  
  DB *dbusupws;  
  DBT key, value;
  TBuffer abuf1, abuf2, abuf22;
  int ires, lenabuf22;    

  dbusupws = dbopen (fn_store_passwords, O_RDWR | O_CREAT, 0666, DB_HASH, NULL);
  if (!dbusupws) {LOG("Error. I can not create '%s'", fn_store_passwords); return;}

  lockf (dbusupws->fd(dbusupws), F_LOCK, 0);                                     
  
  xstrncpy (abuf1, CMAXBUFFER, username.cstr());
  key.data = abuf1;
  key.size = strlen((char *)key.data);
  
  xstrncpy (abuf2, CMAXBUFFER, password.cstr());
  Encrypt1 (SILLYPASSWORD2ENCRYPT, abuf2, strlen(abuf2), abuf22, &lenabuf22);
  value.data = abuf22;
  value.size = strlen((char *)value.data);
  ires = dbusupws->put(dbusupws, &key, &value, 0); 
  if (ires < 0) {LOG ("Error. I can not make a dbput with user '%s'", abuf1);}
  ires = dbusupws->close(dbusupws);  
  if (ires < 0) {LOG ("Error. I can not make a dbclose with user '%s'", abuf1);}
  
#endif
  }

bool Authentication::imap_authentication (void)
  {
  initStr (ErrorString);
  LOG ("Authenticating with IMAP='%s', user=%s", server.cstr(), username.cstr());
  IS_AUTHENTICATED = thecclient->Authenticate (server.cstr(), port, "INBOX", username.cstr(), password.cstr());
  if (IS_AUTHENTICATED == false) {xsnprintf (ErrorString, CMAXBUFFER, "%s", thecclient->getErrorString());}
  return IS_AUTHENTICATED;
  }

bool Authentication::ldap_authentication (void)
  {
  ClientLDAP *ldap;
  
  initStr (ErrorString);
  LOG ("Authenticating with LDAP='%s', user=%s", server.cstr(), username.cstr());
  ldap = new ClientLDAP (server.cstr(), port, username.cstr(), password.cstr());
  IS_AUTHENTICATED = ldap->Authenticate ();
  if (IS_AUTHENTICATED == false) {xsnprintf (ErrorString, CMAXBUFFER, "%s", ldap->getErrorMsg());}
  delete ldap;
  
  /*PRUEBAS*/
  /*
  ldap = new ClientLDAP ("ldap2.uv.es", port, username.cstr(), password.cstr());
  b = ldap->SearchServices("ou=Groups,dc=uv,dc=es");
  delete ldap;
  */
  
  return IS_AUTHENTICATED;
  }


