/*
DateTimeUtils.cc
*/

#include "DateTimeUtils.h"
#include "Language.h"
#include <math.h>

extern Language *L;

int CurrentYear (void)
  {
  time_t now; 
  struct tm *xtm;  
  now = time (NULL);
  xtm = localtime (&now);
  return xtm->tm_year + MIN_YEAR;
  }

int CurrentMonth (void)
  {
  time_t now; 
  struct tm *xtm;  
  now = time (NULL);
  xtm = localtime (&now);
  return xtm->tm_mon;            
  }

int CurrentDay (void)
  {
  time_t now; 
  struct tm *xtm;  
  now = time (NULL);
  xtm = localtime (&now);
  return xtm->tm_mday;
  }

bool DateIsToday (int day, int month, int year)
  {
  time_t now; 
  struct tm *xtm;  
  now = time (NULL);
  xtm = localtime (&now);
  //DEBUG ("day=%d,month=%d,year=%d,tm_mday=%d,tm_mon=%d,tm_year=%d", day, month, year, xtm->tm_mday, xtm->tm_mon, xtm->tm_year+MIN_YEAR);
  //DEBUG ("now=%ld", now);
  if (xtm->tm_mday != day) return false;
  if (xtm->tm_mon  != month) return false;  
  if ((xtm->tm_year + MIN_YEAR) != year) return false;
  return true;
  }
  
bool IsCorrectDay (int day, int month, int year)
  {
  if ((year < MIN_YEAR) || (year > MAX_YEAR)) return false;
  if ((month < 0) || (month > NUMBER_MONTHS)) return false;
  if ((day < 0) || (day > 31)) return false;
  int dom = DaysOfMonth (month, year);
  if (day > dom) return false;
  return true;
  }

void NextDay (int *day, int *month, int *year)
  {
  int dom;
  ++(*day);
  dom = DaysOfMonth((*month), (*year));
  if ((*day) > dom)
    {
    (*day) = 1;
    NextMonth (month, year);
    }   
  }

void PrevDay (int *day, int *month, int *year)
  {
  int dom;
  --(*day);
  if ((*day) < 1)
    {
    PrevMonth (month, year);
    dom = DaysOfMonth (*month, *year);
    (*day) = dom;
    }   
  }

void NextMonth (int *month, int *year)
  {
  ++(*month);  
  if ((*month) > 11) 
    {
    (*month) = 0;
    NextYear (year);
    }
  }
      
void PrevMonth (int *month, int *year)
  {
  --(*month);  
  if ((*month) < 0) 
    {
    (*month) = 11;
    PrevYear (year);
    }
  }

void NextYear (int *year)
  {
  ++(*year);
  if ((*year) > MAX_YEAR) (*year) = MAX_YEAR;   
  }   
  
void PrevYear (int *year)
  {
  --(*year);
  if ((*year) < MIN_YEAR) (*year) = MIN_YEAR;   
  }      

void NextWeek (int *initday, int *week, int *month, int *year)
  {
  int NWY;
  NWY = NumWeeksYear (*year);
  for (int i=0; i <7; ++i) {NextDay (initday, month, year);}
  ++(*week);
  if ((*week) > NWY) {(*week) = 1;}
  }
  
void PrevWeek (int *initday, int *week, int *month, int *year)
  {
  int NWY;
  for (int i=0; i <7; ++i) {PrevDay (initday, month, year);}
  NWY = NumWeeksYear (*year);
  --(*week);
  if ((*week) < 1) {(*week) = NWY;}
  }

int NumWeeksYear (int year)
  {
  return 53;
  }

int NumDaysYear (int year)
  {
  if (IsLeapYear (year))
    {
    return 366;
    }
  else
    {
    return 365;
    }
  }

int CurrentWeek (void)
  {
  return NumberOfWeek (GregorianToJulian (1, 1, CurrentYear()));
  }
  
int DayOfWeek (long julianDay) 
  {
  return (int)(julianDay % 7L);
  }

int NumberOfWeek (long julianDay)
  {
  long d1, d4, L;
  d4 = (julianDay + 31741 - (julianDay % 7)) % 146097 % 36524 % 1461;
  L = (long)floor (d4 / 1460);
  d1 = ((d4 - L) % 365) + L;
  return (int) floor (d1 / 7) + 1;
  }

bool IsLeapYear (int year)
  { 
  return year % 4 == 0 && (year % 100 != 0 || year % 400 == 0); 
  }

//The first month is 0 (January)
int DaysOfMonth (int amonth, int ayear)
  {
  const int daynumbers[] = { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31 }; 
  int days;
  days = daynumbers [amonth];
  //Adjust the number of days in February based on whether or not it's a leap year.
  if (IsLeapYear (ayear) && (amonth == 1))
    {
    ++days;
    }
  return days;  
  }

//1 based numbers (NOT 0 based)  
long GregorianToJulian(int day, int month, int year)
  {
  return (long)day - 32075L + 1461L *
    ((long)year + 4800L + ((long)month - 14L) / 12L) / 4L + 367L * 
    ((long)month - 2L - ((long)month - 14L) / 12L * 12L) / 12L - 3L *
    (((long)year + 4900L + ((long)month - 14L) / 12L) / 100L) / 4L;
  }

void DaysOfWeek (int initweek, int weeknumber, int month, int year, TMatWeek MatWeek)
  {  
  int yearAnterior, yearSiguiente, mesAnterior, mesSiguiente, diasmes, diasmesAnterior, t, g;  
  
  diasmes = DaysOfMonth (month, year);
  //10 11 12 13 14 15 17
  if ((initweek > 0) && (initweek + NUMBER_DAYSFORWEEK <= diasmes + 1))
    {
    for (int i=0; i < NUMBER_DAYSFORWEEK; ++i) 
      {
      MatWeek[i].year  = year;
      MatWeek[i].month = month;
      MatWeek[i].day = initweek + i;
      }  
    }
  //-3 -2 -1 0 1 2 3
  else if (initweek <= 0)
    {
    g = initweek;
    for (int i=0; i < NUMBER_DAYSFORWEEK; ++i) 
      {
      t = initweek + i;
      if (t <= 0) 
        {
        ++g;
        yearAnterior = year; 
        mesAnterior  = month - 1;  
        if (mesAnterior < 0) {mesAnterior = 11; --yearAnterior;}
        diasmesAnterior = DaysOfMonth (mesAnterior, yearAnterior);
        MatWeek[i].year  = yearAnterior;
        MatWeek[i].month = mesAnterior;            
        MatWeek[i].day = diasmesAnterior + t;
        }
      else
        {
        MatWeek[i].year  = year;
        MatWeek[i].month = month;            
        MatWeek[i].day = t;
        }  
      }  
    }                                                                    
  //26 27 28 29 30 31 32  
  else if ((initweek > 0) && (initweek + NUMBER_DAYSFORWEEK > diasmes + 1))
    {
    g = 0;
    for (int i=0; i < NUMBER_DAYSFORWEEK; ++i) 
      {
      t = initweek + i;
      if (t >= diasmes + 1) 
        {
        ++g;
        yearSiguiente = year; 
        mesSiguiente  = month + 1;  
        if (mesSiguiente > 11) {mesSiguiente = 0; ++yearSiguiente;}
        MatWeek[i].year  = yearSiguiente;
        MatWeek[i].month = mesSiguiente;            
        MatWeek[i].day = g;
        }
      else
        {
        MatWeek[i].year  = year;
        MatWeek[i].month = month;            
        MatWeek[i].day = t;
        }  
      }  
    }        
  }

void JulianToGregorian (long julianDay, int& day, int& month, int& year)
  {
  long a = julianDay + 68569L;
  long b = 4L * a / 146097L;
  a = a - (146097L * b + 3L) / 4L;
  long c = 4000L * (a + 1) / 1461001L;
  a = a - 1461L * c / 4L + 31;
  long d = 80L * a / 2447L;
  day = (int)(a - 2447L * d / 80L);
  a = d / 11L;
  month = (int)(d + 2L - 12L * a);
  year = (int)(100L * (b - 49L) + c + a);
  }

time_t makeUnixDate (int day, int month, int year)
  {
  time_t thetime;
  struct tm t;
  t.tm_sec  = 0;
  t.tm_min  = 0;
  t.tm_hour = 0;
  t.tm_mday = day;
  t.tm_mon  = month;
  t.tm_year = year - MIN_YEAR + 1;
  t.tm_wday = 0;
  t.tm_yday = 0;
  t.tm_isdst= 0;   
  thetime = mktime (&t);
  return thetime;
  }

const char *getLongMonth (int amonth)
  {
  switch (L->getLang())
    {
    case LANG_ENGLISH: 
      {
      switch (amonth)
        {
        case 0: return "January"; break;
        case 1: return "February"; break;
        case 2: return "March"; break;
        case 3: return "April"; break;
        case 4: return "May"; break;
        case 5: return "June"; break;
        case 6: return "July"; break;
        case 7: return "August"; break;
        case 8: return "September"; break;
        case 9: return "October"; break;
        case 10: return "November"; break;
        case 11: return "December"; break;
        default: {return "error_no_month"; break;}
        }
      }
    case LANG_SPANISH: 
      {
      switch (amonth)
        {
        case 0: return "Enero"; break;
        case 1: return "Febrero"; break;
        case 2: return "Marzo"; break;
        case 3: return "Abril"; break;
        case 4: return "Mayo"; break;
        case 5: return "Junio"; break;
        case 6: return "Julio"; break;
        case 7: return "Agosto"; break;
        case 8: return "Septiembre"; break;
        case 9: return "Octubre"; break;
        case 10: return "Noviembre"; break;
        case 11: return "Diciembre"; break;
        default: {return "error_no_month"; break;}
        }
      }
    case LANG_CATALA : 
      {
      switch (amonth)
        {
        case 0: return "Gener"; break;
        case 1: return "Febrer"; break;
        case 2: return "Mar&ccedil;"; break;
        case 3: return "Abril"; break;
        case 4: return "Maig"; break;
        case 5: return "Juny"; break;
        case 6: return "Juliol"; break;
        case 7: return "Agost"; break;
        case 8: return "Setembre"; break;
        case 9: return "Octubre"; break;
        case 10: return "Novembre"; break;
        case 11: return "Desembre"; break;
        default: {return "error_no_month"; break;}
        }
      }
    case LANG_EUSKERA :
      {
      switch (amonth)
        {
        case 0: return "January"; break;
        case 1: return "February"; break;
        case 2: return "March"; break;
        case 3: return "April"; break;
        case 4: return "May"; break;
        case 5: return "June"; break;
        case 6: return "July"; break;
        case 7: return "August"; break;
        case 8: return "September"; break;
        case 9: return "October"; break;
        case 10: return "November"; break;
        case 11: return "December"; break;
        default: {return "error_no_month"; break;}
        }
      }
    default: {return "error_no_language"; break;}
    }
  }  
     
const char *getShortMonth (int amonth)
  {
  switch (L->getLang())
    {
    case LANG_ENGLISH: 
      {
      switch (amonth)
        {
        case 0: return "Jan"; break;
        case 1: return "Feb"; break;
        case 2: return "Mar"; break;
        case 3: return "Apr"; break;
        case 4: return "May"; break;
        case 5: return "Jun"; break;
        case 6: return "Jul"; break;
        case 7: return "Aug"; break;
        case 8: return "Sep"; break;
        case 9: return "Oct"; break;
        case 10: return "Nov"; break;
        case 11: return "Dec"; break;
        default: {return "error_no_month"; break;}
        }
      }
    case LANG_SPANISH: 
      {
      switch (amonth)
        {
        case 0: return "Ene"; break;
        case 1: return "Feb"; break;
        case 2: return "Mar"; break;
        case 3: return "Abr"; break;
        case 4: return "May"; break;
        case 5: return "Jun"; break;
        case 6: return "Jul"; break;
        case 7: return "Ago"; break;
        case 8: return "Sep"; break;
        case 9: return "Oct"; break;
        case 10: return "Nov"; break;
        case 11: return "Dic"; break;
        default: {return "error_no_month"; break;}
        }
      }
    case LANG_CATALA : 
      {
      switch (amonth)
        {
        case 0: return "Gen"; break;
        case 1: return "Feb"; break;
        case 2: return "Mar"; break;
        case 3: return "Abr"; break;
        case 4: return "Mai"; break;
        case 5: return "Jun"; break;
        case 6: return "Jul"; break;
        case 7: return "Ago"; break;
        case 8: return "Set"; break;
        case 9: return "Oct"; break;
        case 10: return "Nov"; break;
        case 11: return "Des"; break;
        default: {return "error_no_month"; break;}
        }
      }
    case LANG_EUSKERA :
      {
      switch (amonth)
        {
        case 0: return "Jan"; break;
        case 1: return "Feb"; break;
        case 2: return "Mar"; break;
        case 3: return "Apr"; break;
        case 4: return "May"; break;
        case 5: return "Jun"; break;
        case 6: return "Jul"; break;
        case 7: return "Aug"; break;
        case 8: return "Sep"; break;
        case 9: return "Oct"; break;
        case 10: return "Nov"; break;
        case 11: return "Dec"; break;
        default: {return "error_no_month"; break;}
        }
      }
    default: {return "error_no_language"; break;}
    }
  }     

const char *getLongDay (int aday)
  {
  switch (L->getLang())
    {
    case LANG_ENGLISH: 
      {
      switch (aday)
        {
        case 0: return "Sunday"; break;
        case 1: return "Monday"; break;
        case 2: return "Tuesday"; break;
        case 3: return "Wednesday"; break;
        case 4: return "Thursday"; break;
        case 5: return "Friday"; break;
        case 6: return "Saturday"; break;
        case 7: return "Sunday"; break;
        default: {return "error_no_day"; break;}
        }
      }
    case LANG_SPANISH: 
      {
      switch (aday)
        {
        case 0: return "Domingo"; break;
        case 1: return "Lunes"; break;
        case 2: return "Martes"; break;
        case 3: return "Mi&eacute;rcoles"; break;
        case 4: return "Jueves"; break;
        case 5: return "Viernes"; break;
        case 6: return "S&aacute;bado"; break;
        case 7: return "Domingo"; break;
        default: {return "error_no_day"; break;}
        }
      }
    case LANG_CATALA : 
      {
      switch (aday)
        {
        case 0: return "diumenge"; break;
        case 1: return "dilluns"; break;
        case 2: return "dimarts"; break;
        case 3: return "dimecres"; break;
        case 4: return "dijous"; break;
        case 5: return "divendres"; break;
        case 6: return "dissabte"; break;
        case 7: return "diumenge"; break;
        default: {return "error_no_day"; break;}
        }
      }
    case LANG_EUSKERA :
      {
      switch (aday)
        {                 
        case 0: return "Sunday"; break;
        case 1: return "Monday"; break;
        case 2: return "Tuesday"; break;
        case 3: return "Wednesday"; break;
        case 4: return "Thursday"; break;
        case 5: return "Friday"; break;
        case 6: return "Saturday"; break;
        case 7: return "Sunday"; break;
        default: {return "error_no_day"; break;}
        }
      }
    default: {return "error_no_language"; break;}
    }
  }  

const char *getShortDay3 (int aday)
  {
  switch (L->getLang())
    {
    case LANG_ENGLISH: 
      {
      switch (aday)
        {
        case 0: return "Sun"; break;
        case 1: return "Mon"; break;
        case 2: return "Tue"; break;
        case 3: return "Wed"; break;
        case 4: return "Thu"; break;
        case 5: return "Fri"; break;
        case 6: return "Sat"; break;
        case 7: return "Sun"; break;
        default: {return "error_no_day"; break;}
        }
      }
    case LANG_SPANISH: 
      {
      switch (aday)
        {
        case 0: return "Dom"; break;
        case 1: return "Lun"; break;
        case 2: return "Mar"; break;
        case 3: return "Mie"; break;
        case 4: return "Jue"; break;
        case 5: return "Vie"; break;
        case 6: return "Sab"; break;
        case 7: return "Dom"; break;
        default: {return "error_no_day"; break;}
        }
      }
    case LANG_CATALA : 
      {
      switch (aday)
        {
        case 0: return "diu"; break;
        case 1: return "dil"; break;
        case 2: return "dim"; break;
        case 3: return "dim"; break;
        case 4: return "dij"; break;
        case 5: return "div"; break;
        case 6: return "dis"; break;
        case 7: return "diu"; break;
        default: {return "error_no_day"; break;}
        }
      }
    case LANG_EUSKERA :
      {
      switch (aday)
        {                 
        case 0: return "Sun"; break;
        case 1: return "Mon"; break;
        case 2: return "Tue"; break;
        case 3: return "Wed"; break;
        case 4: return "Thu"; break;
        case 5: return "Fri"; break;
        case 6: return "Sat"; break;
        case 7: return "Sun"; break;
        default: {return "error_no_day"; break;}
        }
      }
    default: {return "error_no_language"; break;}
    }
  }  
  
const char *getShortDay2 (int aday)
  {
  switch (L->getLang())
    {
    case LANG_ENGLISH: 
      {
      switch (aday)
        {
        case 0: return "Su"; break;
        case 1: return "Mo"; break;
        case 2: return "Tu"; break;
        case 3: return "We"; break;
        case 4: return "Th"; break;
        case 5: return "Fr"; break;
        case 6: return "Sa"; break;
        case 7: return "Su"; break;
        default: {return "error_no_day"; break;}
        }
      }
    case LANG_SPANISH: 
      {
      switch (aday)
        {
        case 0: return "Do"; break;
        case 1: return "Lu"; break;
        case 2: return "Ma"; break;
        case 3: return "Mi"; break;
        case 4: return "Ju"; break;
        case 5: return "Vi"; break;
        case 6: return "Sa"; break;
        case 7: return "Do"; break;
        default: {return "error_no_day"; break;}
        }
      }
    case LANG_CATALA : 
      {
      switch (aday)
        {
        case 0: return "dg"; break;
        case 1: return "dl"; break;
        case 2: return "dm"; break;
        case 3: return "dc"; break;
        case 4: return "dj"; break;
        case 5: return "dv"; break;
        case 6: return "ds"; break;
        case 7: return "dg"; break;
        default: {return "error_no_day"; break;}
        }
      }
    case LANG_EUSKERA :
      {
      switch (aday)
        {                 
        case 0: return "Su"; break;
        case 1: return "Mo"; break;
        case 2: return "Tu"; break;
        case 3: return "We"; break;
        case 4: return "Th"; break;
        case 5: return "Fr"; break;
        case 6: return "Sa"; break;
        case 7: return "Su"; break;
        default: {return "error_no_day"; break;}
        }
      }
    default: {return "error_no_language"; break;}
    }
  }    
  
  
  
  
  
