/*                               
Service_Cclient.cc
*/

#include "Service_Cclient.h"

extern Language *L;
extern ClientNNTP *CN;
extern CCLIENT *cclient;
extern TBuffer BasePath;
extern Addressbook *ab;
extern Skin *skin;

bool Service_Cclient_Initialized = false;

class HTMLPages: public HTMLBasic
  {
  private:
    void PrintStatusLine_Cclient (const char *user, UserOptions *uo, bool displayClock, const char *mailboxname);
    void BotoneraComun (int cmdactual, const char *lang, const char *user, const char *connid, UserOptions *uo);
  public:
    void ErrorPageBack (const char *stlang, const char *user, const char *connid, UserOptions *uo, const char *error, int way);
    void BotoneraDisplayMsg (const char *lang, const char *user, const char *connid, UserOptions *uo, bool isdeleted, 
                             ULongList *LL, bool showreplyall, bool isTopBar);
    void BotoneraMailboxIndex (const char *lang, const char *user, const char *connid, UserOptions *uo);
    void BotoneraAttachs (const char *lang, const char *user, const char *connid, UserOptions *uo);
    void BotoneraComposeMsg (int thecmd, const char *lang, const char *user, const char *connid, UserOptions *uo);
    void PrintIndexPage (const char *lang, const char *mailbox, const char *user, const char *connid, 
                         StringList *SLHeaders, StringList *SLmailboxes, UserOptions *uo);
    void PrintMessageHeader 
                      (const char *lang, const char *user, const char *connid, 
                       long nummsgs, const char *aflags, const char *ato, const char *afrom, const char *areplyto, const char *acc, 
                       const char *asubject, const char *adate, const char *asize,
                       StringList *SLAttach, UserOptions *uo, ULongList *LL);
    void PrintMessageTail 
                      (const char *lang, const char *user, const char *connid, 
                       long nummsgs, const char *aflags, const char *ato, const char *afrom, const char *areplyto, const char *acc, 
                       const char *asubject, const char *adate, const char *asize,
                       StringList *SLAttach, UserOptions *uo, ULongList *LL);                                              
    void dumpAttach (const char *chunk, xulong len, StringList *SLAttachInfo);
    void dumpRawAttachPC (const char *pcheader, xulong lenheader, const char *pcbody, xulong lenbody);
    void dumpRawAttachSL (StringList *SLAttachHeader, const char *pcbody, xulong lenbody);
    void dumpAttachWithoutHead (const char *chunk, xulong len);
    void PrintMailboxesPage (const char *lang, const char *mailbox, const char *user, const char *connid, 
                             StringList *SLMailboxes, UserOptions *uo);    
    void PrintComposeMsgPage (int thecmd, int subcmd, const char *lang, const char *user, const char *connid, 
                              const char *to, const char *cc, const char *bcc, const char *subject, 
                              const char *replyto, const char *from, const char *date,
                              const char *firsttext,
                              UserOptions *uo);
    void PrintShowSignature (const char *stlang, const char *user, const char *connid, long actualpos, 
                             const char *signature, UserOptions *uo);
    void PrintShowAttachs (const char *stlang, const char *user, const char *connid, UserOptions *uo);
    void PrintAddBook_Show (int thecmd, const char *stlang, const char *user, const char *connid, UserOptions *uo, Addressbook *ab, int sortby);
    void PrintAddBook_Dump (int thecmd, const char *stlang, const char *user, const char *connid, UserOptions *uo, Addressbook *ab, int sortby);    
    void PrintAddBook_EditEntry (int thecmd, const char *stlang, const char *user, const char *connid, UserOptions *uo, Addressbook *ab, int numentry);
    void PrintFullHeaders (StringList *SLHeaders, UserOptions *uo, const char *asize);
    void PrintSubscribedGroupsPage (const char *lang, const char *mailbox, const char *user, const char *connid, 
                                    StringList *SLMailboxes, UserOptions *uo);
    };

//retrieve the url for the Service icon
const char *GetService_Cclient_ICO_URL (void)
  {
  return skin->getI(L_MAIL);
  }

//Retrieve the ALT tag for the Service icon
const char *GetService_Cclient_ICO_ALT (void)
  {
  return L->get(L_MAIL);
  }

//Retrieve the Service name
const char *GetService_Cclient_NAME (void)
  {
  return L->get(L_MAIL);
  }

//Retrieve the Service Description
const char *GetService_Cclient_DESCRIPTION (void)
  {
  return L->get(L_MAIL_DESCRIPTION);
  }

//Entry point to service init
bool DoService_Cclient_BEGIN (TProgData *pd)
  {
  TBuffer file2show;

  if (Service_Cclient_Initialized == true) {return true;}

  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        
  LOG ("Initializating Service Cclient for user=%s", pd->username);
  
  //Debo validar cuando no he validado antes
  if ((Service_Cclient_Initialized == false) && (pd->uo->getiAuthService() != iSERVICE_CCLIENT))
     {
     cclient->Authenticate (pd->uo->getImapServer(), pd->uo->getImapPort(), "INBOX", pd->username, pd->password);
     }

  Service_Cclient_Initialized = true;    
  return true;
  }

//Entry point to service end
bool DoService_Cclient_END (TProgData *pd)
  {
  Service_Cclient_Initialized = false;
  return true;
  }

//Entry point to execute a service command
bool DoService_Cclient_CMD (TProgData *pd)
  {
  xulong nummsg, cont, len;
  TBuffer attid, contenttype, tmp, abuf;
  char *pc = NULL;
  SendMSG *sendmsg;
  StringList *SLHeaders, *SLAttach, *SLAttachInfo, *SLMailboxes;
  static bool WasCreatedSentMailFolder = false;      
  int cmd;
  HTMLPages *html;
  bool usenntp = false;
  
  html = (HTMLPages *)pd->html;

  TBuffer file2show;
  if (CheckServiceDisabled (TranslateServiceR(pd->service), file2show) == true) 
    {pd->html->dumpFile (file2show, "TEXT/HTML"); return false;}        

  cmd = pd->cmd;
  if (cclient->Ping () == false) 
    {
    LOG("Reconect for IP=%s, user=%s", pd->ipclient, pd->username); 
    cclient->Reconnect();
    }

  SLHeaders = new StringList (); 
  SLMailboxes = new StringList ();
  SLAttach = new StringList ();
  SLAttachInfo = new StringList ();

  //Received ChangeMailbox with especial action: choose netNews Groups
  if ((cmd == CMD_CCLIENT_MB_CHANGE) && 
      (strcmp (Text2HTML(cgienv_GetSimpleVarDef (pd->envfile, "mailboxname", abuf, ""), tmp), L->get(L_ADD_MORE_FORUMS)) == 0)) 
    {
    xsnprintf (tmp, CMAXBUFFER, "%s/%s/config_nntp/noop/%s/%s/%s/%d/%d/%d/#%s/", PATH_CGI, SERVICE_CONFIG, pd->stlang, pd->username, pd->connid, 
               pd->uo->getValidator(), pd->uo->getPageId(), CMD_CCLIENT_MB_INDEX, abuf);                                             
    pd->html->Redirect(tmp);
    return false;
    }

  usenntp = isAllowedService (pd->uo->SLAllowedServices, pd->uo->getDeniedServices(), -1, "nntp");

  switch (cmd)
    {
    case (CMD_CCLIENT_MG_DUMPFULLMSG):
      {
      pd->uo->InitStatusLine ();
      nummsg = xatoldef (pd->parm1, (long int)1);
      html->dumpPChar (cclient->dumpFullMsg (nummsg));
      break;
      }
    case (CMD_CCLIENT_MG_DUMPFULLHEADER):
      {
      TBuffer atmpbuf;
      pd->uo->InitStatusLine ();
      nummsg = xatoldef (pd->parm1, (long int)1);
      xstrncpy (tmp, CMAXBUFFER, cclient->getFormattedSize(nummsg, atmpbuf));
      cclient->dumpFullHeader (nummsg, SLHeaders);
      html->PrintFullHeaders(SLHeaders, pd->uo, tmp);
      break;
      }                
    case CMD_CCLIENT_MG_DISPLAY:
    case CMD_CCLIENT_MG_DELDISPLAY:
    case CMD_CCLIENT_MG_UNDELDISPLAY:
    case CMD_CCLIENT_MG_FG_DELETE:
    case CMD_CCLIENT_MG_FG_UNDELETE:
    case CMD_CCLIENT_MG_FG_ANSWERED:
    case CMD_CCLIENT_MG_FG_UNANSWERED:
    case CMD_CCLIENT_MG_FG_FLAGGED:
    case CMD_CCLIENT_MG_FG_UNFLAGGED:
    case CMD_CCLIENT_MG_FG_SEEN:
    case CMD_CCLIENT_MG_FG_UNSEEN:
    case CMD_CCLIENT_MG_FG_SEARCHED:
    case CMD_CCLIENT_MG_FG_UNSEARCHED:            
      {
      TBuffer aflags, maincontenttype, ato, afrom, areplyto, acc, asubject, adate, asize, atmpbuf;
      long todel, size, ppos;        

      pd->uo->InitStatusLine ();
      nummsg = xatoldef (pd->parm1, (xulong)1);
      if (nummsg > (xulong)cclient->getTotalMsgs ()) nummsg = cclient->getTotalMsgs ();        
      if ((cmd == CMD_CCLIENT_MG_DELDISPLAY) || (cmd == CMD_CCLIENT_MG_UNDELDISPLAY))
        {
        todel = xatoidef (pd->parm1, -100);
        bool boo = cclient->isLastMsgFromList (todel);
        if (todel != -100)
          {
          ppos = cclient->getPosListFromNumMsg(todel);
          if ((boo == true) && ((unsigned long)pd->uo->getCurrentPosition() == nummsg))
            {
            xsnprintf (abuf, CMAXBUFFER, "%ld", todel);
            }
          else
            {
            todel = cclient->getNumMsgFromPosList(cclient->getPosListFromNumMsg(todel));
            xsnprintf (abuf, CMAXBUFFER, "%ld", todel);
            }
          if (cmd == CMD_CCLIENT_MG_DELDISPLAY)
            {
            cont = cclient->setFlags ("\\DELETED", abuf);
            xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED), cont, L->get(L_DELETED));
            xstrncat (abuf, CMAXBUFFER, " "); 
            if (boo == false) xstrncat (abuf, CMAXBUFFER, L->get(L_NEXTMSGSHOWN));              
            else xstrncat (abuf, CMAXBUFFER, L->get(L_LASTMSGSHOWN));                                 
            }
          else
            {
            cont = cclient->clearFlags ("\\DELETED", abuf);
            xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED), cont, L->get(L_UNDELETED));              
            xstrncat (abuf, CMAXBUFFER, " "); 
            if (boo == false) xstrncat (abuf, CMAXBUFFER, L->get(L_NEXTMSGSHOWN));              
            else xstrncat (abuf, CMAXBUFFER, L->get(L_LASTMSGSHOWN));                                               
            }
          pd->uo->setStatusLine (abuf, RED);
          }
        }
      else if ((cmd == CMD_CCLIENT_MG_FG_DELETE)   || (cmd == CMD_CCLIENT_MG_FG_UNDELETE)   || 
               (cmd == CMD_CCLIENT_MG_FG_ANSWERED) || (cmd == CMD_CCLIENT_MG_FG_UNANSWERED) || 
               (cmd == CMD_CCLIENT_MG_FG_FLAGGED)  || (cmd == CMD_CCLIENT_MG_FG_UNFLAGGED)  || 
               (cmd == CMD_CCLIENT_MG_FG_SEEN)     || (cmd == CMD_CCLIENT_MG_FG_UNSEEN)     ||
               (cmd == CMD_CCLIENT_MG_FG_SEARCHED)  || (cmd == CMD_CCLIENT_MG_FG_UNSEARCHED)) 
        {
        ppos = cclient->getPosListFromNumMsg(nummsg);
        xsnprintf (abuf, CMAXBUFFER, "%ld", nummsg);
        switch (cmd)
          {
          case CMD_CCLIENT_MG_FG_DELETE:  {
                                  cont = cclient->setFlags ("\\DELETED", abuf); 
                                  if (cont <= 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED), cont, L->get(L_DELETED));}
                                  else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED_S), cont, L->get(L_DELETED));}
                                  break;
                                  }
          case CMD_CCLIENT_MG_FG_UNDELETE:{
                                  cont = cclient->clearFlags ("\\DELETED", abuf); 
                                  if (cont <= 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED), cont, L->get(L_UNDELETED));}
                                  else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED_S), cont, L->get(L_UNDELETED));}
                                  break;
                                  }
          case CMD_CCLIENT_MG_FG_ANSWERED:{
                                  cont = cclient->setFlags ("\\ANSWERED", abuf); 
                                  if (cont <= 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED), cont, L->get(L_ANSWEREDMSG));}
                                  else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED_S), cont, L->get(L_ANSWEREDMSG));}
                                  break;
                                  }
          case CMD_CCLIENT_MG_FG_UNANSWERED:{
                                  cont = cclient->clearFlags ("\\ANSWERED", abuf); 
                                  if (cont <= 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED), cont, L->get(L_UNANSWEREDMSG));}
                                  else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED_S), cont, L->get(L_UNANSWEREDMSG));}
                                  break;
                                  }
          case CMD_CCLIENT_MG_FG_FLAGGED: {
                                  cont = cclient->setFlags ("\\FLAGGED", abuf); 
                                  if (cont <= 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED), cont, L->get(L_FLAGGEDMSG));}
                                  else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED_S), cont, L->get(L_FLAGGEDMSG));}
                                  break;
                                  }
          case CMD_CCLIENT_MG_FG_UNFLAGGED:{
                                  cont = cclient->clearFlags ("\\FLAGGED", abuf); 
                                  if (cont <= 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED), cont, L->get(L_UNFLAGGEDMSG));}
                                  else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED_S), cont, L->get(L_UNFLAGGEDMSG));}
                                  break;
                                  }
          case CMD_CCLIENT_MG_FG_SEARCHED:{ 
                                  cclient->addMsgInSearchList (nummsg);
                                  xsnprintf (abuf, CMAXBUFFER, "%s", L->get(L_SEARCHEDMSG));
                                  break;
                                  }
          case CMD_CCLIENT_MG_FG_UNSEARCHED:{
                                  cclient->delMsgInSearchList (nummsg);            
                                  xsnprintf (abuf, CMAXBUFFER, "%s", L->get(L_UNSEARCHEDMSG));
                                  break;
                                  }                                    
          }
        pd->uo->setStatusLine (abuf, RED);  
        }   
               
      pd->uo->setCurrentPosition (nummsg, cclient->getTotalMsgs ());        
      xstrncpy (aflags, CMAXBUFFER, cclient->getFlags(nummsg, atmpbuf));
      if (cclient->getServerProtocol() == PROTOCOL_IMAP)
        {xstrncpy (ato, CMAXBUFFER, cclient->getTo (nummsg));}
      else
        {xstrncpy (ato, CMAXBUFFER, cclient->getNewsGroup (nummsg));}
      xstrncpy (afrom,    CMAXBUFFER, cclient->getFrom (nummsg));
      xstrncpy (areplyto, CMAXBUFFER, cclient->getReplyTo (nummsg));
      xstrncpy (acc,      CMAXBUFFER, cclient->getCC (nummsg));        
      xstrncpy (asubject, CMAXBUFFER, cclient->getSubject (nummsg));
      xstrncpy (adate,    CMAXBUFFER, cclient->getDate (nummsg));
      xstrncpy (asize,    CMAXBUFFER, cclient->getFormattedSize(nummsg, atmpbuf));
      cclient->getBodyStructure (nummsg, SLAttach);
      ULongList *IL = new ULongList ();
      cclient->getMsgIndex (IL);        
      html->PrintMessageHeader (pd->stlang, pd->username, pd->connid, 
                          cclient->getTotalMsgs (), aflags, ato, afrom, areplyto, acc, asubject, adate, asize,
                          SLAttach, pd->uo, IL);        
      xstrncpy (maincontenttype, CMAXBUFFER, cclient->getContentType(nummsg));
      for (int Y=0; Y<SLAttach->Count(); ++Y)
        {
        sscanf (SLAttach->getString(Y).cstr(), "%s %s %ld %s", attid, contenttype, &size, tmp);
        if ((size <= MAXTEXTSIZEATTACHFORDISPLAY) || (Y == 0))
          {
          if (strcmp (contenttype, "TEXT/PLAIN") == 0) 
            {
            if (DISPLAYTXTATTASHTML == 0)
              {               
              if (Y > 0) html->WRITE (L->get(L_NUMATTACHSHOW), attid); html->BR();
              pc = cclient->getAttBody (nummsg, attid, SLAttachInfo, &len, true);
              html->BeginPre();
              if (IsNull(pc) == true) {html->WRITE (L->get(MSG_MALFORMED_MESSAGE));}
              else 
                {
                /*
                sprintf (atmpbuf, "<A HREF=\"%s/%s/bd_uudecode/noop/%s/%s/%s/%d/%d/%d/%ld/%s/1/\">%s</A>", 
                         PATH_CGI, SERVICE_CCLIENT, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), 
                         CMD_CCLIENT_MG_DISPLAY, pd->uo->getCurrentPosition(), attid, 
                         L->get(L_DISPLAY_UUENCODED));
                */         
                sprintf (atmpbuf, "<A HREF=\"%s/%s/bd_uudecode/noop/%s/%s/%s/%d/%d/%d/%ld/%s/", 
                         PATH_CGI, SERVICE_CCLIENT, pd->stlang, pd->username, pd->connid, pd->uo->getValidator(), pd->uo->getPageId(), 
                         CMD_CCLIENT_MG_DISPLAY, pd->uo->getCurrentPosition(), attid); 
                ResaltaURLsEnText (pc, pd->xs, pd->uo->getTruncateLengthReadingMsg(), IsUuencodedPChar (pc), atmpbuf);
                }
              html->EndPre();
              if ((Y != 0) || ((Y == 0) && (SLAttach->Count() > 1))) html->Linea();
              }
            else
              {
              if (Y > 0) html->WRITE (L->get(L_NUMATTACHSHOW), attid); html->BR();
              pc = cclient->getAttBody (nummsg, attid, SLAttachInfo, &len, true);
              if (IsNull(pc) == true) {html->WRITE (L->get(MSG_MALFORMED_MESSAGE));}
              else {html->dumpAttachWithoutHead (pc, len);}
              if ((Y != 0) || ((Y == 0) && (SLAttach->Count() > 1))) html->Linea();
              }
            } 
          else if (strcmp (contenttype, "TEXT/HTML") == 0)
            {
            if (Y > 0) html->WRITE (L->get(L_NUMATTACHSHOW), attid); html->BR();
            pc = cclient->getAttBody (nummsg, attid, SLAttachInfo, &len, true);
            if (IsNull(pc) == true) {html->WRITE (L->get(MSG_MALFORMED_MESSAGE));}
            else 
              {
              if (DISABLE_ATT_HTML_TOKENS == 1) {DisableHTMLTokens (pc);}
              html->dumpAttachWithoutHead (pc, len);
              }
            if ((Y != 0) || ((Y == 0) && (SLAttach->Count() > 1))) html->Linea();
            }
         //SACO LOS AJUNTOS DE TEXTO QUE NO ENTIENDO POR PANTALLA   
          else if (strstr (contenttype, "TEXT/") != NULL)
            {
            if (Y > 0) html->WRITE (L->get(L_NUMATTACHSHOW), attid); html->BR();
            pc = cclient->getAttBody (nummsg, attid, SLAttachInfo, &len, true);
            html->BeginPre();
            if (IsNull(pc) == true) {html->WRITE (L->get(MSG_MALFORMED_MESSAGE));}
            else {html->dumpAttachWithoutHead (pc, len);}
            html->EndPre();
            if ((Y != 0) || ((Y == 0) && (SLAttach->Count() > 1))) html->Linea();              
            }
          }
        } //for
      html->PrintMessageTail (pd->stlang, pd->username, pd->connid, 
                              cclient->getTotalMsgs (), aflags, ato, afrom, areplyto, acc, asubject, adate, asize,
                              SLAttach, pd->uo, IL);        
      html->HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));  
      delete IL;
      break;
      }
    case (CMD_CCLIENT_MB_EXPUNGE):
      {
      cont = cclient->getMsgsMarkedDeleted();
      if (cont <= 0) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_MSGSPURGED_0));}
      else if (cont == 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_MSGSPURGED), cont);}
      else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_MSGSPURGED_S), cont);}
      pd->uo->setStatusLine (abuf, RED);
      pd->uo->IncValidator();
      cclient->Expunge ();
      pd->uo->setCurrentPosition (0, cclient->getTotalMsgs ());
      cclient->getHeaderList (pd->uo->getBeginPage(), SLHeaders, pd->username, pd->uo->getMailDomain(), L->get (L_TO), pd->uo->getTrueEmail()); 
      cclient->getMailboxes (SLMailboxes, pd->uo->SLSubscribedGroups, false, usenntp);        
      pd->uo->setMailboxSize (cclient->getMailboxSize());        
      html->PrintIndexPage (pd->stlang, cclient->getMailboxName(), pd->username, pd->connid, SLHeaders, SLMailboxes, pd->uo);
      break;
      }
    case (CMD_CCLIENT_MB_INDEX): 
      {
      pd->uo->InitStatusLine ();
      nummsg = xatoldef (pd->parm1, (long int)1);
      pd->uo->setCurrentPosition (nummsg, cclient->getTotalMsgs ());
      cclient->getHeaderList (pd->uo->getBeginPage(), SLHeaders, pd->username, pd->uo->getMailDomain(), L->get (L_TO), pd->uo->getTrueEmail());
      cclient->getMailboxes (SLMailboxes, pd->uo->SLSubscribedGroups, WasCreatedSentMailFolder, usenntp);        
      WasCreatedSentMailFolder = false;
      pd->uo->setMailboxSize (cclient->getMailboxSize());        
      html->PrintIndexPage (pd->stlang, cclient->getMailboxName(), pd->username, pd->connid, SLHeaders, SLMailboxes, pd->uo);               
      break;
      }
    case (CMD_CCLIENT_MB_SEARCH):
      {
      int firstnummsgfound, fdsearch;                
      cgienv_GetSimpleVar (pd->envfile, "fieldtosearch", pd->parm1, true);
      cgienv_GetSimpleVar (pd->envfile, "whatsearch", pd->allparms2, true);      
      if      (strcasecmp (pd->parm1, "fd_subject") == 0) {fdsearch = 1;}
      else if (strcasecmp (pd->parm1, "fd_from")    == 0) {fdsearch = 2;}
      else if (strcasecmp (pd->parm1, "fd_body")    == 0) {fdsearch = 3;}
      else                                            {fdsearch = 0;}
      cont = cclient->searchFolder2 ("ALL", fdsearch, pd->allparms2, NULL, NULL);
      firstnummsgfound = (int)cclient->getNumFirstMsgInSearch();
      if (cont <= 0) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_MSGSFOUND_0));}
      else if (cont == 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_MSGSFOUND), cont);}
      else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_MSGSFOUND_S), cont);}
      pd->uo->setStatusLine (abuf, BLUE);        
      if (firstnummsgfound > 0) {nummsg = firstnummsgfound;}
      else {nummsg = pd->uo->getCurrentPosition ();}        
      pd->uo->setCurrentPosition (nummsg, cclient->getTotalMsgs ());
      cclient->getHeaderList (pd->uo->getBeginPage(), SLHeaders, pd->username, pd->uo->getMailDomain(), L->get (L_TO), pd->uo->getTrueEmail());
      cclient->getMailboxes (SLMailboxes, pd->uo->SLSubscribedGroups, false, usenntp);
      pd->uo->setMailboxSize (cclient->getMailboxSize());        
      html->PrintIndexPage (pd->stlang, cclient->getMailboxName(), pd->username, pd->connid, SLHeaders, SLMailboxes, pd->uo);
      break;
      }                
    case (CMD_CCLIENT_MB_SORT):
      {
      int sorttype = NO_SORT;
      
      xsnprintf (abuf, CMAXBUFFER, "%s", L->get(MSG_MSGS_SORTED));
      pd->uo->setStatusLine (abuf, RED);
      if      (strcasecmp (pd->stsubcmd, "number")  == 0) {sorttype = NO_SORT;}
      else if (strcasecmp (pd->stsubcmd, "date")    == 0) {if (USE_ARRIVAL_DATE == 1) sorttype = SORTARRIVAL; else sorttype = SORTDATE;}
      else if (strcasecmp (pd->stsubcmd, "from")    == 0) {sorttype = SORTFROM;}
      else if (strcasecmp (pd->stsubcmd, "subject") == 0) {sorttype = SORTSUBJECT;}
      else if (strcasecmp (pd->stsubcmd, "size")    == 0) {sorttype = SORTSIZE;}
      else if (strcasecmp (pd->stsubcmd, "thread")  == 0) {sorttype = SORTTHREAD;}        
      else                                         {sorttype = NO_SORT;}
      cclient->setSortType (sorttype);
      cclient->Sort ();
      pd->uo->setCurrentPosition (1, cclient->getTotalMsgs ());
      cclient->getHeaderList (pd->uo->getBeginPage(), SLHeaders, pd->username, pd->uo->getMailDomain(), L->get (L_TO), pd->uo->getTrueEmail()); 
      cclient->getMailboxes (SLMailboxes, pd->uo->SLSubscribedGroups, false, usenntp);
      pd->uo->setMailboxSize (cclient->getMailboxSize());        
      html->PrintIndexPage (pd->stlang, cclient->getMailboxName(), pd->username, pd->connid, SLHeaders, SLMailboxes, pd->uo);
      break;
      }
    case (CMD_CCLIENT_MB_SHOW):
      {
      pd->uo->InitStatusLine ();
      cclient->getMailboxes (SLMailboxes, pd->uo->SLSubscribedGroups, false, usenntp);
      html->PrintMailboxesPage (pd->stlang, cclient->getMailboxName(), pd->username, pd->connid, SLMailboxes, pd->uo);
      break;
      }
    case (CMD_CCLIENT_MB_CHANGE):
      {
      //If the cgi var "mailboxname" exists, I will use it.
      if (cgienv_ExistsVar (pd->envfile, "mailboxname") == true)
        {
        cgienv_GetSimpleVar (pd->envfile, "mailboxname", pd->parm1, true);
        }
      if (strcmp (pd->parm1, "") == 0) {xstrncpy (pd->parm1, CMAXBUFFER, "INBOX");}
      //If the mailbox begin with ':' I transform it to '#'. That is because char '#' is not passed Ok in urls
      if (pd->parm1[0] == ':') {pd->parm1[0] = '#';} 
      pd->uo->InitStatusLine ();
      bool boo = cclient->ChangeMailbox (pd->parm1, usenntp);
      if (boo == true)
        {
        pd->uo->IncValidator();
        TBuffer abuf;
        xsnprintf (abuf, CMAXBUFFER, L->get(MSG_MAILBOXCHANGED), cclient->getMailboxName());
        pd->uo->setStatusLine (abuf, GREEN);
        if (cclient->getError() == true) 
          {
          xsnprintf (abuf, CMAXBUFFER, cclient->getErrorString());
          html->ErrorPage(abuf);
          }
        else
          {  
          if (strcmp(cclient->getWarningString(), "") != 0) pd->uo->setStatusLine (cclient->getWarningString(), RED);
          pd->uo->setCurrentPosition (0, cclient->getTotalMsgs ());
          cclient->getHeaderList (pd->uo->getBeginPage(), SLHeaders, pd->username, pd->uo->getMailDomain(), L->get (L_TO), pd->uo->getTrueEmail()); 
          cclient->getMailboxes (SLMailboxes, pd->uo->SLSubscribedGroups, true, usenntp);
          pd->uo->setMailboxSize (cclient->getMailboxSize());
          html->PrintIndexPage (pd->stlang, cclient->getMailboxName(), pd->username, pd->connid, SLHeaders, SLMailboxes, pd->uo);
          }
        }
      else 
        {
        TBuffer abuf, abuf2;
        if (cclient->getError() == true) 
          xsnprintf (abuf, CMAXBUFFER, cclient->getErrorString());
        else
          xsnprintf (abuf, CMAXBUFFER, L->get(ERR_INV_MAILBOX), cclient->getFullMailbox(pd->parm1, abuf2));
        html->ErrorPage(abuf);
        }
      break;
      }                        
    case (CMD_CCLIENT_MB_CREATE):
      {
      TBuffer atmpbuf;
      cgienv_GetSimpleVar (pd->envfile, "mailboxname", pd->parm1, true);
      xstrncpy (tmp, CMAXBUFFER, cclient->expandMailboxName (pd->parm1, atmpbuf));
      pd->uo->InitStatusLine ();
      bool boo = cclient->createMailbox (tmp);
      if (boo == true)
        {
        pd->uo->setStatusLine (L->get(MSG_MAILBOXCREATED), RED);          
        cclient->getMailboxes (SLMailboxes, pd->uo->SLSubscribedGroups, true, usenntp);
        html->PrintMailboxesPage (pd->stlang, cclient->getMailboxName(), pd->username, pd->connid, SLMailboxes, pd->uo);
        }
      else 
        {
        xsnprintf (abuf, CMAXBUFFER, L->get(ERR_INV_MAILBOX), tmp);
        html->ErrorPage(abuf);
        }
      break; 
      }                       
    case (CMD_CCLIENT_MB_DELETE):
      {
      cgienv_GetSimpleVar (pd->envfile, "mailboxname", pd->parm1, true);
      pd->uo->InitStatusLine ();
      if (strcmp (cclient->getMailboxName(), pd->parm1) == 0)
        {
        xsnprintf (abuf, CMAXBUFFER, L->get(ERR_ISOPEN_MAILBOX), pd->parm1);
        html->ErrorPage(abuf);
        }
      else
        {  
        bool boo = cclient->deleteMailbox (pd->parm1);
        if (boo == true)
          {
          pd->uo->setStatusLine (L->get(MSG_MAILBOXDELETED), RED);          
          cclient->getMailboxes (SLMailboxes, pd->uo->SLSubscribedGroups, true, usenntp);
          html->PrintMailboxesPage (pd->stlang, cclient->getMailboxName(), pd->username, pd->connid, SLMailboxes, pd->uo);
          }
        else 
          {
          xsnprintf (abuf, CMAXBUFFER, L->get(ERR_INV_MAILBOX), pd->parm1);
          html->ErrorPage(abuf);
          }
        }  
      break; 
      }                       
    case (CMD_CCLIENT_MB_CLEAR):
      {
      cgienv_GetSimpleVar (pd->envfile, "mailboxname", pd->parm1, true);
      pd->uo->InitStatusLine ();
      if (strcmp (cclient->getMailboxName(), pd->parm1) == 0)
        {
        xsnprintf (abuf, CMAXBUFFER, L->get(ERR_ISOPEN_MAILBOX), pd->parm1);
        html->ErrorPage(abuf);
        }
      else
        {  
        bool boo = cclient->emptyMailbox (pd->parm1);
        if (boo == true)
          {
          pd->uo->setStatusLine (L->get(MSG_MAILBOXDELETED), RED);          
          cclient->getMailboxes (SLMailboxes, pd->uo->SLSubscribedGroups, true, usenntp);
          html->PrintMailboxesPage (pd->stlang, cclient->getMailboxName(), pd->username, pd->connid, SLMailboxes, pd->uo);
          }
        else 
          {
          xsnprintf (abuf, CMAXBUFFER, L->get(ERR_INV_MAILBOX), pd->parm1);
          html->ErrorPage(abuf);
          }
        }  
      break; 
      }                             
    case (CMD_CCLIENT_MB_RENAME):
      {
      TBuffer atmpbuf;
      cgienv_GetSimpleVar (pd->envfile, "oldmailboxname", pd->parm1, true);
      cgienv_GetSimpleVar (pd->envfile, "newmailboxname", pd->parm2, true);                  
      xstrncpy (tmp, CMAXBUFFER, cclient->expandMailboxName (pd->parm2, atmpbuf));
      pd->uo->InitStatusLine ();
      bool boo = cclient->renameMailbox (pd->parm1, tmp);
      if (boo == true)
        {
        pd->uo->setStatusLine (L->get(MSG_MAILBOXRENAMED), RED);          
        cclient->getMailboxes (SLMailboxes, pd->uo->SLSubscribedGroups, true, usenntp);
        html->PrintMailboxesPage (pd->stlang, cclient->getMailboxName(), pd->username, pd->connid, SLMailboxes, pd->uo);
        }
      else 
        {
        xsnprintf (abuf, CMAXBUFFER, L->get(ERR_INV_MAILBOX), tmp);
        html->ErrorPage(abuf);
        }
      break;
      }   
    case (CMD_CCLIENT_MB_DUMP):
      {                    
      pd->uo->InitStatusLine ();
      html->Head ("text/plain", "", "");
      for (int i = 1; i <= cclient->getTotalMsgs(); ++i)
        {
        time_t now; now = time (NULL);
        html->pcWRITE ("From "APPNAME" ");
        html->pcWRITE (ctime(&now));
        html->pcWRITE (cclient->dumpFullMsg (i));
        html->pcWRITE ("\r\n");
        }
      break;
      }
    case CMD_CCLIENT_FG_DELETE:
    case CMD_CCLIENT_FG_UNDELETE:
    case CMD_CCLIENT_FG_ANSWERED:
    case CMD_CCLIENT_FG_UNANSWERED:
    case CMD_CCLIENT_FG_FLAGGED:
    case CMD_CCLIENT_FG_UNFLAGGED:
    case CMD_CCLIENT_FG_SEEN:
    case CMD_CCLIENT_FG_UNSEEN:
      {
      cgienv_GetSimpleMultipleEntries (pd->envfile, "msgnumber", ",", pd->allparms, true);
      if (strlen(pd->allparms) == 0) {pd->uo->setStatusLine (L->get(MSG_NO_ENTRIES_MARKED), RED);}
      else
        {
        switch (cmd)
          {
          case CMD_CCLIENT_FG_DELETE:     {
                                  cont = cclient->setFlags ("\\DELETED", pd->allparms); 
                                  if (cont <= 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED), cont, L->get(L_DELETED));}
                                  else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED_S), cont, L->get(L_DELETED));}
                                  break;
                                  }
          case CMD_CCLIENT_FG_UNDELETE:   {
                                  cont = cclient->clearFlags ("\\DELETED", pd->allparms); 
                                  if (cont <= 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED), cont, L->get(L_UNDELETED));}
                                  else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED_S), cont, L->get(L_UNDELETED));}
                                  break;
                                  }
          case CMD_CCLIENT_FG_ANSWERED:   {
                                  cont = cclient->setFlags ("\\ANSWERED", pd->allparms); 
                                  if (cont <= 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED), cont, L->get(L_ANSWEREDMSG));}
                                  else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED_S), cont, L->get(L_ANSWEREDMSG));}
                                  break;
                                  }
          case CMD_CCLIENT_FG_UNANSWERED: {
                                  cont = cclient->clearFlags ("\\ANSWERED", pd->allparms); 
                                  if (cont <= 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED), cont, L->get(L_UNANSWEREDMSG));}
                                  else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED_S), cont, L->get(L_UNANSWEREDMSG));}
                                  break;
                                  }
          case CMD_CCLIENT_FG_FLAGGED:    {
                                  cont = cclient->setFlags ("\\FLAGGED", pd->allparms); 
                                  if (cont <= 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED), cont, L->get(L_FLAGGEDMSG));}
                                  else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED_S), cont, L->get(L_FLAGGEDMSG));}
                                  break;
                                  }
          case CMD_CCLIENT_FG_UNFLAGGED:  {
                                  cont = cclient->clearFlags ("\\FLAGGED", pd->allparms); 
                                  if (cont <= 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED), cont, L->get(L_UNFLAGGEDMSG));}
                                  else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED_S), cont, L->get(L_UNFLAGGEDMSG));}
                                  break;
                                  }
          case CMD_CCLIENT_FG_SEEN:       {
                                  cont = cclient->setFlags ("\\SEEN", pd->allparms); 
                                  if (cont <= 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED), cont, L->get(L_SEENMSG));}
                                  else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED_S), cont, L->get(L_SEENMSG));}
                                  break;
                                  }
          case CMD_CCLIENT_FG_UNSEEN:     {
                                  cont = cclient->clearFlags ("\\SEEN", pd->allparms);
                                  if (cont <= 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED), cont, L->get(L_UNSEENMSG));}
                                  else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_FLAGS_CHANGED_S), cont, L->get(L_UNSEENMSG));}
                                  break;
                                  }
          }
        pd->uo->setStatusLine (abuf, RED);  
        }
      cclient->getHeaderList (pd->uo->getBeginPage(), SLHeaders, pd->username, pd->uo->getMailDomain(), L->get (L_TO), pd->uo->getTrueEmail()); 
      cclient->getMailboxes (SLMailboxes, pd->uo->SLSubscribedGroups, false, usenntp);
      pd->uo->setMailboxSize (cclient->getMailboxSize());        
      html->PrintIndexPage (pd->stlang, cclient->getMailboxName(), pd->username, pd->connid, SLHeaders, SLMailboxes, pd->uo);
      break;
      }
    case CMD_CCLIENT_MG_MOVE:
      {
      cgienv_GetSimpleVarDef (pd->envfile, "mailboxname", pd->parm1, "INBOX");
      cgienv_GetSimpleMultipleEntries (pd->envfile, "msgnumber", ",", pd->allparms2, true);
      if (strlen(pd->allparms2) == 0) {pd->uo->setStatusLine (L->get(MSG_NO_ENTRIES_MARKED), RED);}
      else
        {  
        cont = cclient->moveMessages (pd->parm1, pd->allparms2);
        if (cont <= 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_MOVEDMESSAGES), cont, pd->parm1);}
        else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_MOVEDMESSAGES_S), cont, pd->parm1);}
        pd->uo->setStatusLine (abuf, RED);
        }
      cclient->getHeaderList (pd->uo->getBeginPage(), SLHeaders, pd->username, pd->uo->getMailDomain(), L->get (L_TO), pd->uo->getTrueEmail()); 
      cclient->getMailboxes (SLMailboxes, pd->uo->SLSubscribedGroups, false, usenntp);
      pd->uo->setMailboxSize (cclient->getMailboxSize());        
      html->PrintIndexPage (pd->stlang, cclient->getMailboxName(), pd->username, pd->connid, SLHeaders, SLMailboxes, pd->uo);
      break; 
      } 
    case CMD_CCLIENT_MG_COPY:
      {
      cgienv_GetSimpleVarDef (pd->envfile, "mailboxname", pd->parm1, "INBOX");
      cgienv_GetSimpleMultipleEntries (pd->envfile, "msgnumber", ",", pd->allparms2, true);      
      if (strlen(pd->allparms2) == 0) {pd->uo->setStatusLine (L->get(MSG_NO_ENTRIES_MARKED), RED);}
      else
        {                
        cont = cclient->copyMessages (pd->parm1, pd->allparms2);
        if (cont <= 1) {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_COPYMESSAGES), cont, pd->parm1);}
        else {xsnprintf (abuf, CMAXBUFFER, L->get(MSG_COPYMESSAGES_S), cont, pd->parm1);}
        pd->uo->setStatusLine (abuf, RED);
        }
      cclient->getHeaderList (pd->uo->getBeginPage(), SLHeaders, pd->username, pd->uo->getMailDomain(), L->get (L_TO), pd->uo->getTrueEmail()); 
      cclient->getMailboxes (SLMailboxes, pd->uo->SLSubscribedGroups, false, usenntp);
      pd->uo->setMailboxSize (cclient->getMailboxSize());        
      html->PrintIndexPage (pd->stlang, cclient->getMailboxName(), pd->username, pd->connid, SLHeaders, SLMailboxes, pd->uo);
      break;
      }
    case (CMD_CCLIENT_CM):
      {
      int xcmd;
      if (cgienv_ExistsVar (pd->envfile, "cm_cancel") == true)
        {
        xcmd = CMD_CCLIENT_CM_CANCEL;
        }
      else if (cgienv_ExistsVar (pd->envfile, "cm_save") == true)  
        {
        TBuffer abuf;
        FILE *fw;
        MakeTmpName (pd->parm1, CMAXBUFFER);
        fw = fopen (pd->parm1, "w");        
        fprintf (fw, "%d\n", cgienv_GetEntryBool (pd->envfile, "savemsgsentmail")); 
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "to", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "cc", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "bcc", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "subject", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "from", abuf, ""));
        fprintf (fw, "%s", cgienv_GetComplexVar (pd->envfile, "texttosend"));
        fclose (fw);        
        xcmd = CMD_CCLIENT_CM_SAVE;
        }
      else if (cgienv_ExistsVar (pd->envfile, "ab_from_cm") == true)  
        {
        FILE *fw;
        MakeTmpName (pd->parm1, CMAXBUFFER);
        fw = fopen (pd->parm1, "w");
        fprintf (fw, "%d\n", cgienv_GetEntryBool (pd->envfile, "savemsgsentmail"));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "to", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "cc", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "bcc", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "subject", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "from", abuf, ""));
        fprintf (fw, "%s", cgienv_GetComplexVar (pd->envfile, "texttosend"));
        fclose (fw);        
        xcmd = CMD_CCLIENT_AB_FROM_CM;
        }  
      else if (cgienv_ExistsVar (pd->envfile, "cm_sendnntp") == true)  
        {
        int numattachs;
        cgienv_GetSimpleVar (pd->envfile, "numattachs", pd->parm2, true);
        numattachs = xatoidef (cgienv_GetSimpleVarDef (pd->envfile, "numattachs", abuf, "0"), 0);
        FILE *fw;
        MakeTmpName (pd->parm1, CMAXBUFFER);
        fw = fopen (pd->parm1, "w");
        fprintf (fw, "%d\n", cgienv_GetEntryBool (pd->envfile, "savemsgsentmail"));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "to", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "cc", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "bcc", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "subject", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "from", abuf, ""));
        fprintf (fw, "%s", cgienv_GetComplexVar (pd->envfile, "texttosend"));
        fclose (fw);
        xcmd = CMD_CCLIENT_CM_SENDNNTP;
        }
      else if (cgienv_ExistsVar (pd->envfile, "cm_send") == true)  
        {
        int numattachs;
        cgienv_GetSimpleVar (pd->envfile, "numattachs", pd->parm2, true);
        numattachs = xatoidef (cgienv_GetSimpleVarDef (pd->envfile, "numattachs", abuf, "0"), 0);
        FILE *fw;
        MakeTmpName (pd->parm1, CMAXBUFFER);
        fw = fopen (pd->parm1, "w");
        fprintf (fw, "%d\n", cgienv_GetEntryBool (pd->envfile, "savemsgsentmail"));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "to", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "cc", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "bcc", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "subject", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "from", abuf, ""));
        fprintf (fw, "%s", cgienv_GetComplexVar (pd->envfile, "texttosend"));
        fclose (fw);
        xcmd = CMD_CCLIENT_CM_SEND;
        }  
      else if (cgienv_ExistsVar (pd->envfile, "at_show") == true)  
        {
        FILE *fw;
        MakeTmpName (pd->parm1, CMAXBUFFER);
        fw = fopen (pd->parm1, "w");
        fprintf (fw, "%d\n", cgienv_GetEntryBool (pd->envfile, "savemsgsentmail"));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "to", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "cc", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "bcc", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "subject", abuf, ""));
        fprintf (fw, "%s\n", cgienv_GetSimpleVarDef (pd->envfile, "from", abuf, ""));
        fprintf (fw, "%s", cgienv_GetComplexVar (pd->envfile, "texttosend"));
        fclose (fw);        
        xcmd = CMD_CCLIENT_AT_SHOW;
        }
      else if (cgienv_ExistsVar (pd->envfile, "cm_cleanall") == true)  
        {
        xcmd = CMD_CCLIENT_CM_CLEANALL;
        }
      else if (cgienv_ExistsVar (pd->envfile, "at_save") == true)  
        {
        cgienv_GetSimpleVar (pd->envfile, "file", pd->allparms, true);
        xcmd = CMD_CCLIENT_AT_SAVE;
        }
      else if (cgienv_ExistsVar (pd->envfile, "at_erase") == true)  
        {
        cgienv_GetSimpleMultipleEntries (pd->envfile, "attnumber", ",", pd->allparms, true);
        xcmd = CMD_CCLIENT_AT_ERASE;
        }
      else
        {
        xcmd = CMD_CCLIENT_CM;
        }
      switch (xcmd)
        {
        case (CMD_CCLIENT_CM_CANCEL):
          {
          pd->uo->setStatusLine (L->get(MSG_CANCELMSG), RED);
          cclient->getHeaderList (pd->uo->getBeginPage(), SLHeaders, pd->username, pd->uo->getMailDomain(), L->get (L_TO), pd->uo->getTrueEmail());
          cclient->getMailboxes (SLMailboxes, pd->uo->SLSubscribedGroups, false, usenntp);
          pd->uo->setMailboxSize (cclient->getMailboxSize());        
          html->PrintIndexPage (pd->stlang, cclient->getMailboxName(), pd->username, pd->connid, SLHeaders, SLMailboxes, pd->uo);
          break;  
          }      
        case (CMD_CCLIENT_CM_SAVE):
          { 
          CopyFileOverWrite (pd->parm1, pd->uo->getfnSavedMsg());
          DeleteFile (pd->parm1);
          pd->uo->InitStatusLine ();
          html->PrintComposeMsgPage (CMD_CCLIENT_CM, CMD_CCLIENT_CM_SAVE, pd->stlang, pd->username, pd->connid, 
                                     NULL, NULL, NULL, NULL, 
                                     NULL, NULL, NULL,
                                     NULL,
                                     pd->uo);          
          break; 
          }
        case (CMD_CCLIENT_AB_FROM_CM):
          {
          int sortby = -1;      
          ab = new Addressbook (ReturnUserAddressbookFileName(BasePath, pd->username, pd->imapserver, tmp), pd->uo);
          pd->uo->setStatusLine (L->get(MSG_ADDBOOK), RED);
          CopyFileOverWrite (pd->parm1, pd->uo->getfnSavedMsg());
          DeleteFile (pd->parm1);  
          html->PrintAddBook_Show (cmd, pd->stlang, pd->username, pd->connid, pd->uo, ab, sortby);
          delete ab;
          break; 
          }
        case (CMD_CCLIENT_CM_CLEANALL):
          {
          if (FileExists (pd->uo->getfnSavedMsg()) == true) DeleteFile (pd->uo->getfnSavedMsg());
          pd->uo->delAllAttachs();
          pd->uo->InitStatusLine ();
          html->PrintComposeMsgPage (CMD_CCLIENT_CM, CMD_CCLIENT_CM_CLEANALL, pd->stlang, pd->username, pd->connid, 
                                     NULL, NULL, NULL, NULL, 
                                     NULL, NULL, NULL,
                                     NULL,
                                     pd->uo);          
          break;
          }          
        case (CMD_CCLIENT_AT_SHOW):
          {
          CopyFileOverWrite (pd->parm1, pd->uo->getfnSavedMsg());
          DeleteFile (pd->parm1);  
          pd->uo->setStatusLine (L->get(MSG_SHOWATTACHS), RED);
          html->PrintShowAttachs (pd->stlang, pd->username, pd->connid, pd->uo);
          break;  
          }            
        case (CMD_CCLIENT_AT_SAVE):
          {
          int attssaved;
          xsnprintf (tmp, CMAXBUFFER, "%s, \"\", \"%s\"", getMailcapTipoFromFilename(pd->allparms, MAILCAP), pd->allparms);
          attssaved = pd->uo->addFileNameAtach (pd->allparms, tmp);
          if (attssaved > 0) pd->uo->setStatusLine (L->get(MSG_SAVEATTACHS), RED);
          else pd->uo->setStatusLine (L->get(MSG_NOATTACHSSAVED), RED);
          html->PrintShowAttachs (pd->stlang, pd->username, pd->connid, pd->uo);
          break;
          }   
        case (CMD_CCLIENT_AT_ERASE):
          {
          int totdel;
          totdel = pd->uo->delFileNameAtach (pd->allparms);
          if (totdel > 0) pd->uo->setStatusLine (L->get(MSG_ERASEATTACHS), RED);
          else pd->uo->setStatusLine (L->get(MSG_NOATTACHSERASED), RED);
          html->PrintShowAttachs (pd->stlang, pd->username, pd->connid, pd->uo);
          break; 
          } 
        case (CMD_CCLIENT_CM_SEND):
          {
          TBuffer messageid, abuf;
          TNumber anum;
          int anummsg;
          CopyFileOverWrite (pd->parm1, pd->uo->getfnSavedMsg());
          int numattachs = xatoidef (pd->parm2, 0);
          if (numattachs != pd->uo->numAttachs())
            {
            html->ErrorPageBack(pd->stlang, pd->username, pd->connid, pd->uo, L->get(MSG_ERR_RELOAD_ATTACHS), 2);
            }
          else
            {
            pd->uo->InitStatusLine ();
            sendmsg = new SendMSG (pd->uo->getSMTPServer(), pd->parm1, pd->uo, pd->uo->getImapServer(), cclient);
            WasCreatedSentMailFolder = false;
            anummsg  = pd->uo->getNumMsgToReply ();
            initStr(messageid);
            if (anummsg > -1) 
              {
              xstrncpy (messageid, CMAXBUFFER, cclient->getMessageId(anummsg));
              sendmsg->setREFERENCES (messageid);
              }
            bool boo = sendmsg->sendSMTP(tmp, pd->uo->getSentMailName(), &WasCreatedSentMailFolder, MAILCAP);
            if (boo == true) 
              {              
              if (anummsg > -1) {cclient->setFlags ("\\ANSWERED", xitoa(anummsg, anum));}
              if (strcmp (tmp, "") == 0)
                {
                if (sendmsg->getMustSaveMsgSentmail() == false)
                  {
                  html->OkPage (pd->stlang, pd->username, pd->connid, pd->uo, L->get(MSG_SEND_OK));
                  }
                else
                  {
                  xsnprintf (abuf, CMAXBUFFER, "%s<BR>\n%s<FONT size=-1>(%s \"%s\")</FONT>\n",  
                             L->get(MSG_SEND_OK), ESPACIADOR, L->get(MSG_SAVED_SENTMAIL), pd->uo->getSentMailName());
                  html->OkPageTitle (pd->stlang, pd->username, pd->connid, pd->uo, abuf, L->get(MSG_SEND_OK));
                  }                  
                }
              else
                {
                //SENT, BUT CAN NOT COPY IN SENTMAIL
                html->OkPage (pd->stlang, pd->username, pd->connid, pd->uo, L->get(MSG_ERR_SAVE_SENTMAIL));
                }
              sendmsg->DelAttachs ();  
              }
            else 
              {
              html->ErrorPage (tmp);
              }
            delete sendmsg;
            }
          DeleteFile (pd->parm1);
          break;
          }
        case (CMD_CCLIENT_CM_SENDNNTP):
          {
          TBuffer messageid;
          TNumber anum;
          int anummsg;
          CopyFileOverWrite (pd->parm1, pd->uo->getfnSavedMsg());
          int numattachs = xatoidef (pd->parm2, 0);
          if (numattachs != pd->uo->numAttachs())
            {
            html->ErrorPageBack(pd->stlang, pd->username, pd->connid, pd->uo, L->get(MSG_ERR_RELOAD_ATTACHS), 2);
            }
          else
            {
            pd->uo->InitStatusLine ();
            sendmsg = new SendMSG (pd->uo->getNNTPServer(), pd->parm1, pd->uo, pd->uo->getImapServer(), cclient);
            WasCreatedSentMailFolder = false;
            anummsg  = pd->uo->getNumMsgToReply ();
            initStr (messageid);
            if (anummsg > -1) 
              {
              xstrncpy (messageid, CMAXBUFFER, cclient->getMessageId(anummsg));
              sendmsg->setREFERENCES (messageid);
              }            
            bool boo = sendmsg->sendNNTP(tmp, pd->uo->getSentMailName(), &WasCreatedSentMailFolder, MAILCAP);
            if (boo == true) 
              {
              if (anummsg > -1) {cclient->setFlags ("\\ANSWERED", xitoa(anummsg, anum));}
              if (strcmp (tmp, "") == 0)
                {
                html->OkPage (pd->stlang, pd->username, pd->connid, pd->uo, L->get(MSG_SEND_OK));
                }
              else
                {
                //SENT, BUT CAN NOT COPY IN SENTMAIL
                html->OkPage (pd->stlang, pd->username, pd->connid, pd->uo, L->get(MSG_ERR_SAVE_SENTMAIL));
                }
              sendmsg->DelAttachs ();  
              }
            else 
              {
              html->ErrorPage (tmp);
              }
            delete sendmsg;
            }
          DeleteFile (pd->parm1);
          break;
          }        
        case (CMD_CCLIENT_CM):          
        default:
          {
          TBuffer ato, acc, abcc, asubject, atext;
          initStr (ato); initStr (acc); initStr (abcc); initStr (asubject); initStr (atext);
          if (strcmp (pd->parm1, "") != 0) {xstrncpy (ato, CMAXBUFFER, pd->parm1);}
          if (strcmp (pd->parm2, "") != 0) {xstrncpy (asubject, CMAXBUFFER, pd->parm2);}          
          if (strcmp (pd->parm3, "") != 0) {xstrncpy (atext, CMAXBUFFER, pd->parm3);}          
          pd->uo->setNumMsgToReply (-1);
          pd->uo->setStatusLine (L->get(MSG_COMPOSE_TIMEOUT), skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"));
          html->PrintComposeMsgPage (CMD_CCLIENT_CM, CMD_CCLIENT_CM, pd->stlang, pd->username, pd->connid, 
                                     ato, acc, abcc, asubject, 
                                     NULL, NULL, NULL,
                                     atext,
                                     pd->uo);
          break;
          }
        }
      break;
      }
    case (CMD_CCLIENT_CMNNTP):
      {
      pd->uo->setNumMsgToReply (-1);
      pd->uo->setStatusLine (L->get(MSG_COMPOSE_TIMEOUT), skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"));
      html->PrintComposeMsgPage (CMD_CCLIENT_CMNNTP, CMD_CCLIENT_CMNNTP, pd->stlang, pd->username, pd->connid, 
                                 NULL, NULL, NULL, NULL, 
                                 NULL, NULL, NULL,
                                 NULL,
                                 pd->uo);
      break;
      }        
    case (CMD_CCLIENT_CM_REPLY):
      {
      pd->uo->setStatusLine (L->get(MSG_COMPOSE_TIMEOUT), skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"));
      nummsg = xatoldef (pd->parm1, (long int)1);  
      pd->uo->setNumMsgToReply ((int)nummsg);        
      cclient->getBodyStructure (nummsg, SLAttach);
      sscanf (SLAttach->getString(0).cstr(), "%s %s %s", attid, contenttype, tmp);
      //I need that xtrdup for nntp. DO NOT DELETE.
      pc = xstrdup (cclient->getAttBody (nummsg, attid, SLAttachInfo, &len, true));
      html->PrintComposeMsgPage (CMD_CCLIENT_CM_REPLY, CMD_CCLIENT_CM_REPLY, pd->stlang, pd->username, pd->connid, 
                                 cclient->getTo (nummsg), NULL, NULL, cclient->getSubject (nummsg), 
                                 cclient->getReplyTo(nummsg), cclient->getFrom(nummsg), cclient->getDate(nummsg), 
                                 pc,
                                 pd->uo);                                   
                                 
      delete pc;
      break;  
      }      
    case (CMD_CCLIENT_CM_REPLYGROUP):
      {
      pd->uo->setStatusLine (L->get(MSG_COMPOSE_TIMEOUT), skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"));
      nummsg = xatoldef (pd->parm1, (long int)1);  
      pd->uo->setNumMsgToReply ((int)nummsg);        
      cclient->getBodyStructure (nummsg, SLAttach);
      sscanf (SLAttach->getString(0).cstr(), "%s %s %s", attid, contenttype, tmp);
      //I need that xtrdup for nntp. DO NOT DELETE.
      pc = xstrdup (cclient->getAttBody (nummsg, attid, SLAttachInfo, &len, true));
      html->PrintComposeMsgPage (CMD_CCLIENT_CM_REPLYGROUP, CMD_CCLIENT_CM_REPLYGROUP, pd->stlang, pd->username, pd->connid, 
                                 cclient->getTo (nummsg), NULL, NULL, cclient->getSubject (nummsg), 
                                 cclient->getReplyTo(nummsg), cclient->getFrom(nummsg), cclient->getDate(nummsg), 
                                 pc,
                                 pd->uo);
      delete pc;
      break;  
      }              
    case (CMD_CCLIENT_CM_REPLYALL):
      {
      pd->uo->setStatusLine (L->get(MSG_COMPOSE_TIMEOUT), skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"));
      nummsg = xatoldef (pd->parm1, (long int)1);  
      pd->uo->setNumMsgToReply ((int)nummsg);        
      cclient->getBodyStructure (nummsg, SLAttach);
      sscanf (SLAttach->getString(0).cstr(), "%s %s %s", attid, contenttype, tmp);
      pc = xstrdup (cclient->getAttBody (nummsg, attid, SLAttachInfo, &len, true));
      html->PrintComposeMsgPage (CMD_CCLIENT_CM_REPLYALL, CMD_CCLIENT_CM_REPLYALL, pd->stlang, pd->username, pd->connid, 
                                 cclient->getTo (nummsg), cclient->getCC (nummsg), NULL, cclient->getSubject (nummsg), 
                                 cclient->getReplyTo(nummsg), cclient->getFrom(nummsg), cclient->getDate(nummsg), 
                                 pc,
                                 pd->uo);
      delete pc;
      break;  
      }                      
    case (CMD_CCLIENT_CM_FORWARD):
      {
      xulong size;
      int Y, num;
      TBuffer ftotname, fname, bas, info;
      
      pd->uo->setStatusLine (L->get(MSG_COMPOSE_TIMEOUT), skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"));
      pd->uo->setNumMsgToReply (-1);
      nummsg = xatoldef (pd->parm1, (long int)1);
      
      if ((pd->uo->getForwAttachs () == false) || (pd->uo->getLastCmd () != CMD_CCLIENT_MG_DISPLAY))
        {//*** NO INSERT THE ATTACHS IN THE FORWARD
        cclient->getBodyStructure (nummsg, SLAttach);
        sscanf (SLAttach->getString(0).cstr(), "%s %s %s", attid, contenttype, tmp);
        pc = xstrdup (cclient->getAttBody (nummsg, attid, SLAttachInfo, &len, true));
        html->PrintComposeMsgPage (CMD_CCLIENT_CM_FORWARD, CMD_CCLIENT_CM_FORWARD, pd->stlang, pd->username, pd->connid, 
                                   cclient->getTo (nummsg), NULL, NULL, cclient->getSubject (nummsg), 
                                   cclient->getReplyTo(nummsg), cclient->getFrom(nummsg), cclient->getDate(nummsg),
                                   pc,
                                   pd->uo);        
        }
      else
        {//*** SI INSERT
        cclient->getBodyStructure (nummsg, SLAttach);
        Y = 0; num = 0;
        while (Y < SLAttach->Count())
          {
          //2 IMAGE/GIF 154387 bytes, "un comentario", "logo.gif"
          initStr (tmp); initStr (info);
          sscanf (SLAttach->getString(Y).cstr(), "%s %s %ld %s %[^]]s", attid, contenttype, &size, tmp, info);
          //DEBUG ("--%s--", SLAttach->getString(Y).cstr());
          if (strchr (attid, '.') == NULL)
            {
            if ((Y > 0) || ((Y == 0) && (strcmp (contenttype, "TEXT/PLAIN") != 0)))
              {
              ++num;                
              char *filename = get_filename(SLAttach->getString(Y).cstr());
              xstrncpy(fname, CMAXBUFFER, filename);
              free(filename);                                
              xstrncpy (ftotname, CMAXBUFFER, (char *)pd->uo->getAttachDir()); 
              xstrncat (ftotname, CMAXBUFFER, "/"); xstrncat (ftotname, CMAXBUFFER, fname);
              cclient->getAttBodyToFile (nummsg, attid, SLAttachInfo, &len, ftotname, true);
              xsnprintf (bas, CMAXBUFFER, "%s %s", contenttype, info);
              pd->uo->addFileNameAtach (fname, bas);
              }
            }               
          ++Y;
          }
        sscanf (SLAttach->getString(0).cstr(), "%s %s %s", attid, contenttype, tmp);
        pc = xstrdup (cclient->getAttBody (nummsg, attid, SLAttachInfo, &len, true));
        html->PrintComposeMsgPage (CMD_CCLIENT_CM_FORWARD, CMD_CCLIENT_CM_FORWARD, pd->stlang, pd->username, pd->connid, 
                                   cclient->getTo (nummsg), NULL, NULL, cclient->getSubject (nummsg), 
                                   cclient->getReplyTo(nummsg), cclient->getFrom(nummsg), cclient->getDate(nummsg),
                                   pc,
                                   pd->uo);
        }
      delete pc;
      break;   
      }              
    case (CMD_CCLIENT_AT_DUMP):
      {
      TBuffer atmpbuf;
      StringList *SLAttachHeader = new StringList ();
                               
      pd->uo->InitStatusLine ();
      nummsg = xatoldef (pd->parm1, (long int)1);
      //parm2 es es attid
      //parm3 es el filename

      //pd->parm2 es el attid, un pchar del tipo "12.3.4"
      //    si es del tipo cid:03d501bf68d6$5465a1e0$0401a8c0@Pc3.ncsa.es
      //    debo convertirlo al anterior
      if (NCstrstr(pd->parm2, "CID:") > 0)
        {
        xstrncpy (tmp, CMAXBUFFER, cclient->getAttIdFromCID (nummsg, pd->parm2, atmpbuf));
        } 
      else 
        {
        xstrncpy (tmp, CMAXBUFFER, pd->parm2);  
        }
      cclient->getAttHeaderSL(nummsg, tmp, SLAttachHeader);
      if (cclient->getAttSize (nummsg, tmp, SLAttach) > UNHANDLESIZEATTACH)
        {
        html->ErrorPage(L->get(ERR_UNHANDLESIZEATTACH));
        }
      else
        {          
        pc = cclient->getAttBody (nummsg, tmp, SLAttach, &len, true);
        if ((pc != NULL) && (len > 0))
          {
          html->dumpRawAttachSL (SLAttachHeader, pc, len);
          }
        else
          {
          html->EmulatePageNotFound ();
          }
        }    
      break;  
      }                      
    case (CMD_CCLIENT_BD_UUDECODE):
      {
      int numatt;
      TBuffer TrueName, fntmpin, fntmpout, CT;
      pd->uo->InitStatusLine ();
      nummsg = xatoldef (pd->parm1, (long int)1);
      numatt = xatoldef (pd->parm2, (long int)1);
      //parm3 is the filename
      cclient->getBodyStructure (nummsg, SLAttach);
      xstrncpy (attid, CMAXBUFFER, "1");
      pc = cclient->getAttBody (nummsg, attid, SLAttachInfo, &len, true);
      MakeTmpName (fntmpin, CMAXBUFFER);
      MakeTmpName (fntmpout, CMAXBUFFER);
      if (SavePchar (pc, len, fntmpin) == false) 
        {   
        html->ErrorPage (L->get(ERR_UUDECODING));
        } 
      else if (UudecodeFiles (fntmpin, fntmpout, TrueName, numatt) == false) 
        {
        html->ErrorPage (L->get(ERR_UUDECODING));
        } 
      else
        {
        getMailcapTipoFromFilename (TrueName, MAILCAP);
        xstrncpy (CT, CMAXBUFFER, getMailcapTipoFromFilename (TrueName, MAILCAP));
        html->dumpFile (fntmpout, CT);
        }
      DeleteFile (fntmpin);
      DeleteFile (fntmpout);
      break;  
      }         
    case (CMD_CCLIENT_AB): 
      {
      int xcmd;
      xcmd = TranslateCmd (iSERVICE_CCLIENT, pd->stsubcmd); 
      if (cgienv_ExistsVar (pd->envfile, "ab_saveentry") == true) 
        {xcmd = TranslateCmd (iSERVICE_CCLIENT, "ab_saveentry");}
      else if (cgienv_ExistsVar (pd->envfile, "ab_deleentries") == true) 
        {xcmd = TranslateCmd (iSERVICE_CCLIENT, "ab_deleentries");}
      if (xcmd == CMD_CCLIENT_AB_SAVEENTRY)  
        {
        TBuffer abuf;
        FILE *fw;
        char *pc = NULL;
        MakeTmpName (pd->parm2, CMAXBUFFER);
        fw = fopen (pd->parm2, "w");
        fprintf (fw, "%s\n", Text2HTML(Cut (cgienv_GetSimpleVarDef (pd->envfile, "nickname", abuf, ""), MAXLENGTH_FIELD_AB, abuf), pc)); free (pc);
        fprintf (fw, "%s\n", Text2HTML(Cut (cgienv_GetSimpleVarDef (pd->envfile, "fullname", abuf, ""), MAXLENGTH_FIELD_AB, abuf), pc)); free (pc);
        fprintf (fw, "%s\n", Text2HTML(Cut (cgienv_GetSimpleVarDef (pd->envfile, "addresses", abuf, ""), MAXLENGTH_FIELD_AB, abuf), pc)); free (pc);
        fprintf (fw, "%s\n", Text2HTML(Cut (cgienv_GetSimpleVarDef (pd->envfile, "fcc", abuf, ""), MAXLENGTH_FIELD_AB, abuf), pc)); free (pc);
        fprintf (fw, "%s\n", Text2HTML(Cut (cgienv_GetSimpleVarDef (pd->envfile, "comments", abuf, ""), MAXLENGTH_FIELD_AB, abuf), pc)); free (pc);
        fclose (fw);
        }                                         
      else if (xcmd == CMD_CCLIENT_AB_DELEENTRIES)
        {
        cgienv_GetSimpleMultipleEntries (pd->envfile, "numentry", ",", pd->allparms, true);
        }
      switch (xcmd)
        {
        case (CMD_CCLIENT_AB_DUMP):
          {
          ab = new Addressbook (ReturnUserAddressbookFileName(BasePath, pd->username, pd->imapserver, tmp), pd->uo);
          pd->uo->setStatusLine (L->get(MSG_ADDBOOK), RED);
          html->PrintAddBook_Dump (xcmd, pd->stlang, pd->username, pd->connid, pd->uo, ab, -1);
          delete ab;
          break; 
          }          
        case (CMD_CCLIENT_AB_SORT):
          {
          int sortby = -1;
          
          ab = new Addressbook (ReturnUserAddressbookFileName(BasePath, pd->username, pd->imapserver, tmp), pd->uo);
          pd->uo->setStatusLine (L->get(MSG_ADDBOOK), RED);
          sortby = xatoidef (pd->parm1, -1);
          html->PrintAddBook_Show (xcmd, pd->stlang, pd->username, pd->connid, pd->uo, ab, sortby);
          delete ab;
          break; 
          }
        case (CMD_CCLIENT_AB_TAKEADDRESS):
          {
          nummsg = xatoldef (pd->parm1, (long int)1);
          ab = new Addressbook (ReturnUserAddressbookFileName(BasePath, pd->username, pd->imapserver, tmp), pd->uo);
          pd->uo->setStatusLine (L->get(MSG_AB_EDITENTRY), RED);
          int numentry = ab->AddNewEntry(cclient->getFrom (nummsg));      
          html->PrintAddBook_EditEntry (xcmd, pd->stlang, pd->username, pd->connid, pd->uo, ab, numentry);
          delete ab;
          break; 
          }
        case (CMD_CCLIENT_AB_EDITENTRY):
          {
          ab = new Addressbook (ReturnUserAddressbookFileName(BasePath, pd->username, pd->imapserver, tmp), pd->uo);
          pd->uo->setStatusLine (L->get(MSG_AB_EDITENTRY), RED);
          int numentry = xatoidef (pd->parm1, (int)0);      
          html->PrintAddBook_EditEntry (xcmd, pd->stlang, pd->username, pd->connid, pd->uo, ab, numentry);
          delete ab;
          break; 
          }        
        case (CMD_CCLIENT_AB_NEWENTRY):
          {
          ab = new Addressbook (ReturnUserAddressbookFileName(BasePath, pd->username, pd->imapserver, tmp), pd->uo);
          pd->uo->setStatusLine (L->get(MSG_AB_EDITENTRY), RED);
          html->PrintAddBook_EditEntry (xcmd, pd->stlang, pd->username, pd->connid, pd->uo, ab, -1);
          delete ab;
          break; 
          }                
       case (CMD_CCLIENT_AB_DELEENTRIES):
          {
          ab = new Addressbook (ReturnUserAddressbookFileName(BasePath, pd->username, pd->imapserver, tmp), pd->uo);        
          if (strlen(pd->allparms) == 0) {pd->uo->setStatusLine (L->get(MSG_NO_ENTRIES_MARKED), RED);}
          else if (strcmp (pd->allparms, "-1") != 0)
            {
            bool boo = ab->DeleteEntries (pd->allparms);
            if (boo) {pd->uo->setStatusLine (L->get(MSG_AB_DELEENTRY), RED);}
            else {pd->uo->setStatusLine (L->get(ERR_AB_DELEENTRY), RED);}
            }  
          html->PrintAddBook_Show (xcmd, pd->stlang, pd->username, pd->connid, pd->uo, ab, -1);
          delete ab;
          break;        
          }        
        case (CMD_CCLIENT_AB_SAVEENTRY):
          {
          cgienv_GetSimpleVarDef (pd->envfile, "numentry", pd->parm1, "-1");          
          ab = new Addressbook (ReturnUserAddressbookFileName(BasePath, pd->username, pd->imapserver, tmp), pd->uo);
          int numentry = xatoidef (pd->parm1, (int)-1);
          if (numentry == -1) {numentry = ab->AddNewEntry();}
          ab->UpdateEntryFromFile (numentry, pd->parm2);
          pd->uo->setStatusLine (L->get(MSG_AB_SAVEENTRY), RED);
          delete ab;
          xsnprintf (tmp, CMAXBUFFER, "%s", pd->uo->getLastStringCmd (CMD_CCLIENT_AB_SAVEENTRY, pd->stlang, pd->connid, false));
          html->Redirect (tmp);
          break; 
          }
        case (CMD_CCLIENT_AB_SHOWALL):
        default:
          {
          ab = new Addressbook (ReturnUserAddressbookFileName(BasePath, pd->username, pd->imapserver, tmp), pd->uo);
          html->PrintAddBook_Show (xcmd, pd->stlang, pd->username, pd->connid, pd->uo, ab, -1);
          delete ab;
          break;break; 
          }  
        }  
        
      break;  
      }           
    case (CMD_CCLIENT_AB_ADDFIELDS):
      {
      int n1 = 0, n2 = 0, n3 = 0;
      bool b1 = false, b2 = false, b3 = false;
      TBuffer mulentries, lineaTO, lineaCC, lineaBCC;
      FILE *fw;

      MakeTmpName (pd->parm1, CMAXBUFFER);
      fw = fopen (pd->parm1, "w");
      //ADD TO
      cgienv_GetSimpleMultipleEntries (pd->envfile, "numentryto", ",", mulentries, true);
      fprintf (fw, "%s\n", mulentries); 
      //ADD CC
      cgienv_GetSimpleMultipleEntries (pd->envfile, "numentrycc", ",", mulentries, true);
      fprintf (fw, "%s\n", mulentries);       
      //ADD BCC
      cgienv_GetSimpleMultipleEntries (pd->envfile, "numentrybcc", ",", mulentries, true);
      fprintf (fw, "%s\n", mulentries);       
      fclose (fw);
      
      ab = new Addressbook (ReturnUserAddressbookFileName(BasePath, pd->username, pd->imapserver, tmp), pd->uo);
      if (FileExists (pd->uo->getfnSavedMsg()) == false) {CreaFileSavedMsg(pd->uo->getfnSavedMsg());}
      xstrncpy (lineaTO,  CMAXBUFFER, getLineFile(pd->parm1, 1, 1, tmp));
      xstrncpy (lineaCC,  CMAXBUFFER, getLineFile(pd->parm1, 2, 2, tmp));
      xstrncpy (lineaBCC, CMAXBUFFER, getLineFile(pd->parm1, 3, 3, tmp));
      if (strcmp(lineaTO, " ") != 0)
        {     
        b1 = ConcatLineToLineOfFile (pd->uo->getfnSavedMsg(), 2, ab->getMultiAddresses(lineaTO),  ",", MAXLENGTH_TO); 
        n1 = CountTokensEnString (ab->getMultiAddresses(lineaTO), ',');
        }
      if (strcmp(lineaCC, " ") != 0)  
        {
        b2 = ConcatLineToLineOfFile (pd->uo->getfnSavedMsg(), 3, ab->getMultiAddresses(lineaCC),  ",", MAXLENGTH_TO);         
        n2 = CountTokensEnString (ab->getMultiAddresses(lineaCC), ',');
        }
      if (strcmp(lineaBCC, " ") != 0)
        {
        b3 = ConcatLineToLineOfFile (pd->uo->getfnSavedMsg(), 4, ab->getMultiAddresses(lineaBCC), ",", MAXLENGTH_TO);         
        n3 = CountTokensEnString (ab->getMultiAddresses(lineaBCC), ',');
        }
      if ((b1 == true) || (b2 == true) || (b3 == true))
        {
        pd->uo->setStatusLine (L->get(MSG_ADDRESS_LINE_CUT), RED);
        }
      else if ((strcmp(lineaTO, " ") == 0) && (strcmp(lineaCC, " ") == 0) && (strcmp(lineaBCC, " ") == 0))
        {
        pd->uo->setStatusLine (L->get(MSG_NO_ENTRIES_MARKED), RED);
        }  
      else
        {
        xsnprintf (tmp, CMAXBUFFER, L->get(MSG_AB_ADDFIELDS), n1 + n2 + n3);
        pd->uo->setStatusLine (tmp, RED);
        }  
      DeleteFile (pd->parm1);  
      html->PrintAddBook_Show (cmd, pd->stlang, pd->username, pd->connid, pd->uo, ab, -1);  
      delete ab;
      break;
      }        
    case (CMD_CCLIENT_NW_LIST_DUMP):
      {
      pd->uo->InitStatusLine ();
      CN->setNNTPserver (pd->uo->getNNTPServer());
      CN->retrieveAllGroupsList ();
      html->dumpSL (CN->SLAllGroups, true);
      break;
      }                                                                                      
    case (CMD_CCLIENT_NW_SUBSCRIBED):
      {
      pd->uo->InitStatusLine ();
      html->PrintSubscribedGroupsPage (pd->stlang, cclient->getMailboxName(), pd->username, pd->connid, SLMailboxes, pd->uo);
      break;
      }                                                                                      
    default:
      {
      LOG ("ERROR: Service_Cclient: Here we can not go!! cmd=%s, subcmd=%s", pd->stcmd, pd->stsubcmd);
      pd->html->PrintInvalidCommand (pd->stlang, pd->username, pd->connid, pd->uo);
      break;
      }
    }
  delete SLAttachInfo;  
  delete SLAttach;  
  delete SLMailboxes;
  delete SLHeaders;
  return false;
  } 

void HTMLPages::ErrorPageBack (const char *stlang, const char *user, const char *connid, 
                          UserOptions *uo, const char *error, int way)
  {                    
  Head ("text/html", "", "");  
  HTMLBegin ();  
  Title (error, skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"), skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);
  switch (way)
    {       
    case 1:
      {
      BeginTable (0, 0, 0, 100);
      BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_MAIN_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/mb_index/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, stlang, user, connid, uo->getValidator(), 
             uo->getPageId(), CMD_CCLIENT_MB_INDEX, uo->getCurrentPosition());
      Image (skin->getI(L_INDEXMAILBOX), L->get(L_INDEXMAILBOX2), skin->getISize());      
      WRITE (" %s\n", L->get(ALT_BACK));
      WRITE ("</A>");
      EndTD();        
      EmptyCellx2();
      EndTR();
      EndTable (); 
      break;
      }
    case 2:
      {
      BeginTable (0, 0, 0, 100);
      BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_MAIN_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/cm_forward/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, stlang, user, connid, uo->getValidator(), 
             uo->getPageId(), CMD_CCLIENT_MB_INDEX, uo->getCurrentPosition());
      Image (skin->getI(L_BACK), L->get(L_BACK), skin->getISize());      
      WRITE (" %s\n", L->get(ALT_BACK));
      WRITE ("</A>");
      EndTD();      
      EmptyCellx2();  
      EndTR();
      EndTable (); 
      break;
      }      
    }
  WRITE ("<p><h1><FONT color=\"%s\">Error:</font> %s</h1><p>\n", RED, error);
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }                                                       

void HTMLPages::PrintStatusLine_Cclient (const char *user, UserOptions *uo, bool displayClock, const char *mailboxname)
  {
  WRITE ("<TABLE width=\"100%%\">\n<TR>\n");
  if (FileExists (FILE_FOR_NO_ACCEPT_NEW_CONNS) == true)
    {
    TBuffer amsg;
    GetBufferFromFile (FILE_FOR_NO_ACCEPT_NEW_CONNS, amsg, CMAXBUFFER);
    WRITE ("<TD align=left><B><FONT color=\"#FF0000\"><BLINK>%s</BLINK></FONT></B></TD>\n<TD align=right><B><FONT size=2 color=\"%s\">%s: %s@%s (%s)</FONT></B></TD>\n",
              amsg, skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"), 
              L->get(L_USER), user, uo->getImapServer(), 
              mailboxname);
    }
  else
    {
    if (cclient->getError () == false)
      {
      WRITE ("<TD align=left><B>%s</B></TD>\n<TD align=right><B><FONT size=%d face=\"%s\" color=\"%s\">%s: %s@%s (%s)</FONT></B></TD>\n",
             uo->getStatusLine(), skin->getSkinAtribPropI("FONT_STATUS_SIZE"), skin->getSkinAtribProp("FONT_STATUS"), skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"), 
             L->get(L_USER), user, uo->getImapServer(), 
             mailboxname);
      }
    else
      {
      WRITE ("<TD align=left><B>%s</B></TD>\n<TD align=right><B><FONT size=%d face=\"%s\" color=\"%s\">%s: %s@%s (%s)</FONT></B></TD>\n",
             cclient->getErrorString(), skin->getSkinAtribPropI("FONT_STATUS_SIZE"), skin->getSkinAtribProp("FONT_STATUS"), skin->getSkinAtribProp("COLOR_FONT_STATUSLINE"), 
             L->get(L_USER), user, uo->getImapServer(), 
             mailboxname);
      }  
    }
  
  //Only is seen in IE4+/N6+
  if ((displayClock == true) && (uo->get_use_javascript() == true) && (uo->getShowClock() == true))
    {        
    WRITE ("<TD width=\"1%%\" align=right>");  
    JavaScript (DEF_JavaScriptIDClock);    
    JavaScript (DEF_JavaScriptClock);
    WRITE ("</TD>"); 
    }

  WRITE ("\n</TR></TABLE>\n");
  }
  
void HTMLPages::BotoneraDisplayMsg (const char *lang, const char *user, const char *connid, UserOptions *uo, bool isdeleted, 
                               ULongList *LL, bool showreplyall, bool isTopBar)
  {
  long actualpos, totalmsgs, trueactualpos, truenummsg;
  int validator, pageid, actualcmd;
  
  actualpos = uo->getCurrentPosition();
  totalmsgs = uo->getTotalMsgs();
  validator = uo->getValidator();
  pageid    = uo->getPageId();
  actualcmd = CMD_CCLIENT_MG_DISPLAY;
  trueactualpos = LL->indexOf (actualpos);
  
  if (isTopBar == true) 
    {
    BeginTable (0, 0, 0, 100);
    BeginTR(skin->getSkinAtribProp("COLOR_BGBOTONERA"));

    //BUTTON BACK
    BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"),  skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
    WRITE ("%s", uo->getLastStringCmd(CMD_CCLIENT_MG_DISPLAY, lang, connid, true));
    Image (skin->getI(L_BACK), L->get(ALT_BACK), skin->getISize());      
    if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_BACK));}
    WRITE ("</A>");
    EndTD(); 
    
    //SPACE 
    EmptyCellx2();

    //BUTTON ROOT      
    BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
    WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, uo->getValidator(),
       uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
    Image (skin->getI(L_ROOT), L->get(ALT_ROOT), skin->getISize());      
    if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_ROOT));}
    WRITE ("</A>");
    EndTD();   
    
    //SPACE 
    EmptyCellx2();

    //BUTTON HELP   
    BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"),  skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
    WRITE ("<A HREF=\"%s/%s/help/mg_display/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, actualcmd);
    Image (skin->getI(L_HELP), L->get(ALT_HELP), skin->getISize());      
    if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_HELP));}
    WRITE ("</A>");
    EndTD();
          
    //SPACE 
    EmptyCellx2();

    //BUTTON PREV MSG
    if (trueactualpos > 0)
      {
      truenummsg = LL->elementAt((int)(trueactualpos - 1));
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/mg_display/noop/%s/%s/%s/%d/%d/%d/%ld/\">",PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, actualcmd, truenummsg);
      Image (skin->getI(L_PREVMSG), L->get(ALT_PREVMSG), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_PREVMSG));}
      WRITE ("</A>");
      EndTD();
      }
    else
      {
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      Image (skin->getI(L_PREVMSG_INA), L->get(ALT_PREVMSG_INA), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_PREVMSG_INA));}
      EndTD();
      }
    //SPACE 
    EmptyCellx2();

    //BUTTON NEXT MSG
    if (trueactualpos < totalmsgs - 1)
      {
      truenummsg = LL->elementAt((int)(trueactualpos + 1));
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/mg_display/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, actualcmd, truenummsg);
      Image (skin->getI(L_NEXTMSG), L->get(ALT_NEXTMSG), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_NEXTMSG));}
      WRITE ("</A>");
      EndTD();
      }
    else
      {
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      Image (skin->getI(L_NEXTMSG_INA), L->get(L_NEXTMSG_INA), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_NEXTMSG_INA));}
      EndTD();
      }
    //SPACE 
    EmptyCellx2();

    //BUTTON REPLY
    BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
    WRITE ("<A HREF=\"%s/%s/cm_reply/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, actualcmd, actualpos);
    Image (skin->getI(L_REPLYMSG), L->get(ALT_REPLYMSG), skin->getISize());      
    if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_REPLYMSG));}
    WRITE ("</A>");                                                      
    EndTD();   
    if (showreplyall == true)
      {
      //SPACE 
      EmptyCellx2();

      //BUTTON REPLYALL
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/cm_replyall/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, actualcmd, actualpos);
      Image (skin->getI(L_REPLYALLMSG), L->get(ALT_REPLYALLMSG), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_REPLYALLMSG));}
      WRITE ("</A>");                                                      
      EndTD();              
      }      
    if (cclient->getServerProtocol() == PROTOCOL_NNTP) 
      {      
      //SPACE 
      EmptyCellx2();

      //BUTTON REPLYGROUP
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/cm_replygroup/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, actualcmd, actualpos);
      Image (skin->getI(L_SENDTONNTPGROUP), L->get(ALT_SENDTONNTPGROUP), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_SENDTONNTPGROUP));}
      WRITE ("</A>");                                                      
      EndTD();                    
      }      
    //SPACE 
    EmptyCellx2();

    //BUTTON FORWARD
    BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
    WRITE ("<A HREF=\"%s/%s/cm_forward/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, actualcmd, actualpos);
    Image (skin->getI(L_FORWARDMSG), L->get(ALT_FORWARDMSG), skin->getISize());      
    if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_FORWARDMSG));}
    WRITE ("</A>");
    EndTD();              
    //SPACE 
    EmptyCellx2();

    //BUTTON SAVE ADDRESS
    BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
    WRITE ("<A HREF=\"%s/%s/ab/ab_takeaddress/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, actualcmd, actualpos);
    Image (skin->getI(L_SAVEADDRESS), L->get(ALT_SAVEADDRESS), skin->getISize());      
    if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_SAVEADDRESS));}
    WRITE ("</A>");
    EndTD();              
    //SPACE 
    EmptyCellx2();

    if (cclient->getServerProtocol() == PROTOCOL_IMAP) 
      {      
      //BUTTON DELNEXTMSG
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      if (trueactualpos < totalmsgs - 1) {truenummsg = LL->elementAt((int)(trueactualpos + 1));} else {truenummsg = LL->elementAt((int)(trueactualpos));}
      if (isdeleted == false)
        {
        WRITE ("<A HREF=\"%s/%s/mg_deldisplay/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, 
               actualcmd, truenummsg);
        Image (skin->getI(L_DELNEXTMSG), L->get(ALT_DELNEXTMSG), skin->getISize());      
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_DELNEXTMSG));}
        WRITE ("</A>");                  
        }
      else
        {
        WRITE ("<A HREF=\"%s/%s/mg_undeldisplay/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, 
               actualcmd, truenummsg);
        Image (skin->getI(L_UNDELNEXTMSG), L->get(ALT_UNDELNEXTMSG), skin->getISize());      
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_UNDELNEXTMSG));}
        WRITE ("</A>");                          
        }
      EndTD();
      }
    //SPACE 
    EmptyCellx2();

    //BUTTON LOGOUT   
    BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
    if (uo->getConfirmLogout() == true)    
      {
      WRITE ("<A HREF=\"%s/%s/conf_act/logout/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, actualcmd);
      }
    else
      {  
      WRITE ("<A HREF=\"%s/%s/logout/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, actualcmd);
      }
    Image (skin->getI(L_LOGOUT), L->get(ALT_LOGOUT), skin->getISize());      
    if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_LOGOUT));}
    WRITE ("</A>");
    EndTD();
    EndTR();
    EndTable (); 
    PrintStatusLine_Cclient (user, uo, true, cclient->getMailboxName());
    }
  else //**************  BOTTON BAR
    {
    bool ShowImages = false;
    Linea (); 
    BeginCenter();
    //BUTTON PREV MSG
    if (trueactualpos > 0)
      {
      truenummsg = LL->elementAt((int)(trueactualpos - 1));
      WRITE ("<A HREF=\"%s/%s/mg_display/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, actualcmd, truenummsg);
      if (ShowImages == true) {Image (skin->getI(L_PREVMSG), L->get(ALT_PREVMSG), skin->getISize());}
      WRITE ("[%s]\n", L->get(ALT_PREVMSG));
      WRITE ("</A>&nbsp;&nbsp;");
      }
    //BUTTON NEXT MSG
    if (trueactualpos < totalmsgs - 1)
      {
      truenummsg = LL->elementAt((int)(trueactualpos + 1));
      WRITE ("<A HREF=\"%s/%s/mg_display/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, actualcmd, truenummsg);
      if (ShowImages == true) {Image (skin->getI(L_NEXTMSG), L->get(ALT_NEXTMSG), skin->getISize());}
      WRITE ("[%s]\n", L->get(ALT_NEXTMSG));
      WRITE ("</A>&nbsp;&nbsp;");
      }
    if (cclient->getServerProtocol() == PROTOCOL_IMAP) 
      {      
      //BUTTON DELNEXTMSG
      if (trueactualpos < totalmsgs - 1) {truenummsg = LL->elementAt((int)(trueactualpos + 1));} else {truenummsg = LL->elementAt((int)(trueactualpos));}
      if (isdeleted == false)
        {
        WRITE ("<A HREF=\"%s/%s/mg_deldisplay/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, 
               actualcmd, truenummsg);
        if (ShowImages == true) {Image (skin->getI(L_DELNEXTMSG), L->get(ALT_DELNEXTMSG), skin->getISize());}
        WRITE ("[%s]\n", L->get(ALT_DELNEXTMSG));
        WRITE ("</A>&nbsp;&nbsp;");                  
        }
      else
        {
        WRITE ("<A HREF=\"%s/%s/mg_undeldisplay/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, 
               actualcmd, truenummsg);
        if (ShowImages == true) {Image (skin->getI(L_UNDELNEXTMSG), L->get(ALT_UNDELNEXTMSG), skin->getISize());}
        WRITE ("[%s]\n", L->get(ALT_UNDELNEXTMSG));
        WRITE ("</A>&nbsp;&nbsp;");                          
        }
      }
    EndCenter();
    }
  } 
  
void HTMLPages::BotoneraMailboxIndex (const char *lang, const char *user, const char *connid, UserOptions *uo)
  {
  long newbegin, actualpos, totalmsgs, aMAXMSGSFORPAGE;
  int validator, actualcmd;                           
  
  actualpos = uo->getBeginPage();
  totalmsgs = uo->getTotalMsgs();
  validator = uo->getValidator();
  actualcmd = CMD_CCLIENT_MB_INDEX;
  
  aMAXMSGSFORPAGE = uo->getMsgsPerIndexPage();
  if (aMAXMSGSFORPAGE <= 0) aMAXMSGSFORPAGE = totalmsgs;
  
  BeginTable (0, 0, 0, 100);
    BeginTR(skin->getSkinAtribProp("COLOR_BGBOTONERA"));    
    
      //BUTTON BACK PAGE  
      if (cclient->getServerProtocol() == PROTOCOL_NNTP) 
        {           
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        WRITE ("<A HREF=\"%s/%s/nw_subscribed/root/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, 
               connid, validator, uo->getPageId(), actualcmd);
        Image (skin->getI(L_BACK), L->get(ALT_BACK), skin->getISize());
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_BACK));}
        WRITE ("</A>");
        EndTD();        
        
        //SPACE 
        EmptyCellx2();
        EmptyCellx2();        
        }
      
      //BUTTON ROOT      
      //BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
      BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, uo->getValidator(),
         uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
      Image (skin->getI(L_ROOT), L->get(ALT_ROOT), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_ROOT));}
      WRITE ("</A>");
      EndTD();   

      //BUTTON HELP   
      /**/BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/help/mb_index/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, 
             connid, validator, uo->getPageId(), actualcmd);
      Image (skin->getI(L_HELP), L->get(ALT_HELP), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_HELP));}
      WRITE ("</A>");
      EndTD();

      /**/BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
      //BUTTON PREVIOUS PAGE
      if (actualpos > 1)  
        {
        newbegin = actualpos - aMAXMSGSFORPAGE; if (newbegin <= 0) newbegin = 1;
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        WRITE ("<A HREF=\"%s/%s/mb_index/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, 
               validator, uo->getPageId(), actualcmd, newbegin);
        Image (skin->getI(L_PREVPAGE_ACT), L->get(ALT_PREVPAGE_ACT), skin->getISize());      
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_PREVPAGE_ACT));}
        WRITE ("</A>");
        EndTD();
        }
      else 
        {
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        Image (skin->getI(L_PREVPAGE_INA), L->get(ALT_PREVPAGE_INA), skin->getISize());      
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_PREVPAGE_INA));}
        EndTD();
        }

      /**/BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
      //BUTTON NEXT PAGE
      if (actualpos + aMAXMSGSFORPAGE <= totalmsgs)
        {
        newbegin = actualpos + aMAXMSGSFORPAGE; 
        if (newbegin + aMAXMSGSFORPAGE > totalmsgs)
          {
          ldiv_t ld;
          ld = ldiv (totalmsgs, aMAXMSGSFORPAGE);
          newbegin = (ld.quot * aMAXMSGSFORPAGE) + 1;
          }
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        WRITE ("<A HREF=\"%s/%s/mb_index/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, 
               uo->getPageId(), actualcmd, newbegin);
        Image (skin->getI(L_NEXTPAGE_ACT), L->get(ALT_NEXTPAGE_ACT), skin->getISize());      
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_NEXTPAGE_ACT));}
        WRITE ("</A>");
        EndTD(); 
        }
      else
        {
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        Image (skin->getI(L_NEXTPAGE_INA), L->get(ALT_NEXTPAGE_INA), skin->getISize());      
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_NEXTPAGE_INA));}
        EndTD();
        }  

      /**/BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
      //BUTTON FIRST PAGE
      if (actualpos > 1)
        {
        newbegin = 1;
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        WRITE ("<A HREF=\"%s/%s/mb_index/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, 
               uo->getPageId(), actualcmd, newbegin);
        Image (skin->getI(L_FIRSTPAGE_ACT), L->get(ALT_FIRSTPAGE_ACT), skin->getISize());      
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_FIRSTPAGE_ACT));}
        WRITE ("</A>");
        EndTD();
        }          
      else
        {
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        Image (skin->getI(L_FIRSTPAGE_INA), L->get(ALT_FIRSTPAGE_INA), skin->getISize());      
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_FIRSTPAGE_INA));}
        EndTD();
        }  

      /**/BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
      //BUTTON LAST PAGE
      if (actualpos + aMAXMSGSFORPAGE <= totalmsgs)
        {
        ldiv_t ld;
        ld = ldiv (totalmsgs, aMAXMSGSFORPAGE);
        newbegin = (ld.quot * aMAXMSGSFORPAGE) + 1;
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        WRITE ("<A HREF=\"%s/%s/mb_index/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, 
               uo->getPageId(), actualcmd, newbegin);
        Image (skin->getI(L_LASTPAGE_ACT), L->get(ALT_LASTPAGE_ACT), skin->getISize());      
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_LASTPAGE_ACT));}
        WRITE ("</A>");
        EndTD();
        }          
      else
        {
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        Image (skin->getI(L_LASTPAGE_INA), L->get(ALT_LASTPAGE_INA), skin->getISize());      
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_LASTPAGE_INA));}
        EndTD();
        }

      if (cclient->getServerProtocol() == PROTOCOL_IMAP)
        {  
        /**/BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
        //BUTTON CM
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        WRITE ("<A HREF=\"%s/%s/cm/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, uo->getPageId(), actualcmd);
        Image (skin->getI(L_COMPOSEMSG), L->get(ALT_COMPOSEMSG), skin->getISize());      
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_COMPOSEMSG));}
        WRITE ("</A>");
        EndTD();                
        }
      else
        {
        /**/BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
        //BUTTON CMNNTP
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        WRITE ("<A HREF=\"%s/%s/cmnntp/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, uo->getPageId(), actualcmd);
        Image (skin->getI(L_COMPOSEMSGNNTP), L->get(ALT_COMPOSEMSGNNTP), skin->getISize());      
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_COMPOSEMSGNNTP));}
        WRITE ("</A>");
        EndTD();                
        }

      if (cclient->getServerProtocol() == PROTOCOL_IMAP)
        {  
        /**/BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
        //BUTTON MB
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        WRITE ("<A HREF=\"%s/%s/mb_show/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, uo->getPageId(), actualcmd);
        Image (skin->getI(L_MAILBOXES), L->get(ALT_MAILBOXES), skin->getISize());      
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_MAILBOXES));}
        WRITE ("</A>");
        EndTD();
        }                      

      /**/BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
      //BUTTON AB  
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/ab/ab_showall/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, uo->getPageId(), actualcmd);
      Image (skin->getI(L_ADDBOOK), L->get(ALT_ADDBOOK), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_ADDBOOK));}
      WRITE ("</A>");
      EndTD();                                                                     

      /**/BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
      //BUTTON CONFIG  
      if (cclient->getServerProtocol() == PROTOCOL_IMAP) 
        {
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        WRITE ("<A HREF=\"%s/%s/config_cclient/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CONFIG, lang, user, connid, validator, uo->getPageId(), actualcmd);
        Image (skin->getI(L_SHOWOPTIONS), L->get(L_SHOWOPTIONS), skin->getISize());      
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(L_SHOWOPTIONS));}
        WRITE ("</A>");
        EndTD();                      
        }
      else
        {
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        WRITE ("<A HREF=\"%s/%s/config_nntp/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CONFIG, lang, user, connid, validator, uo->getPageId(), actualcmd);
        Image (skin->getI(L_SHOWOPTIONS), L->get(L_SHOWOPTIONS), skin->getISize());      
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(L_SHOWOPTIONS));}
        WRITE ("</A>");
        EndTD();                      
        }
        
      if (cclient->getServerProtocol() == PROTOCOL_IMAP) 
        {
        /**/BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
        //BUTTON MB_EXPUNGE   
        BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
        if (uo->getConfirmPurge() == true)    
          {
          WRITE ("<A HREF=\"%s/%s/conf_act/mb_expunge/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, uo->getPageId(), actualcmd);
          }
        else
          {  
          WRITE ("<A HREF=\"%s/%s/mb_expunge/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, uo->getPageId(), actualcmd);
          }
        Image (skin->getI(L_EXPUNGE), L->get(ALT_EXPUNGE), skin->getISize());      
        if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_EXPUNGE));}
        WRITE ("</A>");
        EndTD();
        }        

      /**/BeginTD (8, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();   
      //BUTTON LOGOUT   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      if (uo->getConfirmLogout() == true)    
        {
        WRITE ("<A HREF=\"%s/%s/conf_act/logout/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, uo->getPageId(), actualcmd);
        }
      else
        {  
        WRITE ("<A HREF=\"%s/%s/logout/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, uo->getPageId(), actualcmd);
        }
      Image (skin->getI(L_LOGOUT), L->get(ALT_LOGOUT), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_LOGOUT));}
      WRITE ("</A>");
      EndTD();
    EndTR();

  EndTable ();
  PrintStatusLine_Cclient (user, uo, true, cclient->getMailboxName());
  }   
  
void HTMLPages::BotoneraComun (int cmdactual, const char *lang, const char *user, const char *connid, UserOptions *uo)
  {
  long actualpos, totalmsgs;
  int validator, pageid;
  
  actualpos = uo->getCurrentPosition();
  totalmsgs = uo->getTotalMsgs();
  validator = uo->getValidator();
  pageid    = uo->getPageId ();
  
  BeginTable (0, 0, 0, 100);
    BeginTR(skin->getSkinAtribProp("COLOR_BGBOTONERA"));
    
      //BUTTON BACK       
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      if (cmdactual == CMD_CCLIENT_NW_SUBSCRIBED)
        {
        WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, uo->getValidator(),
               uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());                   
        }
      else
        {
        WRITE ("%s", uo->getLastStringCmd(cmdactual, lang, connid, true));
        }
      Image (skin->getI(L_BACK), L->get(ALT_BACK), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_BACK));}
      WRITE ("</A>");
      EndTD();   

      //SPACE 
      EmptyCellx2();

      //BUTTON ROOT      
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, uo->getValidator(),
         uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
      Image (skin->getI(L_ROOT), L->get(ALT_ROOT), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_ROOT));}
      WRITE ("</A>");
      EndTD();   

      //SPACE 
      EmptyCellx2();
      //BUTTON HELP   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      switch (cmdactual)
        {
        case CMD_CCLIENT_MB_SHOW: WRITE ("<A HREF=\"%s/%s/help/mb_show/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, cmdactual); break;
        case CMD_CCLIENT_CM: WRITE ("<A HREF=\"%s/%s/help/cm/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, cmdactual); break;
        case CMD_CCLIENT_AB: case CMD_CCLIENT_AB_SHOWALL: case CMD_CCLIENT_AB_SORT: case CMD_CCLIENT_AB_FROM_CM:
        case CMD_CCLIENT_AB_ADDFIELDS:
          WRITE ("<A HREF=\"%s/%s/help/ab/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, cmdactual); break;
        case CMD_CCLIENT_AB_NEWENTRY:  WRITE ("<A HREF=\"%s/%s/help/ab_newentry/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, cmdactual); break;
        case CMD_CCLIENT_AB_EDITENTRY: WRITE ("<A HREF=\"%s/%s/help/ab_editentry/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, cmdactual); break;
        }
      Image (skin->getI(L_HELP), L->get(ALT_HELP), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_HELP));}
      WRITE ("</A>");
      EndTD();  
      //SPACE 
      EmptyCellx2();     
      //BUTTON LOGOUT   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      if (uo->getConfirmLogout() == true)    
        {
        WRITE ("<A HREF=\"%s/%s/conf_act/logout/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual);
        }
      else
        {  
        WRITE ("<A HREF=\"%s/%s/logout/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, cmdactual);
        }
      Image (skin->getI(L_LOGOUT), L->get(ALT_LOGOUT), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_LOGOUT));}
      WRITE ("</A>");
      EndTD();
      BeginTD (100, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD(); 
    EndTR();
  EndTable ();  
  PrintStatusLine_Cclient (user, uo, true, cclient->getMailboxName());
  }

void HTMLPages::BotoneraComposeMsg (int thecmd, const char *lang, const char *user, const char *connid, UserOptions *uo)
  {
  long actualpos, totalmsgs;
  int validator, pageid;
  
  actualpos = uo->getCurrentPosition();
  totalmsgs = uo->getTotalMsgs();
  validator = uo->getValidator();
  pageid    = uo->getPageId ();
  
  BeginTable (0, 0, 0, 100);
    BeginTR(skin->getSkinAtribProp("COLOR_BGBOTONERA"));

      //BUTTON BACK
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("%s", uo->getLastStringCmd(thecmd, lang, connid, true));      
      Image (skin->getI(L_BACK), L->get(ALT_BACK), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_BACK));}
      WRITE ("</A>");
      EndTD();                                                           
      //SPACE 
      EmptyCellx2();
      //BUTTON ROOT      
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, uo->getValidator(),
      uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
      Image (skin->getI(L_ROOT), L->get(ALT_ROOT), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_ROOT));}
      WRITE ("</A>");
      EndTD();       
      //SPACE 
      EmptyCellx2();
      //BUTTON HELP   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/help/cm/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, thecmd); 
      Image (skin->getI(L_HELP), L->get(ALT_HELP), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_HELP));}
      WRITE ("</A>");
      EndTD();  
      //SPACE 
      EmptyCellx2();
      //BUTTON LOGOUT   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      if (uo->getConfirmLogout() == true)    
        {
        WRITE ("<A HREF=\"%s/%s/conf_act/logout/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, thecmd);
        }
      else
        {  
        WRITE ("<A HREF=\"%s/%s/logout/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, thecmd);
        }
      Image (skin->getI(L_LOGOUT), L->get(ALT_LOGOUT), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_LOGOUT));}
      WRITE ("</A>");
      EndTD();
      BeginTD (100, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();
    EndTR();
  EndTable ();  
  PrintStatusLine_Cclient (user, uo, true, cclient->getMailboxName());
  }

void HTMLPages::BotoneraAttachs (const char *lang, const char *user, const char *connid, UserOptions *uo)
  {
  long actualpos, totalmsgs;
  int validator, pageid, actualcmd;
  
  actualpos = uo->getCurrentPosition();
  totalmsgs = uo->getTotalMsgs();
  validator = uo->getValidator();
  pageid    = uo->getPageId ();
  actualcmd = CMD_CCLIENT_AT_SHOW;
  
  BeginTable (0, 0, 0, 100);
    BeginTR(skin->getSkinAtribProp("COLOR_BGBOTONERA"));

      //BUTTON BACK
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("%s", uo->getLastStringCmd(CMD_CCLIENT_AT_SHOW, lang, connid, true));      
      Image (skin->getI(L_BACK), L->get(ALT_BACK), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_BACK));}
      WRITE ("</A>");
      EndTD();        
      //SPACE 
      EmptyCellx2();
      //BUTTON ROOT      
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/root/noop/%s/%s/%s/%d/%d/%d/%ld/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, uo->getValidator(),
         uo->getPageId(), uo->getLastCmd(), uo->getCurrentPosition());
      Image (skin->getI(L_ROOT), L->get(ALT_ROOT), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_ROOT));}
      WRITE ("</A>");
      EndTD();       
      //SPACE 
      EmptyCellx2();
      //BUTTON HELP   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      WRITE ("<A HREF=\"%s/%s/help/at_show/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, validator, pageid, actualcmd); 
      Image (skin->getI(L_HELP), L->get(ALT_HELP), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_HELP));}
      WRITE ("</A>");
      EndTD();  
      //SPACE 
      EmptyCellx2();
      //BUTTON LOGOUT   
      BeginTD (1, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center");
      if (uo->getConfirmLogout() == true)    
        {
        WRITE ("<A HREF=\"%s/%s/conf_act/logout/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, actualcmd);
        }
      else
        {  
        WRITE ("<A HREF=\"%s/%s/logout/noop/%s/%s/%s/%d/%d/%d/\">", PATH_CGI, SERVICE_MAIN, lang, user, connid, validator, pageid, actualcmd);
        }
      Image (skin->getI(L_LOGOUT), L->get(ALT_LOGOUT), skin->getISize());      
      if (skin->getDisplayButtonLabels()) {WRITE (" %s\n", L->get(ALT_LOGOUT));}
      WRITE ("</A>");
      EndTD();
      BeginTD (100, skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_BOTONERA_SIZE"), "center"); WRITE (HTML_HSP); EndTD();
    EndTR();
  EndTable ();  
  PrintStatusLine_Cclient (user, uo, true, cclient->getMailboxName());
  }

void HTMLPages::PrintIndexPage (const char *lang, const char *mailbox, const char *user, const char *connid, 
                           StringList *SLHeaders, StringList *SLMailboxes,
                           UserOptions *uo)
  {
  TBuffer pag_to_actualizar, tmpbuf;
  TSBuffer sbuf;
  TNumber anum;
  long nummsg, truenummsg, beginshow, endshow;
  uint i, cont;
  char *subject = NULL, *from = NULL;
  ldiv_t ld;
  long newbegin, aMAXMSGSFORPAGE = MAXMSGSFORPAGE;
  if (aMAXMSGSFORPAGE <= 0) aMAXMSGSFORPAGE = uo->getTotalMsgs();

  Head ("text/html", "", "");
  HTMLBegin ();
  
  ld = ldiv (uo->getTotalMsgs(), aMAXMSGSFORPAGE);
  newbegin = (ld.quot * aMAXMSGSFORPAGE) + 1;
  sprintf (pag_to_actualizar, "%s/%s/mb_index/noop/%s/%s/%s/%d/%d/%d/%ld/", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, uo->getValidator(), uo->getPageId(), CMD_CCLIENT_MB_INDEX, newbegin);
  
  if (strcasecmp (mailbox, "INBOX") == 0)
    {
    Title (L->get(TIT_INDEXMAILBOX), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"), 
           skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), uo->getRefreshTime(), pag_to_actualizar);  
    }
  else
    {
    Title (L->get(TIT_INDEXMAILBOX), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),           
           skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);
    }
  BotoneraMailboxIndex (lang, user, connid, uo);
  nummsg = uo->getBeginPage();
  if (uo->get_use_javascript() == true)
    {
    JavaScript(DEF_JavaIndexCheck);
    }
  i = 0;
  
  BeginTable (0, 2, 1, 100);
  BeginFormPost ("PrintIndexPage1", PATH_CGI);
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLEMSGINDEX"));  
  BeginTDColSpanCenter (7);
  if ((CALCULATEMAILBOXSIZE == 1) && (cclient->getServerProtocol() == PROTOCOL_IMAP))
    {
    WRITE (L->get(L_INDEXMAILBOX3), mailbox, uo->getTotalMsgs(), FormatCountBytes1Dec(uo->getMailboxSize(), tmpbuf)); 
    }
  else
    {
    WRITE (L->get(L_INDEXMAILBOX), mailbox, uo->getTotalMsgs());
    }
  beginshow =  nummsg;  
  endshow   = nummsg - 1 + (SLHeaders->Count() / 7);
  if (endshow == 0) {beginshow = 0;}
  if (endshow > 0) {WRITE (L->get(L_MSGS_SHOWN), beginshow, endshow);}
  EndTD();
  EndTR(); 
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  if (uo->get_use_javascript() == true)
    {
    BeginTD (skin->getSkinAtribProp("COLOR_BGFILASMSGINDEX")); JSFormCheckbox ("jscheckall", "", "if (this.checked) {putOn()} else {putOff()}", false); EndTD();     
    }
  else
    {
    BeginTD(true,  1, 1, skin->getSkinAtribProp("FONT_MAIN"), 2, "center"); WRITE (HTML_HSP); EndTD(); 
    }  
  BeginTD(true,  5, 1, skin->getSkinAtribProp("FONT_MAIN"), 2, "center"); 
  if (uo->getTotalMsgs() > 0)
    {WRITE ("<A HREF=\"%s/%s/mb_sort/number/%s/%s/%s/%d/%d/%d/\">%s</A>", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, uo->getValidator(), uo->getPageId(), CMD_CCLIENT_MB_INDEX, L->get(L_NUMBER));}
  else
    {WRITE ("%s", L->get(L_NUMBER));}
  EndTD();     
  BeginTD(true,  5, 1, skin->getSkinAtribProp("FONT_MAIN"), 2, "center"); 
    WRITE ("%s", L->get(L_FLAGS)); 
  EndTD();
  BeginTD(true, 10, 1, skin->getSkinAtribProp("FONT_MAIN"), 2, "center"); 
  if (uo->getTotalMsgs() > 0)
    {WRITE ("<A HREF=\"%s/%s/mb_sort/date/%s/%s/%s/%d/%d/%d/\">%s</A>", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, uo->getValidator(), uo->getPageId(), CMD_CCLIENT_MB_INDEX, L->get(L_DATE));}
  else
    {WRITE ("%s", L->get(L_DATE));}
  EndTD();     
  BeginTD(true, 25, 1, skin->getSkinAtribProp("FONT_MAIN"), 2, "center"); 
  if (uo->getTotalMsgs() > 0)
    {WRITE ("<A HREF=\"%s/%s/mb_sort/from/%s/%s/%s/%d/%d/%d/\">%s</A>", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, uo->getValidator(), uo->getPageId(), CMD_CCLIENT_MB_INDEX, L->get(L_FROM));}
  else
    {WRITE ("%s", L->get(L_FROM));}
  EndTD();     
  BeginTD(true, 49, 1, skin->getSkinAtribProp("FONT_MAIN"), 2, "center"); 
  if (uo->getTotalMsgs() > 0)
    {
    WRITE ("<A HREF=\"%s/%s/mb_sort/subject/%s/%s/%s/%d/%d/%d/\">%s</A>&nbsp;&nbsp;/&nbsp;&nbsp;", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, uo->getValidator(), uo->getPageId(), CMD_CCLIENT_MB_INDEX, L->get(L_SUBJECT));
    WRITE ("<A HREF=\"%s/%s/mb_sort/thread/%s/%s/%s/%d/%d/%d/\">%s</A>", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, uo->getValidator(), uo->getPageId(), CMD_CCLIENT_MB_INDEX, L->get(L_SORTBYTHREADS));
    }
  else
    {WRITE ("%s", L->get(L_SUBJECT));}
  EndTD();     
  BeginTD(true,  5, 1, skin->getSkinAtribProp("FONT_MAIN"), 2, "center"); 
  if (uo->getTotalMsgs() > 0)
    {WRITE ("<A HREF=\"%s/%s/mb_sort/size/%s/%s/%s/%d/%d/%d/\">%s</A>", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, uo->getValidator(), uo->getPageId(), CMD_CCLIENT_MB_INDEX, L->get(L_SIZE));}
  else
    {WRITE ("%s", L->get(L_SIZE));}
  EndTD();     
  EndTR();
  
  cont = SLHeaders->Count();
  while (i < cont) 
    { 
    truenummsg = xatoldef (SLHeaders->getString(i).cstr(), 1);
    
    WRITE ("<TR valign=baseline bgcolor=\"%s\">", skin->getSkinAtribProp("COLOR_BGFILASMSGINDEX"));
    
    //CHECKBOX
    BeginTD();
    FormCheckbox ("msgnumber", xltoa(truenummsg, anum), false); EndTD();

    //1. POSITION
    WRITE ("<TD align=\"right\"><FONT size=2 face=\"%s\"><B>%s.</B></FONT></TD>\n", skin->getSkinAtribProp("FONT_TABLE"), SLHeaders->getString(i).cstr());
    ++i;
    
    if (cclient->getServerProtocol() == PROTOCOL_IMAP)  
      {
      //2. FLAGS FOR IMAP
      WRITE ("<TD nowrap><FONT size=2 face=\"%s\"><B>%s</B></FONT></TD>\n", skin->getSkinAtribProp("FONT_TABLE"), Cclient_DisplayFlags(SLHeaders->getString(i).cstr(), false, "", 0, SERVICE_CCLIENT, tmpbuf));
      }
    else
      {
      //2. FLAGS FOR NNTP
      WRITE ("<TD nowrap><FONT size=2 face=\"%s\"><B>%s</B></FONT></TD>\n", skin->getSkinAtribProp("FONT_TABLE"), Cclient_DisplayFlags(SLHeaders->getString(i).cstr(), false, "", 0, SERVICE_CCLIENT, tmpbuf));
      }    
    
    ++i;
    //3. DATE
    WRITE ("<TD nowrap><FONT size=2 face=\"%s\"><B>%s</B></FONT></TD>\n", skin->getSkinAtribProp("FONT_TABLE"), SLHeaders->getString(i).cstr());
    ++i;

    //4. FROM
    from = Text2HTML(SLHeaders->getString((uint)i).cstr(), from);
    if (IsEmpty(from) == true) {from = xstrdup (L->get(L_NOFROM));}
    WRITE ("<TD nowrap><FONT size=2 face=\"%s\"><B>%s</B></FONT></TD>\n", skin->getSkinAtribProp("FONT_TABLE"), from);
    free (from);
    ++i;

    //5. SUBJECT
    subject = Text2HTML(SLHeaders->getString((uint)i).cstr(), subject);
    if (IsEmpty(subject) == true) {subject = xstrdup (L->get(L_NOSUBJECT));}
    WRITE ("<TD nowrap><FONT size=2 face=\"%s\"><B><A HREF=\"%s/%s/mg_display/noop/%s/%s/%s/%d/%d/%d/%ld/\">%s</A></B></FONT></TD>\n", 
            skin->getSkinAtribProp("FONT_TABLE"), PATH_CGI, SERVICE_CCLIENT, lang, user, connid, uo->getValidator(), uo->getPageId(), CMD_CCLIENT_MB_INDEX, 
            truenummsg, subject);
    free (subject);
    ++i;
    
    //6. SIZE   
    xstrncpy (sbuf, CSMALLBUFFER, SLHeaders->getString(i).cstr());                                                                                                           
    if (sbuf[strlen(sbuf) - 1] != 'K')
      {
      WRITE ("<TD align=\"right\"><FONT color=\"%s\" size=2 face=\"%s\"><B>%s</B></FONT></TD>\n", RED, skin->getSkinAtribProp("FONT_TABLE"), sbuf);
      }
    else
      {
      WRITE ("<TD align=\"right\"><FONT size=2 face=\"%s\"><B>%s</B></FONT></TD>\n", skin->getSkinAtribProp("FONT_TABLE"), sbuf);
      }
    ++i;
    
    //7. UID
    //WRITE ("<TD align=\"right\"><FONT size=2 face=\"%s\"><B>%ld</B></FONT></TD>\n", skin->getSkinAtribProp("FONT_TABLE"), SLHeaders->getString(i).cstr());
    ++i;
    
    EndTR();

    ++nummsg;
    }
  EndTable();
    
  if (endshow < uo->getTotalMsgs()) //PARA PASAR PAGINA AL FINAL DEL INDEX
    {   
    newbegin = uo->getBeginPage() + aMAXMSGSFORPAGE; 
    if (newbegin + aMAXMSGSFORPAGE > uo->getTotalMsgs())
      {
      ld = ldiv (uo->getTotalMsgs(), uo->getMsgsPerIndexPage());
      newbegin = (ld.quot * uo->getMsgsPerIndexPage()) + 1;
      } 
    WRITE ("<CENTER><FONT size=2><A HREF=\"%s/%s/mb_index/noop/%s/%s/%s/%d/%d/%d/%ld/\">[%s]</A></FONT></CENTER>", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, uo->getValidator(),
            uo->getPageId(), CMD_CCLIENT_MB_INDEX, newbegin,  L->get(L_NEXTPAGE_ACT));
    }
  else //ACTUALIZAR BUZON
    {
    if (cclient->getServerProtocol() == PROTOCOL_IMAP)
      {
      //DO NOT WORK WITH NNTP. WHY?
      WRITE ("<CENTER><FONT size=2><A HREF=\"%s\">[%s]</A></FONT></CENTER>", pag_to_actualizar, L->get(L_REFRESH));
      }
    }  
  
  BeginTable (5, 0, 0, 100);
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  WRITE ("<TD><FONT>"); EndTD();
  
  FormHidden ("service", SERVICE_CCLIENT); 
  FormHidden ("lang", lang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("validator", uo->getValidator());
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("lastcmd", CMD_CCLIENT_MB_INDEX);
  
  BeginTDCenter();
  FormButton ("theaction", L->get(L_MARK));
  Label (L->get(L_MSGS_AS));
  FormBeginSelect ("PrintIndexPage1", "cmd", NULL, uo->get_use_javascript()); 
  if (cclient->getServerProtocol() == PROTOCOL_IMAP)  
    {
    FormAddOptionSelect (true,  "fg_delete",     L->get(L_DELETED));
    FormAddOptionSelect (false, "fg_undelete",   L->get(L_UNDELETED));
    FormAddOptionSelect (false, "fg_answered",   L->get(L_ANSWEREDMSG));
    FormAddOptionSelect (false, "fg_unanswered", L->get(L_UNANSWEREDMSG));
    FormAddOptionSelect (false, "fg_unseen",     L->get(L_UNSEENMSG));
    FormAddOptionSelect (false, "fg_seen",       L->get(L_SEENMSG));  
    FormAddOptionSelect (false, "fg_flagged",    L->get(L_FLAGGEDMSG));
    FormAddOptionSelect (false, "fg_unflagged",  L->get(L_UNFLAGGEDMSG));
    }
  else
    {
    FormAddOptionSelect (true, "fg_seen",       L->get(L_SEENMSG));          
    FormAddOptionSelect (false, "fg_unseen",     L->get(L_UNSEENMSG));
    }  
  FormEndSelect();
  EndTD();
  
  BeginTD();  WRITE (HTML_HSP); EndTD();
  
  BeginTDCenter();
  FormBeginSelect ("PrintIndexPage1", "cmd2", NULL, uo->get_use_javascript()); 
  if (cclient->getServerProtocol() == PROTOCOL_IMAP)  
    {
    FormAddOptionSelect (false, "mg_move",     L->get(L_MOVEMSG));
    FormAddOptionSelect (false, "mg_copy",     L->get(L_COPYMSG));
    }
  FormAddOptionSelect (true,  "mb_change",   L->get(L_CHANGEMAILBOX));
  FormEndSelect();
  FormBeginSelect ("PrintIndexPage1", "mailboxname", "theaction2", uo->get_use_javascript()); 
  //FormAddOptionSelect (true, INBOX, "INBOX");
  TSBuffer abuzon;
  for (int Y=0; Y<SLMailboxes->Count(); ++Y)
    {
    //LOG ("--%s--", SLMailboxes->getString(Y).cstr());
    xstrncpy (abuzon, CSMALLBUFFER, SLMailboxes->getString(Y).cstr() + strlen(HTML_DCOMILLAS));
    abuzon [strlen(abuzon) - strlen(HTML_DCOMILLAS)] = '\0';
    
    XString XS;
    int ppos;
    XS = "";
    if (NCstrstr (abuzon, NNTPFOLDERHTMLPREFIX) == 1) //Mailbox from News
      {
      XS += abuzon;
      }
    else if (strcmp (abuzon, "INBOX") != 0)
      {
      ppos = NCstrstr (abuzon, uo->getMailboxPrefix());
      if (ppos > 0) {XS = XString (abuzon).substring(ppos + strlen(uo->getMailboxPrefix()) - 1);}
      else {XS = "/"; XS += abuzon;}
      }
    else {XS = "INBOX";}
    
    if (Y == 0) FormAddOptionSelect (true, SLMailboxes->getString(Y).cstr(), XS.cstr());
    else FormAddOptionSelect (false, SLMailboxes->getString(Y).cstr(), XS.cstr());
    }
  
  if (isAllowedService (uo->SLAllowedServices, uo->getDeniedServices(), -1, "nntp"))
    {
    FormAddOptionSelect (false, L->get(L_ADD_MORE_FORUMS), L->get(L_ADD_MORE_FORUMS));
    }
    
  FormEndSelect(); 
  FormButton ("theaction2", L->get(L_EXECUTE));
  EndTD();
  EndTR();
  
  EndForm ();
  
  BeginFormPost ("PrintIndexPage2", PATH_CGI);
  FormHidden ("service", SERVICE_CCLIENT);
  FormHidden ("lang", lang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("validator", uo->getValidator());
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("cmd", "mb_search");      
  FormHidden ("lastcmd", CMD_CCLIENT_MB_INDEX);    
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  WRITE ("<TD><FONT>"); EndTD();
  BeginTDColSpanCenter(3);   
  FormButton ("fd_tosearch", L->get(L_SEARCH));  
  FormBeginSelect ("PrintIndexPage2", "fieldtosearch", NULL, uo->get_use_javascript()); 
  FormAddOptionSelect (true,  "fd_subject", L->get(L_SEARCH_SUBJECT));
  FormAddOptionSelect (false, "fd_from",    L->get(L_SEARCH_FROM));
  FormAddOptionSelect (false, "fd_body",    L->get(L_SEARCH_BODY));
  FormAddOptionSelect (false, "fd_all",     L->get(L_SEARCH_ALL));
  FormEndSelect();
  WRITE ("<INPUT TYPE=TEXT NAME=\"whatsearch\" SIZE=\"40\" MAXLENGTH=\"100\" VALUE=\"\">\n"); 
  EndTD();
  EndTR();    
  EndForm();  
  EndTable();
  if (DEBUGGING_APP == 1) 
    {
    WRITE ("<BR><A HREF=\"%s/%s/debug/noop/%s/%s/%s/%d/%d/%d/%ld/\">PAGINA DE DEBUG</A>\n", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, uo->getValidator(),uo->getPageId(), CMD_CCLIENT_MB_INDEX, uo->getCurrentPosition());
    }
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }

void HTMLPages::dumpAttach (const char *chunk, xulong len, StringList *SLAttachInfo)
  {
  TBuffer tiposubtipo, fn;
  xstrncpy (tiposubtipo, CMAXBUFFER, SLAttachInfo->getString(3).cstr());
  xstrncat (tiposubtipo, CMAXBUFFER, "/");
  xstrncat (tiposubtipo, CMAXBUFFER, SLAttachInfo->getString(4).cstr());
  if (SLAttachInfo->getString(6).cstr() != NULL) xstrncpy (fn, CMAXBUFFER, SLAttachInfo->getString(6).cstr());
  else if (SLAttachInfo->getString(7).cstr() != NULL) xstrncpy (fn, CMAXBUFFER, SLAttachInfo->getString(7).cstr()); 
  else initStr (fn);
  HeadInline (tiposubtipo, fn, len);  
  if (chunk == NULL) pcWRITE ("NULL"); 
  else pcWRITEBuffer (chunk, len);
  }  
  
void HTMLPages::dumpRawAttachPC (const char *pcheader, xulong lenheader, const char *pcbody, xulong lenbody)
  {
  pcWRITEBuffer (pcheader, lenheader);
  pcWRITEBuffer (pcbody, lenbody);
  }    
  
void HTMLPages::dumpRawAttachSL (StringList *SLAttachHeader, const char *pcbody, xulong lenbody)
  {
  for (int i = 0; i < SLAttachHeader->Count() - 1; ++i)
    {
    pcWRITEBuffer (SLAttachHeader->getString((uint)i).cstr(), 
                   strlen(SLAttachHeader->getString((uint)i).cstr()));
    }
  pcWRITEBuffer ("\r\n", 2);  
  pcWRITEBuffer (pcbody, lenbody);  
  }      
  
void HTMLPages::dumpAttachWithoutHead (const char *chunk, xulong len)
  {
  if (chunk == NULL) pcWRITE ("NULL"); 
  else pcWRITEBuffer (chunk, len);
  }    
  
void HTMLPages::PrintMessageHeader 
                        (const char *lang, const char *user, const char *connid, 
                         long nummsgs, 
                         const char *aflags, const char *ato, const char *afrom, const char *areplyto, const char *acc, const char *asubject, const char *adate, const char *asize,
                         StringList *SLAttachs,
                         UserOptions *uo, ULongList *LL)
  {
  bool isdeleted, displayreplyall;
  XString JS;
  xulong i, Partes, size;
  char *fileName, *pc = NULL;
  TBuffer attid, contenttype, basura, molde, tmpbuf;
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_MESSAGEHEADER), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
        skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);  
  if (strchr (aflags,  FDELETED) == NULL) isdeleted = false; else isdeleted = true;
  displayreplyall = MustDoReplayAll (ato, afrom, areplyto, acc);  
  BotoneraDisplayMsg (lang, user, connid, uo, isdeleted, LL, displayreplyall, true);
  BeginTable (0, 2, 1, 100);
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginTDColSpanCenter (3); WRITE (L->get(L_MESSAGE), uo->getCurrentPosition(), nummsgs, asize); BR(); EndTD();
  EndTR();
  
  if (cclient->getServerProtocol() == PROTOCOL_IMAP) 
    {              
    BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
    BeginTD(10); Label (L->get(L_FLAGS)); EndTD();    
    sprintf (molde, "%s/%s/%s/%d/%d/%d/%ld/\">", 
             lang, user, connid, uo->getValidator(), uo->getPageId(), CMD_CCLIENT_MG_DISPLAY, uo->getCurrentPosition());
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "left", 1); JS = Cclient_DisplayFlags(aflags, true, molde, 1, SERVICE_CCLIENT, tmpbuf); WRITE (JS.cstr()); EndTD();
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "right", 1);JS = Cclient_DisplayFlags(aflags, true, molde, 2, SERVICE_CCLIENT, tmpbuf); WRITE (JS.cstr()); EndTD(); 
    EndTR();       
    }
  
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginTD(10); Label (L->get(L_SUBJECT)); EndTD();
  BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "left", 2); JS = Text2HTML(asubject, pc); free (pc); WRITE (JS.cstr()); EndTD();
  EndTR();
  
  if (cclient->getServerProtocol() == PROTOCOL_IMAP) 
    {
    BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
    BeginTD(10); Label (L->get(L_TO)); EndTD();
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "left", 2); JS = Text2HTML(ato, pc); free (pc); WRITE (JS.cstr()); EndTD();                                                 
    EndTR();
    }
  else if (cclient->getServerProtocol() == PROTOCOL_NNTP)
    {
    BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));  
    BeginTD(10); Label (L->get(L_NNTPGROUP)); EndTD();
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "left", 2); 
    JS = Text2HTML(ato, pc); 
    free (pc); 
    WRITE (JS.cstr()); 
    EndTD();                                                 
    EndTR();    
    }
  
  //SHOW CC FIELD ONLY IF EXISTS  
  if ((acc != NULL) && (strcmp (acc, "") != 0))
    {
    BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
    BeginTD(10); Label (L->get(L_CC)); EndTD();
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "left", 2); 
    JS = Text2HTML(acc, pc); 
    free (pc); 
    WRITE (JS.cstr()); 
    EndTD();
    EndTR();  
    }
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginTD(10); Label (L->get(L_FROM)); EndTD();
  BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "left", 2); JS = Text2HTML(afrom, pc); free (pc); WRITE (JS.cstr()); EndTD();
  EndTR();
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginTD(10); Label (L->get(L_DATE)); EndTD();
  BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "left", 1); JS = Text2HTML(adate, pc); free (pc); WRITE (JS.cstr()); EndTD();
  BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "right", 1);
  sprintf (molde, "%s/%s/mg_dumpfullheader/noop/%s/%s/%s/%d/%d/%d/%ld/", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, uo->getValidator(), uo->getPageId(), CMD_CCLIENT_MG_DISPLAY, uo->getCurrentPosition());
  URLIMAGE (L->get (ALT_DUMPFULLHEADER), molde, skin->getI(L_DUMPFULLHEADER));
  sprintf (molde, "%s/%s/mg_dumpfullmsg/noop/%s/%s/%s/%d/%d/%d/%ld/", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, uo->getValidator(), uo->getPageId(), CMD_CCLIENT_MG_DISPLAY, uo->getCurrentPosition());
  URLIMAGE (L->get (ALT_DUMPFULLMSG), molde, skin->getI(L_DUMPFULLMSG));
  EndTD();
  EndTR();    
  EndTable();
  Linea ();
  
  Partes = SLAttachs->Count();
  if (Partes > 1)  //SHOW ATT INDEX WHEN THERE ARE MORE THAN 1 ATTACH
    {
    BeginFont (skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_MAIN_SIZE"), skin->getSkinAtribProp("COLOR_FONT_MAIN"));  
    H4(L->get (L_STRUCTMIME));
    for (i=0; i< Partes; ++i)
      {
      sscanf (SLAttachs->getString((xuint)i).cstr(), "%s %s %ld %s", attid, contenttype, &size, basura);
      const char *str = SLAttachs->getString(xuint(i)).cstr();
      fileName = get_filename(str);
      WRITE ("<A HREF=\"%s/%s/at_dump/noop/%s/%s/%s/%d/%d/%d/%ld/%s/%s\">%s</A>", 
             PATH_CGI, SERVICE_CCLIENT, lang, user, connid, uo->getValidator(), uo->getPageId(), CMD_CCLIENT_MG_DISPLAY,
             uo->getCurrentPosition(), attid, fileName, SLAttachs->getString((uint)i).cstr());
      free((void *)fileName);
      if ((strstr (contenttype, "TEXT/") != NULL) && (size <= MAXTEXTSIZEATTACHFORDISPLAY))
        {
        WRITE ("<FONT COLOR=\"%s\">  %s</FONT>", RED, L->get(L_ATTACHSHOWED));
        }       
      WRITE ("<BR>\n");       
      }
    Linea ();
    EndFont();
    }
  else if (Partes == 1) //SHOW ATT INDEX WHEN THERE ARE ONLY ONE BUT THIS IS NOT TEXT/xxx
    {
    sscanf (SLAttachs->getString(0).cstr(), "%s %s %ld %s", attid, contenttype, &size, basura);
    if (strstr (contenttype, "TEXT/") == NULL)
      {
      BeginFont (skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_MAIN_SIZE"), skin->getSkinAtribProp("COLOR_FONT_MAIN"));  
      H4(L->get (L_STRUCTMIME));
      const char *str = SLAttachs->getString(0).cstr();
      fileName = get_filename(str);
      WRITE ("<A HREF=\"%s/%s/at_dump/noop/%s/%s/%s/%d/%d/%d/%ld/%s/%s\">%s</A>", 
             PATH_CGI, SERVICE_CCLIENT, lang, user, connid, uo->getValidator(), uo->getPageId(), CMD_CCLIENT_MG_DISPLAY,
             uo->getCurrentPosition(), attid, fileName, SLAttachs->getString(0).cstr());
      free((void *)fileName);
      if ((strstr (contenttype, "TEXT/") != NULL) && (size <= MAXTEXTSIZEATTACHFORDISPLAY))
        {
        WRITE ("<FONT COLOR=\"%s\">  %s</FONT>", RED, L->get(L_ATTACHSHOWED));
        }       
      WRITE ("<BR>\n");       
      Linea ();
      EndFont();          
      }
    }  
  }  

void HTMLPages::PrintMessageTail
                        (const char *lang, const char *user, const char *connid, 
                         long nummsgs, 
                         const char *aflags, const char *ato, const char *afrom, const char *areplyto, const char *acc, const char *asubject, const char *adate, const char *asize,
                         StringList *SLAttachs,
                         UserOptions *uo, ULongList *LL)
  {
  bool isdeleted, displayreplyall;
  if (strchr (aflags,  FDELETED) == NULL) isdeleted = false; else isdeleted = true;
  displayreplyall = MustDoReplayAll (ato, afrom, areplyto, acc);  
  BotoneraDisplayMsg (lang, user, connid, uo, isdeleted, LL, displayreplyall, false);
  }  

void HTMLPages::PrintMailboxesPage (const char *lang, const char *mailbox, const char *user, const char *connid, 
                               StringList *SLMailboxes, UserOptions *uo)
  {
  int i;
  StringList *SLMailboxesSinComillas;
  TSBuffer abuzon;
  SLMailboxesSinComillas = new StringList();
  for (i=0; i<SLMailboxes->Count(); ++i)
    {
    xstrncpy (abuzon, CSMALLBUFFER, SLMailboxes->getString(i).cstr() + strlen(HTML_DCOMILLAS));
    abuzon [strlen(abuzon) - strlen(HTML_DCOMILLAS)] = '\0';
    if (strcmp(SLMailboxes->getString(i).cstr(), FORM_SELECT_SEPARATOR) == 0)
      {
      SLMailboxesSinComillas->Add (SLMailboxes->getString(i).cstr());
      }
    else {SLMailboxesSinComillas->Add (abuzon);}
    }
  
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_MAILBOXES), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
        skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);  
  BotoneraComun (CMD_CCLIENT_MB_SHOW, lang, user, connid, uo);
  BeginTable (1, 2, 1, 100);
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginTDColSpanCenter (2); WRITE (L->get(L_INDEXMAILBOX4), mailbox, uo->getTotalMsgs()); EndTD();
  BeginTR(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"));
  BeginFormPost ("PrintMailboxesPage1", PATH_CGI);
  BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "right"); 
    FormButton ("theaction", L->get(L_CHANGEMAILBOX)); EndTD();   
  BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG")); 
  FormHidden ("service", SERVICE_CCLIENT);
  FormHidden ("lang", lang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("cmd", "mb_change");
  FormHidden ("validator", uo->getValidator());
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("lastcmd", CMD_CCLIENT_MB_SHOW);  
  FormBeginSelect ("PrintMailboxesPage1", "mailboxname", NULL, uo->get_use_javascript()); 
  //FormAddOptionSelect (true, INBOX, "INBOX");
  for (i=0; i<SLMailboxes->Count(); ++i)
    {
    XString XS;
    int ppos;
    XS = "";
    if (strcmp (SLMailboxesSinComillas->getString(i).cstr(), "INBOX") != 0)
      {
      ppos = NCstrstr (SLMailboxesSinComillas->getString(i).cstr(), uo->getMailboxPrefix());
      if (ppos > 0) {XS = XString (SLMailboxesSinComillas->getString(i).cstr()).substring(ppos + strlen(uo->getMailboxPrefix()) - 1);}
      else 
        {
        if (NCstrstr (SLMailboxesSinComillas->getString(i).cstr(), NNTPFOLDERHTMLPREFIX) == 1) //Mailbox from News
          {
          XS = XString (SLMailboxesSinComillas->getString(i).cstr()).substring(ppos + strlen(NNTPFOLDERPREFIX) - 1);
          }
        else {XS = "/"; XS += SLMailboxesSinComillas->getString(i).cstr();}
        }
      }
    else {XS = "INBOX";}
    if (i == 0) FormAddOptionSelect (true, SLMailboxes->getString(i).cstr(), XS.cstr()); 
    else FormAddOptionSelect (false, SLMailboxes->getString(i).cstr(), XS.cstr()); 
    }
  FormEndSelect();  
  EndTD();
  EndTR(); 
  EndForm ();
  
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginFormPost ("PrintMailboxesPage2", PATH_CGI);
  FormHidden ("service", SERVICE_CCLIENT);
  FormHidden ("lang", lang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("cmd", "mb_create");
  FormHidden ("validator", uo->getValidator());
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("lastcmd", CMD_CCLIENT_MB_SHOW);
  BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "right"); FormButton ("theaction", L->get(L_CREATEMAILBOX)); EndTD();     
  BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE")); FormEdit (16, 16, "mailboxname", "");     EndTD();
  EndForm ();
  EndTR();

  if (SLMailboxes->Count () > 0)
    {
    BeginTR(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"));
    BeginFormPost ("PrintMailboxesPage3", PATH_CGI);
    FormHidden ("lang", lang);
    FormHidden ("user", user);
    FormHidden ("connid", connid);
    FormHidden ("validator", uo->getValidator());
    FormHidden ("pageid", uo->getPageId());
    FormHidden ("lastcmd", CMD_CCLIENT_MB_SHOW);
    if (CONFIRM_DELETEMAILBOX == 1)
      {
      FormHidden ("service", SERVICE_MAIN);
      FormHidden ("subcmd", "mb_clear");
      FormHidden ("cmd", "conf_act");
      }
    else 
      {
      FormHidden ("service", SERVICE_CCLIENT);
      FormHidden ("cmd", "mb_clear");
      }
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "right"); FormButton ("theaction", L->get(L_CLEARMAILBOX)); EndTD();
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"));
    FormBeginSelect ("PrintMailboxesPage3", "mailboxname", NULL, uo->get_use_javascript()); 
    for (int j=0; j<SLMailboxes->Count(); ++j)
      {
      XString XS;
      int ppos;
      XS = "";
      if (strcmp (SLMailboxesSinComillas->getString(j).cstr(), "INBOX") != 0)
        {
        ppos = NCstrstr (SLMailboxesSinComillas->getString(j).cstr(), uo->getMailboxPrefix());
        if ((ppos > 0) && (!IsEmpty(uo->getMailboxPrefix())))
          {
          XS = XString (SLMailboxesSinComillas->getString(j).cstr()).substring(ppos + strlen(uo->getMailboxPrefix()) - 1);
          }
        else 
          {
          if (NCstrstr (SLMailboxesSinComillas->getString(j).cstr(), NNTPFOLDERHTMLPREFIX) == 1)
            {
            }
          else if (IsEmpty(uo->getMailboxPrefix()))
            {
            XS = XString (SLMailboxesSinComillas->getString(j).cstr());
            }  
          else 
            {
            XS = "/"; XS += SLMailboxesSinComillas->getString(j).cstr();
            }
          }
        }
      else {XS = "INBOX";}
      
      if ((XS != "INBOX") && (XS != "") 
          && (strcmp (SLMailboxes->getString(j).cstr(), FORM_SELECT_SEPARATOR) != 0))
        {       
        if (j == 0)  FormAddOptionSelect (true, SLMailboxes->getString(j).cstr(), XS.cstr());
        else FormAddOptionSelect (false, SLMailboxes->getString(j).cstr(), XS.cstr());
        }
      }
    FormEndSelect();  
    EndTD();
    EndTR();   
    EndForm ();          
    }
    
  if (SLMailboxes->Count () > 0)
    {
    BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
    BeginFormPost ("PrintMailboxesPage4", PATH_CGI);
    FormHidden ("lang", lang);
    FormHidden ("user", user);
    FormHidden ("connid", connid);
    FormHidden ("validator", uo->getValidator());
    FormHidden ("pageid", uo->getPageId());
    FormHidden ("lastcmd", CMD_CCLIENT_MB_SHOW);
    if (CONFIRM_DELETEMAILBOX == 1)
      {
      FormHidden ("service", SERVICE_MAIN);
      FormHidden ("subcmd", "mb_delete");
      FormHidden ("cmd", "conf_act");
      }
    else 
      {
      FormHidden ("service", SERVICE_CCLIENT);
      FormHidden ("cmd", "mb_delete");
      }
    BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "right"); FormButton ("theaction", L->get(L_DELETEMAILBOX)); EndTD();
    BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"));
    FormBeginSelect ("PrintMailboxesPage4", "mailboxname", NULL, uo->get_use_javascript()); 
    for (int j=0; j<SLMailboxes->Count(); ++j)
      {
      XString XS;
      int ppos;
      XS = "";
      if (strcmp (SLMailboxesSinComillas->getString(j).cstr(), "INBOX") != 0)
        {
        ppos = NCstrstr (SLMailboxesSinComillas->getString(j).cstr(), uo->getMailboxPrefix());
        if ((ppos > 0) && (!IsEmpty(uo->getMailboxPrefix())))
          {
          XS = XString (SLMailboxesSinComillas->getString(j).cstr()).substring(ppos + strlen(uo->getMailboxPrefix()) - 1);
          }
        else 
          {
          if (NCstrstr (SLMailboxesSinComillas->getString(j).cstr(), NNTPFOLDERHTMLPREFIX) == 1) //Mailbox from News
            {
            //DO NOT ALLOW DELETE NNTP FOLDERS
            }
          else if (IsEmpty(uo->getMailboxPrefix()))
            {
            XS = XString (SLMailboxesSinComillas->getString(j).cstr());
            }  
          else 
            {
            XS = "/"; XS += SLMailboxesSinComillas->getString(j).cstr();
            }
          }
        }
      else {XS = "INBOX";}
      
      if ((XS != "INBOX") && (XS != "") 
          && (strcmp (SLMailboxes->getString(j).cstr(), FORM_SELECT_SEPARATOR) != 0))
        {       
        if (j == 0)  FormAddOptionSelect (true, SLMailboxes->getString(j).cstr(), XS.cstr());
        else FormAddOptionSelect (false, SLMailboxes->getString(j).cstr(), XS.cstr());
        }
      }
    FormEndSelect();  
    EndTD();
    EndTR();   
    EndForm ();          
    BeginTR(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"));
    BeginFormPost ("PrintMailboxesPage5", PATH_CGI);
    FormHidden ("service", SERVICE_CCLIENT);
    FormHidden ("lang", lang);
    FormHidden ("user", user);
    FormHidden ("connid", connid);
    FormHidden ("cmd", "mb_rename");
    FormHidden ("validator", uo->getValidator());
    FormHidden ("pageid", uo->getPageId());
    FormHidden ("lastcmd", CMD_CCLIENT_MB_SHOW);
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "right"); FormButton ("theaction", L->get(L_RENAMEMAILBOX)); EndTD();
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"));
    FormBeginSelect ("PrintMailboxesPage5", "oldmailboxname", NULL, uo->get_use_javascript()); 
    for (int k=0; k<SLMailboxes->Count(); ++k)
      {
      XString XS;
      int ppos;
      XS = "";
      if (strcmp (SLMailboxesSinComillas->getString(k).cstr(), "INBOX") != 0)
        {
        ppos = NCstrstr (SLMailboxesSinComillas->getString(k).cstr(), uo->getMailboxPrefix());
        if ((ppos > 0) && (!IsEmpty(uo->getMailboxPrefix()))) 
          {
          XS = XString (SLMailboxesSinComillas->getString(k).cstr()).substring(ppos + strlen(uo->getMailboxPrefix()) - 1);
          }
        else 
          {
          if (NCstrstr (SLMailboxesSinComillas->getString(k).cstr(), NNTPFOLDERHTMLPREFIX) == 1) //Mailbox from News
            {
            //DO NOT ALLOW RENAME NNTP FOLDERS
            }
          else if (IsEmpty(uo->getMailboxPrefix()))
            {
            XS = XString (SLMailboxesSinComillas->getString(k).cstr());
            }              
          else 
            {
            XS = "/"; XS += SLMailboxesSinComillas->getString(k).cstr();
            }
          }
        }
      else {XS = "INBOX";}    
      
      if ((XS != "INBOX") && (XS != "") 
          && (strcmp (SLMailboxes->getString(k).cstr(), FORM_SELECT_SEPARATOR) != 0))
        {       
        if (k == 0)  FormAddOptionSelect (true, SLMailboxes->getString(k).cstr(), XS.cstr());
        else FormAddOptionSelect (false, SLMailboxes->getString(k).cstr(), XS.cstr());
        }
      }
    FormEndSelect();  
    WRITE ("%s<B>%s</B>%s\n", HTML_HSP, L->get(L_LEX_TO), HTML_HSP);
    FormEdit (16, 16, "newmailboxname", ""); 
    EndTD();
    EndTR();
    EndForm ();
    }  
  
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginFormPost ("PrintMailboxesPage6", PATH_CGI);
  FormHidden ("service", SERVICE_CCLIENT);
  FormHidden ("lang", lang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("cmd", "mb_dump");
  FormHidden ("validator", uo->getValidator());
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("lastcmd", CMD_CCLIENT_MB_SHOW);   
  BeginTD(skin->getSkinAtribProp("COLOR_BGTABLE"), "right"); FormButton ("theaction", L->get(L_DOWNLOADMAILBOX)); EndTD();     
  BeginTD(); WRITE(HTML_HSP); WRITE(HTML_HSP); Label (mailbox); EndTD();
  EndForm ();
  EndTable();          
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  delete SLMailboxesSinComillas;
  }  
        
void HTMLPages::PrintComposeMsgPage (int thecmd, int subcmd, const char *lang, const char *user, const char *connid, 
                                const char *to, const char *cc, const char *bcc, const char *subject, 
                                const char *replyto, const char *from, const char *date,
                                const char *firsttext,
                                UserOptions *uo)
  {
  TBuffer abuf, amsg, temp;
  int thecmd_x, p, length_fields;
  char *pc = NULL;
  XString JS, JS2, JS3, JS4;
  Head ("text/html", "", "");
  HTMLBegin ();
  
  length_fields = uo->getWidthWriteArea() - 10;
  if ((uo->get_use_javascript() == true) && (USETIMEOUT == 1))
    {
    long restotime = (uo->getTimeout() - (5 * 60)) * 1000;
    sprintf (amsg, DEF_JavaAlertToDisabled, restotime, L->get(MSG_GO_TO_DISABLED));
    JavaScript(amsg);
    }
  
  switch (thecmd)
    {
    case CMD_CCLIENT_CM:            Title (L->get(TIT_COMPOSEMSG), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"), skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL); break;
    case CMD_CCLIENT_CMNNTP:        Title (L->get(TIT_COMPOSEMSGNNTP), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"), skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL); break;    
    case CMD_CCLIENT_CM_REPLY:      Title (L->get(TIT_REPLYMSG), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"), skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL); break; 
    case CMD_CCLIENT_CM_REPLYGROUP: Title (L->get(TIT_REPLYGROUP), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"), skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL); break;     
    case CMD_CCLIENT_CM_REPLYALL:   Title (L->get(TIT_REPLYALLMSG), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"), skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL); break;
    case CMD_CCLIENT_CM_FORWARD:    Title (L->get(TIT_FORWARDMSG), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"), skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL); break;
    }
  BotoneraComposeMsg (subcmd, lang, user, connid, uo);
  /*silly_table*/WRITE ("<CENTER><TABLE width=\"100%%\"><TR><TD>\n");
  BeginFormPost ("PrintComposeMsgPage1", PATH_CGI);
  BeginFont (skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_MAIN_SIZE"), skin->getSkinAtribProp("COLOR_FONT_MAIN"));
  FormButton ("cm_save", L->get(L_SAVE));
  //REMOVED AT THIS MOMENT FormButton ("cm_cancel",   L->get(L_CANCELMSG));
  if ((cclient->getServerProtocol() == PROTOCOL_IMAP) || (thecmd == CMD_CCLIENT_CM_REPLY) ||
      (thecmd == CMD_CCLIENT_CM_FORWARD))
    {                       
    FormButton ("cm_send",   L->get(L_SENDMSG));
    }
  else
    {
    FormButton ("cm_sendnntp",   L->get(L_SENDMSG));
    }
  FormButton ("at_show", L->get(L_ATTACHMSG));
  FormButton ("cm_cleanall", L->get(L_CLEANALL));
  if (cclient->getServerProtocol() == PROTOCOL_IMAP) 
    {                       
    FormButton ("ab_from_cm", L->get(L_ADDBOOK));  
    }
  FormHidden ("service", SERVICE_CCLIENT);  
  FormHidden ("lang", lang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("lastcmd", thecmd);  
  FormHidden ("cmd", "cm");
  FormHidden ("validator", uo->getValidator());
  FormHidden ("numattachs", uo->numAttachs());  
  
  //ESTO ES PARA QUE AL VOLVER A UN MENSAJE QUE ESTOY HACIENDO UN REPLY (o FORWARD) NO ME EJECUTE
  //   EL REPLY SINO QUE BUSQUE EL MSG GUARDADO Y LO MUESTRE
  thecmd_x = thecmd;
  if (uo->getLastCmd() != CMD_CCLIENT_MG_DISPLAY) 
    {
    if (cclient->getServerProtocol() == PROTOCOL_IMAP) 
      {
      thecmd_x = CMD_CCLIENT_CM;
      }
    else
      {
      thecmd_x = CMD_CCLIENT_CMNNTP;
      }  
    }
  switch (thecmd_x)
    {
    case CMD_CCLIENT_CM: 
      BeginTable (0, 0, 1, 50);
      BeginTR(); BeginTD(); Label (L->get (L_TO));      EndTD(); BeginTD(); 
        if (IsEmpty(to) == true)
          {
          FormEdit (MAXLENGTH_TO, length_fields, "to", Text2HTML(getLineFile(uo->getfnSavedMsg(), 2, 2, temp), pc)); free (pc); 
          }
        else
          {
          FormEdit (MAXLENGTH_TO, length_fields, "to", to); 
          }            
      EndTD(); EndTR(); 
      if (USERCANCHANGEFROM == 1)
        {
        BeginTR(); BeginTD(); Label (L->get (L_FROM)); EndTD(); BeginTD(); 
        if (strcmp (getLineFile(uo->getfnSavedMsg(), 6, 6, temp), "") == 0)
          {
          if (uo->getPersonalName() != NULL)
            {
            sprintf (temp, "%s%s%s@%s%s", uo->getPersonalName(), HTML_MENOR, user, uo->getMailDomain(), HTML_MAYOR);
            }
          else
            {
            sprintf (temp, "%s@%s", user, uo->getMailDomain());
            }
          FormEdit (MAXLENGTH_FROM, length_fields, "from", Text2HTML(temp, pc)); free (pc);
          }
        else 
          {
          FormEdit (MAXLENGTH_FROM, length_fields, "from", Text2HTML(getLineFile(uo->getfnSavedMsg(), 6, 6, temp), pc)); free (pc);    
          }       
        EndTD(); EndTR();            
        }
      else FormHidden ("from", "");  
      BeginTR(); BeginTD(); Label (L->get (L_CC));      EndTD(); BeginTD(); 
        if (IsEmpty(cc) == true)
          {
          FormEdit (MAXLENGTH_TO, length_fields, "cc", Text2HTML(getLineFile(uo->getfnSavedMsg(), 3, 3, temp), pc)); free (pc);     
          }    
        else
          {
          FormEdit (MAXLENGTH_TO, length_fields, "cc", cc);     
          }                
      EndTD(); EndTR();
      BeginTR(); BeginTD(); Label (L->get (L_BCC));     EndTD(); BeginTD(); 
        if (IsEmpty(bcc) == true)
          {
          FormEdit (MAXLENGTH_TO, length_fields, "bcc", Text2HTML(getLineFile(uo->getfnSavedMsg(), 4, 4, temp), pc)); free (pc);    
          }
        else
          {
          FormEdit (MAXLENGTH_TO, length_fields, "bcc", bcc);
          }      
      EndTD(); EndTR();
      BeginTR(); BeginTD(); Label (L->get (L_SUBJECT)); EndTD(); BeginTD(); 
        if (IsEmpty(subject) == true)
          {
          FormEdit (255, length_fields, "subject", Text2HTML(getLineFile(uo->getfnSavedMsg(), 5, 5, temp), pc)); free (pc);
          }
        else
          {
          FormEdit (255, length_fields, "subject", subject);          
          }
      EndTD(); EndTR();
      EndTable ();
      
      if (FileExists (uo->getfnSavedMsg()) == false)
        {
        FormCheckbox ("savemsgsentmail", bool2char(uo->getSaveMsgSentMail()), uo->getSaveMsgSentMail()); WRITE (L->get(L_SAVEMSGSENTMAIL)); WRITE ("<B>\"%s\"</B>", uo->getSentMailName()); BR();  
        }
      else
        {                                                
        FormCheckbox ("savemsgsentmail", getLineFile(uo->getfnSavedMsg(), 1, 1, temp), char2bool(getLineFile(uo->getfnSavedMsg(), 1, 1, temp))); WRITE (L->get(L_SAVEMSGSENTMAIL)); WRITE ("<B>\"%s\"</B>", uo->getSentMailName()); BR();
        }
      if (uo->numAttachs () > 0)
        {
        Label (L->get(L_ATTACHMSG));
        WRITE ("<UL>");
        for (int i = 0; i < uo->numAttachs (); ++i)
          {
          WRITE ("<LI><B>%d. %s&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[%s]</B>\n", i + 1, uo->getFileNameAttach(i), uo->getAttachInfo(i));
          }
        WRITE ("</UL>");          
        }
      Label (L->get(L_TEXTTOSEND)); BR();
      if (IsEmpty(firsttext) == true)
        {
        if (IsEmpty(getLineFile(uo->getfnSavedMsg(), 7, -1, temp)))
          {
          if (uo->getInsertSignatureInNewMsg() == true) {JS = "\n--\n"; JS += uo->getSignature();} else {JS = "";}
          }
        else
          {
          JS = getLineFile(uo->getfnSavedMsg(), 7, -1, NULL);
          } 
        }
      else
        {
        JS = firsttext;
        }    
      EndFont();
      FormTextArea (uo->getHeightWriteArea(), uo->getWidthWriteArea(), "texttosend", Text2HTML(JS.cstr(), pc), false); BR(); free (pc);
      break;
    case CMD_CCLIENT_CM_REPLY:               
      BeginTable (0, 0, 1, 50);
      BeginTR(); BeginTD(); Label (L->get (L_TO));      EndTD(); BeginTD(); 
      xstrncpy (abuf, CMAXBUFFER, user); 
      xstrncat (abuf, CMAXBUFFER, "@"); 
      xstrncat (abuf, CMAXBUFFER, uo->getMailDomain());
      //Reply to field TO or to field REPLYTO in imap mode
      //   in nntp mode we reply to "from" field ("to" field is the newsgroup)      
      if (cclient->getServerProtocol() == PROTOCOL_NNTP)
        {
        FormEdit (MAXLENGTH_TO, length_fields, "to", Text2HTML(from, pc)); free (pc); EndTD(); EndTR();
        }
      else if ((uo->getReplyFrom() == true) || ((uo->getReplyFrom() == false) && (strcmp (replyto, "") == 0)))
        {
        //If the FROM field is the same that user@maildomain then use TO field
        if (strstr (from, abuf) == NULL)
          {
          FormEdit (MAXLENGTH_TO, length_fields, "to", Text2HTML(from, pc)); free (pc); EndTD(); EndTR();
          }
        else
          {
          FormEdit (MAXLENGTH_TO, length_fields, "to", Text2HTML(to, pc)); free (pc); EndTD(); EndTR();
          }
        }
      else
        {
        //If the REPLYTO field is the same that user@maildomain then use FROM field
        if (strstr (replyto, abuf) == NULL)
          {
          FormEdit (MAXLENGTH_TO, length_fields, "to", Text2HTML(replyto, pc)); free (pc); EndTD(); EndTR();
          }
        else
          {
          FormEdit (MAXLENGTH_TO, length_fields, "to", Text2HTML(from, pc)); free (pc); EndTD(); EndTR();
          }
        }
      if (USERCANCHANGEFROM == 1)
        {
        BeginTR(); BeginTD(); Label (L->get (L_FROM)); EndTD(); BeginTD(); 
        if (strcmp (getLineFile(uo->getfnSavedMsg(), 6, 6, temp), "") == 0)
          {
          sprintf (temp, "%s@%s", user, uo->getMailDomain());
          FormEdit (MAXLENGTH_FROM, length_fields, "from", Text2HTML(temp, pc)); free (pc);
          }
        else 
          {
          FormEdit (MAXLENGTH_FROM, length_fields, "from", Text2HTML(getLineFile(uo->getfnSavedMsg(), 6, 6, temp), pc)); free (pc);    
          }       
        EndTD(); EndTR();            
        }
      else FormHidden ("from", "");  
      BeginTR(); BeginTD(); Label (L->get (L_CC));      EndTD(); BeginTD(); FormEdit (MAXLENGTH_TO, length_fields, "cc", Text2HTML(cc, pc));   free (pc); EndTD(); EndTR();
      BeginTR(); BeginTD(); Label (L->get (L_BCC));     EndTD(); BeginTD(); FormEdit (MAXLENGTH_TO, length_fields, "bcc", Text2HTML(bcc, pc)); free (pc); EndTD(); EndTR();
      
      JS = L->get (PREFIX_REPLY);
      JS2 = XString (Text2HTML(subject, pc)).trim(); free (pc);
      p = NCstrstr (JS2.cstr(), L->get (PREFIX_REPLY));
      if (p == 1) {JS = JS2;} else {JS += (Text2HTML(subject, pc)); free (pc);}
      BeginTR(); BeginTD(); Label (L->get (L_SUBJECT)); EndTD(); BeginTD(); 
      FormEdit (255, length_fields, "subject", JS.cstr()); EndTD(); EndTR();
      EndTable ();                                                                        
      FormCheckbox ("savemsgsentmail", "1", uo->getSaveMsgSentMail()); WRITE (L->get(L_SAVEMSGSENTMAIL)); WRITE ("<B>\"%s\"</B>", uo->getSentMailName()); BR();  
      if (uo->numAttachs () > 0)
        {
        Label (L->get(L_ATTACHMSG));
        WRITE ("<UL>");
        for (int i = 0; i < uo->numAttachs (); ++i)
          {
          WRITE ("<LI><B>%d. %s&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[%s]</B>\n", i + 1, 
                 uo->getFileNameAttach(i), uo->getAttachInfo(i));
          }
        WRITE ("</UL>");          
        }      
      Label (L->get(L_TEXTTOSEND)); BR();
      JS2 = "\n"; 
      JS2 += REPLY_BEGIN_LINE;
      if (uo->getInsertSignatureInNewMsg() == true) {JS3 = "\n--\n"; JS3 += uo->getSignature(); JS3 += "\n\n";} else {JS3 = "";}      
      JS = REPLY_BEGIN_LINE; JS += firsttext;
      JS.Cut (MAXLENGTH_IN_REPLY);
      JS.replace (XString("\n"), JS2);
      JS4 = "\n\n"; JS4 += JS; JS4 += "\n\n"; JS4 += JS3;
      EndFont();
      FormTextArea (uo->getHeightWriteArea(), uo->getWidthWriteArea(), "texttosend", Text2HTML(JS4.cstr(), pc), false); free (pc); BR();
      break;
    case CMD_CCLIENT_CMNNTP:  
      if (SHOW_NNTP_SEND_WARNING == 1)
        {
        WRITE ("<BR>\n");
        RedRectangle (L->get (MSG_NNTP_SEND_WARNING));
        WRITE ("<BR>\n");
        }
      BeginTable (0, 0, 1, 50);
      BeginTR(); BeginTD(); Label (L->get (L_TO));      EndTD(); BeginTD(); 
        Label (cclient->getMailboxName());
      EndTD(); EndTR(); 
      FormHidden ("to", cclient->getMailboxName());

      if (USERCANCHANGEFROM == 1)
        {
        BeginTR(); BeginTD(); Label (L->get (L_FROM)); EndTD(); BeginTD(); 
        if (strcmp (getLineFile(uo->getfnSavedMsg(), 6, 6, temp), "") == 0)
          {
          if (uo->getPersonalName() != NULL)
            {
            sprintf (temp, "%s%s%s@%s%s", uo->getPersonalName(), HTML_MENOR, user, uo->getMailDomain(), HTML_MAYOR);
            }
          else
            {
            sprintf (temp, "%s@%s", user, uo->getMailDomain());
            }
          FormEdit (MAXLENGTH_FROM, length_fields, "from", Text2HTML(temp, pc)); free (pc);
          }
        else 
          {
          FormEdit (MAXLENGTH_FROM, length_fields, "from", Text2HTML(getLineFile(uo->getfnSavedMsg(), 6, 6, temp), pc)); free (pc);   
          }       
        EndTD(); EndTR();            
        }
      else FormHidden ("from", "");  
      BeginTR(); BeginTD(); Label (L->get (L_SUBJECT)); EndTD(); BeginTD(); 
        FormEdit (255, length_fields, "subject", Text2HTML(getLineFile(uo->getfnSavedMsg(), 5, 5, temp), pc)); free (pc);
      EndTD(); EndTR();
      EndTable ();
      
      if (FileExists (uo->getfnSavedMsg()) == false)
        {
        FormCheckbox ("savemsgsentmail", bool2char(uo->getSaveMsgSentMail()), uo->getSaveMsgSentMail()); WRITE (L->get(L_SAVEMSGSENTMAIL)); WRITE ("<B>\"%s\"</B>", uo->getSentMailName()); BR();  
        }
      else
        {                                                
        FormCheckbox ("savemsgsentmail", getLineFile(uo->getfnSavedMsg(), 1, 1, temp), char2bool(getLineFile(uo->getfnSavedMsg(), 1, 1, temp))); WRITE (L->get(L_SAVEMSGSENTMAIL)); WRITE ("<B>\"%s\"</B>", uo->getSentMailName()); BR();
        }
      if (uo->numAttachs () > 0)
        {
        Label (L->get(L_ATTACHMSG));
        WRITE ("<UL>");
        for (int i = 0; i < uo->numAttachs (); ++i)
          {
          WRITE ("<LI><B>%d. %s&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[%s]</B>\n", i + 1, 
                 uo->getFileNameAttach(i), uo->getAttachInfo(i));
          }
        WRITE ("</UL>");          
        }
      Label (L->get(L_TEXTTOSEND)); BR();
      if (IsEmpty(getLineFile(uo->getfnSavedMsg(), 7, -1, temp)))
        {
        if (uo->getInsertSignatureInNewMsg() == true) 
          {JS = "\n--\n"; JS += uo->getSignature();} else {JS = "";}
        }
      else
        {
        JS = getLineFile(uo->getfnSavedMsg(), 7, -1, NULL);
        } 
      EndFont();
      FormTextArea (uo->getHeightWriteArea(), uo->getWidthWriteArea(), "texttosend", Text2HTML(JS.cstr(), pc), false); free (pc); BR();
      break;
    case CMD_CCLIENT_CM_REPLYGROUP:               
      if (SHOW_NNTP_SEND_WARNING == 1)
        {
        WRITE ("<BR>\n");
        RedRectangle (L->get (MSG_NNTP_SEND_WARNING));
        WRITE ("<BR>\n");
        }
      BeginTable (0, 0, 1, 50);
      BeginTR(); BeginTD(); Label (L->get (L_TO));      EndTD(); BeginTD(); 
      xstrncpy (abuf, CMAXBUFFER, user); 
      xstrncat (abuf, CMAXBUFFER, "@"); 
      xstrncat (abuf, CMAXBUFFER, uo->getMailDomain());
      
      //Reply to News Group      
      Label (cclient->getMailboxName());
      FormHidden ("to", cclient->getMailboxName());
      
      if (USERCANCHANGEFROM == 1)
        {
        BeginTR(); BeginTD(); Label (L->get (L_FROM)); EndTD(); BeginTD(); 
        if (strcmp (getLineFile(uo->getfnSavedMsg(), 6, 6, temp), "") == 0)
          {
          sprintf (temp, "%s@%s", user, uo->getMailDomain());
          FormEdit (MAXLENGTH_FROM, length_fields, "from", Text2HTML(temp, pc)); free (pc);
          }
        else 
          {
          FormEdit (MAXLENGTH_FROM, length_fields, "from", Text2HTML(getLineFile(uo->getfnSavedMsg(), 6, 6, temp), pc)); free (pc);
          }       
        EndTD(); EndTR();            
        }
      else FormHidden ("from", "");  
      
      JS = L->get (PREFIX_REPLY);
      JS2 = XString (Text2HTML(subject, pc)).trim(); free (pc);
      p = NCstrstr (JS2.cstr(), L->get (PREFIX_REPLY));
      if (p == 1) {JS = JS2;} else {JS += (Text2HTML(subject, pc)); free(pc);}
      BeginTR(); BeginTD(); Label (L->get (L_SUBJECT)); EndTD(); BeginTD(); 
      FormEdit (255, length_fields, "subject", JS.cstr()); EndTD(); EndTR();
      EndTable ();                                                                        
      FormCheckbox ("savemsgsentmail", "1", uo->getSaveMsgSentMail()); WRITE (L->get(L_SAVEMSGSENTMAIL)); WRITE ("<B>\"%s\"</B>", uo->getSentMailName()); BR();  
      if (uo->numAttachs () > 0)
        {
        Label (L->get(L_ATTACHMSG));
        WRITE ("<UL>");
        for (int i = 0; i < uo->numAttachs (); ++i)
          {
          WRITE ("<LI><B>%d. %s&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[%s]</B>\n", i + 1, 
                 uo->getFileNameAttach(i), uo->getAttachInfo(i));
          }
        WRITE ("</UL>");          
        }      
      Label (L->get(L_TEXTTOSEND)); BR();
      JS2 = "\n"; 
      JS2 += REPLY_BEGIN_LINE;
      if (uo->getInsertSignatureInNewMsg() == true) {JS3 = "\n--\n"; JS3 += uo->getSignature(); JS3 += "\n\n";} else {JS3 = "";}      
      JS = REPLY_BEGIN_LINE; JS += firsttext;
      JS.Cut (MAXLENGTH_IN_REPLY);
      JS.replace (XString("\n"), JS2);
      JS4 = "\n\n"; JS4 += JS; JS4 += "\n\n"; JS4 += JS3;
      EndFont();
      FormTextArea (uo->getHeightWriteArea(), uo->getWidthWriteArea(), "texttosend", Text2HTML(JS4.cstr(), pc), false); free(pc); BR();
      break;      
    case CMD_CCLIENT_CM_REPLYALL:               
      BeginTable (0, 0, 1, 50);
      BeginTR(); BeginTD(); Label (L->get (L_TO));      EndTD(); BeginTD(); 
      xstrncpy (abuf, CMAXBUFFER, user); 
      xstrncat (abuf, CMAXBUFFER, "@"); 
      xstrncat (abuf, CMAXBUFFER, uo->getMailDomain());
      
      FormEdit (MAXLENGTH_TO, length_fields, "to", Text2HTML(getReplyAllAddresses(to, from, replyto, cc), pc)); free (pc); EndTD(); EndTR();        
      if (USERCANCHANGEFROM == 1)
        {
        BeginTR(); BeginTD(); Label (L->get (L_FROM)); EndTD(); BeginTD(); 
        if (strcmp (getLineFile(uo->getfnSavedMsg(), 6, 6, temp), "") == 0)
          {
          sprintf (temp, "%s@%s", user, uo->getMailDomain());
          FormEdit (MAXLENGTH_FROM, length_fields, "from", Text2HTML(temp, pc)); free (pc);
          }
        else 
          {
          FormEdit (MAXLENGTH_FROM, length_fields, "from", Text2HTML(getLineFile(uo->getfnSavedMsg(), 6, 6, temp), pc)); free(pc);    
          }       
        EndTD(); EndTR();            
        }
      else FormHidden ("from", "");  
      BeginTR(); BeginTD(); Label (L->get (L_CC));      EndTD(); BeginTD(); FormEdit (MAXLENGTH_TO, length_fields, "cc", "");           EndTD(); EndTR();
      BeginTR(); BeginTD(); Label (L->get (L_BCC));     EndTD(); BeginTD(); FormEdit (MAXLENGTH_TO, length_fields, "bcc", "");         EndTD(); EndTR();
      
      JS = L->get (PREFIX_REPLY);
      JS2 = XString (Text2HTML(subject, pc)).trim(); free(pc); 
      p = NCstrstr (JS2.cstr(), L->get (PREFIX_REPLY));
      if (p == 1) {JS = JS2;} else {JS += (Text2HTML(subject, pc)); free (pc);}
      BeginTR(); BeginTD(); Label (L->get (L_SUBJECT)); EndTD(); BeginTD(); 
      FormEdit (255, length_fields, "subject", JS.cstr()); EndTD(); EndTR();
      EndTable ();                                                                        
      FormCheckbox ("savemsgsentmail", "1", uo->getSaveMsgSentMail()); WRITE (L->get(L_SAVEMSGSENTMAIL)); WRITE ("<B>\"%s\"</B>", uo->getSentMailName()); BR();  
      if (uo->numAttachs () > 0)
        {
        Label (L->get(L_ATTACHMSG));
        WRITE ("<UL>");
        for (int i = 0; i < uo->numAttachs (); ++i)
          {
          WRITE ("<LI><B>%d. %s&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[%s]</B>\n", i + 1, 
                 uo->getFileNameAttach(i), uo->getAttachInfo(i));
          }
        WRITE ("</UL>");          
        }      
      Label (L->get(L_TEXTTOSEND)); BR();
      JS2 = "\n"; 
      JS2 += REPLY_BEGIN_LINE;
      if (uo->getInsertSignatureInNewMsg() == true) {JS3 = "\n--\n"; JS3 += uo->getSignature(); JS3 += "\n\n";} else {JS3 = "";}      
      JS = REPLY_BEGIN_LINE; JS += firsttext;
      JS.Cut (MAXLENGTH_IN_REPLY);
      JS.replace (XString("\n"), JS2);
      JS4 = "\n\n"; JS4 += JS; JS4 += "\n\n"; JS4 += JS3;
      EndFont();
      FormTextArea (uo->getHeightWriteArea(), uo->getWidthWriteArea(), "texttosend", Text2HTML(JS4.cstr(), pc), false); free (pc); BR();
      break;            
    case CMD_CCLIENT_CM_FORWARD:
      BeginTable (0, 0, 1, 50);
      BeginTR(); BeginTD(); Label (L->get (L_TO));      EndTD(); BeginTD(); 
      FormEdit (MAXLENGTH_TO, length_fields, "to", ""); EndTD(); EndTR();
      if (USERCANCHANGEFROM == 1)
        {
        BeginTR(); BeginTD(); Label (L->get (L_FROM)); EndTD(); BeginTD(); 
        if (strcmp (getLineFile(uo->getfnSavedMsg(), 6, 6, temp), "") == 0)
          {
          sprintf (temp, "%s@%s", user, uo->getMailDomain());
          FormEdit (MAXLENGTH_FROM, length_fields, "from", Text2HTML(temp, pc)); free (pc);
          }
        else 
          {
          FormEdit (MAXLENGTH_FROM, length_fields, "from", Text2HTML(getLineFile(uo->getfnSavedMsg(), 6, 6, temp), pc)); free (pc);    
          }       
        EndTD(); EndTR();            
        }
      else FormHidden ("from", "");  
      BeginTR(); BeginTD(); Label (L->get (L_CC));      EndTD(); BeginTD(); FormEdit (MAXLENGTH_TO, length_fields, "cc", Text2HTML(cc, pc));   free (pc); EndTD(); EndTR();
      BeginTR(); BeginTD(); Label (L->get (L_BCC));     EndTD(); BeginTD(); FormEdit (MAXLENGTH_TO, length_fields, "bcc", Text2HTML(bcc, pc)); free (pc); EndTD(); EndTR();
      JS = L->get (PREFIX_FORWARD); JS += (Text2HTML(subject, pc)); free (pc);
      BeginTR(); BeginTD(); Label (L->get (L_SUBJECT)); EndTD(); BeginTD(); 
      FormEdit (255, length_fields, "subject", JS.cstr()); EndTD(); EndTR();
      EndTable ();
      FormCheckbox ("savemsgsentmail", "1", uo->getSaveMsgSentMail()); WRITE (L->get(L_SAVEMSGSENTMAIL)); WRITE ("<B>\"%s\"</B>", uo->getSentMailName()); BR();  
      if (uo->numAttachs () > 0)
        {
        Label (L->get(L_ATTACHMSG));
        WRITE ("<UL>");
        for (int i = 0; i < uo->numAttachs (); ++i)
          {
          WRITE ("<LI><B>%d. %s&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;[%s]</B>\n", i + 1, 
                 uo->getFileNameAttach(i), uo->getAttachInfo(i));
          }
        WRITE ("</UL>");          
        }
      Label (L->get(L_TEXTTOSEND)); BR();
      JS = "\n\n\n";
      if (uo->getInsertSignatureInNewMsg() == true) {JS += "--\n"; JS += uo->getSignature(); JS += "\n\n";}
      JS += L->get(FORWARDLINE); JS += "\n"; 
      if (strcmp(to, "")     != 0) {JS += L->get(L_TO);      JS += to;      JS += "\n";}
      if (strcmp(subject, "")!= 0) {JS += L->get(L_SUBJECT); JS += subject; JS += "\n";}
      if (strcmp(replyto, "")!= 0) {JS += L->get(L_REPLYTO); JS += replyto; JS += "\n";}
      if (strcmp(from, "")   != 0) {JS += L->get(L_FROM);    JS += from;    JS += "\n";}
      if (strcmp(date, "")   != 0) {JS += L->get(L_DATE);    JS += date;    JS += "\n";}
      JS += "\n"; 
      JS += firsttext;  
      EndFont();
      FormTextArea (uo->getHeightWriteArea(), uo->getWidthWriteArea(), "texttosend", Text2HTML(JS.cstr(), pc), false); free (pc); BR();      
      break;  
    }
  EndForm();   
  /*end_silly_table*/WRITE("</TD></TR></TABLE></CENTER>\n");  
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }

void HTMLPages::PrintShowAttachs (const char *stlang, const char *user, const char *connid, UserOptions *uo)
  {
  TNumber anum;
  char *pc = NULL;
  XString XS;
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_SHOWATTACHS), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
        skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);
  BotoneraAttachs (stlang, user, connid, uo);
  Linea ();
  BeginFont (skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_MAIN_SIZE"), skin->getSkinAtribProp("COLOR_FONT_MAIN"));    
  if (uo->numAttachs() > 0)
    {
    BeginFormPost ("PrintShowAttachs1", PATH_CGI);
    FormHidden ("service", SERVICE_CCLIENT);
    FormHidden ("lang", stlang);
    FormHidden ("user", user);
    FormHidden ("connid", connid);
    FormHidden ("cmd", "cm");
    FormHidden ("validator", uo->getValidator());    
    FormHidden ("pageid", uo->getPageId());
    FormHidden ("lastcmd", CMD_CCLIENT_AT_SHOW);    
    Label (L->get(L_ATTACHMSG)); BR();    
    for (int i=0; i < uo->numAttachs(); ++i) 
      {
      FormCheckbox ("attnumber", xltoa(i, anum), false); 
      XS = ""; 
      XS += xitoa(i + 1, anum); 
      XS += ". "; 
      XS += Text2HTML(uo->getFileNameAttach(i), pc); free (pc); 
      XS += "&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;["; 
      XS += Text2HTML(uo->getAttachInfo(i), pc); free (pc); XS += "]<BR>\n";
      WRITE ("<B><FONT COLOR=\"%s\">%s</FONT></B>", RED, XS.cstr());
      }
    BR();
    FormButton ("at_erase", L->get(L_DETACH));
    EndForm ();
    }   
  else
    {
    Label (L->get(L_NO_ATTACHS)); BR();
    }
  Linea ();
  BeginFormPostMultipartFormData ("PrintShowAttachs2", PATH_CGI);
  FormHidden ("service", SERVICE_CCLIENT);
  FormHidden ("lang", stlang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("cmd", "cm");
  FormHidden ("validator", uo->getValidator());  
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("lastcmd", CMD_CCLIENT_AT_SHOW);
  Label (L->get(L_ATTACH_NEW)); BR();
  Label (L->get(L_FILE)); FormFile (255, 30, "file", "", "*"); BR();
  FormButton ("at_save", L->get(L_DOATTACH));
  EndForm ();
  EndFont();
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }
  
void HTMLPages::PrintAddBook_Show (int thecmd, const char *stlang, const char *user, const char *connid, 
                              UserOptions *uo, Addressbook *ab, int sortby)
  {
  TBuffer abuf;
  TNumber anum;
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_ADDBOOK), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);
  BotoneraComun (thecmd, stlang, user, connid, uo);
  
  
  BeginTable (0, 2, 1, 100);
  BeginTR();
  //BOTON NEW ENTRY
  WRITE ("<TD ALIGN=\"left\" WIDTH=\"1%%\"><CENTER>");
  WRITE ("<A HREF=\"%s/%s/ab/ab_newentry/%s/%s/%s/%d/%d/%d/\">\n", PATH_CGI, SERVICE_CCLIENT, stlang, user, connid, 
          uo->getValidator(), uo->getPageId(), thecmd);
  Image (skin->getI(L_AB_NEWENTRY_S), L->get(ALT_AB_NEWENTRY_S), "");      
  WRITE ("<FONT size=2 face=\"%s\" color=\"%s\">\n", TABLEFACEFONT, BLACK);
  WRITE (" %s\n", L->get(L_AB_NEWENTRY_S));
  WRITE ("</FONT></A></CENTER>\n");
  EndTD();
  //BOTON DUMP          
  WRITE ("<TD ALIGN=\"left\" WIDTH=\"1%%\"><CENTER>");
  WRITE ("<A HREF=\"%s/%s/ab/ab_dump/%s/%s/%s/%d/%d/%d/\">\n", PATH_CGI, SERVICE_CCLIENT, stlang, user, connid, 
         uo->getValidator(), uo->getPageId(), thecmd); 
  Image (skin->getI(L_AB_DUMP_S), L->get(ALT_AB_DUMP_S), "");      
  WRITE ("<FONT size=2 face=\"%s\" color=\"%s\">\n", TABLEFACEFONT, BLACK);
  WRITE (" %s\n", L->get(L_AB_DUMP_S));
  WRITE ("</FONT></A></CENTER>\n");
  EndTD();
  //BOTON ADD SELECTED ADDRESSES  
  WRITE ("<TD ALIGN=\"center\" VALIGN=\"bottom\"WIDTH=\"99%%\">");
  BeginFormPost ("PrintAddBook_Show1", PATH_CGI);
  FormHidden ("service", SERVICE_CCLIENT);
  FormHidden ("lang", stlang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("validator", uo->getValidator());
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("lastcmd", uo->getLastCmd());  
  FormHidden ("cmd", "ab_addfields");
  FormButton ("theaction", L->get(L_ADDADDRESS_FIELD));  
  EndTD();
  EndTR();
  EndTable (); 
  
  BeginTable (1, 2, 1, 100);  
  //CASILLA NUMBER OF ENTRIES
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginTDColSpanCenter (10); WRITE ("<B>%s: %d</B>\n", L->get(L_NUMOFENTRIES), ab->Count ()); EndTD();
  EndTR();
  
  //LABELS
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginTD(); Label("&nbsp;"); EndTD();
  BeginTD(); Label(L->get(L_TO0)); EndTD();
  BeginTD(); Label(L->get(L_CC0)); EndTD();
  BeginTD(); Label(L->get(L_BCC0)); EndTD();
  BeginTD(); Label("&nbsp;"); EndTD();

  sprintf (abuf, "%s/%s/ab/ab_sort/%s/%s/%s/%d/%d/%d/0/", PATH_CGI, SERVICE_CCLIENT, stlang, user, connid, 
           uo->getValidator(), uo->getPageId(), uo->getLastCmd()); 
  BeginTD(); URL (L->get(L_AB_NICKNAME), abuf); EndTD();
  
  sprintf (abuf, "%s/%s/ab/ab_sort/%s/%s/%s/%d/%d/%d/1/", PATH_CGI, SERVICE_CCLIENT, stlang, user, connid, 
           uo->getValidator(), uo->getPageId(), uo->getLastCmd()); 
  BeginTD(); URL (L->get(L_AB_FULLNAME), abuf); EndTD();
    
  sprintf (abuf, "%s/%s/ab/ab_sort/%s/%s/%s/%d/%d/%d/2/", PATH_CGI, SERVICE_CCLIENT, stlang, user, connid, 
           uo->getValidator(), uo->getPageId(), uo->getLastCmd()); 
  BeginTD(); URL (L->get(L_AB_ADDRESSES), abuf); EndTD();   

  sprintf (abuf, "%s/%s/ab/ab_sort/%s/%s/%s/%d/%d/%d/3/", PATH_CGI, SERVICE_CCLIENT, stlang, user, connid, 
           uo->getValidator(), uo->getPageId(), uo->getLastCmd()); 
  BeginTD(); URL (L->get(L_ADDBOOK), abuf); EndTD();     
  
  BeginTD(); WRITE ("<U>%s</U>\n", L->get(L_AB_COMMENTS)); EndTD();
  EndTR();
  ab->SORT(sortby);

  WRITE ("<FONT size=2 face=\"%s\" color=\"%s\">\n", TABLEFACEFONT, BLACK);

  for (int N = 0; N < ab->Count (); ++N)
    {    
    if ((IsMultiplo (N, 20) == true) && (N > 0))
      {
      BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));

      WRITE ("<TD><B>&nbsp;</B></TD>\n");
      WRITE ("<TD><B>%s</B></TD>\n", L->get(L_TO0));
      WRITE ("<TD><B>%s</B></TD>\n", L->get(L_CC0));            
      WRITE ("<TD><B>%s</B></TD>\n", L->get(L_BCC0));
      WRITE ("<TD><B>&nbsp;</B></TD>\n");      
      WRITE ("<TD><B>%s</B></TD>\n", L->get(L_AB_NICKNAME));      
      WRITE ("<TD><B>%s</B></TD>\n", L->get(L_AB_FULLNAME));
      WRITE ("<TD><B>%s</B></TD>\n", L->get(L_AB_ADDRESSES));
      WRITE ("<TD><B>%s</B></TD>\n", L->get(L_ADDBOOK));
      WRITE ("<TD><B>%s</B></TD>\n", L->get(L_AB_COMMENTS));            
      EndTR();      
      }     
    WRITE ("<TR valign=baseline bgcolor=\"%s\">\n", skin->getSkinAtribProp("COLOR_BGFILASADDBOOK"));
    WRITE ("<TD><B>%s</B></TD>\n", xitoa(N + 1, anum));

    WRITE ("<TD>"); FormCheckbox ("numentryto",  xitoa(N + 1, anum), false); WRITE ("</TD>\n");
    WRITE ("<TD>"); FormCheckbox ("numentrycc",  xitoa(N + 1, anum), false); WRITE ("</TD>\n");
    WRITE ("<TD>"); FormCheckbox ("numentrybcc", xitoa(N + 1, anum), false); WRITE ("</TD>\n");
    WRITE ("<TD>"); 
      WRITE ("<A HREF=\"%s/%s/ab/ab_editentry/%s/%s/%s/%d/%d/%d/%d/\">", 
             PATH_CGI, SERVICE_CCLIENT, stlang, user, connid, uo->getValidator(), uo->getPageId(), uo->getLastCmd(), N); 
      Image (skin->getI(L_EDIT), L->get(L_EDIT), "");
      WRITE ("</A>");
    WRITE ("</TD>\n");
    WRITE ("<TD>"); WRITE (CutSign(ForceSpace(ab->getNickname  (N)), 20, CUTINDICATOR, abuf)); WRITE ("</TD>\n");
    WRITE ("<TD>"); WRITE (CutSign(ForceSpace(ab->getFullname  (N)), 20, CUTINDICATOR, abuf)); WRITE ("</TD>\n");
    WRITE ("<TD>"); WRITE (CutSign(ForceSpace(ab->getAddresses (N)), 20, CUTINDICATOR, abuf)); WRITE ("</TD>\n");
    WRITE ("<TD>"); WRITE (CutSign(ForceSpace(ab->getFcc       (N)), 20, CUTINDICATOR, abuf)); WRITE ("</TD>\n");
    WRITE ("<TD>"); WRITE (CutSign(ForceSpace(ab->getComment   (N)), 20, CUTINDICATOR, abuf)); WRITE ("</TD>\n");
    
    EndTR();
    }
  WRITE ("</FONT>\n");
  EndTable ();  
  
  EndForm ();
    
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }         

void HTMLPages::PrintAddBook_Dump (int thecmd, const char *stlang, const char *user, const char *connid, 
                              UserOptions *uo, Addressbook *ab, int sortby)
  {
  int NUM;
  XString as;
  Head ("text/html", "", "");
  ab->SORT(sortby);
  NUM = ab->Count ();
  if (NUM <= 0)
    {
    WRITE ("%s\n", L->get(MSG_NO_ELEMENTS));
    }
  else
    {  
    WRITE ("<PRE>\n");
    for (int N = 0; N < ab->Count (); ++N)
      {
      WRITE ("<BR>#%d ------------------------------------------\n", N + 1);
      WRITE ("<BR>%s: %s\n", L->get(L_AB_NICKNAME),  ab->getNickname  (N));    
      WRITE ("<BR>%s: %s\n", L->get(L_AB_FULLNAME),  ab->getFullname  (N));
      WRITE ("<BR>%s: %s\n", L->get(L_ADDBOOK),   ab->getFcc       (N));         
      WRITE ("<BR>%s: %s\n", L->get(L_AB_COMMENTS),  ab->getComment   (N));
      as = ab->getAddresses (N); 
      as.replace (",", "<BR>");
      WRITE ("<BR>%s\n", as.cstr());    
      }
    WRITE ("</PRE>\n");      
    }
  }

void HTMLPages::PrintAddBook_EditEntry (int thecmd, const char *stlang, const char *user, const char *connid, 
                                   UserOptions *uo, Addressbook *ab, int numentry)
  {
  TNumber anum;
  char *pc = NULL;
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_ADDBOOK), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
         skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);
  BotoneraComun (thecmd, stlang, user, connid, uo);
  Linea();
  BeginFont (skin->getSkinAtribProp("FONT_MAIN"), skin->getSkinAtribPropI("FONT_MAIN_SIZE"), skin->getSkinAtribProp("COLOR_FONT_MAIN"));  
  BeginFormPost ("PrintAddBook_EditEntry1", PATH_CGI);
  FormHidden ("service", SERVICE_CCLIENT);
  FormHidden ("lang", stlang);
  FormHidden ("user", user);
  FormHidden ("connid", connid);
  FormHidden ("cmd", "ab");
  FormHidden ("numentry", xitoa(numentry, anum));
  FormHidden ("validator", uo->getValidator()); 
  FormHidden ("pageid", uo->getPageId());
  FormHidden ("lastcmd", thecmd);    
  FormButton ("ab_saveentry", L->get(L_SAVE));
  if (thecmd == CMD_CCLIENT_AB_EDITENTRY) FormButton ("ab_deleentries", L->get(L_DELETE));
  else FormButton ("ab_deleentries", L->get(L_CANCEL));
  BeginTable (1, 2, 1, 100);
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginTD(); Label (L->get(L_AB_NICKNAME)); EndTD();
  BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG")); 
  if (numentry > -1) {FormEdit (255, 50, "nickname", Text2HTML(ab->getNickname(numentry), pc)); free (pc);}
  else {FormEdit (255, 50, "nickname", "");}
  EndTD();  
  EndTR();
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginTD(); Label (L->get(L_AB_FULLNAME)); EndTD();
  BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG")); 
  if (numentry > -1) {FormEdit (255, 50, "fullname", Text2HTML(ab->getFullname(numentry), pc)); free (pc);}
  else {FormEdit (255, 50, "fullname", "");}
  EndTD();  
  EndTR();
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginTD(); Label (L->get(L_AB_ADDRESSES)); EndTD();                
  BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG")); 
  if (numentry > -1) {FormEdit (MAXLENGTH_TO, 50, "addresses", Text2HTML(ab->getAddresses(numentry), pc)); free (pc);} 
  else {FormEdit (MAXLENGTH_TO, 50, "addresses", "");}
  EndTD();  
  EndTR();  
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginTD(); Label (L->get(L_ADDBOOK)); EndTD();                
  BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG")); 
  if (numentry > -1) {FormEdit (255, 50, "fcc", Text2HTML(ab->getFcc(numentry), pc)); free (pc);} 
  else {FormEdit (255, 50, "fcc", "");}
  EndTD();  
  EndTR();    
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginTD(); Label (L->get(L_AB_COMMENTS)); EndTD();
  BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG")); 
  if (numentry > -1) {FormEdit (255, 50, "comments", Text2HTML(ab->getComment(numentry), pc)); free (pc);} 
  else {FormEdit (255, 50, "comments", "");}
  EndTD();  
  EndTR();  
  EndTable ();  
  EndForm ();
  EndFont();

  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }           
    
void HTMLPages::PrintFullHeaders (StringList *SLHeaders, UserOptions *uo, const char *asize)
  {
  TBuffer abuf;
  XString JSUno, JSDos;
  int p;
  char *pc = NULL;
    
  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(TIT_SHOWHEADERS), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
        skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);  
  BeginTable (0, 2, 1, 100);
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginTDColSpanCenter (3); BeginBold(); WRITE (L->get(TIT_SHOWHEADERS)); EndBold(); EndTD(); EndTR();
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
  BeginTDColSpanCenter (3); WRITE (L->get(L_MESSAGE), uo->getCurrentPosition(), uo->getTotalMsgs(), asize); EndTD(); EndTR();
  for (int i=0; i< SLHeaders->Count(); ++i)
    {
    BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));    
    xstrncpy (abuf, CMAXBUFFER, SLHeaders->getString(i).cstr());
    p = NCstrstr (abuf, ":");
    if ((p > 0) && (abuf[0] != SP) && (abuf[0] != '\x009'))
      {
      JSUno = XString (abuf).substring (0, p);
      JSDos = XString (abuf).substring (p); 
      }
    else
      {
      JSUno = "";
      JSDos = abuf;
      }
    JSDos.replace ("\n", "");   
    BeginTD(10); WRITE ("<B>%s</B>", Text2HTML(JSUno.cstr(), pc)); free (pc); EndTD();
    BeginTD(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"), "left", 2);
    WRITE (Text2HTML(JSDos.cstr(), pc));  free (pc);
    EndTD();
    EndTR();
    }
  EndTable();  
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  }

const char *Cclient_DisplayFlags(const char *flags, bool clickable, const char *molde, 
                                 int show_way, const char *aservice, TBuffer abuf)
  {
  XString XS;
  char c;
  TBuffer tmpbuf;
  
  //show_way = 0: All flags
  //show_way = 1: Active flags
  //show_way = 2: Inactive flags
  
  XS = HTML_HSP; XS += "\n";
  for (xuint i=0; i < strlen (flags); ++i)
    {
    c = flags[i];
    if (i == POS_FLAG_DELETED)
      {
      if ((c == FDELETED) && ((show_way == 0) || (show_way == 1)))
        {
        if (clickable)
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/mg_fg_undelete/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;
          }
        XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_DELETED); XS += "\" ALT=\"("; XS += L->get(L_FLAG_DELETED); XS += ")\">";
        if (clickable) XS += "</A>\n";
        }
      else
        {  
        if ((c == FEMPTY) && (clickable) && ((show_way == 0) || (show_way == 2)))
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/mg_fg_delete/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;
          XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_UNDELETED); XS += "\" ALT=\"("; XS += L->get(L_FLAG_UNDELETED); XS += ")\">";
          XS += "</A>\n";
          }
        }
      }
    else if (i == POS_FLAG_SEARCHED)
      {
      if ((c == FSEARCHED) && ((show_way == 0) || (show_way == 1)))
        {
        if (clickable)
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/mg_fg_unsearched/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;                                           
          }
        XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_SEARCHED); XS += "\" ALT=\"("; XS += L->get(L_FLAG_SEARCHED); XS += ")\">";        
        if (clickable) XS += "</A>\n";
        }
      else
        {  
        if ((c == FEMPTY) && (clickable) && ((show_way == 0) || (show_way == 2)))
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/mg_fg_searched/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;
          XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_UNSEARCHED); XS += "\" ALT=\"("; XS += L->get(L_FLAG_UNSEARCHED); XS += ")\">";    
          XS += "</A>\n";
          }
        }
      }                                                                 
    else if (i == POS_FLAG_ANSWERED)
      {
      if ((c == FANSWERED) && ((show_way == 0) || (show_way == 1)))
        {  
        if (clickable)
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/mg_fg_unanswered/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;
          }
        XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_ANSWERED); XS += "\" ALT=\"("; XS += L->get(L_FLAG_ANSWERED); XS += ")\">";        
        if (clickable) XS += "</A>\n";
        }
      else
        {  
        if ((c == FEMPTY) && (clickable) && ((show_way == 0) || (show_way == 2)))
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/mg_fg_answered/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;
          XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_UNANSWERED); XS += "\" ALT=\"("; XS += L->get(L_FLAG_UNANSWERED); XS += ")\">";    
          XS += "</A>\n";
          }
        }
      }                                                 
    else if (i == POS_FLAG_IMPORTANT)
      {
      if ((c == FFLAGGED) && ((show_way == 0) || (show_way == 1)))
        {
        if (clickable)
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/mg_fg_unflagged/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;
          }
        XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_FLAGGED); XS += "\" ALT=\"("; XS += L->get(L_FLAG_FLAGGED); XS += ")\">";        
        if (clickable) XS += "</A>\n";
        }
      else
        {  
        if ((c == FEMPTY) && (clickable) && ((show_way == 0) || (show_way == 2)))
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/mg_fg_flagged/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;
          XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_UNFLAGGED); XS += "\" ALT=\"("; XS += L->get(L_FLAG_UNFLAGGED); XS += ")\">";      
          XS += "</A>\n";
          }
        }
      }
    else if ((i == POS_FLAG_NEW) && (clickable == false))
      {
      if (((c == FNEW) || (c == FUNSEEN)) && ((show_way == 0) || (show_way == 1)))
        {
        if (clickable)
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/mg_fg_seen/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;
          }
        XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_UNSEEN); XS += "\" ALT=\"("; XS += L->get(L_FLAG_UNSEEN); XS += ")\">";
        if (clickable) XS += "</A>\n";
        }
      else
        {  
        if ((c == FEMPTY) && (clickable) && ((show_way == 0) || (show_way == 2)))
          {
          sprintf (tmpbuf, "<A HREF=\"%s/%s/mg_fg_unseen/noop/%s", PATH_CGI, aservice, molde);
          XS += tmpbuf;
          XS += "<IMG BORDER=\"0\" SRC=\""; XS += skin->getI(IMG_FLAG_SEEN); XS += "\" ALT=\"("; XS += L->get(L_FLAG_SEEN); XS += ")\">";
          XS += "</A>\n";
          }
        }
      }
    }   
  xstrncpy (abuf, CMAXBUFFER, XS.cstr());
  return abuf;
  }  
     
void HTMLPages::PrintSubscribedGroupsPage (const char *lang, const char *mailbox, const char *user, const char *connid, 
                                           StringList *SLMailboxes, UserOptions *uo)
  {
  TBuffer color, fname;
  Configuration *XConf;

  sprintf (fname, "%s.%s", NN_DEFAULTGROUPS, lang);
  XConf = new Configuration (fname, false);
  XConf->Reload();

  Head ("text/html", "", "");
  HTMLBegin ();
  Title (L->get(L_SUBSCRIBEDGROUPS), skin->getSkinAtribProp("COLOR_BGBODY"), skin->getSkinAtribProp("COLOR_BGTEXTO"),
        skin->getSkinAtribProp("IMG_BG"), uo->get_use_javascript(), 0, NULL);  
  BotoneraComun (CMD_CCLIENT_NW_SUBSCRIBED, lang, user, connid, uo);
  BeginCenter();
  BeginTable (1, 2, 1, 100);
  BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
    BeginTDColSpanCenter (3);
      WRITE ("<B>%s</B>", L->get(L_NNTP)); 
    EndTD();  
  EndTR();  

  BeginTR(skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"));
    BeginTDCenter ();
      WRITE ("<B>%s</B>", L->get(L_SUBSCRIBEDGROUPS)); 
    EndTD();                                           
    BeginTDCenter ();
      WRITE ("<B>%s</B>", L->get(L_DESCRIPTION)); 
    EndTD();                                               
    BeginTDCenter ();
      WRITE ("<B>%s</B>", L->get(L_MODERATORS)); 
    EndTD();                                               
  EndTR();    
  
  for (int i=0; i<uo->SLSubscribedGroups->Count(); ++i)
    {
    BeginTR(skin->getSkinAtribProp("COLOR_BGTABLE"));
    if (IsMultiplo (i, 2) == true) {xstrncpy (color, CMAXBUFFER, skin->getSkinAtribProp("COLOR_BGTABLE"));}
      else {xstrncpy (color, CMAXBUFFER, skin->getSkinAtribProp("COLOR_BGFILASREADINGMSG"));}
    BeginTD(color, "left");  
      WRITE ("<A HREF=\"%s/%s/mb_change/noop/%s/%s/%s/%d/%d/%d/:%s/\">", PATH_CGI, SERVICE_CCLIENT, lang, user, connid, 
             uo->getValidator(), uo->getValidator(), uo->getLastCmd(), uo->SLSubscribedGroups->getString(i).cstr());
      WRITE (uo->SLSubscribedGroups->getString(i).cstr());                                                                       
      WRITE ("</A>\n");
    EndTD();
    BeginTD(color, "left");
      WRITE (XConf->getString(uo->SLSubscribedGroups->getString(i).cstr(), "description", " ", 100));
    EndTD();           
    BeginTD(color, "left");
      WRITE (XConf->getString(uo->SLSubscribedGroups->getString(i).cstr(), "moderators", " ", 100));
    EndTD();           
 
    EndTR();
    }
  EndTable();          
  EndCenter();  
  HTMLEnd(skin->getSkinAtribProp("COLOR_BGTABLECOPYRIGHT"));      
  delete XConf;
  }        
  
