  /*  prefs-appearance.c - powershell
   *  Copyright (C) 1999  Matt Spong <spong@glue.umd.edu>
   *  Based from zterm.c by Michael Zucci from the libzvt docs
   *
   *  A big, puffy lotsa-shells-in-one app. 
   *
   *  This program is free software; you can redistribute it and/or modify
   *  it under the terms of the GNU General Public License as published by
   *  the Free Software Foundation; either version 2 of the License, or
   *  (at your option) any later version.
   *
   *  This program is distributed in the hope that it will be useful,
   *  but WITHOUT ANY WARRANTY; without even the implied warranty of
   *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   *  GNU General Public License for more details.
   *
   *  You should have received a copy of the GNU General Public License
   *  along with this program; if not, write to the Free Software
   *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "powershell.h"

GtkWidget * hbox1, * hbox2, * hbox3;
GtkWidget * vbox1, * vbox2, * vbox3, * vbox4, * vbox5, * vbox6;
GtkWidget * hbox5, * vbox8, * vbox9;

GtkWidget * label1;
GtkWidget * bg_pixmap, * use_pixmap, * transparent, * shaded;
GtkWidget * hidetabswhensingle, * ask_ssh_checkbox;
GtkWidget * use_matching, * run_def_shell;

GtkWidget * blinkcheckbox, * bellcheckbox, * scrollkeycheckbox;
GtkWidget * scrolloutcheckbox, * delbscheckbox, * scrolllineslabel;
GtkWidget * scrolllinesentry;

GtkWidget * browse_button;

GtkWidget * nbposmenu, * nbposdrop;
GtkWidget * scrollposmenu, * scrollposdrop;
GtkWidget * nbposmenuitems[5], * scrollposmenuitems[3];

GtkWidget * pbox;

GtkWidget * f;

gint nbtp, scrollp;


void store_filename (GtkFileSelection * b, gpointer user_data)
{
  gchar * filename = gtk_file_selection_get_filename (GTK_FILE_SELECTION(f));
  gtk_entry_set_text (GTK_ENTRY(bg_pixmap), filename);
}

void browse_clicked (GtkButton * button, gpointer data)
{
  gchar * filename;   
  f = gtk_file_selection_new ("Choose a Pixmap");

  filename = gtk_entry_get_text (GTK_ENTRY(bg_pixmap));

  gtk_signal_connect (GTK_OBJECT(GTK_FILE_SELECTION(f)->ok_button),
	 	      "clicked", GTK_SIGNAL_FUNC (store_filename), NULL);
  
  gtk_signal_connect_object (GTK_OBJECT(GTK_FILE_SELECTION(f)->cancel_button),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     (gpointer) f);
  
  gtk_signal_connect_object (GTK_OBJECT(GTK_FILE_SELECTION(f)->ok_button),
			     "clicked", GTK_SIGNAL_FUNC (gtk_widget_destroy),
			     (gpointer) f);

  if (filename)
    gtk_file_selection_set_filename (GTK_FILE_SELECTION(f), filename);

  gtk_widget_show (GTK_WIDGET(f)); 
} 

void nbtabpos_event (GtkMenuItem *w, gpointer data)
     /** Notebook position event **/
{
  property_changed(NULL, NULL);
  nbtp = (gint)data;
}

void scrollpos_event (GtkMenuItem * w, gpointer data)
     /** Scrollbar position event **/
{
  property_changed(NULL, NULL);
  scrollp = (gint)data;
}

int ApplyPrefsAppearance ()
{
  gchar * tmp1;
    Prefs.hidetabswhensingle = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(hidetabswhensingle));
  Prefs.use_pixmap = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(use_pixmap));
  Prefs.transparent = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(transparent));
  Prefs.shaded = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(shaded));

  ColorPrefs.bell = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(bellcheckbox));
  ColorPrefs.blink = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(blinkcheckbox));
  ColorPrefs.scroll_keystroke = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(scrollkeycheckbox));
  ColorPrefs.scroll_output = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(scrolloutcheckbox));
  ColorPrefs.del_bs_switch = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(delbscheckbox));
  Prefs.ask_ssh_password = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(ask_ssh_checkbox));
  strcpy (Prefs.bg_pixmap, gtk_entry_get_text (GTK_ENTRY(bg_pixmap)));

  Prefs.notebookpos = nbtp;
  Prefs.scrollbarpos = scrollp;
  
  tmp1 = gtk_entry_get_text (GTK_ENTRY(scrolllinesentry));

  if (atoi(tmp1))
    Prefs.scrollbacklines = atoi (tmp1);
  scrollbacklines = Prefs.scrollbacklines;
 
  if (Prefs.notebookpos < 4)
    gtk_notebook_set_tab_pos (GTK_NOTEBOOK(notebook), Prefs.notebookpos);

  gtk_notebook_set_show_tabs (GTK_NOTEBOOK(notebook), Prefs.notebookpos!=4);

  if (Prefs.hidetabswhensingle)
  {
    gtk_notebook_set_show_tabs (GTK_NOTEBOOK(notebook), terms_open > 1);

  }

  Prefs.run_def_shell = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(run_def_shell));
  Prefs.hidetabswhensingle = gtk_toggle_button_get_active (GTK_TOGGLE_BUTTON(hidetabswhensingle));

  Prefs.use_matching = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(use_matching));
}

int CreatePrefsAppearance (GtkContainer * area)
{
  char tmp[256];

  hbox1 = gtk_hbox_new (TRUE, 1);
  hbox2 = gtk_hbox_new (TRUE, 1);
  hbox3 = gtk_hbox_new (TRUE, 1);
  hbox5 = gtk_hbox_new (TRUE, 0);

  vbox1 = gtk_vbox_new (TRUE, 1);
  vbox2 = gtk_vbox_new (TRUE, 1);
  vbox3 = gtk_vbox_new (TRUE, 1);
  vbox4 = gtk_vbox_new (TRUE, 1);
  vbox5 = gtk_vbox_new (TRUE, 1);
  vbox6 = gtk_vbox_new (TRUE, 1);
  vbox8 = gtk_vbox_new (TRUE, 0);
  vbox9 = gtk_vbox_new (TRUE, 0);

  label1 = gtk_label_new ("Background Pixmap");

  bg_pixmap = gtk_entry_new();
  use_pixmap = gtk_check_button_new_with_label ("Use Background Pixmap");
  transparent = gtk_check_button_new_with_label ("Transparent");
  shaded = gtk_check_button_new_with_label ("Shaded");

  hidetabswhensingle = gtk_check_button_new_with_label 
    ("Hide tabs if only running a single term");


  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(hidetabswhensingle), 
				Prefs.hidetabswhensingle);

  ask_ssh_checkbox = gtk_check_button_new_with_label ("Ask for SSH Password");
  gtk_widget_set_sensitive (GTK_WIDGET(ask_ssh_checkbox), FALSE);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(use_pixmap), Prefs.use_pixmap);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(transparent), Prefs.transparent);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(shaded), Prefs.shaded);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(ask_ssh_checkbox), Prefs.ask_ssh_password);


  gtk_entry_set_text (GTK_ENTRY(bg_pixmap), Prefs.bg_pixmap);

#ifdef ZVT_USE_MATCHING
  use_matching = gtk_check_button_new_with_label ("Use URL Matching");
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(use_matching), Prefs.use_matching);

  gtk_signal_connect_object (GTK_OBJECT(use_matching), "toggled", GTK_SIGNAL_FUNC(property_changed), GTK_OBJECT(pbox));

#endif

  browse_button = gtk_button_new_with_label ("Browse...");

  gtk_signal_connect_object (GTK_OBJECT(use_pixmap), "toggled", GTK_SIGNAL_FUNC(property_changed), GTK_OBJECT(pbox));
    gtk_signal_connect_object (GTK_OBJECT(transparent), "toggled", GTK_SIGNAL_FUNC(property_changed), GTK_OBJECT(pbox));
  gtk_signal_connect_object (GTK_OBJECT(shaded), "toggled", GTK_SIGNAL_FUNC(property_changed), GTK_OBJECT(pbox));

  gtk_signal_connect_object (GTK_OBJECT(bg_pixmap), "changed", GTK_SIGNAL_FUNC(property_changed), GTK_OBJECT(pbox));

  gtk_signal_connect_object (GTK_OBJECT(ask_ssh_checkbox), "toggled", GTK_SIGNAL_FUNC(property_changed), GTK_OBJECT(pbox));


  gtk_signal_connect_object (GTK_OBJECT(browse_button), "clicked",
			     GTK_SIGNAL_FUNC (browse_clicked), GTK_OBJECT(pbox));



  run_def_shell = gtk_check_button_new_with_label ("Always Run Default Shell");
  blinkcheckbox = gtk_check_button_new_with_label ("Use blinking cursor");
  bellcheckbox = gtk_check_button_new_with_label ("Enable terminal bell");
  scrollkeycheckbox = gtk_check_button_new_with_label ("Scroll on keystroke");
  scrolloutcheckbox = gtk_check_button_new_with_label ("Scroll on output");
  delbscheckbox = gtk_check_button_new_with_label ("Swap backspace/delete");


  scrolllineslabel = gtk_label_new ("Scrollback lines");
  scrolllinesentry = gtk_entry_new ();

#ifdef ZVT_USE_MATCHING
  gtk_box_pack_start (GTK_BOX(vbox8), use_matching, TRUE, FALSE, 0);
#endif

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(run_def_shell), Prefs.run_def_shell);

  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(blinkcheckbox), ColorPrefs.blink);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(bellcheckbox), ColorPrefs.bell);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(scrollkeycheckbox), ColorPrefs.scroll_keystroke);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(scrolloutcheckbox), ColorPrefs.scroll_output);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON(delbscheckbox), ColorPrefs.del_bs_switch);

  nbposmenu = gtk_menu_new ();

  nbposmenuitems[0] = gtk_menu_item_new_with_label ("Left");
  gtk_signal_connect (GTK_OBJECT(nbposmenuitems[0]), "activate",
			     GTK_SIGNAL_FUNC (nbtabpos_event), (gpointer)0);

  gtk_menu_append (GTK_MENU(nbposmenu), nbposmenuitems[0]);  

  nbposmenuitems[1] = gtk_menu_item_new_with_label ("Right");
  gtk_signal_connect (GTK_OBJECT(nbposmenuitems[1]), "activate",
			     GTK_SIGNAL_FUNC (nbtabpos_event), (gpointer)1);

  gtk_menu_append (GTK_MENU(nbposmenu), nbposmenuitems[1]);  

  nbposmenuitems[2] = gtk_menu_item_new_with_label ("Top");
  gtk_signal_connect (GTK_OBJECT(nbposmenuitems[2]), "activate",
			     GTK_SIGNAL_FUNC (nbtabpos_event), (gpointer)2);

  gtk_menu_append (GTK_MENU(nbposmenu), nbposmenuitems[2]);  

  nbposmenuitems[3] = gtk_menu_item_new_with_label ("Bottom");
  gtk_signal_connect (GTK_OBJECT(nbposmenuitems[3]), "activate",
			     GTK_SIGNAL_FUNC (nbtabpos_event), (gpointer)3);

  gtk_menu_append (GTK_MENU(nbposmenu), nbposmenuitems[3]);  
  
  nbposmenuitems[4] = gtk_menu_item_new_with_label ("Hidden");
  gtk_signal_connect (GTK_OBJECT(nbposmenuitems[4]), "activate",
			     GTK_SIGNAL_FUNC (nbtabpos_event), (gpointer)4);

  gtk_menu_append (GTK_MENU(nbposmenu), nbposmenuitems[4]);  

  
  scrollposmenu = gtk_menu_new ();

  scrollposmenuitems[0] = gtk_menu_item_new_with_label ("Right");
  gtk_signal_connect (GTK_OBJECT(scrollposmenuitems[0]), "activate",
		      GTK_SIGNAL_FUNC (scrollpos_event), (gpointer) 0);
  gtk_menu_append (GTK_MENU(scrollposmenu), scrollposmenuitems[0]);

  scrollposmenuitems[1] = gtk_menu_item_new_with_label ("Left");
  gtk_signal_connect (GTK_OBJECT(scrollposmenuitems[1]), "activate",
		      GTK_SIGNAL_FUNC (scrollpos_event), (gpointer) 1);
  gtk_menu_append (GTK_MENU(scrollposmenu), scrollposmenuitems[1]);

  scrollposmenuitems[2] = gtk_menu_item_new_with_label ("Hidden");
  gtk_signal_connect (GTK_OBJECT(scrollposmenuitems[2]), "activate",
		      GTK_SIGNAL_FUNC (scrollpos_event), (gpointer) 2);
  gtk_menu_append (GTK_MENU(scrollposmenu), scrollposmenuitems[2]);


  


  nbposdrop = gtk_option_menu_new ();
  gtk_option_menu_set_menu (GTK_OPTION_MENU(nbposdrop), GTK_WIDGET(nbposmenu));

  gtk_option_menu_set_history (GTK_OPTION_MENU(nbposdrop), Prefs.notebookpos);

  nbtp = Prefs.notebookpos;

  scrollposdrop = gtk_option_menu_new();
  gtk_option_menu_set_menu (GTK_OPTION_MENU(scrollposdrop), GTK_WIDGET(scrollposmenu));

  gtk_option_menu_set_history (GTK_OPTION_MENU(scrollposdrop), Prefs.scrollbarpos);
  
  scrollp = Prefs.scrollbarpos;


  sprintf (tmp, "%d", scrollbacklines);
  gtk_entry_set_text (GTK_ENTRY(scrolllinesentry), tmp);
  
  gtk_signal_connect_object (GTK_OBJECT(run_def_shell), "toggled", GTK_SIGNAL_FUNC(property_changed), GTK_OBJECT(pbox));
  gtk_signal_connect_object (GTK_OBJECT(blinkcheckbox), "toggled", GTK_SIGNAL_FUNC(property_changed), GTK_OBJECT(pbox));
  gtk_signal_connect_object (GTK_OBJECT(bellcheckbox), "toggled", GTK_SIGNAL_FUNC(property_changed), GTK_OBJECT(pbox));
  gtk_signal_connect_object (GTK_OBJECT(scrollkeycheckbox), "toggled", GTK_SIGNAL_FUNC(property_changed), GTK_OBJECT(pbox));
  gtk_signal_connect_object (GTK_OBJECT(scrolloutcheckbox), "toggled", GTK_SIGNAL_FUNC(property_changed), GTK_OBJECT(pbox));
  gtk_signal_connect_object (GTK_OBJECT(delbscheckbox), "toggled", GTK_SIGNAL_FUNC(property_changed), GTK_OBJECT(pbox));
  gtk_signal_connect_object (GTK_OBJECT(scrolllinesentry), "changed", GTK_SIGNAL_FUNC(property_changed), GTK_OBJECT(pbox));
  gtk_signal_connect_object (GTK_OBJECT(hidetabswhensingle), "toggled",
			     GTK_SIGNAL_FUNC(property_changed), GTK_OBJECT(area));

  gtk_box_pack_start (GTK_BOX(area), hbox1, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(hbox1), vbox1, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(hbox1), vbox2, TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX(vbox1), bellcheckbox, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(vbox1), run_def_shell, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(vbox1), scrollkeycheckbox, TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX(vbox2), delbscheckbox, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(vbox2), hidetabswhensingle, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(vbox2), scrolloutcheckbox, TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX(area), gtk_hseparator_new(), TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX(area), hbox2, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(hbox2), vbox3, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(hbox2), vbox4, TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX(vbox3), transparent, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(vbox4), shaded, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(vbox3), use_pixmap, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(vbox4), blinkcheckbox, TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX(area), hbox3, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(hbox3), label1, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(hbox3), bg_pixmap, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(hbox3), browse_button, FALSE, FALSE, 0);

  gtk_box_pack_start (GTK_BOX(area), gtk_hseparator_new(), TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX(area), hbox5, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(hbox5), vbox5, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(hbox5), vbox6, TRUE, TRUE, 0);
  
  gtk_box_pack_start (GTK_BOX(vbox5), gtk_label_new ("Scrollbar position"), TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(vbox6), scrollposdrop, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(vbox5), gtk_label_new ("Tab position"), TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(vbox6), nbposdrop, TRUE, TRUE, 0);

  gtk_box_pack_start (GTK_BOX(vbox5), scrolllineslabel, TRUE, TRUE, 0);
  gtk_box_pack_start (GTK_BOX(vbox6), scrolllinesentry, TRUE, TRUE, 0);

}

