/*
 *  $Id: cputweaks.c,v 1.9 2001/10/01 01:59:00 davej Exp $
 *	This file is part of Powertweak Linux.
 *	(C) 2000 Dave Jones, Arjan van de Ven.
 *
 * 	Licensed under the terms of the GNU GPL License version 2.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include <powertweak.h>
#include <config.h>
#include <string.h>
#include <tree.h>
#include <libxmlcompat.h>

/* for readdir/stat and friends */
#include <sys/types.h>
#include <sys/stat.h>
#include <dirent.h>

#include "x86.h"
#include "../cpu.h"

extern int xmlDoValidityCheckingDefaultValue;


static void load_xml_recursive (struct cpu_identity *id, char *path)
{
	DIR *dir;
	struct dirent *di;
	char *filebuf;			

	dir = opendir (path);
	if (dir == NULL) {
		printf ("xml datadir for CPU MSRs '%s' not found \n",path);
		return;
	}
	di = readdir (dir);
	while (di != NULL) {
		struct stat statbuf;
		int stringlen;
		
		stringlen = strlen(path)+strlen(di->d_name)+4;
		filebuf = calloc(stringlen,1);

		strncpy (filebuf, path, stringlen);
		strncat (filebuf, di->d_name, stringlen - strlen (filebuf)-1);

		if (strstr (filebuf, ".xml") != NULL)
			load_MSR_xmlfile (id, filebuf);

		if ((strcmp (di->d_name, ".") != 0) && (strcmp (di->d_name, "..") != 0)) {
			int retval;
			retval = stat (filebuf, &statbuf);
			if ((S_ISDIR (statbuf.st_mode))&&(retval==0))
				load_xml_recursive (id, filebuf);
		}
		free(filebuf);
		di = readdir (dir);
	}
	closedir (dir);
}


void append_to_CPU_name(struct cpu_identity *id, char *TXT)
{
	char *tmpstr;
	if (id->CPUName == NULL) {
		id->CPUName = strdup (TXT);
		return;
	}

	tmpstr = malloc (strlen (id->CPUName) + strlen (TXT));
	if (tmpstr==NULL) {
		printf ("Boom, couldn't malloc %d bytes.\n",
			(strlen (id->CPUName) + strlen (TXT)));
		return;
	}
	memset (tmpstr, 0, (strlen (id->CPUName) + strlen (TXT)));
	sprintf (tmpstr, "%s%s", id->CPUName, TXT);
	free (id->CPUName);
	id->CPUName = tmpstr;
}


void Add_CPU_tweaks(struct cpu_identity *id)
{
	unsigned long long tmp;

	if (rdmsr (0, 0, &tmp) == -1) {	/* Do we have the MSR driver? */
		printf ("MSR driver not loaded.\n");
		return;
	}

	/* Do the XML tweaks. */
	LIBXML_TEST_VERSION
	xmlDoValidityCheckingDefaultValue = 1;
	load_xml_recursive (id, PT_DATADIR "/CPU/");
	
	/* K6 PowerNOW. */
	if ( (id->vendor==X86_VENDOR_AMD) && 
    	 (id->family==5) && (id->model>=12) )
		PowerNow_tweak(id->CPUName);
}
