#ifndef _INCLUDE_GUARD_X86_H
#define _INCLUDE_GUARD_X86_H

/*
 *  $Id: x86.h,v 1.11 2001/10/01 01:59:00 davej Exp $
 *	This file is part of Powertweak Linux.
 *	(C) 2000 Dave Jones, Arjan van de Ven.
 *
 * 	Licensed under the terms of the GNU GPL License version 2.
 *
 */

#include <powertweak.h>

/* Vendors (x86) */
#define X86_VENDOR_AMD 0
#define X86_VENDOR_CENTAUR 1
#define X86_VENDOR_CYRIX 2
#define X86_VENDOR_INTEL 3
#define X86_VENDOR_NEXGEN 4
#define X86_VENDOR_RISE 5
#define X86_VENDOR_TRANSMETA 6
#define X86_VENDOR_UMC 7
#define X86_VENDOR_UNKNOWN 0xFF

/*
 * struct private_CPU_data contains everything
 * needed to get/set CPU tweaks from the GUI
 */
struct cpu_identity {
	int CPU_number;
	int vendor;
	int family;
	int model;
	int stepping;
	int type;
	int brand;
	int L1_cache_size;
	int L2_cache_size;  /* For CPUs with onboard L2 cache */
	char VendorName[16];
	char *CPUName;   /* 'made' by Powertweak. */
};

struct private_CPU_data {
	int CPU_number;
	/* MSR stuff */
	unsigned long MSR_Register;
	unsigned long long MSR_Mask;
	unsigned long long MSR_OnMask;
	unsigned long long MSR_OffMask;
	value_t value;
};

extern void cpuid (int, int, unsigned long *, unsigned long *, unsigned long *, unsigned long *);
extern void cpuid_UP (int, unsigned long *, unsigned long *, unsigned long *, unsigned long *);

extern void identify_AMD(struct cpu_identity *id);
extern void identify_Cyrix(struct cpu_identity *id);
extern void identify_Intel(struct cpu_identity *id);
extern void identify_IDT(struct cpu_identity *id);
extern void identify_Rise(struct cpu_identity *id);
extern void identify_Transmeta(struct cpu_identity *id);

extern int TranslateVendor(char *vendorstr);
extern void load_MSR_xmlfile (struct cpu_identity *id, char *filename);

int rdmsr(int cpu, unsigned long msrindex, unsigned long long *val);
int wrmsr(int cpu, unsigned long msrindex, unsigned long long *val);

extern void Add_CPU_tweaks(struct cpu_identity *id);

extern int HaveCPUID(void);
extern int PowerNow_tweak(char *CPUNAME);

extern void append_to_CPU_name(struct cpu_identity *id, char *TXT);
extern void append_to_brand_name(struct cpu_identity *id, char *TXT);

extern void ShowMTRRInfo (struct cpu_identity *id);

#endif
