#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/Shell.h>
#include <X11/xpm.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "Panel.h"
#include "xppxpm.h"

XrmOptionDescRec options[] = {
{"-polling",          "*polling",    XrmoptionSepArg, NULL    },
{"-debug",            "*debug",      XrmoptionNoArg,  "True"  },
{"-wmaker",           "*wmaker",     XrmoptionNoArg,  "True"  },
{"-nomenu",           "*menu",       XrmoptionNoArg,  "False" },
{"-shape",            "*shape",      XrmoptionNoArg,  "True"  },
{"-vcolor",           "*vcolor",     XrmoptionSepArg, NULL    },
};

static XtResource resources[] = {
  { XtNpolling, XtCPolling, XtRInt, sizeof(int),
            XtOffset(AppDataPtr, polling), XtRImmediate, (XtPointer) -1 },
  { XtNdebug, XtCDebug, XtRBoolean, sizeof(Boolean), 
            XtOffset(AppDataPtr, debug), XtRImmediate, (XtPointer) FALSE},
  { XtNwmaker, XtCWMaker, XtRBoolean, sizeof(Boolean), 
            XtOffset(AppDataPtr, wmaker), XtRImmediate, (XtPointer) FALSE},
  { XtNmenu, XtCMenu, XtRBoolean, sizeof(Boolean), 
            XtOffset(AppDataPtr, menu), XtRImmediate, (XtPointer) TRUE},
  { XtNshape, XtCShape, XtRBoolean, sizeof(Boolean), 
            XtOffset(AppDataPtr, shape), XtRImmediate, (XtPointer) FALSE},
  { XtNvcolor, XtCVColor, XtRString, sizeof(String),
            XtOffset(AppDataPtr, vcolor), XtRString, NULL },
};

XtAppContext appc;
Widget top, base, panel, qstat, sindc, tdisp;
AppData app_data;

XtActionsRec actions[] = {{NULL, NULL}};

int orargc;
char **orargv;
int srargc;
char **srargv;
XtIntervalId TimerId = -1;

void
ppxpAddAction()
{
        if (ppxpFd >0) {
		if (app_data.menu)
                	MenuChange(0);
                InputId=XtAppAddInput(appc, ppxpFd, 
                                      (XtPointer)XtInputReadMask, 
                                      (XtInputCallbackProc)ppxpCheck, NULL);
        } else if (app_data.polling > 0) {
		if (app_data.menu)
	                MenuChange(1);
                XtAppAddTimeOut(appc, app_data.polling * 1000,
                                (XtTimerCallbackProc)ppxpRetry, NULL);
        }
}

void
ppxpTry()
{
        int i;

        srargc=orargc;
        for(i = 0; i <= orargc; i++) {
                srargv[i]=orargv[i];
        }
        ppxpInit(&srargc, srargv);
}

void
ppxpRetry(Widget w)
{
        ppxpTry();
        ppxpAddAction();
}

void
selectColorMode()
{
	app_data.cmode = -1;
	if (app_data.vcolor) {
		if (strncasecmp(app_data.vcolor, "auto", 4) == 0) {
			app_data.cmode = -1;
		} else if (strncasecmp(app_data.vcolor, "true", 4) == 0) {
			app_data.cmode = 1;
		} else if (strncasecmp(app_data.vcolor, "direct", 6) == 0) {
			app_data.cmode = 1;
		} else if (strncasecmp(app_data.vcolor, "full", 4) == 0) {
			app_data.cmode = 1;
		} else if (strncasecmp(app_data.vcolor, "pseudo", 6) == 0) {
			app_data.cmode = 0;
		} else if (strncasecmp(app_data.vcolor, "static", 6) == 0) {
			app_data.cmode = 0;
		} else if (strncasecmp(app_data.vcolor, "gray", 4) == 0) {
			app_data.cmode = 0;
		}
	}

	if (app_data.cmode < 0) {
		if (DefaultDepthOfScreen(XtScreen(top)) >= 12) {
			app_data.cmode = 1;
		} else {
			app_data.cmode = 0;
		}
	} else if (app_data.cmode > 0) {
		app_data.cmode = 1;
	}
}

int
main(int argc, char *argv[])
{
        XSizeHints hints;
        Dimension width, height;
        int i;

        orargc=argc;
        if ((orargv = malloc(sizeof(char*) * (argc + 1))) == NULL) {
                perror("xppxpm: malloc: ");
                exit(0);
        }
        for(i = 0; i <= argc; i++) {
                orargv[i]=argv[i];
        }

        srargc=orargc;
        if ((srargv = malloc(sizeof(char*) * (orargc + 1))) == NULL) {
                perror("xppxpm: malloc: ");
                exit(0);
        }

        ppxpTry();
        top = XtVaAppInitialize(&appc, NAME,
                                options, XtNumber(options),
                                &srargc, srargv, 
                                NULL, 
                                XtNinput, (XtArgVal)TRUE,
                                NULL);
        XtAppAddActions(appc, actions, XtNumber(actions));

        XtVaGetApplicationResources(top, &app_data,
                                    resources, XtNumber(resources),
                                    NULL);
	selectColorMode();

	if (app_data.menu) {
	        XawSimpleMenuAddGlobalActions(appc);
	}
        if (ppxpFd < 0 && app_data.polling <0) {
                fprintf(stderr,"server not found\n");
                exit(-1);
        }
        if (app_data.debug && ppxpFd >0) {
                fprintf(stderr, "%s version %s\n", NAME, VERSION);
                fprintf(stderr, "PPxP version %s\n", ppxpGetEnv("VERSION"));
                fprintf(stderr, "interface: %s\n", ppxpGetEnv("IF.DEV"));
        };

        panel_init_m();
        XtRealizeWidget(top);

        XtVaGetValues((Widget)base, XtNwidth,     &width,  NULL);
        XtVaGetValues((Widget)base, XtNheight,    &height, NULL);
        XtVaSetValues((Widget)top,  XtNminWidth,  width,   NULL);
        XtVaSetValues((Widget)top,  XtNmaxWidth,  width,   NULL);
        XtVaSetValues((Widget)top,  XtNminHeight, height,  NULL);
        XtVaSetValues((Widget)top,  XtNmaxHeight, height,  NULL);

	if (app_data.wmaker) {
		XWMHints wmhints;

		wmhints.window_group = XtWindow(top);
		wmhints.initial_state = WithdrawnState;
		wmhints.icon_window = XtWindow(base);
		wmhints.flags = WindowGroupHint | StateHint | IconWindowHint;
		XSetWMHints(XtDisplay(top), XtWindow(top), &wmhints);
	}
	if (app_data.menu) {
		CreateMenu( top );
	}

        ppxpAddAction();
        signal_init();
        ppxpGetState();
        ppxpGetState();

        XtAppMainLoop(appc);
        FreeAll();
        exit(0);
}


void
FreeAll()
{
        free(srargv);
        free(orargv);
        ppxpFinish();
        XtUnrealizeWidget(top);
        XtDestroyWidget(top);
}

void
XpmError(int err)
{
        switch(err) {
        case XpmSuccess:
                break;
        case XpmColorError:
                fprintf(stderr, 
                        "%s: warning: can not alloc color for XPM\n", NAME);
                break;
        case XpmOpenFailed:
                fprintf(stderr, "%s: cant open XPM file\n", NAME);
                break;
        case XpmFileInvalid:
                fprintf(stderr, "%s: cant invalid XPM\n", NAME);
                break;                
        case XpmNoMemory:
                fprintf(stderr, "%s: not enough memory for XPM\n", NAME);
                break;                
        case XpmColorFailed:
                fprintf(stderr, "%s: can not alloc color for XPM\n", NAME);
                break;                
        }
        if (err <0) {
                FreeAll();
                exit(1);
        }
}
