#ifndef PPPINFO_H
#define PPPINFO_H

#include <xcio.h>

enum PPPXINFO_TYPE {
    PPXPINFO_NONE,
    PPXPINFO_INT,
    PPXPINFO_LONG,
    PPXPINFO_STR,
};

struct keyval_s {
    char *keyval[2];
    int type;
};

struct ppxpinfo_ops {
    struct keyval_s *(*new)(void);
    int (*parse)(struct keyval_s *, char *, int);
    void (*clear)(struct keyval_s *);
    void (*delete)(struct keyval_s *);
};

#define N_PPPINFO 15
#define N_PWDINFO 5
#define N_CONINFO 4

extern struct ppxpinfo_ops PPxP_pppInfo;
extern struct ppxpinfo_ops PPxP_PwdInfo;
extern struct ppxpinfo_ops PPxP_ConInfo;

#endif /* PPPINFO_H */
