/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: emphnode.cc,v $
 * Revision 1.1.1.1  2001/01/30 18:36:20  slash
 * Initial release.
 *
 */


#include "emphnode.h"


//---------------------------------------------------------------------------
EmphNode::EmphNode(xmlNodePtr node) : InlineNode()
{
    html_open_ = "<EM>";
    html_close_ = "</EM>";
    latex_open_ = "\\emph{";
    latex_close_ = "}";
    xml_open_ = "<emph>";
    xml_close_ = "</emph>";

    read(node);
}

//---------------------------------------------------------------------------
EmphNode::~EmphNode()
{
}
