//
//  PRCTraceEdges.m
//  PRICE
//
//  Created by Riccardo Mottola on Wed Jan 14 2004.
//  Copyright (c) 2004 Carduus. All rights reserved.
//
// This application is free software; you can redistribute it and/or modify it under the terms of the GNU General Public License as published by the Free Software Foundation; either version 2 of the License, or (at your option) any later version.
// This program is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for more details.


#import "PRCTraceEdges.h"
#import "MyDocument.h"


@implementation PRCTraceEdges

- (IBAction)showEdges:(id)sender
{
    if (!edgeWindow)
        [NSBundle loadNibNamed:@"TraceEdges" owner:self];
    [edgeWindow makeKeyAndOrderFront:nil];

    if ([thresholdCheck state] == NSOnState)
    {
        [thresholdSlider setEnabled:YES];
        [thresholdField setEnabled:YES];
        thresholdOn = YES;
        if ([[filterType selectedItem] tag] >= 7)
            [zeroCrossCheck setEnabled:YES];
    } else
    {
        [thresholdSlider setEnabled:NO];
        [thresholdField setEnabled:NO];
        thresholdOn = NO;
        [zeroCrossCheck setEnabled:NO];
    }
    thresholdLevel = [thresholdField floatValue];
}

- (IBAction)edgeOK:(id)sender
{
    BOOL zeroCrossOn;
    
    if ([zeroCrossCheck state] == NSOnState)
        zeroCrossOn = YES;
    else
        zeroCrossOn = NO;
        
    if ([[filterType selectedItem] tag] < 7)
    {
        [zeroCrossCheck setState:NO];
        zeroCrossOn = NO;
    }
        
    [[[NSDocumentController sharedDocumentController] currentDocument] makeTraceEdges  :[[filterType selectedItem] tag]:thresholdOn :thresholdLevel :zeroCrossOn];
    
    if ([[NSApp delegate] prefClosePanels])
        [edgeWindow performClose:nil];
}

- (IBAction)edgeCancel:(id)sender
{
    [edgeWindow performClose:nil];
}

- (IBAction)thresholdToggle:(id)sender
{
    thresholdOn = !thresholdOn;
    if (thresholdOn)
    {
        [thresholdSlider setEnabled:YES];
        [thresholdField setEnabled:YES];
        if ([[filterType selectedItem] tag] >= 7)
            [zeroCrossCheck setEnabled:YES];
    } else
    {
        [thresholdSlider setEnabled:NO];
        [thresholdField setEnabled:NO];
        [zeroCrossCheck setEnabled:NO];
    }
}

- (IBAction)changeThreshold:(id)sender
{
    thresholdLevel = [sender floatValue];
    [thresholdField setFloatValue:thresholdLevel];
}


- (IBAction)filterTypeToggle:(id)sender
{
    if ([[filterType selectedItem] tag] >= 7)
        [zeroCrossCheck setEnabled:YES];
    else
        [zeroCrossCheck setEnabled:NO];
}

@end
