;; $Id: prime-input-mode.el,v 1.12 2004/12/11 07:53:45 komatsu Exp $

;; undo $B5!9=$r<+A0$GMQ0U$7$F$$$k$N$G(B, $B$=$N$X$s$rCm0U(B.
(defun prime-input-mode (&optional arg)
  (setq prime-input-mode 
	(if (null arg) (not prime-input-mode)
	  (> (prefix-numeric-value arg) 0)))
  (if prime-input-mode
      (prime-input-mode-on t)
    (prime-input-mode-off t)
    ))

(defun prime-input-mode-on (&optional forcep)
  (if (or forcep (not prime-input-mode))
      (progn
	(prime-mode-on nil)
	(prime-conv-mode-off)
	(prime-fund-mode-off)
	(setq prime-input-mode t)
	(setq prime-buffer-undo-list buffer-undo-list)
	(buffer-disable-undo)
	(setq prime-tmp-fontify-region font-lock-fontify-region-function)
	(setq font-lock-fontify-region-function 'prime-fontify-region)

	(and (eq prime-style-display-candidates 'compact)
	     (not (eq prime-style-display-candidates-compact
		      'always-number-selection))
	     (setq prime-enum-mode-ignorep t))
	)))

(defun prime-input-mode-off (&optional forcep)
  (if (or forcep prime-input-mode)
      (progn
	(prime-conv-mode-off)
	(setq prime-input-mode nil)
	(buffer-enable-undo)
	(setq buffer-undo-list prime-buffer-undo-list)
	(setq font-lock-fontify-region-function prime-tmp-fontify-region)

	(and (eq prime-style-display-candidates 'compact)
	     (setq prime-enum-mode-ignorep nil))
	)))

;;;; ------------------------------------------------------------
;;;; $B4X?tDj5A(B
;;;; ------------------------------------------------------------

(defun prime-input-get-session-id ()
  "This returns a sesseion id for the current buffer.
If the current buffer is a general buffer, this returns prime-session-default.
If mini-buffer, the return id is prime-session-minibuffer."
  (if (mell-buffer-minibuffer-p)
      prime-session-minibuffer
    prime-session-default))

(defun mell-buffer-minibuffer-p ()
  "This function returns t if the current buffer is a minibuffer, or nil."
  (interactive)
  (eq (minibuffer-window)
      (get-buffer-window (current-buffer))))

(defun prime-input-insert-char (char)
  (interactive)
  (prime-server-edit-insert (prime-input-get-session-id) (char-to-string char))
  (prime-input-refresh))

(defun prime-input-insert-string (string)
  (interactive)
  (prime-server-edit-insert (prime-input-get-session-id) string)
  (prime-input-refresh))

(defun prime-input-get-label (&optional pattern)
  (prime-server-edit-get-preedition (prime-input-get-session-id)))

(defun prime-input-get-inserting-label (&optional pattern)
  (apply 'concat (prime-input-get-label pattern)))

(defun prime-input-erase ()
  (prime-server-edit-erase (prime-input-get-session-id)))

(defun prime-input-undo ()
  (prime-server-edit-undo (prime-input-get-session-id)))

(defun prime-input-backward-char ()
  (interactive)
  (prime-server-edit-cursor-left (prime-input-get-session-id))
  (prime-input-refresh)
  )
	
(defun prime-input-forward-char ()
  (interactive)
  (prime-server-edit-cursor-right (prime-input-get-session-id))
  (prime-input-refresh)
  )

(defun prime-input-end-of-pattern ()
  (interactive)
  (prime-server-edit-cursor-right-edge (prime-input-get-session-id))
  (prime-input-refresh)
  )

(defun prime-input-beginning-of-pattern ()
  (interactive)
  (prime-server-edit-cursor-left-edge (prime-input-get-session-id))
  (prime-input-refresh)
  )

(defun prime-input-transpose-chars ()
  (interactive)
  ;; FIXME: Implement it.
  ;; FIXME: (2004-12-03) <Hiro>
  (prime-input-refresh)
  )

;; Think "undo" !
(defun prime-input-delete-char ()
  (interactive)
  (let ((preedition (prime-server-edit-delete (prime-input-get-session-id))))
    (if (equal preedition '("" "" ""))
	(prime-conv-cancel-all)
      (prime-input-refresh)
      )))

(defun prime-input-delete-backward-char ()
  (interactive)
  (let ((preedition (prime-server-edit-backspace
		     (prime-input-get-session-id))))
    (if (equal preedition '("" "" ""))
	(prime-conv-cancel-all)
      (prime-input-refresh)
      )))

;;
;; Mode operations
;;
(defun prime-input-set-mode-internal (mode)
  "This is an internal funcion for prime-input-set-mode"
  (and prime-conv-mode
       (prime-conv-cancel))
  (prime-server-edit-set-mode (prime-input-get-session-id) mode)
  (or prime-fund-mode
      (prime-input-refresh)))
 
(defun prime-input-set-mode-default ()
  "PRIME $B$NDL>o$NF~NO%b!<%I$KJQ99$7$^$9!#(B [F6]"
  (interactive)
  (prime-input-set-mode-internal "default"))

(defun prime-input-set-mode-hiragana ()
  "PRIME $B$NDL>o$NF~NO%b!<%I$KJQ99$7$^$9!#(B [F6]"
  (interactive)
  (prime-input-set-mode-default))
  
(defun prime-input-set-mode-katakana ()
  "PRIME $B$N%+%?%+%JF~NO%b!<%I$KJQ99$7$^$9!#(B[F7]"
  (interactive)
  (prime-input-set-mode-internal "katakana"))
  
(defun prime-input-set-mode-halfkatakana ()
  "PRIME $B$NH>3Q%+%?%+%JF~NO%b!<%I$KJQ99$7$^$9!#(B[F8]"
  (interactive)
  (prime-input-set-mode-internal "half_katakana"))
  
(defun prime-input-set-mode-wideascii ()
  "PRIME $B$NA43Q1Q?t;zF~NO%b!<%I$KJQ99$7$^$9!#(B[F9]"
  (interactive)
  (prime-input-set-mode-internal "wide_ascii"))
  
(defun prime-input-set-mode-ascii ()
  "PRIME $B$N1Q?t;zF~NO%b!<%I$KJQ99$7$^$9!#(B[F10]"
  (interactive)
  (prime-input-set-mode-internal "raw"))


(defun prime-input-refresh ()
  (let ((query (prime-input-get-query-string)))
    (prime-disp-input query)))

(defun prime-input-get-query-string ()
  (prime-server-edit-get-query-string (prime-input-get-session-id)))

;;;; ----------

(defun prime-input-split ()
  (interactive)
  ;; FIXME: Implement it.
  ;; FIXME: (2004-12-03) <Hiro>
  (prime-input-refresh)
  )

(defun mell-x-selection-set (data &optional type)
  (if (featurep 'xemacs)
      (own-selection data type)
    (x-set-selection type data)))

(defun mell-frame-get-frame (&optional object)
  (window-frame (get-buffer-window (current-buffer))))

; (setq prime-style-dictionary-command 'ebview)
(defun prime-input-lookup-word (&optional pattern)
  (interactive)
  (setq pattern	(cond (pattern pattern)
		      (prime-conv-mode  prime-curstr)
		      (prime-input-mode (prime-input-get-inserting-label))))
  (cond
   ((eq prime-style-dictionary-command 'lookup-el)
    (if (functionp 'lookup-word)
	(lookup-word pattern)))
   ((eq prime-style-dictionary-command 'ebview)
    (mell-x-selection-set pattern)
    (focus-frame (mell-frame-get-frame)))
  ))

(provide 'prime-input-mode)
