/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.FieldrefConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InterfaceMethodrefConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.ConstantPoolEditor;

public class ConstantAdder
implements ConstantVisitor {
    private final ConstantPoolEditor constantPoolEditor;
    private int constantIndex;

    public ConstantAdder(ProgramClass programClass) {
        this.constantPoolEditor = new ConstantPoolEditor(programClass);
    }

    public int addConstant(Clazz clazz, int n) {
        clazz.constantPoolEntryAccept(n, this);
        return this.constantIndex;
    }

    public int addConstant(Clazz clazz, Constant constant) {
        constant.accept(clazz, this);
        return this.constantIndex;
    }

    public int getConstantIndex() {
        return this.constantIndex;
    }

    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        this.constantIndex = this.constantPoolEditor.addIntegerConstant(integerConstant.getValue());
    }

    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        this.constantIndex = this.constantPoolEditor.addLongConstant(longConstant.getValue());
    }

    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        this.constantIndex = this.constantPoolEditor.addFloatConstant(floatConstant.getValue());
    }

    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        this.constantIndex = this.constantPoolEditor.addDoubleConstant(doubleConstant.getValue());
    }

    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        this.constantIndex = this.constantPoolEditor.addStringConstant(stringConstant.getString(clazz), stringConstant.referencedClass, stringConstant.referencedMember);
    }

    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        this.constantIndex = this.constantPoolEditor.addUtf8Constant(utf8Constant.getString());
    }

    public void visitFieldrefConstant(Clazz clazz, FieldrefConstant fieldrefConstant) {
        clazz.constantPoolEntryAccept(fieldrefConstant.u2classIndex, this);
        this.constantIndex = this.constantPoolEditor.addFieldrefConstant(this.constantIndex, fieldrefConstant.getName(clazz), fieldrefConstant.getType(clazz), fieldrefConstant.referencedClass, fieldrefConstant.referencedMember);
    }

    public void visitInterfaceMethodrefConstant(Clazz clazz, InterfaceMethodrefConstant interfaceMethodrefConstant) {
        clazz.constantPoolEntryAccept(interfaceMethodrefConstant.u2classIndex, this);
        this.constantIndex = this.constantPoolEditor.addInterfaceMethodrefConstant(this.constantIndex, interfaceMethodrefConstant.getName(clazz), interfaceMethodrefConstant.getType(clazz), interfaceMethodrefConstant.referencedClass, interfaceMethodrefConstant.referencedMember);
    }

    public void visitMethodrefConstant(Clazz clazz, MethodrefConstant methodrefConstant) {
        clazz.constantPoolEntryAccept(methodrefConstant.u2classIndex, this);
        this.constantIndex = this.constantPoolEditor.addMethodrefConstant(this.constantIndex, methodrefConstant.getName(clazz), methodrefConstant.getType(clazz), methodrefConstant.referencedClass, methodrefConstant.referencedMember);
    }

    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.constantIndex = this.constantPoolEditor.addClassConstant(classConstant.getName(clazz), classConstant.referencedClass);
    }

    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        this.constantIndex = this.constantPoolEditor.addNameAndTypeConstant(nameAndTypeConstant.getName(clazz), nameAndTypeConstant.getType(clazz));
    }
}

