/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.annotation.Annotation;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.KeepMarker;

public class DuplicateInitializerFixer
extends SimplifiedVisitor
implements MemberVisitor,
AttributeVisitor {
    private static final boolean DEBUG = false;
    private static final char[] TYPES = new char[]{'B', 'C', 'S', 'I', 'Z'};
    private final MemberVisitor extraFixedInitializerVisitor;

    public DuplicateInitializerFixer() {
        this(null);
    }

    public DuplicateInitializerFixer(MemberVisitor memberVisitor) {
        this.extraFixedInitializerVisitor = memberVisitor;
    }

    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        String string;
        Method method;
        String string2 = programMethod.getName(programClass);
        if (string2.equals("<init>") && !programMethod.equals(method = programClass.findMethod(string2, string = programMethod.getDescriptor(programClass)))) {
            if (!KeepMarker.isKept(programMethod)) {
                programMethod = (ProgramMethod)method;
            }
            int n = string.indexOf(41);
            for (int i = 0; i < TYPES.length; ++i) {
                String string3 = string.substring(0, n) + TYPES[i] + string.substring(n);
                if (programClass.findMethod(string2, string3) != null) continue;
                programMethod.u2descriptorIndex = new ConstantPoolEditor(programClass).addUtf8Constant(string3);
                programMethod.attributesAccept(programClass, this);
                if (this.extraFixedInitializerVisitor != null) {
                    this.extraFixedInitializerVisitor.visitProgramMethod(programClass, programMethod);
                }
                return;
            }
            throw new IllegalStateException("Can't find unique constructor descriptor for [" + programClass.getName() + "." + programMethod.getName(programClass) + programMethod.getDescriptor(programClass) + "]");
        }
    }

    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        int n = ClassUtil.internalMethodParameterSize(method.getDescriptor(clazz), method.getAccessFlags());
        if (codeAttribute.u2maxLocals < n) {
            codeAttribute.u2maxLocals = n;
        }
    }

    public void visitSignatureAttribute(Clazz clazz, Method method, SignatureAttribute signatureAttribute) {
        String string = method.getDescriptor(clazz);
        int n = string.indexOf(41);
        String string2 = clazz.getString(signatureAttribute.u2signatureIndex);
        int n2 = string2.indexOf(41);
        String string3 = string2.substring(0, n2) + string.charAt(n - 1) + string2.substring(n2);
        signatureAttribute.u2signatureIndex = new ConstantPoolEditor((ProgramClass)clazz).addUtf8Constant(string3);
    }

    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
        int n = parameterAnnotationsAttribute.u2parametersCount++;
        if (parameterAnnotationsAttribute.u2parameterAnnotationsCount == null || parameterAnnotationsAttribute.u2parameterAnnotationsCount.length < parameterAnnotationsAttribute.u2parametersCount) {
            int[] nArray = new int[parameterAnnotationsAttribute.u2parametersCount];
            Annotation[][] annotationArrayArray = new Annotation[parameterAnnotationsAttribute.u2parametersCount][];
            System.arraycopy(parameterAnnotationsAttribute.u2parameterAnnotationsCount, 0, nArray, 0, n);
            System.arraycopy(parameterAnnotationsAttribute.parameterAnnotations, 0, annotationArrayArray, 0, n);
            parameterAnnotationsAttribute.u2parameterAnnotationsCount = nArray;
            parameterAnnotationsAttribute.parameterAnnotations = annotationArrayArray;
        }
    }
}

