/*
    MakefileChecking.h

    Makefile integrity checking procedures for the ProjectManager application.

    Copyright (C) 2006  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>
#import <Foundation/NSString.h>
#import <Foundation/NSArray.h>

static unsigned int
ComputeHashFromMakeString(NSString * fileString)
{
  unichar * buf;
  int i, n;
  unsigned int hash = 0;

  n = [fileString length];
  buf = (unichar *) malloc(sizeof(unichar) * n);
  [fileString getCharacters: buf];

  for (i = 0; i < n; i++)
    {
      hash ^= buf[i];
      hash = (hash << 1) | (hash >> (sizeof(hash) * 8 - 1));
    }

  free(buf);

  return hash;
}

static unsigned int
ComputeHashFromMakefile(NSString * filePath)
{
  return ComputeHashFromMakeString([NSString stringWithContentsOfFile:
    filePath]);
}
