/*
    ProjectTypeDescription.h

    Interface declaration for the ProjectTypeDescription class for
    the ProjectManager app.

    Copyright (C) 2006  Saso Kiselkov

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#import <Foundation/NSObject.h>

@protocol ProjectType;
@class NSArray,
       NSString,
       NSImage;

@interface ProjectTypeDescription : NSObject
{
  Class projType;

  NSArray * templates;
}

- initWithProjectType: (Class) aClass;

- (NSString *) name;
- (NSString *) description;
- (NSImage *) icon;
- (NSArray *) templates;
- (Class) projectType;

@end
