#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>

#include "gui.h"
#include "jobmanager.h"
#include "configuration.h"
#include "datadispatcher.h"
#include "mtabwatcher.h"
#include "supermountwatcher.h"
#include "submountwatcher.h"
#include "pixmapcache.h"
#include "database_mysql.h"

#ifdef HAVE_MIXXX
#include "mixxxclient.h"
#endif /* HAVE_MIXXX */

#ifdef HAVE_LIBMUSICBRAINZ
#include "musicbrainzclient.h"
#endif

#include "job_connecttodatabase.h"
#include "splashscreen.h"

#ifdef EMBEDDED
  #include "database_embedded_dialog.h"
  #include "job_connecttodatabase.h"
#endif   // ifdef EMBEDDED

#include <unistd.h>
#include <qapplication.h>
#include <qtextcodec.h>
#include <getopt.h>

#if HAVE_TAG
#include <id3v1tag.h>
#include <id3v2framefactory.h>
#include "tagger_taglib.h"
#endif

#include <qmessagebox.h>
#include <qtooltip.h>
#include <qpalette.h>
#include <qdir.h>
#include <qfile.h>

#include <locale.h> /* required by gcc 2.95 */

#include <prokyon.h>

GUI *gui;
JobManager *jobman;
DataBase *database;
Configuration *config;
DataDispatcher *datadispatcher;
MtabWatcher *mtabwatcher;
SupermountWatcher *supermountwatcher;
SubmountWatcher *submountwatcher;
PixmapCache *pixmapcache;
QApplication *app;

#ifdef HAVE_MIXXX
MixxxClient *mixxxClient;
#endif /* HAVE_MIXXX */

#ifdef HAVE_LIBMUSICBRAINZ
MusicBrainzClient *musicBrainzClient;
#endif

int verbose = 0;

void usage() {
  qWarning(_(" Valid options are:\n"
	   "    -vX ,verbose debug output to stderr. X: verbosity level (default to 1).\n"
           "      1,2 and 3 provide general purpose logging. Higher numbers for specific development only.\n"
	   "    -h ,this message\n\n"
	   " All standard QT command lines options are valid but not necessarily supported by Prokyon3:\n"
	   "    -style style, sets the application GUI style. Possible values are motif, windows, and platinum.\n"
	   "    -session session, restores the application from an earlier session.\n\n" 
	   " Prokyon3 also supports some traditional X11 command line options:\n" 
	   "    -display display, sets the X display (default is $DISPLAY). \n"
	   "    -geometry geometry, sets the client geometry of the main widget. \n"
	   "    -fn or -font font, defines the application font. The font should be specified\n"
	   "                 using an X logical font description. \n"
	   "    -bg or -background color, sets the default background color and an application palette \n"
	   "                              (light and dark shades are calculated). \n"
	   "    -fg or -foreground color, sets the default foreground color.\n" 
	   "    -btn or -button color, sets the default button color. \n"
	   "    -name name, sets the application name. \n"
	   "    -title title, sets the application title (caption). \n"
	   "    -visual TrueColor, forces the application to use a TrueColor visual on an 8-bit display. \n"
	   "    -ncols count, limits the number of colors allocated in the color cube on an 8-bit display,\n"
	   "    -cmap, causes the application to install a private color map on an 8-bit display. \n"));
}

/* Note: specific verbose mode is as follows:
   1 and above: Print a warning when catching library exception
   2 and above: dump files name when synchronizing 

   4 : trace tag edit signals and slots
   5 : trace deltamaps
   6 : dump tags detail when reading files
   7 : debug musicextras output
   8 : debug jobs and threads
   9 : debug musicextras database support
  10 : debug mixxx protocol
*/

int main(int argc, char *argv[])
{
  setlocale (LC_ALL, "");
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);

  int optch;
  static char optstring[] = "v::h";
  while (( optch = getopt(argc,argv,optstring)) != -1)
    switch ( optch ) {
    case 'v':
      verbose = !optarg ? 1 : atoi(optarg);
      break;
    case 'h':
    default:
      usage();
      return 0;
    }

  //  verbose = 10;  

  if ( verbose )
    qWarning( "Codec for locale:%s             mime name: %s", 
	      QTextCodec::locale(), QTextCodec::codecForLocale()->mimeName() );

#if HAVE_TAG
/**********************************************************************************
  ID3v1 technically isn't supposed to contain anything other than ISO-8859-1 ("Latin 1")
  next line is an "unsupported"  hack enabling non latin1 encoding in id3V1
**********************************************************************************/
  // TagLib::ID3v1::Tag::setStringHandler(new LocaleStringHandler);

  // below code will force utf-8/latin1 encoding when rendering id3v2 tags, independly
  // of frame present encoding
  if ( !qstrcmp( QTextCodec::codecForLocale()->mimeName() ,"UTF-8" ) )
    TagLib::ID3v2::FrameFactory::instance()->setDefaultTextEncoding ( TagLib::String::UTF8 );
  else
    TagLib::ID3v2::FrameFactory::instance()->setDefaultTextEncoding ( TagLib::String::Latin1 );
#endif
 
  app = new QApplication(argc, argv);



  QPixmap pixmap( PROKYON_HOME + "/images/splash5.png" );
  SplashScreen *splash = new SplashScreen( pixmap );
  splash->setFont( QFont("Times", 10, QFont::Bold) );
  splash->setStatus( _("Initializing...") );
  app->processEvents();

  QToolTip::setPalette( QPalette( Qt::black, Qt::cyan));
  config = new Configuration();

#ifdef EMBEDDED
  bool mysql_config_OK = false;

  if ( QFile::exists( config->getEmbeddedBaserdir() + "/var" ) &&
       QFile::exists( config->getEmbeddedLanguage() + "/errmsg.sys" ) ) {
        
      QCString basedir ("--basedir=");
      basedir += config->getEmbeddedBaserdir().local8Bit().data();
      QCString datadir ("--datadir=");
      datadir += config->getEmbeddedBaserdir().local8Bit().data();
      datadir += "/var";
      QCString language ("--language=");
      language += config->getEmbeddedLanguage().local8Bit().data();
      
      char *server_args[] = {
          "prokyon3_embedded_MySQL_server",
          "--no-defaults",
          basedir.data(),
          datadir.data(),
          language.data(),
          "--skip-innodb"
      };

      mysql_server_init(sizeof(server_args) / sizeof(char *),
                        server_args, NULL);
      mysql_config_OK = true;
  } else {
      qWarning( _("can't find embedded database structure in filesystem\n"
	              "  => Calling first-time database wizard"));
      config->setStartupTip( 1 );
  }
#endif   // ifdef EMBEDDED

  gui = new GUI();
  jobman = new JobManager();
  database = new DataBase_MySQL();
  datadispatcher = new DataDispatcher();
  mtabwatcher = new MtabWatcher(); // no automount
  supermountwatcher = new SupermountWatcher(); // automount used by Mandrake
  submountwatcher = new SubmountWatcher(); // automount used by SuSE
  pixmapcache = new PixmapCache();
  
#ifdef HAVE_MIXXX
  mixxxClient = new MixxxClient();
#endif /* HAVE_MIXXX */

#ifdef HAVE_LIBMUSICBRAINZ
  musicBrainzClient = new MusicBrainzClient();
#endif

  app->processEvents();

  gui->resize( QSize( config->getwidth(), config->getheight()) );        // restore size
  gui->move( QPoint(config->getposx(), config->getposy() ) );
  gui->show();

#ifdef HAVE_MIXXX
  gui->notifyLostMixxxConnection();
#endif /* HAVE_MIXXX */
		
  gui->getSelector()->correctSize();
	
  gui->getSourcer()->init();
  app->processEvents();

  if(config->getStartupTip() == 1) {
    splash->finish(gui);
    gui->slot_WELCOME();

#ifdef EMBEDDED
    Database_Embedded_Dialog *dlg = new Database_Embedded_Dialog(0);
    if ( dlg->exec() == QDialog::Accepted )
      config->setStartupTip( 2 );  
#else
    config->setStartupTip( 0 );
#endif   // ifdef EMBEDDED
  }

#ifdef EMBEDDED
  else
    if(config->getStartupTip() == 2) {
      splash->finish(gui);
      QString result = database->createNewDatabase(0,0,0,0,0,0,0);
      result = result.stripWhiteSpace();
      if (result.isEmpty() || result.contains("Database exists", false)) result = "SUCCESS"; 
      QMessageBox::information(0, _("Message"), QString(_("Creating/reading embedded database ")) + ": " + result, QMessageBox::Ok);
      if(result == "SUCCESS") 	config->setAutoConnect( 1 );
      config->setStartupTip( 0 );
    } 
#endif   // ifdef EMBEDDED

#ifdef EMBEDDED
  splash->setStatus( _("Connecting to embedded server...") );
#else
  splash->setStatus( _("Connecting...") );
#endif   // ifdef EMBEDDED

  if(config->getAutoConnect() == 1) {
    jobman->lock();
    jobman->addJob(new Job_ConnectToDatabase(config->getHOST(), config->getDATABASE(), config->getUSER(), config->getPASS()));
    jobman->unlock();
  }

  app->processEvents();
  app->setMainWidget(gui);
  if(config->getStartupTip() != 1) splash->finish(gui);
  delete splash;

  mtabwatcher->start(QThread::LowestPriority);
  supermountwatcher->start(QThread::LowestPriority);
  submountwatcher->start(QThread::LowestPriority);

  int x =  app->exec();

  mtabwatcher->stop();
  supermountwatcher->stop();
  submountwatcher->stop();
  mtabwatcher->wait();
  supermountwatcher->wait();
  submountwatcher->wait();

#ifdef EMBEDDED
  if ( mysql_config_OK ) mysql_server_end();
#endif   // ifdef EMBEDDED

  delete config;
  config = 0;

  QString   qt_config = QDir::homeDirPath() +  "/.qt/prokyon3rc" ;
  if ( QFile::exists( qt_config ) && 
       ::chmod( qt_config.local8Bit().data(), S_IRUSR | S_IWUSR ) )
    qWarning( _(" Cannot force config file to user readable only (600).\n"
	      " This is a minor security risk as MySQL password is stored as clear text.....") ); 

  delete database;
  delete datadispatcher;

  return x;
}


