#ifndef MUSICEXTRA_WRAPPER_H
#define MUSICEXTRA_WRAPPER_H

#include <qprocess.h>
#include <qcstring.h>
#include <qstring.h>
#include <qxml.h>
#include <qobject.h>

#include "prokyon.h"

class MusicextrasWrapper : public QObject
{ 
  Q_OBJECT 
public:
  EXTRADATA * get(TRACK*, EXTRA_STATUS status);
  void safeTerminate() { terminated=true;}
  void log_gui(QString ss, QColor col = Qt::black);
  MusicextrasWrapper();
  ~MusicextrasWrapper();

private:
  QProcess *proc;
  EXTRADATA *extraData;
  QString qsxml;
  QString qsxmlerr;
  TRACK *Track;
  bool terminated;
  void parseXML();
//  void strip_nondata_xml(QCString& s);

public slots:
  void slot_readFromStdout();
  void slot_readFromStderr();
};

class MusicextrasHandler : public QXmlDefaultHandler
{ 
public:
  bool startElement( const QString&, const QString&, const QString& ,
                     const QXmlAttributes& );
  bool endElement( const QString&, const QString&, const QString& );
  bool characters( const QString& );
  void setExtraData( EXTRADATA * );
  void setTrack( TRACK * );
  void setLogger( MusicextrasWrapper * );

private:
  EXTRADATA *extraData;
  TRACK *Track;
  QString currentTag;
  MusicextrasWrapper *logger;
};

#endif
