/* Generated by Together */

#ifndef GUI_SELECTOR_H
#define GUI_SELECTOR_H

#include "prokyon.h"

#include "lvi_album.h"
#include "lvi_medium.h"

#include <qtabwidget.h>
#include <qwidgetstack.h>
#include <qlistview.h>
#include <qmap.h>
#include <qlayout.h>
#include <qevent.h>

/**
 * Implementiert einen <tt>ISelector</tt> als KDE2-GUI-Interface
 * @version 0.1
 * @author Holger Sattel
 * @since 28.04.2001 
 */
class GUI_Selector: public QTabWidget {
    Q_OBJECT
public:

    GUI_Selector(QWidget *parent=0, const char *name=0);

    #ifdef HAVE_MIXXX

    void setMixxxConnectionState(bool state);
    #endif /* HAVE_MIXXX */

    void notifyAddReadWriteLock() {
        rwLock++;
    }
    void notifyRemoveReadWriteLock() {
        rwLock--;
    }

    void notifyMediumAvailabilityChanged(int id, bool state);
    void notifyNewSamplerBasis(QList<ARTISTALBUM> *tracklist);
    void notifyNewFavouritesBasis(QList<ARTISTALBUM> *tracklist);
    void notifyNewArtistAlbumBasis(QList<ARTISTALBUM> *tracklist, bool select);
    void notifyNewArtistDelta(QMap<int, QMap<int, DELTAINFO*> > *deltamap);
    void notifyNewMediumBasis(QList<MEDIUM> *mediumlist);
    void notifyNewMedium(MEDIUM *medium);
    void notifyMediumRemoved(int id);
    void notifyNewLocalAlbumDeltaBasis(QMap<int, QMap<QString, int> > *deltalist);
    void notifyNewLocalAlbumDelta(int id, QMap<QString, int> delta);
    void notifyFavouriteChanged(int id, bool state);
    void notifySelectArtistAlbum();
    void notifyMediumRenamed(MEDIUM *medium);
    void clear();

    void correctSize();
    QListView* getTabAlbum() {
        return tabAlbum;
    }
    QListView* getTabArtist() {
        return mapArtistList["AllTree"];
    }

    ~GUI_Selector();

public slots:
    void notifyCloseSelectorTree();
    void notifyOpenSelectorTree();
    void slot_setConnectionState(bool state);

protected:
    void customEvent(QCustomEvent*);

private:
    int rwLock;
    #ifdef HAVE_MIXXX

    bool isMixxxConnected;
    #endif /* HAVE_MIXXX */

    void addButton(QString text, int id, int x1, int x2, int y1, int y2);

    void updateStatusBar();
    void resort(QListView*);

    void applyLocalAlbumDelta(int id, bool isAvailable);

    void showLetter(QString letter);
    void setNewBasisOnTab(QList<ARTISTALBUM>*, QListView*, bool);
    void adjustIconsOnTab(QListView*);
    void createJobPlayAlbum(int);

    QMap<QString, LVI_Album*> mapAllTree;
    QMap<int, LVI_Medium*> mapMediumByID;

    QMap<int, QMap<int, int> > *localDelta;
    QMap<int, QMap<QString, int> > *localAlbumDelta;

    QMap<int, bool> mapIsAvailable;

    QWidgetStack* artistStack;
    QFrame* artistButtonFrame;
    QGridLayout* artistButtonFrameLayout;
    QFrame* tabArtists;
    QListView* tabCDROM;
    QListView* tabAlbum;
    QListView* tabFavourites;
    QListViewItem* lastLVI;

    QMap<QString, QListView*> mapArtistList;

    bool isConnected;
    bool isLocked;

private slots:
    void slot_menuPlayXmms(int);
    void slot_menuEnqueueXmms(int);
    void slot_mixxxEnqueueAtChannel1(int);
    void slot_mixxxEnqueueAtChannel2(int);
    void slot_contextMenu(QListViewItem* item, const QPoint &point, int);
    void slot_menuAddFavourite(int);
    void slot_menuDeleteFavourite(int);
    void slot_menuDeleteMediumFromDatabase();
    void slot_menuRenameMedium();

    void slot_lviSelected(QListViewItem* lvi);
    void slot_doubleclicked(QListViewItem* lvi);
    void slot_tabSelected(QWidget* widget);

    void slot_buttonSelected_AllTree();
    void slot_buttonSelected_Favourites();
    void slot_buttonSelected_0();
    void slot_buttonSelected_A();
    void slot_buttonSelected_B();
    void slot_buttonSelected_C();
    void slot_buttonSelected_D();
    void slot_buttonSelected_E();
    void slot_buttonSelected_F();
    void slot_buttonSelected_G();
    void slot_buttonSelected_H();
    void slot_buttonSelected_I();
    void slot_buttonSelected_J();
    void slot_buttonSelected_K();
    void slot_buttonSelected_L();
    void slot_buttonSelected_M();
    void slot_buttonSelected_N();
    void slot_buttonSelected_O();
    void slot_buttonSelected_P();
    void slot_buttonSelected_Q();
    void slot_buttonSelected_R();
    void slot_buttonSelected_S();
    void slot_buttonSelected_T();
    void slot_buttonSelected_U();
    void slot_buttonSelected_V();
    void slot_buttonSelected_W();
    void slot_buttonSelected_X();
    void slot_buttonSelected_Y();
    void slot_buttonSelected_Z();
};

#endif
